/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.pixelplate;

import de.jave.jave.DefaultPixelPlateConfiguration;
import de.jave.jave.configuration.ConfigurationException;
import de.jave.jave.configuration.IJavaInitializationContext;
import de.jave.jave.configuration.IJaveInitializable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import net.disy.commons.core.io.IOUtilities;

public class PixelPlateConfiguration
implements IJaveInitializable {
    private static final PixelPlateConfiguration instance = new PixelPlateConfiguration();
    private static char[] rules;
    private static char[] rulesThick;

    private PixelPlateConfiguration() {
        this.setDefaultConfiguration();
    }

    @Override
    public void initialize(IJavaInitializationContext context) throws ConfigurationException {
        File configurationFile0 = context.getConfigurationFile("./config/convert.txt");
        rules = PixelPlateConfiguration.loadRules(configurationFile0);
        File configurationFile1 = context.getConfigurationFile("./config/convert_thick.txt");
        rulesThick = PixelPlateConfiguration.loadRules(configurationFile1);
    }

    private void setDefaultConfiguration() {
        int i;
        rules = new char[4096];
        for (i = 0; i < DefaultPixelPlateConfiguration.RULES_TABLE.length; ++i) {
            PixelPlateConfiguration.rules[DefaultPixelPlateConfiguration.RULES_TABLE[i][0]] = DefaultPixelPlateConfiguration.RULES_TABLE[i][1];
        }
        rulesThick = new char[4096];
        for (i = 0; i < DefaultPixelPlateConfiguration.RULES_THICK_TABLE.length; ++i) {
            PixelPlateConfiguration.rulesThick[DefaultPixelPlateConfiguration.RULES_THICK_TABLE[i][0]] = DefaultPixelPlateConfiguration.RULES_THICK_TABLE[i][1];
        }
    }

    private static char[] loadRules(File file) throws ConfigurationException {
        char[] rules = new char[4096];
        for (int i = 0; i < rules.length; ++i) {
            rules[i] = '\u0000';
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            String[] lines = new String[4];
            int blockCount = 0;
            int lineCount = 0;
            while (lines != null) {
                String line = br.readLine();
                ++lineCount;
                while (line != null && (line.length() < 3 || line.charAt(0) == '#')) {
                    line = br.readLine();
                    ++lineCount;
                }
                if (line == null) break;
                lines[0] = line;
                for (int i = 1; i < lines.length; ++i) {
                    lines[i] = br.readLine();
                    ++lineCount;
                    if (lines[i] != null) continue;
                    lines = null;
                    break;
                }
                if (lines == null) continue;
                char[] pattern = new char[12];
                char ch = lines[3].charAt(8);
                boolean index = false;
                for (int x = 0; x < 3; ++x) {
                    for (int y = 0; y < 4; ++y) {
                        pattern[x * 4 + y] = lines[y].length() <= x ? 46 : lines[y].charAt(x);
                    }
                }
                PixelPlateConfiguration.addRule(lineCount - 4, blockCount++, pattern, ch, rules);
            }
        }
        catch (IOException e) {
            try {
                throw new ConfigurationException(file, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtilities.close(br);
                throw throwable;
            }
        }
        IOUtilities.close(br);
        int defined = 0;
        int undefined = 0;
        for (int i = 0; i < rules.length; ++i) {
            if (rules[i] != '\u0000') {
                ++defined;
                continue;
            }
            ++undefined;
        }
        return rules;
    }

    private static void addRule(int lineCount, int blockCount, char[] pattern, char ch, char[] rules) {
        for (int i = 0; i < 12; ++i) {
            if (pattern[i] != '?') continue;
            char[] pattern2 = new char[12];
            System.arraycopy(pattern, 0, pattern2, 0, 12);
            pattern2[i] = 88;
            pattern[i] = 46;
            PixelPlateConfiguration.addRule(lineCount, blockCount, pattern, ch, rules);
            PixelPlateConfiguration.addRule(lineCount, blockCount, pattern2, ch, rules);
            return;
        }
        int index = 0;
        for (int i = 0; i < 12; ++i) {
            if (pattern[i] != 'X') continue;
            index |= 1 << i;
        }
        if (rules[index] != '\u0000' && rules[index] != ch) {
            return;
        }
        rules[index] = ch;
    }

    public static PixelPlateConfiguration getInstance() {
        return instance;
    }

    public char[] getRulesThick() {
        return rulesThick;
    }

    public char[] getRules() {
        return rules;
    }
}

