/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.application.startup;

import de.jave.gui.splash.IStartupMonitor;
import de.jave.gui.splash.IStartupRunnable;
import de.jave.gui.splash.StartupException;
import de.jave.image2ascii.AsciiGreyscaleTableConfiguration;
import de.jave.jave.CharSetsConfiguration;
import de.jave.jave.JavEApplication;
import de.jave.jave.JaveConfigurationFileLoader;
import de.jave.jave.actions.quickstart.QuickStartAction;
import de.jave.jave.algorithm.GeneralAlgorithmConfiguration;
import de.jave.jave.algorithm.gradient.AsciiGradientConfiguration;
import de.jave.jave.algorithm.repair.AsciiRepairAlgorithmConfiguration;
import de.jave.jave.algorithm.replaceillegal.AsciiReplaceIllegalConfiguration;
import de.jave.jave.configuration.ConfigurationException;
import de.jave.jave.figlet.FigletConfiguration;
import de.jave.jave.filter.Filter;
import de.jave.jave.icon.JaveIcons;
import de.jave.jave.pixelplate.PixelPlateConfiguration;
import de.jave.jave.preferences.JaveApplicationPreferences;
import de.jave.lib.CharacterPlateConfiguration;
import de.jave.maxosx.MacOsXInitializer;
import java.awt.Component;
import net.disy.commons.swing.dialog.core.DialogDefaults;

public class JaveStartupRunnable
implements IStartupRunnable {
    public JaveStartupRunnable(String[] arguments) {
    }

    @Override
    public void startUp(IStartupMonitor monitor) throws StartupException {
        JavEApplication jave = null;
        try {
            monitor.beginTask("Starting JavE...", -1);
            monitor.subTask("Creating User Interface...");
            DialogDefaults.getInstance().setFrameIconImage(JaveIcons.JAVE_ICON_IMAGE);
            jave = new JavEApplication();
            monitor.subTask("Loading Configuration Files...");
            JaveStartupRunnable.initConfigFiles(monitor.getParentComponent());
            monitor.subTask("Halfway Finished...");
            Filter.init();
            jave.setTool(0);
            monitor.subTask("Crash Recovery...");
            boolean recovered = jave.startupRecovery(monitor);
            monitor.subTask("Creating Menubar...");
            jave.startupMenuBar();
            monitor.subTask("Cleanup");
            jave.startupFinish2();
            monitor.subTask("Creating Tool Options Dialog");
            jave.startupOptionsDialog();
            MacOsXInitializer.initializeApplicationCallbacks(jave.getMaxOsXApplicationCallbacks());
            monitor.subTask("That's it :-)");
            jave.startupFinish3();
            jave.getMainPanel().requestFocus();
            jave.getFrame().toFront();
            if (!recovered) {
                JaveApplicationPreferences applicationPreferences = jave.getApplicationPreferences();
                boolean showQuickStartOnStartup = applicationPreferences.isShowQuickStartOnStartup();
                if (showQuickStartOnStartup) {
                    monitor.dispose();
                    QuickStartAction quickStartAction = new QuickStartAction(jave);
                    quickStartAction.performQuickStart(jave.getFrame());
                }
                if (jave.getDocumentManager().getSize() == 0) {
                    jave.doNew();
                }
            }
        }
        catch (StartupException e) {
            throw e;
        }
        catch (Exception e) {
            if (jave != null) {
                jave.dispose();
            }
            throw new StartupException("An error has occured while trying to start JavE.", e);
        }
    }

    public static void initConfigFiles(Component parentComponent) throws StartupException {
        JaveConfigurationFileLoader loader = new JaveConfigurationFileLoader(parentComponent);
        try {
            loader.checkConfigurationFolderExistant();
        }
        catch (ConfigurationException e) {
            throw new StartupException("The program is not installed correctly. If you have unzipped this software from a ZIP file you most probably have forgotten to check the option 'Use folder names' to keep the folder structure as it is in the ZIP file. Try reinstalling the software again.", e);
        }
        loader.initConfigFile(CharSetsConfiguration.getInstance());
        loader.initConfigFile(PixelPlateConfiguration.getInstance());
        loader.initConfigFile(CharacterPlateConfiguration.getInstance());
        loader.initConfigFile(GeneralAlgorithmConfiguration.getInstance());
        loader.initConfigFile(AsciiGradientConfiguration.getInstance());
        loader.initConfigFile(AsciiGreyscaleTableConfiguration.getInstance());
        loader.initConfigFile(AsciiReplaceIllegalConfiguration.getInstance());
        loader.initConfigFile(AsciiRepairAlgorithmConfiguration.getInstance());
        loader.initConfigFile(FigletConfiguration.getInstance());
    }
}

