/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.actions.export;

import de.jave.gui.io.ExtensionFileFilter;
import de.jave.gui.io.FileChooserUtilities;
import de.jave.gui.io.IFileChooserConfiguration;
import de.jave.gui.io.SmartFileFilter;
import de.jave.jave.JaveSelection;
import de.jave.jave.actions.AbstractJaveAction;
import de.jave.jave.actions.enablestrategy.AnyEditorEnabledStrategy;
import de.jave.jave.actions.enablestrategy.IJaveDocumentEditorActionEnabledStrategy;
import de.jave.jave.actions.export.ExportDestination;
import de.jave.jave.actions.export.ITextExportFormat;
import de.jave.jave.actions.export.ITextExportOptions;
import de.jave.jave.actions.export.TextExportDialogModel;
import de.jave.jave.actions.export.TextExportDialogPage;
import de.jave.jave.icon.JaveIcons;
import de.jave.jave.plate.DocumentEditorTitleFactory;
import de.jave.jave.plate.IDocumentEditor;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.preferences.ColorScheme;
import de.jave.lib.CharacterPlate;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;
import net.disy.commons.swing.dialog.userdialog.DefaultDialogConfiguration;
import net.disy.commons.swing.dialog.userdialog.UserDialog;
import net.disy.commons.swing.dialog.userdialog.page.IDialogPage;
import net.disy.commons.swing.fontchooser.model.FontModel;

public final class ExportTextAction
extends AbstractJaveAction {
    private final FileModel currentDirectoryModel;
    private final FontModel displayFontModel;

    public ExportTextAction(JaveMainPanel mainPanel, FileModel currentDirectoryModel, FontModel displayFontModel) {
        super(mainPanel, "Export...", JaveIcons.EXPORT_ICON);
        Ensure.ensureArgumentNotNull(currentDirectoryModel);
        Ensure.ensureArgumentNotNull(displayFontModel);
        this.currentDirectoryModel = currentDirectoryModel;
        this.displayFontModel = displayFontModel;
    }

    @Override
    protected void ececute(Component parentComponent, IDocumentEditor editor) {
        JaveSelection contentOfInterest = editor.getPlate().getContentOfInterest();
        CharacterPlate content = contentOfInterest.getContent();
        TextExportDialogModel model = new TextExportDialogModel();
        ColorScheme colorScheme = editor.getPlate().getDocument().getColorScheme();
        model.getOptionsModel().setForegroundColor(colorScheme.getColorText());
        model.getOptionsModel().setBackgroundColor(colorScheme.getColorPlateBackground());
        model.getOptionsModel().setFont(this.displayFontModel.getFont());
        TextExportDialogPage dialogPage = new TextExportDialogPage(content, model);
        UserDialog dialog = new UserDialog(parentComponent, new DefaultDialogConfiguration<IDialogPage>((IDialogPage)dialogPage){

            @Override
            public Icon getLargeDialogIcon() {
                return JaveIcons.LARGE_EXPORT_WIZARD_ICON;
            }
        });
        dialog.show();
        if (dialog.isCanceled()) {
            return;
        }
        ITextExportFormat format = model.getFormatSelectionModel().getFirstSelectedValue();
        if (model.getDestinationModel().getValue() == ExportDestination.CLIPBOARD) {
            this.performExportToClipboard(parentComponent, content, model, format);
        } else {
            this.performExportToFile(parentComponent, content, model, format);
        }
    }

    private void performExportToFile(Component parentComponent, CharacterPlate content, TextExportDialogModel model, final ITextExportFormat format) {
        final String documentName = DocumentEditorTitleFactory.createShortEditorTitle(this.getMainPanel().getEditor());
        final SmartFileFilter[] fileFilters = format.getFileFilters();
        File file = FileChooserUtilities.performSaveFileChooser(parentComponent, new IFileChooserConfiguration(){

            @Override
            public FileModel getCurrentDirectoryModel() {
                return ExportTextAction.this.currentDirectoryModel;
            }

            @Override
            public String getSaveDialogTitle() {
                return "Save as " + format.getName();
            }

            @Override
            public String getOpenDialogTitle() {
                return null;
            }

            @Override
            public SmartFileFilter[] getFileFilters() {
                return fileFilters;
            }

            @Override
            public String getFileNameSuggestion() {
                SmartFileFilter filter = fileFilters[0];
                if (filter instanceof ExtensionFileFilter) {
                    ExtensionFileFilter extensionFilter = (ExtensionFileFilter)filter;
                    return documentName + "." + extensionFilter.getExtensions().get(0).getString();
                }
                return documentName;
            }

            @Override
            public boolean isMultipleOpenFileSelectionAllowed() {
                return false;
            }
        });
        if (file == null) {
            return;
        }
        try {
            format.convertTo(content, (ITextExportOptions)model.getOptionsModel(), file);
        }
        catch (IOException e) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("Error writing to file '" + file.getAbsolutePath() + "'.", e));
        }
    }

    private void performExportToClipboard(Component parentComponent, CharacterPlate content, TextExportDialogModel model, ITextExportFormat format) {
        Clipboard clipboard = parentComponent.getToolkit().getSystemClipboard();
        format.convertTo(content, (ITextExportOptions)model.getOptionsModel(), clipboard);
    }

    @Override
    protected IJaveDocumentEditorActionEnabledStrategy getEnabledStrategy() {
        return AnyEditorEnabledStrategy.getInstance();
    }
}

