/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.JavELauncher;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class Jave {
    public static void main(String[] args) {
        if (!Jave.isJre16OrGreater()) {
            Jave.printAndShowJdkOutdatedError();
            return;
        }
        Jave.launchJavE(args);
    }

    private static void launchJavE(String[] args) {
        JavELauncher.launchJavE(args);
    }

    private static void printAndShowJdkOutdatedError() {
        String version = System.getProperty("java.version");
        String message = "Error: The version of your JRE (Java Runtime Environment) is outdated.\n\nJavE requires a JRE 1.6.0 or greater to be installed.\nYour version is: " + version + ".\n\nPlease update your JRE and try again.";
        System.err.println(message);
        String title = "Error: JRE outdated";
        Jave.showAwtErrorMessageDialog(message, "Error: JRE outdated");
    }

    private static void showAwtErrorMessageDialog(String message, String title) {
        final Frame frame = new Frame(title);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Jave.disposeAndExitWithError(frame);
            }
        });
        frame.setLayout(new BorderLayout());
        TextArea textArea = new TextArea(message, 0, 0, 3);
        textArea.setEditable(false);
        frame.add((Component)textArea, "Center");
        Panel buttonPanel = new Panel(new FlowLayout(2));
        Button exitButton = new Button("Exit");
        exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Jave.disposeAndExitWithError(frame);
            }
        });
        buttonPanel.add(exitButton);
        frame.add((Component)buttonPanel, "South");
        frame.pack();
        Jave.centerOnScreen(frame);
        frame.setVisible(true);
    }

    private static void disposeAndExitWithError(Frame frame) {
        frame.dispose();
        System.exit(1);
    }

    public static void centerOnScreen(Window window) {
        try {
            Dimension screenSize = window.getToolkit().getScreenSize();
            Dimension windowSize = window.getSize();
            int x = (screenSize.width - windowSize.width) / 2;
            int y = (screenSize.height - windowSize.height) / 2;
            ((Component)window).setLocation(x, y);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isJre16OrGreater() {
        String classNameOfClassThatCameWithJdk16 = "java.awt.Desktop";
        try {
            Class.forName("java.awt.Desktop");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

