/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.tablecreation;

import java.awt.geom.Rectangle2D;

public class FieldBounds {
    private static final double HANDLE_WIDTH = 6.0;
    private static final double HANDLE_EDGE_DISTANCE = 40.0;
    private double x0;
    private double y0;
    private double x1;
    private double y1;

    public FieldBounds(double x0, double y0, double x1, double y1) {
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
    }

    public void growLeft() {
        this.x0 -= 0.5;
    }

    public void shrinkLeft() {
        this.x0 += 0.5;
    }

    public void growRight() {
        this.x1 += 0.5;
    }

    public void shrinkRight() {
        this.x1 -= 0.5;
    }

    public void shrinkBottom() {
        this.y1 -= 0.5;
    }

    public void growBottom() {
        this.y1 += 0.5;
    }

    public void shrinkTop() {
        this.y0 -= 0.5;
    }

    public void growTop() {
        this.y0 += 0.5;
    }

    public Rectangle2D getRectangle() {
        return new Rectangle2D.Double(this.x0, this.y0, this.x1 - this.x0, this.y1 - this.y0);
    }

    public Rectangle2D getLeftOuterHandleRectangle() {
        return new Rectangle2D.Double(this.x0 - 6.0, this.y0 + 40.0, 6.0, this.y1 - this.y0 - 40.0 - 40.0);
    }

    public Rectangle2D getLeftInnerHandleRectangle() {
        return new Rectangle2D.Double(this.x0, this.y0 + 40.0, 6.0, this.y1 - this.y0 - 40.0 - 40.0);
    }

    public Rectangle2D getRightOuterHandleRectangle() {
        return new Rectangle2D.Double(this.x1, this.y0 + 40.0, 6.0, this.y1 - this.y0 - 40.0 - 40.0);
    }

    public Rectangle2D getRightInnerHandleRectangle() {
        return new Rectangle2D.Double(this.x1 - 6.0, this.y0 + 40.0, 6.0, this.y1 - this.y0 - 40.0 - 40.0);
    }

    public Rectangle2D getTopOuterHandleRectangle() {
        return new Rectangle2D.Double(this.x0 + 40.0, this.y0 - 6.0, this.x1 - this.x0 - 40.0 - 40.0, 6.0);
    }

    public Rectangle2D getTopInnerHandleRectangle() {
        return new Rectangle2D.Double(this.x0 + 40.0, this.y0, this.x1 - this.x0 - 40.0 - 40.0, 6.0);
    }

    public Rectangle2D getBottomOuterHandleRectangle() {
        return new Rectangle2D.Double(this.x0 + 40.0, this.y1, this.x1 - this.x0 - 40.0 - 40.0, 6.0);
    }

    public Rectangle2D getBottomInnerHandleRectangle() {
        return new Rectangle2D.Double(this.x0 + 40.0, this.y1 - 6.0, this.x1 - this.x0 - 40.0 - 40.0, 6.0);
    }

    public Rectangle2D getInnerFieldRectangle(int characterCode) {
        int x = (characterCode - 32) % 19;
        int y = (characterCode - 32) / 19;
        double charWidth = (this.x1 - this.x0) / 21.0 / 3.0;
        double charHeight = (this.y1 - this.y0) / 7.0 / 3.0;
        double xx = this.x0 + ((double)x * 3.0 + 3.0) * charWidth;
        double yy = this.y0 + ((double)y * 3.0 + 3.0) * charHeight;
        return new Rectangle2D.Double(xx, yy, 2.0 * charWidth, 2.0 * charHeight);
    }
}

