/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui.splash;

import de.jave.gui.splash.AwtSplashScreenWindow;
import de.jave.gui.splash.FallbackSplashWindow;
import de.jave.gui.splash.ISplashScreenSetup;
import de.jave.gui.splash.ISplashWindow;
import de.jave.gui.splash.IStartupMonitor;
import de.jave.gui.splash.IStartupRunnable;
import de.jave.gui.splash.StartupException;
import java.awt.Component;
import java.awt.SplashScreen;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;

public class SplashScreenManager {
    private static final long MIN_VISIBLE_TIME = 1500L;
    private final ISplashWindow window;

    public SplashScreenManager(ISplashScreenSetup setup) {
        Ensure.ensureArgumentNotNull(setup);
        SplashScreen awtSplash = SplashScreen.getSplashScreen();
        this.window = awtSplash == null ? new FallbackSplashWindow(setup) : new AwtSplashScreenWindow(awtSplash, setup);
    }

    public void startup(IStartupRunnable runnable) {
        long startTime = System.currentTimeMillis();
        Thread.yield();
        try {
            runnable.startUp(new IStartupMonitor(){

                @Override
                public void beginTask(String taskName, int totalWork) {
                    SplashScreenManager.this.window.setProgressText(taskName);
                    Thread.yield();
                }

                @Override
                public void subTask(String name) {
                    SplashScreenManager.this.window.setProgressText(name);
                    Thread.yield();
                }

                @Override
                public void dispose() {
                    SplashScreenManager.this.window.dispose();
                }

                @Override
                public Component getParentComponent() {
                    return SplashScreenManager.this.window.getOptionalComponentForParent();
                }
            });
            long time = System.currentTimeMillis() - startTime;
            if (time < 1500L) {
                try {
                    Thread.sleep(1500L - time);
                }
                catch (InterruptedException exception1) {
                    // empty catch block
                }
            }
            this.window.dispose();
        }
        catch (StartupException exception) {
            exception.printStackTrace();
            String message = exception.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = exception.toString();
            }
            this.window.dispose();
            MessageDialogFactory.showMessageDialog(null, new Message(message, exception));
            System.exit(1);
        }
        catch (Throwable exception) {
            exception.printStackTrace();
            String message = exception.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = exception.toString();
            }
            this.window.dispose();
            MessageDialogFactory.showMessageDialog(null, new Message(message, exception));
            System.exit(1);
        }
    }
}

