/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.swing.action;

import de.jave.ascii.plate.ITextContentListener;
import de.jave.ascii.plate.textareabased.AsciiTextArea;
import de.jave.ascii.plate.textareabased.AsciiTextAreaProperties;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.disy.commons.core.message.BasicMessage;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.core.util.StringUtilities;
import net.disy.commons.swing.dialog.userdialog.page.AbstractDialogPage;
import net.disy.commons.swing.label.SmartLabel;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;

public final class FontSampleInputDialogPage
extends AbstractDialogPage {
    private AsciiTextArea asciiTextArea;

    public FontSampleInputDialogPage() {
        super("Please provide a text sample to find the FIGlet font, it might have been created from.");
    }

    @Override
    public String getTitle() {
        return "Find Font by Sample";
    }

    @Override
    public JComponent createContent() {
        JPanel panel = new JPanel(new GridDialogLayout(1, false, 0, 0));
        this.asciiTextArea = new AsciiTextArea(new Dimension(30, 12), new AsciiTextAreaProperties());
        this.asciiTextArea.addTextContentListener(new ITextContentListener(){

            @Override
            public void textContentChanged() {
                FontSampleInputDialogPage.this.checkInputValid();
            }
        });
        panel.add(new SmartLabel("&Sample:", this.asciiTextArea.getContent()));
        panel.add((Component)this.asciiTextArea.getContent(), GridDialogLayoutData.FILL_BOTH);
        return panel;
    }

    @Override
    public IBasicMessage createCurrentMessage() {
        if (StringUtilities.isNullOrTrimmedEmpty(this.asciiTextArea.getText())) {
            return new BasicMessage("The sample text is empty. Please provide a text sample to find the FIGlet font, it might have been created from.", MessageType.ERROR);
        }
        return this.getDefaultMessage();
    }

    public String getSampleText() {
        return this.asciiTextArea.getText();
    }
}

