/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.smarttable.filtered;

import java.awt.Component;
import javax.swing.JTextField;
import net.disy.commons.core.model.ObjectModel;
import net.disy.commons.core.model.listener.IChangeListener;
import net.disy.commons.core.util.StringUtilities;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.icon.CommonIcons;

public final class ClearFilterTextFieldAction
extends SmartAction {
    private final ObjectModel<String> model;
    private final JTextField textField;

    public ClearFilterTextFieldAction(JTextField textField, ObjectModel<String> model) {
        super(CommonIcons.DELETE);
        this.setToolTipText("Filter zur\u00fccksetzen");
        this.textField = textField;
        this.model = model;
        model.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                ClearFilterTextFieldAction.this.updateEnabled();
            }
        });
        this.updateEnabled();
    }

    private void updateEnabled() {
        this.setEnabled(!StringUtilities.isNullOrEmpty(this.model.getValue()));
    }

    @Override
    protected void execute(Component parentComponent) {
        this.model.setValue("");
        this.textField.requestFocus();
    }
}

