/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.layout.grid;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import net.disy.commons.swing.layout.grid.EndOfLineMarkerComponent;
import net.disy.commons.swing.layout.grid.Grid;
import net.disy.commons.swing.layout.grid.GridCell;
import net.disy.commons.swing.layout.grid.GridCoverage;
import net.disy.commons.swing.layout.grid.IGridDialogLayoutData;
import net.disy.commons.swing.layout.util.GridCellSizeList;

public class GridBuilder {
    private int columnIndex = 0;
    private int rowIndex = 0;
    private final GridCoverage gridCoverage;
    private final List<GridCell> gridCells = new ArrayList<GridCell>();
    private final int columnCount;

    public GridBuilder(int columnCount) {
        if (columnCount < 1) {
            throw new IllegalArgumentException("ColumnCount must be >=1, was " + columnCount);
        }
        this.columnCount = columnCount;
        this.gridCoverage = new GridCoverage(columnCount);
    }

    public void add(Component component, IGridDialogLayoutData layoutData) {
        if (component instanceof EndOfLineMarkerComponent) {
            if (this.columnIndex != 0) {
                this.columnIndex = 0;
                ++this.rowIndex;
            }
            return;
        }
        while (this.gridCoverage.isCovered(this.columnIndex, this.rowIndex)) {
            this.gotoNextCell(1);
        }
        if (this.columnIndex + layoutData.getHorizontalSpan() > this.columnCount) {
            throw new IllegalArgumentException("Illegal horizontal span " + layoutData.getHorizontalSpan() + " in GridLayoutData for component at column " + this.columnIndex + " in " + this.columnCount + " columns GridDialogLayout.");
        }
        GridCell gridCell = new GridCell(component, layoutData, this.columnIndex, this.rowIndex);
        this.gridCells.add(gridCell);
        this.gridCoverage.add(gridCell);
        this.gotoNextCell(layoutData.getHorizontalSpan());
    }

    private void gotoNextCell(int count) {
        this.columnIndex += count;
        if (this.columnIndex >= this.columnCount) {
            this.columnIndex = 0;
            ++this.rowIndex;
        }
    }

    public Grid createGrid(int horizontalSpacing, int verticalSpacing) {
        GridCell cell;
        int i;
        int rowCount = 0;
        for (int i2 = 0; i2 < this.gridCells.size(); ++i2) {
            GridCell cell2 = this.gridCells.get(i2);
            int maxRowIndex = cell2.getRowIndex() + cell2.getRowSpan() - 1;
            if (maxRowIndex + 1 <= rowCount) continue;
            rowCount = maxRowIndex + 1;
        }
        GridCellSizeList rowSizes = new GridCellSizeList(rowCount);
        GridCellSizeList columnSizes = new GridCellSizeList(this.columnCount);
        Grid grid = new Grid(rowSizes, columnSizes, this.gridCells.toArray(new GridCell[this.gridCells.size()]));
        this.initializeExcessFlags(rowSizes, columnSizes);
        for (i = 0; i < this.gridCells.size(); ++i) {
            cell = this.gridCells.get(i);
            if (cell.getColumnSpan() == 1) {
                int minimumWidth = cell.getMinimumSize().width;
                columnSizes.get(cell.getColumnIndex()).guaranteeMinimumSize(minimumWidth);
                int preferredWidth = cell.getPreferredSize().width;
                columnSizes.get(cell.getColumnIndex()).guaranteePreferredSize(preferredWidth);
            }
            if (cell.getRowSpan() != 1) continue;
            int minimumHeight = cell.getMinimumSize().height;
            rowSizes.get(cell.getRowIndex()).guaranteeMinimumSize(minimumHeight);
            int preferredHeight = cell.getPreferredSize().height;
            rowSizes.get(cell.getRowIndex()).guaranteePreferredSize(preferredHeight);
        }
        for (i = 0; i < this.gridCells.size(); ++i) {
            int availablePreferredHeight;
            cell = this.gridCells.get(i);
            if (cell.getColumnSpan() > 1) {
                int availablePreferredWidth;
                int availableMinimumWidth = columnSizes.getAvailableMinimumSize(cell.getColumnIndex(), cell.getColumnSpan(), horizontalSpacing);
                if (cell.getMinimumSize().width > availableMinimumWidth) {
                    GridCellSizeList grabbingColumnSizes = grid.getGrabbingColumnSizes(cell.getColumnIndex(), cell.getColumnSpan());
                    if (grabbingColumnSizes.size() > 0) {
                        grabbingColumnSizes.increaseMinimumSizes(0, grabbingColumnSizes.size(), cell.getMinimumSize().width - availableMinimumWidth);
                    } else {
                        columnSizes.increaseMinimumSizes(cell.getColumnIndex(), cell.getColumnSpan(), cell.getMinimumSize().width - availableMinimumWidth);
                    }
                }
                if (cell.getPreferredSize().width > (availablePreferredWidth = columnSizes.getAvailablePreferredSize(cell.getColumnIndex(), cell.getColumnSpan(), horizontalSpacing))) {
                    GridCellSizeList grabbingColumnSizes = grid.getGrabbingColumnSizes(cell.getColumnIndex(), cell.getColumnSpan());
                    if (grabbingColumnSizes.size() > 0) {
                        grabbingColumnSizes.increasePreferredSizes(0, grabbingColumnSizes.size(), cell.getPreferredSize().width - availablePreferredWidth);
                    } else {
                        columnSizes.increasePreferredSizes(cell.getColumnIndex(), cell.getColumnSpan(), cell.getPreferredSize().width - availablePreferredWidth);
                    }
                }
            }
            if (cell.getRowSpan() <= 1) continue;
            int availableMinimumHeight = rowSizes.getAvailableMinimumSize(cell.getRowIndex(), cell.getRowSpan(), verticalSpacing);
            if (cell.getMinimumSize().height > availableMinimumHeight) {
                GridCellSizeList grabbingRowSizes = grid.getGrabbingRowSizes(cell.getRowIndex(), cell.getRowSpan());
                if (grabbingRowSizes.size() > 0) {
                    grabbingRowSizes.increaseMinimumSizes(0, grabbingRowSizes.size(), cell.getMinimumSize().height - availableMinimumHeight);
                } else {
                    rowSizes.increaseMinimumSizes(cell.getRowIndex(), cell.getRowSpan(), cell.getMinimumSize().height - availableMinimumHeight);
                }
            }
            if (cell.getPreferredSize().height <= (availablePreferredHeight = rowSizes.getAvailablePreferredSize(cell.getRowIndex(), cell.getRowSpan(), verticalSpacing))) continue;
            GridCellSizeList grabbingRowSizes = grid.getGrabbingRowSizes(cell.getRowIndex(), cell.getRowSpan());
            if (grabbingRowSizes.size() > 0) {
                grabbingRowSizes.increasePreferredSizes(0, grabbingRowSizes.size(), cell.getPreferredSize().height - availablePreferredHeight);
                continue;
            }
            rowSizes.increasePreferredSizes(cell.getRowIndex(), cell.getRowSpan(), cell.getPreferredSize().height - availablePreferredHeight);
        }
        return grid;
    }

    private void initializeExcessFlags(GridCellSizeList rowSizes, GridCellSizeList columnSizes) {
        for (int i = 0; i < this.gridCells.size(); ++i) {
            GridCell cell = this.gridCells.get(i);
            if (cell.getLayoutData().isGrabExcessHorizontalSpace()) {
                columnSizes.get(cell.getColumnIndex() + cell.getColumnSpan() - 1).setGrabExcessSpace(true);
            }
            if (!cell.getLayoutData().isGrabExcessVerticalSpace()) continue;
            rowSizes.get(cell.getRowIndex() + cell.getRowSpan() - 1).setGrabExcessSpace(true);
        }
    }
}

