/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import net.disy.commons.core.io.FileUtilities;
import net.disy.commons.core.io.IOUtilities;
import net.disy.commons.core.io.UriUtilities;
import net.disy.commons.core.util.ArrayUtilities;
import net.disy.commons.core.util.ITransformer;

public class ClassLoaderUtilities {
    private static Map<URI, Manifest> manifests = new HashMap<URI, Manifest>();

    public static void addToClassPath(ClassLoader classLoader, String name) throws IOException {
        ClassLoaderUtilities.addToClassPath(classLoader, new File(name));
    }

    public static void addToClassPath(ClassLoader classLoader, File path) throws IOException {
        File[] files;
        if (path.isDirectory() && (files = ClassLoaderUtilities.listJarFiles(path)).length != 0) {
            for (File file : files) {
                ClassLoaderUtilities.addToClassPath(classLoader, file);
            }
            return;
        }
        ClassLoaderUtilities.addToClassPath(classLoader, path.toURI().toURL());
    }

    private static File[] listJarFiles(File path) {
        File[] files = path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                String extension = FileUtilities.getExtension(file);
                return "jar".equalsIgnoreCase(extension) || "zip".equalsIgnoreCase(extension);
            }
        });
        return files;
    }

    public static void addToClassPath(ClassLoader classLoader, URL url) throws IOException {
        if (!(classLoader instanceof URLClassLoader)) {
            throw new IOException("Error, could not add URL to system classloader");
        }
        URLClassLoader sysloader = (URLClassLoader)classLoader;
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Class[] parameters = new Class[]{URL.class};
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysloader, url);
        }
        catch (Throwable t) {
            throw new IOException("Error, could not add URL to system classloader", t);
        }
    }

    public static String getClassPath(ClassLoader classLoader) {
        URI[] classPathList = ClassLoaderUtilities.getClassPathUris(classLoader);
        String classPath = "";
        for (URI url : classPathList) {
            classPath = classPath + " " + url.toString();
        }
        return classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest getManifest(URI uri) {
        if (uri == null) {
            return null;
        }
        Manifest manifest = manifests.get(uri);
        if (manifest != null) {
            return manifest;
        }
        InputStream inputStream = null;
        try {
            inputStream = uri.toURL().openStream();
            JarInputStream jarInputStream = new JarInputStream(inputStream);
            manifest = jarInputStream.getManifest();
            if (manifest != null) {
                manifests.put(uri, manifest);
            }
            Manifest manifest2 = manifest;
            return manifest2;
        }
        catch (IOException exception) {
            Manifest manifest3 = null;
            return manifest3;
        }
        finally {
            IOUtilities.close(inputStream);
        }
    }

    public static URI[] getLibraries(Manifest manifest, String parent) {
        String classPath = ClassLoaderUtilities.getClassPath(manifest);
        if (classPath == null) {
            return new URI[0];
        }
        ArrayList<URI> urls = new ArrayList<URI>();
        StringTokenizer stringTokenizer = new StringTokenizer(classPath, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                URI uri = new URI(string);
                if (!uri.isAbsolute()) {
                    try {
                        File file = new File(new File(parent == null ? System.getProperty("user.dir") : parent), string);
                        urls.add(file.getCanonicalFile().toURI());
                    }
                    catch (IOException exception) {
                        urls.add(new URI(string));
                    }
                    continue;
                }
                if ("file".equalsIgnoreCase(uri.getScheme())) {
                    try {
                        urls.add(new File(uri).getCanonicalFile().toURI());
                    }
                    catch (IOException exception) {
                        urls.add(new URI(string));
                    }
                    continue;
                }
                urls.add(uri);
            }
            catch (URISyntaxException e) {}
        }
        return urls.toArray(new URI[urls.size()]);
    }

    private static String getClassPath(Manifest manifest) {
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        String classPath = attributes.getValue("Class-Path");
        if (classPath == null) {
            return null;
        }
        return classPath;
    }

    public static URI[] getClassPathUris(ClassLoader classLoader) {
        if (!(classLoader instanceof URLClassLoader)) {
            return new URI[0];
        }
        URLClassLoader sysloader = (URLClassLoader)classLoader;
        URI[] classPathList = ArrayUtilities.transform(sysloader.getURLs(), URI.class, new ITransformer<URL, URI>(){

            @Override
            public URI transform(URL input) {
                try {
                    return input.toURI();
                }
                catch (URISyntaxException exception) {
                    return null;
                }
            }
        });
        return classPathList;
    }

    public static URI[] getLibraries(ClassLoader classLoader) {
        URI[] classPathUrls = ClassLoaderUtilities.getClassPathUris(classLoader);
        if (classPathUrls.length == 0) {
            return classPathUrls;
        }
        ArrayList<URI> libraryList = new ArrayList<URI>();
        for (URI url : classPathUrls) {
            String string;
            int length = (string = url.toString()).length();
            if (!string.substring(length - 4 < 0 ? 0 : length - 4, length).equalsIgnoreCase(".jar")) continue;
            libraryList.add(url);
        }
        ArrayList<URI> subLibraryList = new ArrayList<URI>();
        for (URI uri : libraryList) {
            URI[] classPaths;
            Manifest manifest = ClassLoaderUtilities.getManifest(uri);
            if (manifest == null) continue;
            for (URI classPath : classPaths = ClassLoaderUtilities.getLibraries(manifest, ClassLoaderUtilities.getParent(uri))) {
                if (libraryList.contains(classPath) || classPath.isAbsolute() && "file".equalsIgnoreCase(classPath.getScheme()) && !new File(classPath).exists()) continue;
                subLibraryList.add(classPath);
            }
        }
        libraryList.addAll(subLibraryList);
        return libraryList.toArray(new URI[libraryList.size()]);
    }

    public static String getParent(URI uri) {
        if (UriUtilities.isFile(uri)) {
            return new File(uri).getParent();
        }
        return null;
    }
}

