/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp.net;

import de.grogra.imp.IMP;
import de.grogra.imp.IMPWorkbench;
import de.grogra.imp.net.Connection;
import de.grogra.imp.net.MessageHandler;
import de.grogra.imp.net.MessageInfo;
import de.grogra.imp.net.RemoteClientImpl;
import de.grogra.imp.net.SimpleResponseHandler;
import de.grogra.pf.boot.Main;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.registry.UIItem;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public final class Commands
implements MessageHandler {
    private final Workbench workbench;

    public Commands(Workbench workbench) {
        this.workbench = workbench;
    }

    public boolean handleMessage(Connection connection, long l, String string, boolean bl) throws IOException {
        String string2 = "/connection/commands/" + string;
        Item item = Item.resolveItem((RegistryContext)this.workbench.getMainWorkbench(), (String)string2);
        if (item instanceof Command) {
            if (bl) {
                return item instanceof UIItem ? ((UIItem)item).isAvailable((Context)this.workbench) : UI.isAvailable((Item)item, (Context)this.workbench);
            }
            this.workbench.getLogger().log(Workbench.GUI_INFO, "Connection to " + connection.getSocket().getRemoteSocketAddress() + " induces execution of command " + item.getAbsoluteName());
            ((Command)item).run((Object)new MessageInfo(connection, l, string), (Context)this.workbench);
            return true;
        }
        return false;
    }

    public static void connectRemoteWorkbench(Item item, Object object, Context context) throws IOException {
        MessageInfo messageInfo = (MessageInfo)object;
        new RemoteClientImpl(context.getWorkbench(), messageInfo.connection, messageInfo.messageId);
    }

    public static Connection add(Context context) throws IOException {
        Socket socket = Commands.getSocket(context, "localhost:58090");
        Connection connection = new Connection(socket);
        connection.start();
        ((IMPWorkbench)context.getWorkbench()).addConnection(connection);
        return connection;
    }

    public static void openClientWorkbench(Item item, Object object, Context context) {
        final MessageInfo messageInfo = (MessageInfo)object;
        UI.getJobManager((Context)context).runLater(new Command(){

            public String getCommandName() {
                return null;
            }

            public void run(Object object, Context context) {
                try {
                    IMP.openClientWorkbench(messageInfo.connection, context);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }, null, context, 10000);
    }

    public static void availableProcessors(Item item, Object object, Context context) throws IOException {
        MessageInfo messageInfo = (MessageInfo)object;
        long l = messageInfo.connection.beginResponse(messageInfo.messageId, null);
        messageInfo.connection.getOut().writeInt(Runtime.getRuntime().availableProcessors());
        messageInfo.connection.end(l);
    }

    public static void version(Item item, Object object, Context context) throws IOException {
        MessageInfo messageInfo = (MessageInfo)object;
        long l = messageInfo.connection.beginResponse(messageInfo.messageId, null);
        messageInfo.connection.getOut().writeUTF(Main.getVersion());
        messageInfo.connection.end(l);
    }

    public static SimpleResponseHandler getAvailableProcessors(Connection connection) throws IOException {
        SimpleResponseHandler simpleResponseHandler = new SimpleResponseHandler(0);
        long l = connection.beginMessage("processors", simpleResponseHandler);
        connection.end(l);
        return simpleResponseHandler;
    }

    public static SimpleResponseHandler getVersion(Connection connection) throws IOException {
        SimpleResponseHandler simpleResponseHandler = new SimpleResponseHandler(2);
        long l = connection.beginMessage("version", simpleResponseHandler);
        connection.end(l);
        return simpleResponseHandler;
    }

    public static void sendMessage(Connection connection, String string) throws IOException {
        long l = connection.beginMessage(string, null);
        connection.end(l);
    }

    private static int checkPort(String string, Context context) {
        String string2 = null;
        try {
            int n = Integer.parseInt(string.trim());
            if (n > 0 && n <= 65535) {
                return n;
            }
            string2 = "socket.illegal-port-number";
        }
        catch (NumberFormatException numberFormatException) {
            string2 = "socket.port-not-numeric";
        }
        string2 = IMP.I18N.msg(string2, (Object)string);
        Commands.illegalPort(string2, context);
        return -1;
    }

    private static void illegalPort(String string, Context context) {
        context.getWindow().showDialog(IMP.I18N.msg("socket.illegal-port"), (Object)string, 1);
    }

    private static String getSimpleName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return n >= 0 ? string.substring(n + 1) : string;
    }

    public static Socket getSocket(Context context, String string) {
        String string2;
        while ((string2 = context.getWindow().showInputDialog(IMP.I18N.msg("chooseserver.title"), (Object)IMP.I18N.msg("chooseserver.msg"), string)) != null) {
            String string3;
            int n = string2.indexOf(58);
            if (n < 0) {
                string3 = IMP.I18N.msg("socket.colon-missing", (Object)string2);
            } else {
                int n2 = Commands.checkPort(string2.substring(n + 1), context);
                if (n2 < 0) continue;
                try {
                    return new Socket(string2.substring(0, n).trim(), n2);
                }
                catch (IOException iOException) {
                    string3 = Commands.getSimpleName(iOException.getClass()) + ": " + iOException.getMessage();
                }
            }
            context.getWindow().showDialog(IMP.I18N.msg("socket.illegal-address"), (Object)string3, 1);
        }
        return null;
    }

    public static ServerSocket getServerSocket(Context context, int n) {
        while (true) {
            String string = String.valueOf(n);
            if (context.getWindow() != null) {
                string = context.getWindow().showInputDialog(IMP.I18N.msg("startserver.title"), (Object)IMP.I18N.msg("startserver.msg-port"), string);
            }
            if (string == null) {
                return null;
            }
            int n2 = Commands.checkPort(string, context);
            if (n2 <= 0) continue;
            try {
                return new ServerSocket(n2);
            }
            catch (IOException iOException) {
                Commands.illegalPort(Commands.getSimpleName(iOException.getClass()) + ": " + iOException.getMessage(), context);
                continue;
            }
            break;
        }
    }
}

