/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp.io;

import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.OutputStreamSource;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;

public class ImageWriter
extends FilterBase
implements OutputStreamSource {
    public static final IOFlavor RENDERED_IMAGE_FLAVOR = IOFlavor.valueOf(RenderedImage.class);

    public ImageWriter(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(filterItem.getOutputFlavor());
    }

    public void write(OutputStream outputStream) throws IOException {
        RenderedImage renderedImage = (RenderedImage)((ObjectSource)this.source).getObject();
        while (true) {
            int n;
            Object object;
            Iterator<javax.imageio.ImageWriter> iterator;
            if (!(iterator = ImageIO.getImageWritersByMIMEType(this.getFlavor().getMimeType().getMediaType())).hasNext()) {
                throw new IOException("Unsupported image MIME-type " + this.getFlavor().getMimeType());
            }
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!((javax.imageio.ImageWriter)object).getOriginatingProvider().canEncodeImage(renderedImage)) continue;
                ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
                ((javax.imageio.ImageWriter)object).setOutput(imageOutputStream);
                ((javax.imageio.ImageWriter)object).write(renderedImage);
                imageOutputStream.flush();
                ((javax.imageio.ImageWriter)object).dispose();
                return;
            }
            if (!(renderedImage instanceof BufferedImage)) break;
            object = (BufferedImage)renderedImage;
            int n2 = n = ((BufferedImage)object).getType() != 2 && ((BufferedImage)object).getColorModel().hasAlpha() ? 2 : 1;
            if (((BufferedImage)object).getType() == n) break;
            BufferedImage bufferedImage = new BufferedImage(((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight(), n);
            bufferedImage.getGraphics().drawImage((Image)object, 0, 0, null);
            renderedImage = bufferedImage;
        }
        throw new IOException("Image type not supported by image writer.");
    }
}

