/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp;

import de.grogra.graph.ArrayPath;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.GraphUtils;
import de.grogra.graph.Path;
import de.grogra.imp.NavigatorFactory;
import de.grogra.imp.PickElement;
import de.grogra.imp.PickList;
import de.grogra.imp.View;
import de.grogra.imp.edit.ViewSelection;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.JobManager;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.event.ClickEvent;
import de.grogra.pf.ui.event.DragEvent;
import de.grogra.util.Disposable;
import de.grogra.util.DisposableEventListener;
import de.grogra.util.EventListener;
import de.grogra.util.Lockable;
import de.grogra.util.Map;
import de.grogra.util.ModifiableMap;
import de.grogra.util.Utils;
import java.awt.event.MouseEvent;
import java.util.EventObject;

public abstract class ViewEventHandler
implements Disposable,
EventListener {
    private boolean disposed = false;
    private JobManager jm;
    private View view;
    private DisposableEventListener navigator = null;
    private PickList list;
    private PickList list2;
    private PickElement pickInfo = new PickElement();
    private ArrayPath lastSelected = new ArrayPath((Graph)null);
    private static final int NOTHING = 0;
    private static final int HIGHLIGHTED = 1;
    private static final int SELECTED = 2;
    private int highlightState = 0;
    private int highlightIndex;
    private static final int NORMAL = 1;
    private static final int NAVIGATING = 2;
    private static final int DRAGGING = 3;
    private int state = 1;
    private MouseEvent dragEvent = null;
    private MouseEvent pressEvent = null;
    private int pickX;
    private int pickY;
    private int lastDragX;
    private int lastDragY;
    private int tolerance = 10;
    private int highlightDelay = 500;
    private final int[] a2 = new int[2];
    private int chX = -1;
    private int chY;
    private Unhighlight unhighlight = null;

    public ViewEventHandler(View view, boolean bl) {
        this.view = view;
        this.jm = view.getWorkbench().getJobManager();
        this.list = new PickList(10, bl);
        this.list2 = new PickList(10, bl);
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.unhighlight != null) {
            this.unhighlight.cancel();
            this.unhighlight = null;
        }
        this.list.reset();
        this.list2.reset();
        this.pickInfo = null;
        if (this.navigator != null) {
            this.navigator.dispose();
            this.navigator = null;
        }
        this.dragEvent = null;
        this.view = null;
        this.jm = null;
    }

    public final View getView() {
        return this.view;
    }

    private void setState(int n) {
        if (this.state == n) {
            return;
        }
        switch (this.state) {
            case 1: {
                if (this.unhighlight != null) {
                    this.unhighlight.cancel();
                    this.unhighlight = null;
                }
                if (n == 3) break;
                this.resetHighlight();
                break;
            }
            case 2: {
                this.navigator.dispose();
                this.navigator = null;
                break;
            }
            case 3: {
                if (this.dragEvent == null) break;
                this.mouseDragged(this.dragEvent, 2, 0, 0);
                this.dragEvent = null;
            }
        }
        this.state = n;
    }

    public void disposeNavigator(EventObject eventObject) {
        this.setState(1);
        if (eventObject != null) {
            this.eventOccured(eventObject);
        }
    }

    protected abstract NavigatorFactory getNavigatorFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void eventOccured(EventObject eventObject) {
        try {
            View.set(GraphState.current((Graph)this.view.getGraph()), this.view);
            NavigatorFactory navigatorFactory = this.getNavigatorFactory();
            if (this.state == 2) {
                this.navigator.eventOccured(eventObject);
                return;
            }
            if (this.state == 1 && navigatorFactory != null && navigatorFactory.isActivationEvent(eventObject)) {
                UI.consume((Object)eventObject);
                this.setState(2);
                this.navigator = navigatorFactory.createNavigator(this, eventObject);
                return;
            }
            if (!(eventObject instanceof MouseEvent)) {
                return;
            }
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            switch (mouseEvent.getID()) {
                case 501: {
                    if (this.state != 1) return;
                    this.pressEvent = mouseEvent;
                    this.buttonClicked(mouseEvent);
                    return;
                }
                case 502: {
                    if (this.state == 1) {
                        this.buttonClicked(mouseEvent);
                        return;
                    }
                    this.setState(1);
                    return;
                }
                case 500: {
                    if (this.state != 1) return;
                    this.handleClick(mouseEvent);
                    if (mouseEvent.isConsumed()) return;
                    this.buttonClicked(mouseEvent);
                    return;
                }
                case 503: {
                    if (this.state != 1) {
                        this.setState(1);
                    }
                    this.mouseMoved(mouseEvent);
                    mouseEvent.consume();
                    return;
                }
                case 506: {
                    this.dragEvent = mouseEvent;
                    if (this.state == 1) {
                        this.setState(3);
                    }
                    if (this.pressEvent != null) {
                        this.mouseDragged(this.pressEvent, 0, 0, 0);
                        this.lastDragX = this.pressEvent.getX();
                        this.lastDragY = this.pressEvent.getY();
                        this.pressEvent = null;
                    }
                    this.mouseDragged(mouseEvent, 1, mouseEvent.getX() - this.lastDragX, mouseEvent.getY() - this.lastDragY);
                    this.lastDragX = mouseEvent.getX();
                    this.lastDragY = mouseEvent.getY();
                    mouseEvent.consume();
                    return;
                }
                case 505: {
                    this.enqueueUnhighlight();
                    return;
                }
            }
            return;
        }
        finally {
            View.set(GraphState.current((Graph)this.view.getGraph()), null);
        }
    }

    private Path getHighlightedPath(int n) {
        if (this.highlightState == 0) {
            return null;
        }
        this.list.getItem((this.highlightIndex + n + this.list.getSize()) % this.list.getSize(), this.pickInfo);
        return this.pickInfo.path;
    }

    private void handleClick(MouseEvent mouseEvent) {
        if (mouseEvent.isAltDown() && this.highlightState != 0 && this.list.getSize() > 1) {
            mouseEvent.consume();
            this.a2[0] = this.highlightIndex++;
            if (mouseEvent.isControlDown()) {
                if (this.highlightIndex == 0) {
                    this.highlightIndex = this.list.getSize();
                }
            } else if (this.highlightIndex == this.list.getSize()) {
                this.highlightIndex = 0;
            }
            this.a2[1] = --this.highlightIndex;
            this.highlight(this.list, this.highlightIndex, this.a2);
            this.highlightState = 2;
            this.lastSelected.set(this.getHighlightedPath(0));
            if (this.unhighlight != null) {
                this.enqueueUnhighlight();
            }
        }
    }

    protected void mouseMoved(final MouseEvent mouseEvent) {
        if (this.highlightState != 2 || Math.abs(mouseEvent.getX() - this.pickX) > this.tolerance || Math.abs(mouseEvent.getY() - this.pickY) > this.tolerance) {
            UI.executeLockedly((Lockable)this.view.getGraph(), (boolean)false, (Command)new Command(){

                public String getCommandName() {
                    return null;
                }

                public void run(Object object, Context context) {
                    ViewEventHandler.this.calculateHighlight(mouseEvent.getX(), mouseEvent.getY());
                }
            }, (Object)mouseEvent, (Context)this.view, (int)66536);
        }
    }

    public void updateHighlight() {
        if (this.chX >= 0) {
            this.calculateHighlight(this.chX, this.chY);
        }
    }

    private void calculateHighlight(int n, int n2) {
        this.chX = n;
        this.chY = n2;
        this.view.pick(n, n2, this.list2);
        if (this.list2.getSize() > 0) {
            if (this.unhighlight != null) {
                this.unhighlight.cancel();
                this.unhighlight = null;
            }
            if (this.list2.equals((Object)this.list)) {
                this.list2.reset();
            } else {
                ModifiableMap modifiableMap;
                this.resetHighlight();
                PickList pickList = this.list;
                this.list = this.list2;
                this.list2 = pickList;
                this.pickX = n;
                this.pickY = n2;
                this.highlightIndex = -1;
                for (int i = 0; i < this.list.getSize(); ++i) {
                    this.list.getItem(i, this.pickInfo);
                    if (!GraphUtils.equal((Path)this.pickInfo.path, (Path)this.lastSelected)) continue;
                    this.highlightIndex = i;
                    break;
                }
                if (this.highlightIndex < 0) {
                    this.lastSelected.clear(null);
                    this.highlightIndex = 0;
                }
                if (Utils.getBoolean((Map)(modifiableMap = UI.getOptions((Context)this.getView().getWorkbench())), (Object)"highlightOnMove", (boolean)true)) {
                    this.highlight(this.list, this.highlightIndex, null);
                }
                this.highlightState = 1;
            }
        } else if (this.highlightState != 0 && this.unhighlight == null) {
            this.enqueueUnhighlight();
        }
    }

    private void enqueueUnhighlight() {
        if (this.unhighlight != null) {
            this.unhighlight.cancel();
        }
        this.unhighlight = new Unhighlight();
        this.jm.runLater((long)this.highlightDelay, (Command)this.unhighlight, null, (Context)this.view);
    }

    private void resetHighlight() {
        if (this.unhighlight != null) {
            this.unhighlight.cancel();
            this.unhighlight = null;
        }
        if (this.highlightState != 0) {
            this.highlight(this.list, -1, null);
            this.list.reset();
            this.highlightState = 0;
        }
    }

    private void highlight(PickList pickList, int n, int[] nArray) {
        ViewSelection viewSelection = ViewSelection.get((Context)this.view);
        int n2 = -1;
        int n3 = -1;
        while (true) {
            if (nArray == null) {
                if (++n2 == pickList.getSize()) {
                    break;
                }
            } else {
                if (++n3 == nArray.length) break;
                n2 = nArray[n3];
            }
            int n4 = n >= 0 ? (n2 == n ? 3 : 1) : 0;
            ArrayPath arrayPath = pickList.getPath(n2);
            if (this.view.isToolGraph(arrayPath.getGraph())) continue;
            viewSelection.removeAndAdd(3, n4, (Path)arrayPath);
        }
    }

    protected void buttonClicked(MouseEvent mouseEvent) {
        ViewSelection viewSelection;
        mouseEvent.consume();
        ArrayPath arrayPath = null;
        boolean bl = false;
        for (int i = 0; i < this.list.getSize(); ++i) {
            Path path = this.getHighlightedPath(i);
            if (path == null) continue;
            if (this.view.isToolGraph(path.getGraph())) {
                if (i != 0) continue;
                bl = true;
                continue;
            }
            arrayPath = path;
            break;
        }
        if (!(bl || mouseEvent.getID() != 501 || mouseEvent.isAltDown() || mouseEvent.isMetaDown() || (viewSelection = ViewSelection.get((Context)this.view)) == null)) {
            if (arrayPath != null) {
                if (mouseEvent.isControlDown()) {
                    viewSelection.toggle(4, (Path)arrayPath);
                } else {
                    viewSelection.set(4, new Path[]{arrayPath}, true);
                }
            } else {
                viewSelection.set(4, Path.PATH_0, true);
            }
        }
        if (ViewEventHandler.hasListener(arrayPath)) {
            arrayPath = new ArrayPath(arrayPath);
            ClickEvent clickEvent = this.createClickEvent(mouseEvent);
            clickEvent.set((Context)this.getView(), (Object)arrayPath);
            clickEvent.set(mouseEvent);
            ViewEventHandler.send((EventObject)clickEvent, (Path)arrayPath);
        }
    }

    private static void send(EventObject eventObject, Path path) {
        Object object = path.getObject(-1);
        if (object instanceof EventListener) {
            ((EventListener)object).eventOccured(eventObject);
        }
        if (path.getGraph() instanceof EventListener) {
            ((EventListener)path.getGraph()).eventOccured(eventObject);
        }
    }

    private static boolean hasListener(Path path) {
        if (path == null) {
            return false;
        }
        return path.getObject(-1) instanceof EventListener || path.getGraph() instanceof EventListener;
    }

    protected void mouseDragged(MouseEvent mouseEvent, int n, int n2, int n3) {
        Path path = this.getHighlightedPath(0);
        if (ViewEventHandler.hasListener(path)) {
            path = new ArrayPath(path);
            DragEvent dragEvent = this.createDragEvent(mouseEvent);
            dragEvent.set((Context)this.getView(), (Object)path);
            dragEvent.set(mouseEvent);
            dragEvent.setDragData(n, n2, n3);
            ViewEventHandler.send((EventObject)dragEvent, path);
        }
    }

    protected abstract ClickEvent createClickEvent(MouseEvent var1);

    protected abstract DragEvent createDragEvent(MouseEvent var1);

    private class Unhighlight
    implements Command {
        private boolean canceled = false;

        private Unhighlight() {
        }

        void cancel() {
            this.canceled = true;
        }

        public String getCommandName() {
            return null;
        }

        public void run(Object object, Context context) {
            if (!this.canceled) {
                ViewEventHandler.this.resetHighlight();
            }
        }
    }
}

