/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp;

import de.grogra.imp.View;
import de.grogra.util.Disposable;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.util.ArrayList;

public abstract class Renderer
implements Disposable,
ImageObserver {
    protected View view;
    protected ArrayList<ImageObserver> observers = new ArrayList();
    protected int width;
    protected int height;
    private final Object imageLock = new Object();
    private boolean renderingDone = false;
    private Image finalImage = null;

    public abstract String getName();

    public final void initialize(View view, int n, int n2) {
        this.view = view;
        this.width = n;
        this.height = n2;
        this.initializeImpl();
    }

    public void addImageObserver(ImageObserver imageObserver) {
        imageObserver.getClass();
        this.observers.add(imageObserver);
    }

    protected void initializeImpl() {
    }

    public abstract void render() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl = false;
        for (int i = 0; i < this.observers.size(); ++i) {
            bl |= this.observers.get(i).imageUpdate(image, n, n2, n3, n4, n5);
        }
        if ((n & 0xE0) != 0) {
            Object object = this.imageLock;
            synchronized (object) {
                this.renderingDone = true;
                if ((n & 0xC0) == 0) {
                    this.finalImage = image;
                }
                this.imageLock.notifyAll();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image waitForImage() throws InterruptedException {
        Object object = this.imageLock;
        synchronized (object) {
            while (!this.renderingDone) {
                this.imageLock.wait();
            }
        }
        return this.finalImage;
    }

    public Image computeImage() throws IOException, InterruptedException {
        this.render();
        return this.waitForImage();
    }
}

