/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp;

import de.grogra.graph.ArrayPath;
import de.grogra.graph.GraphState;
import de.grogra.graph.GraphUtils;
import de.grogra.graph.Path;
import de.grogra.imp.PickElement;
import de.grogra.imp.View;
import de.grogra.math.Pool;

public final class PickList
extends Pool {
    private int currentLayer;
    private Path path = null;
    private boolean removeNode;
    private PickElement[] info = new PickElement[0];
    private int size = 0;
    private int maxLength;
    private int groupSize = 0;
    private int x;
    private int y;
    private View view;
    private double minDist;
    private GraphState state;
    private final boolean allowNegativeDist;

    public PickList(int n, boolean bl) {
        this.maxLength = n;
        this.allowNegativeDist = bl;
    }

    public GraphState getGraphState() {
        return this.state;
    }

    public View getView() {
        return this.view;
    }

    public int getViewX() {
        return this.x;
    }

    public int getViewY() {
        return this.y;
    }

    public void reset(View view, int n, int n2) {
        this.view = view;
        this.state = view.getWorkbenchGraphState();
        this.x = n;
        this.y = n2;
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < this.size; ++i) {
            this.info[i].set(null, 0.0);
        }
        this.size = 0;
        this.groupSize = 0;
    }

    public void beginNewGroup() {
        this.groupSize = 0;
    }

    public void setCurrentLayer(int n) {
        this.currentLayer = n;
    }

    public void begin(Path path, boolean bl) {
        this.path = path;
        this.removeNode = bl;
        this.minDist = Double.POSITIVE_INFINITY;
    }

    public void add(double d) {
        if ((this.allowNegativeDist || d >= 0.0) && d < this.minDist) {
            this.minDist = d;
        }
    }

    public void add() {
        if ((double)this.currentLayer < this.minDist) {
            this.minDist = this.currentLayer;
        }
    }

    public boolean containsCurrent() {
        return this.minDist != Double.POSITIVE_INFINITY;
    }

    public void end() {
        PickElement pickElement;
        int n;
        boolean bl;
        if (this.minDist == Double.POSITIVE_INFINITY) {
            return;
        }
        Object object = this.path.getObject(this.removeNode ? -2 : -1);
        boolean bl2 = bl = !this.removeNode;
        if (this.size == this.info.length) {
            this.info = new PickElement[this.size + 10];
            System.arraycopy(this.info, 0, this.info, 0, this.size);
            for (n = this.size; n < this.info.length; ++n) {
                this.info[n] = new PickElement();
            }
        }
        for (n = 0; n < this.groupSize && !(this.minDist < this.info[n].distance); ++n) {
            if (this.info[n].path.endsInNode() != bl || this.info[n].path.getObject(-1) != object) continue;
            return;
        }
        if (n < this.size) {
            pickElement = this.info[this.size];
            System.arraycopy(this.info, n, this.info, n + 1, this.size - n);
            this.info[n] = pickElement;
        } else if (this.size == this.maxLength) {
            return;
        }
        this.info[n].set(this.path, this.minDist);
        if (this.removeNode) {
            this.info[n].path.popNode();
        }
        for (int i = n + 1; i <= this.size; ++i) {
            pickElement = this.info[i];
            if (pickElement.path.endsInNode() != bl || pickElement.path.getObject(-1) != object) continue;
            pickElement.set(null, 0.0);
            if (i < this.size) {
                System.arraycopy(this.info, i + 1, this.info, i, this.size - i);
                this.info[this.size] = pickElement;
            }
            return;
        }
        ++this.size;
        ++this.groupSize;
    }

    public double getMaxDistance() {
        return this.size == 0 ? Double.NEGATIVE_INFINITY : this.info[this.size - 1].distance;
    }

    public void getItem(int n, PickElement pickElement) {
        pickElement.set(this.info[n]);
    }

    public void getPath(int n, ArrayPath arrayPath) {
        arrayPath.set((Path)this.info[n].path);
    }

    public ArrayPath getPath(int n) {
        return new ArrayPath((Path)this.info[n].path);
    }

    public int getSize() {
        return this.size;
    }

    public boolean equals(Object object) {
        if (object instanceof PickList) {
            PickList pickList = (PickList)((Object)object);
            if (pickList.size == this.size) {
                for (int i = 0; i < this.size; ++i) {
                    if (GraphUtils.equal((Path)this.info[i].path, (Path)pickList.info[i].path)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString()).append("[size=").append(this.size).append(":\n");
        for (int i = 0; i < this.size; ++i) {
            stringBuffer.append(this.info[i]);
            stringBuffer.append('\n');
        }
        return stringBuffer.append(']').toString();
    }
}

