/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.GVector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;

public class GMatrix
implements Serializable {
    private double[] elementData;
    private int nRow;
    private int nCol;

    public GMatrix(int n, int n2) {
        if (n < 0) {
            throw new NegativeArraySizeException(n + " < 0");
        }
        if (n2 < 0) {
            throw new NegativeArraySizeException(n2 + " < 0");
        }
        this.nRow = n;
        this.nCol = n2;
        this.elementData = new double[n * n2];
        this.setIdentity();
    }

    public GMatrix(int n, int n2, double[] dArray) {
        if (n < 0) {
            throw new NegativeArraySizeException(n + " < 0");
        }
        if (n2 < 0) {
            throw new NegativeArraySizeException(n2 + " < 0");
        }
        this.nRow = n;
        this.nCol = n2;
        this.elementData = new double[n * n2];
        this.set(dArray);
    }

    public GMatrix(GMatrix gMatrix) {
        this.nRow = gMatrix.nRow;
        this.nCol = gMatrix.nCol;
        int n = this.nRow * this.nCol;
        this.elementData = new double[n];
        System.arraycopy(gMatrix.elementData, 0, this.elementData, 0, n);
    }

    public final void mul(GMatrix gMatrix) {
        this.mul(this, gMatrix);
    }

    public final void mul(GMatrix gMatrix, GMatrix gMatrix2) {
        if (this.nRow != gMatrix.nRow) {
            throw new ArrayIndexOutOfBoundsException("nRow:" + this.nRow + " != m1.nRow:" + gMatrix.nRow);
        }
        if (this.nCol != gMatrix2.nCol) {
            throw new ArrayIndexOutOfBoundsException("nCol:" + this.nCol + " != m2.nCol:" + gMatrix2.nCol);
        }
        if (gMatrix.nCol != gMatrix2.nRow) {
            throw new ArrayIndexOutOfBoundsException("m1.nCol:" + gMatrix.nCol + " != m2.nRow:" + gMatrix2.nRow);
        }
        double[] dArray = new double[this.nCol * this.nRow];
        for (int i = 0; i < this.nRow; ++i) {
            for (int j = 0; j < this.nCol; ++j) {
                double d = 0.0;
                for (int k = 0; k < gMatrix.nCol; ++k) {
                    d += gMatrix.elementData[i * gMatrix.nCol + k] * gMatrix2.elementData[k * gMatrix2.nCol + j];
                }
                dArray[i * this.nCol + j] = d;
            }
        }
        this.elementData = dArray;
    }

    public final void mul(GVector gVector, GVector gVector2) {
        if (this.nRow < gVector.getSize()) {
            throw new IllegalArgumentException("nRow:" + this.nRow + " < v1.getSize():" + gVector.getSize());
        }
        if (this.nCol < gVector2.getSize()) {
            throw new IllegalArgumentException("nCol:" + this.nCol + " < v2.getSize():" + gVector2.getSize());
        }
        for (int i = 0; i < this.nRow; ++i) {
            for (int j = 0; j < this.nCol; ++j) {
                this.elementData[i * this.nCol + j] = gVector.getElement(i) * gVector2.getElement(j);
            }
        }
    }

    public final void add(GMatrix gMatrix) {
        if (this.nRow != gMatrix.nRow || this.nCol != gMatrix.nCol) {
            throw new IllegalArgumentException("this:(" + this.nRow + "x" + this.nCol + ") != m1:(" + gMatrix.nRow + "x" + gMatrix.nCol + ").");
        }
        for (int i = 0; i < this.nRow * this.nCol; ++i) {
            int n = i;
            this.elementData[n] = this.elementData[n] + gMatrix.elementData[i];
        }
    }

    public final void add(GMatrix gMatrix, GMatrix gMatrix2) {
        if (this.nRow != gMatrix.nRow || this.nCol != gMatrix.nCol) {
            throw new IllegalArgumentException("this:(" + this.nRow + "x" + this.nCol + ") != m1:(" + gMatrix.nRow + "x" + gMatrix.nCol + ").");
        }
        if (this.nRow != gMatrix2.nRow || this.nCol != gMatrix2.nCol) {
            throw new IllegalArgumentException("this:(" + this.nRow + "x" + this.nCol + ") != m2:(" + gMatrix2.nRow + "x" + gMatrix2.nCol + ").");
        }
        for (int i = 0; i < this.nRow * this.nCol; ++i) {
            this.elementData[i] = gMatrix.elementData[i] + gMatrix2.elementData[i];
        }
    }

    public final void sub(GMatrix gMatrix) {
        if (this.nRow != gMatrix.nRow || this.nCol != gMatrix.nCol) {
            throw new IllegalArgumentException("this:(" + this.nRow + "x" + this.nCol + ") != m1:(" + gMatrix.nRow + "x" + gMatrix.nCol + ").");
        }
        for (int i = 0; i < this.nRow * this.nCol; ++i) {
            int n = i;
            this.elementData[n] = this.elementData[n] - gMatrix.elementData[i];
        }
    }

    public final void sub(GMatrix gMatrix, GMatrix gMatrix2) {
        if (this.nRow != gMatrix.nRow || this.nCol != gMatrix.nCol) {
            throw new IllegalArgumentException("this:(" + this.nRow + "x" + this.nCol + ") != m1:(" + gMatrix.nRow + "x" + gMatrix.nCol + ").");
        }
        if (this.nRow != gMatrix2.nRow || this.nCol != gMatrix2.nCol) {
            throw new IllegalArgumentException("this:(" + this.nRow + "x" + this.nCol + ") != m2:(" + gMatrix2.nRow + "x" + gMatrix2.nCol + ").");
        }
        for (int i = 0; i < this.nRow * this.nCol; ++i) {
            this.elementData[i] = gMatrix.elementData[i] - gMatrix2.elementData[i];
        }
    }

    public final void negate() {
        for (int i = 0; i < this.nRow * this.nCol; ++i) {
            this.elementData[i] = -this.elementData[i];
        }
    }

    public final void negate(GMatrix gMatrix) {
        this.set(gMatrix);
        this.negate();
    }

    public final void setIdentity() {
        this.setZero();
        int n = this.nRow < this.nCol ? this.nRow : this.nCol;
        for (int i = 0; i < n; ++i) {
            this.elementData[i * this.nCol + i] = 1.0;
        }
    }

    public final void setZero() {
        for (int i = 0; i < this.nRow * this.nCol; ++i) {
            this.elementData[i] = 0.0;
        }
    }

    public final void identityMinus() {
        this.negate();
        int n = this.nRow < this.nCol ? this.nRow : this.nCol;
        for (int i = 0; i < n; ++i) {
            int n2 = i * this.nCol + i;
            this.elementData[n2] = this.elementData[n2] + 1.0;
        }
    }

    public final void invert() {
        if (this.nRow != this.nCol) {
            throw new ArrayIndexOutOfBoundsException("not a square matrix");
        }
        int n = this.nRow;
        GMatrix gMatrix = new GMatrix(n, n);
        GVector gVector = new GVector(n);
        GVector gVector2 = new GVector(n);
        GVector gVector3 = new GVector(n);
        this.LUD(gMatrix, gVector);
        for (int i = 0; i < n; ++i) {
            gVector3.zero();
            gVector3.setElement(i, 1.0);
            gVector2.LUDBackSolve(gMatrix, gVector3, gVector);
            this.setColumn(i, gVector2);
        }
    }

    public final void invert(GMatrix gMatrix) {
        this.set(gMatrix);
        this.invert();
    }

    public final void copySubMatrix(int n, int n2, int n3, int n4, int n5, int n6, GMatrix gMatrix) {
        if (n < 0 || n2 < 0 || n5 < 0 || n6 < 0) {
            throw new ArrayIndexOutOfBoundsException("rowSource,colSource,rowDest,colDest < 0.");
        }
        if (this.nRow < n3 + n || this.nCol < n4 + n2) {
            throw new ArrayIndexOutOfBoundsException("Source GMatrix too small.");
        }
        if (gMatrix.nRow < n3 + n5 || gMatrix.nCol < n4 + n6) {
            throw new ArrayIndexOutOfBoundsException("Target GMatrix too small.");
        }
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                gMatrix.elementData[(i + n5) * this.nCol + (j + n6)] = this.elementData[(i + n) * this.nCol + (j + n2)];
            }
        }
    }

    public final void setSize(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new NegativeArraySizeException("nRow or nCol < 0");
        }
        if (this.nRow != n || this.nCol != n2) {
            int n3 = this.nRow;
            int n4 = this.nCol;
            int n5 = this.nRow * this.nCol;
            double[] dArray = this.elementData;
            this.nRow = n;
            this.nCol = n2;
            int n6 = n * n2;
            this.elementData = new double[n6];
            if (n4 == n2) {
                System.arraycopy(dArray, 0, this.elementData, 0, Math.min(n5, n6));
            } else {
                int n7 = Math.min(n2, n4);
                int n8 = Math.min(n, n3);
                for (int i = 0; i < n8; ++i) {
                    System.arraycopy(dArray, i * n4, this.elementData, i * n2, n7);
                }
            }
        }
    }

    public final void set(double[] dArray) {
        int n = this.nRow * this.nCol;
        System.arraycopy(dArray, 0, this.elementData, 0, n);
    }

    public final void set(Matrix3f matrix3f) {
        this.elementData[0] = matrix3f.m00;
        this.elementData[1] = matrix3f.m01;
        this.elementData[2] = matrix3f.m02;
        this.elementData[this.nCol] = matrix3f.m10;
        this.elementData[this.nCol + 1] = matrix3f.m11;
        this.elementData[this.nCol + 2] = matrix3f.m12;
        this.elementData[2 * this.nCol] = matrix3f.m20;
        this.elementData[2 * this.nCol + 1] = matrix3f.m21;
        this.elementData[2 * this.nCol + 2] = matrix3f.m22;
    }

    public final void set(Matrix3d matrix3d) {
        this.elementData[0] = matrix3d.m00;
        this.elementData[1] = matrix3d.m01;
        this.elementData[2] = matrix3d.m02;
        this.elementData[this.nCol] = matrix3d.m10;
        this.elementData[this.nCol + 1] = matrix3d.m11;
        this.elementData[this.nCol + 2] = matrix3d.m12;
        this.elementData[2 * this.nCol] = matrix3d.m20;
        this.elementData[2 * this.nCol + 1] = matrix3d.m21;
        this.elementData[2 * this.nCol + 2] = matrix3d.m22;
    }

    public final void set(Matrix4f matrix4f) {
        this.elementData[0] = matrix4f.m00;
        this.elementData[1] = matrix4f.m01;
        this.elementData[2] = matrix4f.m02;
        this.elementData[3] = matrix4f.m03;
        this.elementData[this.nCol] = matrix4f.m10;
        this.elementData[this.nCol + 1] = matrix4f.m11;
        this.elementData[this.nCol + 2] = matrix4f.m12;
        this.elementData[this.nCol + 3] = matrix4f.m13;
        this.elementData[2 * this.nCol] = matrix4f.m20;
        this.elementData[2 * this.nCol + 1] = matrix4f.m21;
        this.elementData[2 * this.nCol + 2] = matrix4f.m22;
        this.elementData[2 * this.nCol + 3] = matrix4f.m23;
        this.elementData[3 * this.nCol] = matrix4f.m30;
        this.elementData[3 * this.nCol + 1] = matrix4f.m31;
        this.elementData[3 * this.nCol + 2] = matrix4f.m32;
        this.elementData[3 * this.nCol + 3] = matrix4f.m33;
    }

    public final void set(Matrix4d matrix4d) {
        this.elementData[0] = matrix4d.m00;
        this.elementData[1] = matrix4d.m01;
        this.elementData[2] = matrix4d.m02;
        this.elementData[3] = matrix4d.m03;
        this.elementData[this.nCol] = matrix4d.m10;
        this.elementData[this.nCol + 1] = matrix4d.m11;
        this.elementData[this.nCol + 2] = matrix4d.m12;
        this.elementData[this.nCol + 3] = matrix4d.m13;
        this.elementData[2 * this.nCol] = matrix4d.m20;
        this.elementData[2 * this.nCol + 1] = matrix4d.m21;
        this.elementData[2 * this.nCol + 2] = matrix4d.m22;
        this.elementData[2 * this.nCol + 3] = matrix4d.m23;
        this.elementData[3 * this.nCol] = matrix4d.m30;
        this.elementData[3 * this.nCol + 1] = matrix4d.m31;
        this.elementData[3 * this.nCol + 2] = matrix4d.m32;
        this.elementData[3 * this.nCol + 3] = matrix4d.m33;
    }

    public final void set(GMatrix gMatrix) {
        if (gMatrix.nRow < this.nRow || gMatrix.nCol < this.nCol) {
            throw new ArrayIndexOutOfBoundsException("m1 smaller than this matrix");
        }
        System.arraycopy(gMatrix.elementData, 0, this.elementData, 0, this.nRow * this.nCol);
    }

    public final int getNumRow() {
        return this.nRow;
    }

    public final int getNumCol() {
        return this.nCol;
    }

    public final double getElement(int n, int n2) {
        if (this.nRow <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's nRow:" + this.nRow);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        if (this.nCol <= n2) {
            throw new ArrayIndexOutOfBoundsException("column:" + n2 + " > matrix's nCol:" + this.nCol);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("column:" + n2 + " < 0");
        }
        return this.elementData[n * this.nCol + n2];
    }

    public final void setElement(int n, int n2, double d) {
        if (this.nRow <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's nRow:" + this.nRow);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        if (this.nCol <= n2) {
            throw new ArrayIndexOutOfBoundsException("column:" + n2 + " > matrix's nCol:" + this.nCol);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("column:" + n2 + " < 0");
        }
        this.elementData[n * this.nCol + n2] = d;
    }

    public final void getRow(int n, double[] dArray) {
        if (this.nRow <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's nRow:" + this.nRow);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        if (dArray.length < this.nCol) {
            throw new ArrayIndexOutOfBoundsException("array length:" + dArray.length + " smaller than matrix's nCol:" + this.nCol);
        }
        System.arraycopy(this.elementData, n * this.nCol, dArray, 0, this.nCol);
    }

    public final void getRow(int n, GVector gVector) {
        if (this.nRow <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's nRow:" + this.nRow);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        if (gVector.getSize() < this.nCol) {
            throw new ArrayIndexOutOfBoundsException("vector size:" + gVector.getSize() + " smaller than matrix's nCol:" + this.nCol);
        }
        for (int i = 0; i < this.nCol; ++i) {
            gVector.setElement(i, this.elementData[n * this.nCol + i]);
        }
    }

    public final void getColumn(int n, double[] dArray) {
        if (this.nCol <= n) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " > matrix's nCol:" + this.nCol);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " < 0");
        }
        if (dArray.length < this.nRow) {
            throw new ArrayIndexOutOfBoundsException("array.length:" + dArray.length + " < matrix's nRow=" + this.nRow);
        }
        for (int i = 0; i < this.nRow; ++i) {
            dArray[i] = this.elementData[i * this.nCol + n];
        }
    }

    public final void getColumn(int n, GVector gVector) {
        if (this.nCol <= n) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " > matrix's nCol:" + this.nCol);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " < 0");
        }
        if (gVector.getSize() < this.nRow) {
            throw new ArrayIndexOutOfBoundsException("vector size:" + gVector.getSize() + " < matrix's nRow:" + this.nRow);
        }
        for (int i = 0; i < this.nRow; ++i) {
            gVector.setElement(i, this.elementData[i * this.nCol + n]);
        }
    }

    public final void get(Matrix3d matrix3d) {
        matrix3d.m00 = this.elementData[0];
        matrix3d.m01 = this.elementData[1];
        matrix3d.m02 = this.elementData[2];
        matrix3d.m10 = this.elementData[this.nCol];
        matrix3d.m11 = this.elementData[this.nCol + 1];
        matrix3d.m12 = this.elementData[this.nCol + 2];
        matrix3d.m20 = this.elementData[2 * this.nCol];
        matrix3d.m21 = this.elementData[2 * this.nCol + 1];
        matrix3d.m22 = this.elementData[2 * this.nCol + 2];
    }

    public final void get(Matrix3f matrix3f) {
        matrix3f.m00 = (float)this.elementData[0];
        matrix3f.m01 = (float)this.elementData[1];
        matrix3f.m02 = (float)this.elementData[2];
        matrix3f.m10 = (float)this.elementData[this.nCol];
        matrix3f.m11 = (float)this.elementData[this.nCol + 1];
        matrix3f.m12 = (float)this.elementData[this.nCol + 2];
        matrix3f.m20 = (float)this.elementData[2 * this.nCol];
        matrix3f.m21 = (float)this.elementData[2 * this.nCol + 1];
        matrix3f.m22 = (float)this.elementData[2 * this.nCol + 2];
    }

    public final void get(Matrix4d matrix4d) {
        matrix4d.m00 = this.elementData[0];
        matrix4d.m01 = this.elementData[1];
        matrix4d.m02 = this.elementData[2];
        matrix4d.m03 = this.elementData[3];
        matrix4d.m10 = this.elementData[this.nCol];
        matrix4d.m11 = this.elementData[this.nCol + 1];
        matrix4d.m12 = this.elementData[this.nCol + 2];
        matrix4d.m13 = this.elementData[this.nCol + 3];
        matrix4d.m20 = this.elementData[2 * this.nCol];
        matrix4d.m21 = this.elementData[2 * this.nCol + 1];
        matrix4d.m22 = this.elementData[2 * this.nCol + 2];
        matrix4d.m23 = this.elementData[2 * this.nCol + 3];
        matrix4d.m30 = this.elementData[3 * this.nCol];
        matrix4d.m31 = this.elementData[3 * this.nCol + 1];
        matrix4d.m32 = this.elementData[3 * this.nCol + 2];
        matrix4d.m33 = this.elementData[3 * this.nCol + 3];
    }

    public final void get(Matrix4f matrix4f) {
        matrix4f.m00 = (float)this.elementData[0];
        matrix4f.m01 = (float)this.elementData[1];
        matrix4f.m02 = (float)this.elementData[2];
        matrix4f.m03 = (float)this.elementData[3];
        matrix4f.m10 = (float)this.elementData[this.nCol];
        matrix4f.m11 = (float)this.elementData[this.nCol + 1];
        matrix4f.m12 = (float)this.elementData[this.nCol + 2];
        matrix4f.m13 = (float)this.elementData[this.nCol + 3];
        matrix4f.m20 = (float)this.elementData[2 * this.nCol];
        matrix4f.m21 = (float)this.elementData[2 * this.nCol + 1];
        matrix4f.m22 = (float)this.elementData[2 * this.nCol + 2];
        matrix4f.m23 = (float)this.elementData[2 * this.nCol + 3];
        matrix4f.m30 = (float)this.elementData[3 * this.nCol];
        matrix4f.m31 = (float)this.elementData[3 * this.nCol + 1];
        matrix4f.m32 = (float)this.elementData[3 * this.nCol + 2];
        matrix4f.m33 = (float)this.elementData[3 * this.nCol + 3];
    }

    public final void get(GMatrix gMatrix) {
        if (gMatrix.nRow < this.nRow || gMatrix.nCol < this.nCol) {
            throw new IllegalArgumentException("m1 matrix is smaller than this matrix.");
        }
        if (gMatrix.nCol == this.nCol) {
            System.arraycopy(this.elementData, 0, gMatrix.elementData, 0, this.nRow * this.nCol);
        } else {
            for (int i = 0; i < this.nRow; ++i) {
                System.arraycopy(this.elementData, i * this.nCol, gMatrix.elementData, i * gMatrix.nCol, this.nCol);
            }
        }
    }

    public final void setRow(int n, double[] dArray) {
        if (this.nRow <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's nRow:" + this.nRow);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        if (dArray.length < this.nCol) {
            throw new ArrayIndexOutOfBoundsException("array length:" + dArray.length + " < matrix's nCol=" + this.nCol);
        }
        System.arraycopy(dArray, 0, this.elementData, n * this.nCol, this.nCol);
    }

    public final void setRow(int n, GVector gVector) {
        if (this.nRow <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's nRow:" + this.nRow);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        int n2 = gVector.getSize();
        if (n2 < this.nCol) {
            throw new ArrayIndexOutOfBoundsException("vector's size:" + n2 + " < matrix's nCol=" + this.nCol);
        }
        for (int i = 0; i < this.nCol; ++i) {
            this.elementData[n * this.nCol + i] = gVector.getElement(i);
        }
    }

    public final void setColumn(int n, double[] dArray) {
        if (this.nCol <= n) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " > matrix's nCol=" + this.nCol);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " < 0");
        }
        if (dArray.length < this.nRow) {
            throw new ArrayIndexOutOfBoundsException("array length:" + dArray.length + " < matrix's nRow:" + this.nRow);
        }
        for (int i = 0; i < this.nRow; ++i) {
            this.elementData[i * this.nCol + n] = dArray[i];
        }
    }

    public final void setColumn(int n, GVector gVector) {
        if (this.nCol <= n) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " > matrix's nCol=" + this.nCol);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " < 0");
        }
        int n2 = gVector.getSize();
        if (n2 < this.nRow) {
            throw new ArrayIndexOutOfBoundsException("vector size:" + n2 + " < matrix's nRow=" + this.nRow);
        }
        for (int i = 0; i < this.nRow; ++i) {
            this.elementData[i * this.nCol + n] = gVector.getElement(i);
        }
    }

    public final void mulTransposeBoth(GMatrix gMatrix, GMatrix gMatrix2) {
        this.mul(gMatrix2, gMatrix);
        this.transpose();
    }

    public final void mulTransposeRight(GMatrix gMatrix, GMatrix gMatrix2) {
        if (gMatrix.nCol != gMatrix2.nCol || this.nRow != gMatrix.nRow || this.nCol != gMatrix2.nRow) {
            throw new ArrayIndexOutOfBoundsException("matrices mismatch");
        }
        for (int i = 0; i < this.nRow; ++i) {
            for (int j = 0; j < this.nCol; ++j) {
                double d = 0.0;
                for (int k = 0; k < gMatrix.nCol; ++k) {
                    d += gMatrix.elementData[i * gMatrix.nCol + k] * gMatrix2.elementData[j * gMatrix2.nCol + k];
                }
                this.elementData[i * this.nCol + j] = d;
            }
        }
    }

    public final void mulTransposeLeft(GMatrix gMatrix, GMatrix gMatrix2) {
        this.transpose(gMatrix);
        this.mul(gMatrix2);
    }

    public final void transpose() {
        for (int i = 0; i < this.nRow; ++i) {
            for (int j = i + 1; j < this.nCol; ++j) {
                double d = this.elementData[i * this.nCol + j];
                this.elementData[i * this.nCol + j] = this.elementData[j * this.nCol + i];
                this.elementData[j * this.nCol + i] = d;
            }
        }
    }

    public final void transpose(GMatrix gMatrix) {
        this.set(gMatrix);
        this.transpose();
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(string);
        for (int i = 0; i < this.nRow; ++i) {
            stringBuffer.append("  [");
            for (int j = 0; j < this.nCol; ++j) {
                if (0 < j) {
                    stringBuffer.append("\t");
                }
                stringBuffer.append(this.elementData[i * this.nCol + j]);
            }
            if (i + 1 < this.nRow) {
                stringBuffer.append("]");
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append("] ]");
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.nRow * this.nCol; ++i) {
            long l = Double.doubleToLongBits(this.elementData[i]);
            n ^= (int)(l ^ l >> 32);
        }
        return n;
    }

    public boolean equals(GMatrix gMatrix) {
        if (gMatrix == null) {
            return false;
        }
        if (gMatrix.nRow != this.nRow) {
            return false;
        }
        if (gMatrix.nCol != this.nCol) {
            return false;
        }
        for (int i = 0; i < this.nRow; ++i) {
            for (int j = 0; j < this.nCol; ++j) {
                if (this.elementData[i * this.nCol + j] == gMatrix.elementData[i * this.nCol + j]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof GMatrix && this.equals((GMatrix)object);
    }

    public boolean epsilonEquals(GMatrix gMatrix, float f) {
        if (gMatrix.nRow != this.nRow) {
            return false;
        }
        if (gMatrix.nCol != this.nCol) {
            return false;
        }
        for (int i = 0; i < this.nRow; ++i) {
            for (int j = 0; j < this.nCol; ++j) {
                if (!((double)f < Math.abs(this.elementData[i * this.nCol + j] - gMatrix.elementData[i * this.nCol + j]))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean epsilonEquals(GMatrix gMatrix, double d) {
        if (gMatrix.nRow != this.nRow) {
            return false;
        }
        if (gMatrix.nCol != this.nCol) {
            return false;
        }
        for (int i = 0; i < this.nRow; ++i) {
            for (int j = 0; j < this.nCol; ++j) {
                if (!(d < Math.abs(this.elementData[i * this.nCol + j] - gMatrix.elementData[i * this.nCol + j]))) continue;
                return false;
            }
        }
        return true;
    }

    public final double trace() {
        int n = this.nRow < this.nCol ? this.nRow : this.nCol;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.elementData[i * this.nCol + i];
        }
        return d;
    }

    public final void setScale(double d) {
        this.setZero();
        int n = this.nRow < this.nCol ? this.nRow : this.nCol;
        for (int i = 0; i < n; ++i) {
            this.elementData[i * this.nCol + i] = d;
        }
    }

    private void setDiag(int n, double d) {
        this.elementData[n * this.nCol + n] = d;
    }

    private double getDiag(int n) {
        return this.elementData[n * this.nCol + n];
    }

    private double dpythag(double d, double d2) {
        double d3;
        double d4 = Math.abs(d);
        if (d4 > (d3 = Math.abs(d2))) {
            if (d4 == 0.0) {
                return 0.0;
            }
            double d5 = d3 / d4;
            if (Math.abs(d5) <= Double.MIN_VALUE) {
                return d4;
            }
            return d4 * Math.sqrt(1.0 + d5 * d5);
        }
        if (d3 == 0.0) {
            return 0.0;
        }
        double d6 = d4 / d3;
        if (Math.abs(d6) <= Double.MIN_VALUE) {
            return d3;
        }
        return d3 * Math.sqrt(1.0 + d6 * d6);
    }

    public final int SVD(GMatrix gMatrix, GMatrix gMatrix2, GMatrix gMatrix3) {
        int n;
        double d;
        double d2;
        int n2;
        double d3;
        int n3;
        int n4;
        if (gMatrix.nRow != this.nRow || gMatrix.nCol != this.nRow) {
            throw new ArrayIndexOutOfBoundsException("The U Matrix invalid size");
        }
        if (gMatrix3.nRow != this.nCol || gMatrix3.nCol != this.nCol) {
            throw new ArrayIndexOutOfBoundsException("The V Matrix invalid size");
        }
        if (gMatrix2.nCol != this.nCol || gMatrix2.nRow != this.nRow) {
            throw new ArrayIndexOutOfBoundsException("The W Matrix invalid size");
        }
        int n5 = this.nRow;
        int n6 = this.nCol;
        int n7 = n5 > n6 ? n5 : n6;
        double[] dArray = gMatrix.elementData;
        double[] dArray2 = gMatrix3.elementData;
        int n8 = 0;
        int n9 = 0;
        double[] dArray3 = new double[n6];
        this.get(gMatrix);
        for (n4 = n5; n4 < n7; ++n4) {
            for (n3 = 0; n3 < n7; ++n3) {
                dArray[n4 * n5 + n3] = 0.0;
            }
        }
        for (n3 = n6; n3 < n7; ++n3) {
            for (n4 = 0; n4 < n7; ++n4) {
                dArray[n4 * n5 + n3] = 0.0;
            }
        }
        gMatrix2.setZero();
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (n4 = 0; n4 < n6; ++n4) {
            double d7;
            n8 = n4 + 1;
            dArray3[n4] = d5 * d6;
            d5 = 0.0;
            d3 = 0.0;
            d6 = 0.0;
            if (n4 < n5) {
                for (n2 = n4; n2 < n5; ++n2) {
                    d5 += Math.abs(dArray[n2 * n5 + n4]);
                }
                if (d5 != 0.0) {
                    for (n2 = n4; n2 < n5; ++n2) {
                        int n10 = n2 * n5 + n4;
                        dArray[n10] = dArray[n10] / d5;
                        d3 += dArray[n2 * n5 + n4] * dArray[n2 * n5 + n4];
                    }
                    d2 = dArray[n4 * n5 + n4];
                    d6 = d2 < 0.0 ? Math.sqrt(d3) : -Math.sqrt(d3);
                    d = d2 * d6 - d3;
                    dArray[n4 * n5 + n4] = d2 - d6;
                    for (n3 = n8; n3 < n6; ++n3) {
                        d3 = 0.0;
                        for (n2 = n4; n2 < n5; ++n2) {
                            d3 += dArray[n2 * n5 + n4] * dArray[n2 * n5 + n3];
                        }
                        d2 = d3 / d;
                        for (n2 = n4; n2 < n5; ++n2) {
                            int n11 = n2 * n5 + n3;
                            dArray[n11] = dArray[n11] + d2 * dArray[n2 * n5 + n4];
                        }
                    }
                    for (n2 = n4; n2 < n5; ++n2) {
                        int n12 = n2 * n5 + n4;
                        dArray[n12] = dArray[n12] * d5;
                    }
                }
            }
            gMatrix2.setDiag(n4, d5 * d6);
            d5 = 0.0;
            d3 = 0.0;
            d6 = 0.0;
            if (n4 < n5 && n4 != n6 - 1) {
                for (n2 = n8; n2 < n6; ++n2) {
                    d5 += Math.abs(dArray[n4 * n5 + n2]);
                }
                if (d5 != 0.0) {
                    for (n2 = n8; n2 < n6; ++n2) {
                        int n13 = n4 * n5 + n2;
                        dArray[n13] = dArray[n13] / d5;
                        d3 += dArray[n4 * n5 + n2] * dArray[n4 * n5 + n2];
                    }
                    d2 = dArray[n4 * n5 + n8];
                    d6 = d2 < 0.0 ? Math.sqrt(d3) : -Math.sqrt(d3);
                    d = d2 * d6 - d3;
                    dArray[n4 * n5 + n8] = d2 - d6;
                    for (n2 = n8; n2 < n6; ++n2) {
                        dArray3[n2] = dArray[n4 * n5 + n2] / d;
                    }
                    for (n3 = n8; n3 < n5; ++n3) {
                        d3 = 0.0;
                        for (n2 = n8; n2 < n6; ++n2) {
                            d3 += dArray[n3 * n5 + n2] * dArray[n4 * n5 + n2];
                        }
                        for (n2 = n8; n2 < n6; ++n2) {
                            int n14 = n3 * n5 + n2;
                            dArray[n14] = dArray[n14] + d3 * dArray3[n2];
                        }
                    }
                    for (n2 = n8; n2 < n6; ++n2) {
                        int n15 = n4 * n5 + n2;
                        dArray[n15] = dArray[n15] * d5;
                    }
                }
            }
            if (!((d7 = Math.abs(gMatrix2.getDiag(n4)) + Math.abs(dArray3[n4])) > d4)) continue;
            d4 = d7;
        }
        n4 = n6 - 1;
        while (n4 >= 0) {
            if (n4 < n6 - 1) {
                if (d6 != 0.0) {
                    for (n3 = n8; n3 < n6; ++n3) {
                        dArray2[n3 * n6 + n4] = dArray[n4 * n5 + n3] / dArray[n4 * n5 + n8] / d6;
                    }
                    for (n3 = n8; n3 < n6; ++n3) {
                        d3 = 0.0;
                        for (n2 = n8; n2 < n6; ++n2) {
                            d3 += dArray[n4 * n5 + n2] * dArray2[n2 * n6 + n3];
                        }
                        for (n2 = n8; n2 < n6; ++n2) {
                            int n16 = n2 * n6 + n3;
                            dArray2[n16] = dArray2[n16] + d3 * dArray2[n2 * n6 + n4];
                        }
                    }
                }
                for (n3 = n8; n3 < n6; ++n3) {
                    dArray2[n3 * n6 + n4] = 0.0;
                    dArray2[n4 * n6 + n3] = 0.0;
                }
            }
            dArray2[n4 * n6 + n4] = 1.0;
            d6 = dArray3[n4];
            n8 = n4--;
        }
        int n17 = n5 < n6 ? n5 : n6;
        for (n4 = n17 - 1; n4 >= 0; --n4) {
            n8 = n4 + 1;
            d6 = gMatrix2.getDiag(n4);
            for (n3 = n8; n3 < n6; ++n3) {
                dArray[n4 * n5 + n3] = 0.0;
            }
            if (d6 != 0.0) {
                d6 = 1.0 / d6;
                for (n3 = n8; n3 < n6; ++n3) {
                    d3 = 0.0;
                    for (n2 = n8; n2 < n5; ++n2) {
                        d3 += dArray[n2 * n5 + n4] * dArray[n2 * n5 + n3];
                    }
                    d2 = d3 / dArray[n4 * n5 + n4] * d6;
                    for (n2 = n4; n2 < n5; ++n2) {
                        int n18 = n2 * n5 + n3;
                        dArray[n18] = dArray[n18] + d2 * dArray[n2 * n5 + n4];
                    }
                }
                for (n3 = n4; n3 < n5; ++n3) {
                    int n19 = n3 * n5 + n4;
                    dArray[n19] = dArray[n19] * d6;
                }
            } else {
                for (n3 = n4; n3 < n5; ++n3) {
                    dArray[n3 * n5 + n4] = 0.0;
                }
            }
            int n20 = n4 * n5 + n4;
            dArray[n20] = dArray[n20] + 1.0;
        }
        block31: for (n2 = n6 - 1; n2 >= 0; --n2) {
            for (int i = 1; i <= 30; ++i) {
                double d8;
                double d9;
                double d10;
                n = 1;
                for (n8 = n2; n8 >= 0; --n8) {
                    n9 = n8 - 1;
                    if (Math.abs(dArray3[n8]) + d4 == d4) {
                        n = 0;
                        break;
                    }
                    if (Math.abs(gMatrix2.getDiag(n9)) + d4 == d4) break;
                }
                if (n != 0) {
                    d10 = 0.0;
                    d3 = 1.0;
                    for (n4 = n8; n4 <= n2; ++n4) {
                        d2 = d3 * dArray3[n4];
                        dArray3[n4] = d10 * dArray3[n4];
                        if (Math.abs(d2) + d4 == d4) break;
                        d6 = gMatrix2.getDiag(n4);
                        d = this.dpythag(d2, d6);
                        gMatrix2.setDiag(n4, d);
                        d = 1.0 / d;
                        d10 = d6 * d;
                        d3 = -d2 * d;
                        for (n3 = 0; n3 < n5; ++n3) {
                            d9 = dArray[n3 * n5 + n9];
                            d8 = dArray[n3 * n5 + n4];
                            dArray[n3 * n5 + n9] = d9 * d10 + d8 * d3;
                            dArray[n3 * n5 + n4] = d8 * d10 - d9 * d3;
                        }
                    }
                }
                d8 = gMatrix2.getDiag(n2);
                if (n8 == n2) {
                    if (!(d8 < 0.0)) continue block31;
                    gMatrix2.setDiag(n2, -d8);
                    for (n3 = 0; n3 < n6; ++n3) {
                        dArray2[n3 * n6 + n2] = -dArray2[n3 * n6 + n2];
                    }
                    continue block31;
                }
                if (i == 30) {
                    return 0;
                }
                double d11 = gMatrix2.getDiag(n8);
                n9 = n2 - 1;
                d9 = gMatrix2.getDiag(n9);
                d6 = dArray3[n9];
                d = dArray3[n2];
                d2 = ((d9 - d8) * (d9 + d8) + (d6 - d) * (d6 + d)) / (2.0 * d * d9);
                d6 = this.dpythag(d2, 1.0);
                d2 = ((d11 - d8) * (d11 + d8) + d * (d9 / (d2 + (d2 >= 0.0 ? Math.abs(d6) : -Math.abs(d6))) - d)) / d11;
                d3 = 1.0;
                d10 = 1.0;
                for (n3 = n8; n3 <= n9; ++n3) {
                    int n21;
                    n4 = n3 + 1;
                    d6 = dArray3[n4];
                    d9 = gMatrix2.getDiag(n4);
                    d = d3 * d6;
                    d6 = d10 * d6;
                    dArray3[n3] = d8 = this.dpythag(d2, d);
                    d10 = d2 / d8;
                    d3 = d / d8;
                    d2 = d11 * d10 + d6 * d3;
                    d6 = d6 * d10 - d11 * d3;
                    d = d9 * d3;
                    d9 *= d10;
                    for (n21 = 0; n21 < n6; ++n21) {
                        d11 = dArray2[n21 * n6 + n3];
                        d8 = dArray2[n21 * n6 + n4];
                        dArray2[n21 * n6 + n3] = d11 * d10 + d8 * d3;
                        dArray2[n21 * n6 + n4] = d8 * d10 - d11 * d3;
                    }
                    d8 = this.dpythag(d2, d);
                    gMatrix2.setDiag(n3, d8);
                    if (d8 != 0.0) {
                        d8 = 1.0 / d8;
                        d10 = d2 * d8;
                        d3 = d * d8;
                    }
                    d2 = d10 * d6 + d3 * d9;
                    d11 = d10 * d9 - d3 * d6;
                    for (n21 = 0; n21 < n5; ++n21) {
                        d9 = dArray[n21 * n5 + n3];
                        d8 = dArray[n21 * n5 + n4];
                        dArray[n21 * n5 + n3] = d9 * d10 + d8 * d3;
                        dArray[n21 * n5 + n4] = d8 * d10 - d9 * d3;
                    }
                }
                dArray3[n8] = 0.0;
                dArray3[n2] = d2;
                gMatrix2.setDiag(n2, d11);
            }
        }
        n = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            if (!(gMatrix2.getDiag(n4) > 0.0)) continue;
            ++n;
        }
        return n;
    }

    private void swapRows(int n, int n2) {
        for (int i = 0; i < this.nCol; ++i) {
            double d = this.elementData[n * this.nCol + i];
            this.elementData[n * this.nCol + i] = this.elementData[n2 * this.nCol + i];
            this.elementData[n2 * this.nCol + i] = d;
        }
    }

    public final int LUD(GMatrix gMatrix, GVector gVector) {
        int n;
        if (this.nRow != this.nCol) {
            throw new ArrayIndexOutOfBoundsException("not a square matrix");
        }
        int n2 = this.nRow;
        if (n2 != gMatrix.nRow) {
            throw new ArrayIndexOutOfBoundsException("this.nRow:" + n2 + " != LU.nRow:" + gMatrix.nRow);
        }
        if (n2 != gMatrix.nCol) {
            throw new ArrayIndexOutOfBoundsException("this.nCol:" + n2 + " != LU.nCol:" + gMatrix.nCol);
        }
        if (gVector.getSize() < n2) {
            throw new ArrayIndexOutOfBoundsException("permutation.size:" + gVector.getSize() + " < this.nCol:" + n2);
        }
        if (this != gMatrix) {
            gMatrix.set(this);
        }
        int n3 = 1;
        double[] dArray = gMatrix.elementData;
        for (n = 0; n < n2; ++n) {
            gVector.setElement(n, n);
        }
        for (n = 0; n < n2; ++n) {
            double d;
            int n4;
            double d2;
            int n5;
            for (n5 = 0; n5 < n; ++n5) {
                d2 = dArray[n5 * n2 + n];
                for (n4 = 0; n4 < n5; ++n4) {
                    if (dArray[n5 * n2 + n4] == 0.0 || dArray[n4 * n2 + n] == 0.0) continue;
                    d2 -= dArray[n5 * n2 + n4] * dArray[n4 * n2 + n];
                }
                dArray[n5 * n2 + n] = d2;
            }
            double d3 = 0.0;
            int n6 = n;
            for (n5 = n; n5 < n2; ++n5) {
                d2 = dArray[n5 * n2 + n];
                for (n4 = 0; n4 < n; ++n4) {
                    if (dArray[n5 * n2 + n4] == 0.0 || dArray[n4 * n2 + n] == 0.0) continue;
                    d2 -= dArray[n5 * n2 + n4] * dArray[n4 * n2 + n];
                }
                dArray[n5 * n2 + n] = d2;
                d = Math.abs(d2);
                if (!(d >= d3)) continue;
                d3 = d;
                n6 = n5;
            }
            if (n != n6) {
                gMatrix.swapRows(n6, n);
                double d4 = gVector.getElement(n6);
                gVector.setElement(n6, gVector.getElement(n));
                gVector.setElement(n, d4);
                n3 = -n3;
            }
            if (n == n2 - 1) continue;
            d = 1.0 / dArray[n * n2 + n];
            for (int i = n + 1; i < n2; ++i) {
                int n7 = i * n2 + n;
                dArray[n7] = dArray[n7] * d;
            }
        }
        return n3;
    }
}

