/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4d;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;

public class AxisAngle4f
implements Serializable {
    public float x;
    public float y;
    public float z;
    public float angle;

    public AxisAngle4f(float f, float f2, float f3, float f4) {
        this.set(f, f2, f3, f4);
    }

    public AxisAngle4f(float[] fArray) {
        this.set(fArray);
    }

    public AxisAngle4f(AxisAngle4f axisAngle4f) {
        this.set(axisAngle4f);
    }

    public AxisAngle4f(AxisAngle4d axisAngle4d) {
        this.set(axisAngle4d);
    }

    public AxisAngle4f() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 1.0f;
        this.angle = 0.0f;
    }

    public AxisAngle4f(Vector3f vector3f, float f) {
        this.x = vector3f.x;
        this.y = vector3f.y;
        this.z = vector3f.z;
        this.angle = f;
    }

    public final void set(Vector3f vector3f, float f) {
        this.x = vector3f.x;
        this.y = vector3f.y;
        this.z = vector3f.z;
        this.angle = f;
    }

    public final void set(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.angle = f4;
    }

    public final void set(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        this.angle = fArray[3];
    }

    public final void set(AxisAngle4f axisAngle4f) {
        this.x = axisAngle4f.x;
        this.y = axisAngle4f.y;
        this.z = axisAngle4f.z;
        this.angle = axisAngle4f.angle;
    }

    public final void set(AxisAngle4d axisAngle4d) {
        this.x = (float)axisAngle4d.x;
        this.y = (float)axisAngle4d.y;
        this.z = (float)axisAngle4d.z;
        this.angle = (float)axisAngle4d.angle;
    }

    public final void get(float[] fArray) {
        fArray[0] = this.x;
        fArray[1] = this.y;
        fArray[2] = this.z;
        fArray[3] = this.angle;
    }

    public final void set(Matrix4f matrix4f) {
        this.setFromMat(matrix4f.m00, matrix4f.m01, matrix4f.m02, matrix4f.m10, matrix4f.m11, matrix4f.m12, matrix4f.m20, matrix4f.m21, matrix4f.m22);
    }

    public final void set(Matrix4d matrix4d) {
        this.setFromMat(matrix4d.m00, matrix4d.m01, matrix4d.m02, matrix4d.m10, matrix4d.m11, matrix4d.m12, matrix4d.m20, matrix4d.m21, matrix4d.m22);
    }

    public final void set(Matrix3f matrix3f) {
        this.setFromMat(matrix3f.m00, matrix3f.m01, matrix3f.m02, matrix3f.m10, matrix3f.m11, matrix3f.m12, matrix3f.m20, matrix3f.m21, matrix3f.m22);
    }

    public final void set(Matrix3d matrix3d) {
        this.setFromMat(matrix3d.m00, matrix3d.m01, matrix3d.m02, matrix3d.m10, matrix3d.m11, matrix3d.m12, matrix3d.m20, matrix3d.m21, matrix3d.m22);
    }

    public final void set(Quat4f quat4f) {
        this.setFromQuat(quat4f.x, quat4f.y, quat4f.z, quat4f.w);
    }

    public final void set(Quat4d quat4d) {
        this.setFromQuat(quat4d.x, quat4d.y, quat4d.z, quat4d.w);
    }

    private void setFromMat(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = (d + d5 + d9 - 1.0) * 0.5;
        this.x = (float)(d8 - d6);
        this.y = (float)(d3 - d7);
        this.z = (float)(d4 - d2);
        double d11 = 0.5 * Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.angle = (float)Math.atan2(d11, d10);
    }

    private void setFromQuat(double d, double d2, double d3, double d4) {
        double d5 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        this.angle = (float)(2.0 * Math.atan2(d5, d4));
        this.x = (float)d;
        this.y = (float)d2;
        this.z = (float)d3;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.angle + ")";
    }

    public boolean equals(AxisAngle4f axisAngle4f) {
        return axisAngle4f != null && this.x == axisAngle4f.x && this.y == axisAngle4f.y && this.z == axisAngle4f.z && this.angle == axisAngle4f.angle;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof AxisAngle4f && this.equals((AxisAngle4f)object);
    }

    public boolean epsilonEquals(AxisAngle4f axisAngle4f, float f) {
        return Math.abs(axisAngle4f.x - this.x) <= f && Math.abs(axisAngle4f.y - this.y) <= f && Math.abs(axisAngle4f.z - this.z) <= f && Math.abs(axisAngle4f.angle - this.angle) <= f;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.x) ^ Float.floatToIntBits(this.y) ^ Float.floatToIntBits(this.z) ^ Float.floatToIntBits(this.angle);
    }
}

