/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4d;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3d;

public class AxisAngle4d
implements Serializable {
    public double x;
    public double y;
    public double z;
    public double angle;

    public AxisAngle4d(double d, double d2, double d3, double d4) {
        this.set(d, d2, d3, d4);
    }

    public AxisAngle4d(double[] dArray) {
        this.set(dArray);
    }

    public AxisAngle4d(AxisAngle4d axisAngle4d) {
        this.set(axisAngle4d);
    }

    public AxisAngle4d(AxisAngle4f axisAngle4f) {
        this.set(axisAngle4f);
    }

    public AxisAngle4d() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 1.0;
        this.angle = 0.0;
    }

    public AxisAngle4d(Vector3d vector3d, double d) {
        this.x = vector3d.x;
        this.y = vector3d.y;
        this.z = vector3d.z;
        this.angle = d;
    }

    public final void set(Vector3d vector3d, double d) {
        this.x = vector3d.x;
        this.y = vector3d.y;
        this.z = vector3d.z;
        this.angle = d;
    }

    public final void set(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.angle = d4;
    }

    public final void set(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
        this.angle = dArray[3];
    }

    public final void set(AxisAngle4d axisAngle4d) {
        this.x = axisAngle4d.x;
        this.y = axisAngle4d.y;
        this.z = axisAngle4d.z;
        this.angle = axisAngle4d.angle;
    }

    public final void set(AxisAngle4f axisAngle4f) {
        this.x = axisAngle4f.x;
        this.y = axisAngle4f.y;
        this.z = axisAngle4f.z;
        this.angle = axisAngle4f.angle;
    }

    public final void get(double[] dArray) {
        dArray[0] = this.x;
        dArray[1] = this.y;
        dArray[2] = this.z;
        dArray[3] = this.angle;
    }

    public final void set(Matrix4f matrix4f) {
        this.setFromMat(matrix4f.m00, matrix4f.m01, matrix4f.m02, matrix4f.m10, matrix4f.m11, matrix4f.m12, matrix4f.m20, matrix4f.m21, matrix4f.m22);
    }

    public final void set(Matrix4d matrix4d) {
        this.setFromMat(matrix4d.m00, matrix4d.m01, matrix4d.m02, matrix4d.m10, matrix4d.m11, matrix4d.m12, matrix4d.m20, matrix4d.m21, matrix4d.m22);
    }

    public final void set(Matrix3f matrix3f) {
        this.setFromMat(matrix3f.m00, matrix3f.m01, matrix3f.m02, matrix3f.m10, matrix3f.m11, matrix3f.m12, matrix3f.m20, matrix3f.m21, matrix3f.m22);
    }

    public final void set(Matrix3d matrix3d) {
        this.setFromMat(matrix3d.m00, matrix3d.m01, matrix3d.m02, matrix3d.m10, matrix3d.m11, matrix3d.m12, matrix3d.m20, matrix3d.m21, matrix3d.m22);
    }

    public final void set(Quat4f quat4f) {
        this.setFromQuat(quat4f.x, quat4f.y, quat4f.z, quat4f.w);
    }

    public final void set(Quat4d quat4d) {
        this.setFromQuat(quat4d.x, quat4d.y, quat4d.z, quat4d.w);
    }

    private void setFromMat(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = (d + d5 + d9 - 1.0) * 0.5;
        this.x = d8 - d6;
        this.y = d3 - d7;
        this.z = d4 - d2;
        double d11 = 0.5 * Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.angle = Math.atan2(d11, d10);
    }

    private void setFromQuat(double d, double d2, double d3, double d4) {
        double d5 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        this.angle = 2.0 * Math.atan2(d5, d4);
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.angle + ")";
    }

    public boolean equals(AxisAngle4d axisAngle4d) {
        return axisAngle4d != null && this.x == axisAngle4d.x && this.y == axisAngle4d.y && this.z == axisAngle4d.z && this.angle == axisAngle4d.angle;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof AxisAngle4d && this.equals((AxisAngle4d)object);
    }

    public boolean epsilonEquals(AxisAngle4d axisAngle4d, double d) {
        return Math.abs(axisAngle4d.x - this.x) <= d && Math.abs(axisAngle4d.y - this.y) <= d && Math.abs(axisAngle4d.z - this.z) <= d && Math.abs(axisAngle4d.angle - this.angle) <= d;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        long l2 = Double.doubleToLongBits(this.y);
        long l3 = Double.doubleToLongBits(this.z);
        long l4 = Double.doubleToLongBits(this.angle);
        return (int)(l ^ l >> 32 ^ l2 ^ l2 >> 32 ^ l3 ^ l3 >> 32 ^ l4 ^ l4 >> 32);
    }
}

