/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath.geom;

import de.grogra.vecmath.Math2;
import de.grogra.vecmath.geom.BoundingBox;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.TransformableVolume;
import de.grogra.vecmath.geom.Variables;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class Sphere
extends TransformableVolume {
    public boolean computeIntersections(Line line, int n, IntersectionList intersectionList, Intersection intersection, Intersection intersection2) {
        if (intersection != null && intersection2 != null && intersection.volume == this && intersection2.volume == this) {
            return true;
        }
        Vector3d vector3d = intersectionList.tmpVector1;
        this.transformPoint(line.origin, vector3d);
        Vector3d vector3d2 = intersectionList.tmpVector0;
        this.transformVector(line.direction, vector3d2);
        double d = vector3d2.lengthSquared();
        double d2 = vector3d.dot(vector3d2);
        double d3 = vector3d.lengthSquared() - 1.0;
        double d4 = d2 * d2 - d * d3;
        if (d4 <= 0.0) {
            return false;
        }
        d4 = Math.sqrt(d4);
        double d5 = -(d4 + d2) / d;
        double d6 = (d4 - d2) / d;
        return this.addConvexIntersections(d5, 0, d6, 0, true, line, n, intersectionList, intersection, intersection2);
    }

    public boolean contains(Tuple3d tuple3d, boolean bl) {
        double d = tuple3d.x - this.t0;
        double d2 = tuple3d.y - this.t1;
        double d3 = tuple3d.z - this.t2;
        double d4 = this.m00 * d + this.m01 * d2 + this.m02 * d3;
        double d5 = this.m10 * d + this.m11 * d2 + this.m12 * d3;
        double d6 = this.m20 * d + this.m21 * d2 + this.m22 * d3;
        double d7 = d4 * d4 + d5 * d5 + d6 * d6;
        return bl ? d7 < 1.0 : d7 <= 1.0;
    }

    public void getExtent(Tuple3d tuple3d, Tuple3d tuple3d2, Variables variables) {
        Matrix3d matrix3d = this.getObjectToWorldRotationScale();
        tuple3d2.set(Math.sqrt(matrix3d.m00 * matrix3d.m00 + matrix3d.m01 * matrix3d.m01 + matrix3d.m02 * matrix3d.m02), Math.sqrt(matrix3d.m10 * matrix3d.m10 + matrix3d.m11 * matrix3d.m11 + matrix3d.m12 * matrix3d.m12), Math.sqrt(matrix3d.m20 * matrix3d.m20 + matrix3d.m21 * matrix3d.m21 + matrix3d.m22 * matrix3d.m22));
        Vector3d vector3d = variables.tmpVector0;
        vector3d.x = this.t0;
        vector3d.y = this.t1;
        vector3d.z = this.t2;
        tuple3d.sub(vector3d, tuple3d2);
        tuple3d2.add(vector3d);
    }

    public boolean boxContainsBoundary(BoundingBox boundingBox, Tuple3d tuple3d, double d, Variables variables) {
        double d2;
        double d3;
        int n;
        int n2;
        Vector3d vector3d = variables.tmpVector0;
        Vector3d vector3d2 = variables.tmpVector1;
        Vector3d vector3d3 = variables.tmpVector2;
        double d4 = d * this.getFrobeniusNorm() + 1.0;
        this.transformPoint(tuple3d, vector3d);
        if (vector3d.lengthSquared() > d4 * d4) {
            return false;
        }
        Point3d point3d = boundingBox.min;
        Point3d point3d2 = boundingBox.max;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i <= 1; ++i) {
            vector3d.x = i == 0 ? point3d.x : point3d2.x;
            for (n2 = 0; n2 <= 1; ++n2) {
                vector3d.y = n2 == 0 ? point3d.y : point3d2.y;
                for (n = 0; n <= 1; ++n) {
                    double d5;
                    vector3d.z = n == 0 ? point3d.z : point3d2.z;
                    this.transformPoint(vector3d, vector3d2);
                    d3 = vector3d2.lengthSquared();
                    if (d3 > 1.0) {
                        if (bl) {
                            return true;
                        }
                        bl2 = true;
                    } else {
                        if (bl2) {
                            return true;
                        }
                        bl = true;
                    }
                    if (i == 0 && !bl3) {
                        d2 = point3d2.x - point3d.x;
                        vector3d3.set(d2 * this.m00, d2 * this.m10, d2 * this.m20);
                        d5 = vector3d2.dot(vector3d3);
                        d2 = vector3d3.lengthSquared();
                        boolean bl4 = bl3 = d5 <= 0.0 && -d5 <= d2 && d3 * d2 <= d5 * d5 + d2;
                    }
                    if (n2 == 0 && !bl3) {
                        d2 = point3d2.y - point3d.y;
                        vector3d3.set(d2 * this.m01, d2 * this.m11, d2 * this.m21);
                        d5 = vector3d2.dot(vector3d3);
                        d2 = vector3d3.lengthSquared();
                        boolean bl5 = bl3 = d5 <= 0.0 && -d5 <= d2 && d3 * d2 <= d5 * d5 + d2;
                    }
                    if (n != 0 || bl3) continue;
                    d2 = point3d2.z - point3d.z;
                    vector3d3.set(d2 * this.m02, d2 * this.m12, d2 * this.m22);
                    d5 = vector3d2.dot(vector3d3);
                    d2 = vector3d3.lengthSquared();
                    bl3 = d5 <= 0.0 && -d5 <= d2 && d3 * d2 <= d5 * d5 + d2;
                }
            }
        }
        if (!bl2) {
            return false;
        }
        if (bl3) {
            return true;
        }
        if (point3d.x <= this.t0 && this.t0 <= point3d2.x && point3d.y <= this.t1 && this.t1 <= point3d2.y && point3d.z <= this.t2 && this.t2 <= point3d2.z) {
            return true;
        }
        Matrix3d matrix3d = this.getObjectToWorldRotationScale();
        for (n2 = -1; n2 <= 1; n2 += 2) {
            this.transformPoint(n2 < 0 ? point3d : point3d2, vector3d);
            for (n = 0; n <= 2; ++n) {
                vector3d2.set(n == 0 ? (double)n2 : 0.0, n == 1 ? (double)n2 : 0.0, n == 2 ? (double)n2 : 0.0);
                Math2.transformTranspose(matrix3d, vector3d2);
                d3 = vector3d.dot(vector3d2);
                if (!(d3 < 0.0)) continue;
                d2 = vector3d2.lengthSquared();
                if (d3 * d3 > d2) {
                    return false;
                }
                vector3d2.scale(d3 / d2);
                matrix3d.transform(vector3d2);
                vector3d2.x += this.t0;
                vector3d2.y += this.t1;
                vector3d2.z += this.t2;
                if (!boundingBox.contains((Tuple3d)vector3d2, n)) continue;
                return true;
            }
        }
        return false;
    }

    public void computeNormal(Intersection intersection, Vector3d vector3d) {
        this.transformPoint(intersection.getPoint(), vector3d);
        this.transformTranspose(vector3d, vector3d);
        vector3d.normalize();
    }

    public void computeUV(Intersection intersection, Vector2d vector2d) {
        Vector3d vector3d = intersection.tmpVector0;
        this.transformPoint(intersection.getPoint(), vector3d);
        vector3d.normalize();
        Sphere.getUV(vector3d, vector2d);
    }

    static void getUV(Tuple3d tuple3d, Vector2d vector2d) {
        double d;
        double d2;
        double d3;
        double d4 = tuple3d.z;
        double d5 = 1.0 - tuple3d.z * tuple3d.z;
        double d6 = d3 = d5 <= 0.0 ? 0.0 : Math.sqrt(d5);
        if (d3 == 0.0) {
            d2 = 1.0;
            d = 0.0;
        } else {
            d2 = tuple3d.x / d3;
            d = tuple3d.y / d3;
        }
        double d7 = Math.atan2(d, d2) * 0.15915494309189535;
        if (d7 < 0.0) {
            d7 += 1.0;
        }
        vector2d.set(d7, Math.acos(-d4) * 0.3183098861837907);
    }

    public void computeTangents(Intersection intersection, Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = intersection.tmpVector0;
        this.transformPoint(intersection.getPoint(), vector3d3);
        Sphere.getTangents(vector3d3, this.getObjectToWorldRotationScale(), vector3d, vector3d2);
    }

    static void getTangents(Tuple3d tuple3d, Matrix3d matrix3d, Vector3d vector3d, Vector3d vector3d2) {
        vector3d.set(Math.PI * -2 * tuple3d.y, Math.PI * 2 * tuple3d.x, 0.0);
        matrix3d.transform(vector3d);
        double d = Math.sqrt(tuple3d.x * tuple3d.x + tuple3d.y * tuple3d.y);
        if (d > 0.0) {
            double d2 = tuple3d.z / d;
            vector3d2.set(-Math.PI * tuple3d.x * d2, -Math.PI * tuple3d.y * d2, Math.PI * d);
        } else {
            vector3d2.set(-Math.PI, 0.0, 0.0);
        }
        matrix3d.transform(vector3d2);
    }
}

