/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath.geom;

import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.Volume;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class Intersection {
    public static final int LEAVING = -1;
    public static final int ENTERING = 1;
    public static final int PASSING = 0;
    public static final int ALL = 0;
    public static final int CLOSEST = 1;
    public static final int ANY = 2;
    public Volume volume;
    public Volume solid;
    public Line line;
    public double parameter;
    public int type;
    public int face;
    public final Vector3d volumeVector = new Vector3d();
    public Object volumeData;
    public Point3d tmpPoint0;
    public Vector3d tmpVector0;
    private boolean pointValid;
    private Point3d point;
    private boolean negateNormal;
    private boolean normalValid;
    private Vector3d normal;
    private boolean uvValid;
    private Vector2d uv;
    private boolean tangentsValid;
    private Vector3d uTangent;
    private Vector3d vTangent;

    public Intersection(IntersectionList intersectionList) {
        this.tmpPoint0 = intersectionList.tmpPoint0;
        this.tmpVector0 = intersectionList.tmpVector0;
    }

    public void negateNormal() {
        if (this.normalValid) {
            throw new IllegalStateException();
        }
        this.negateNormal = !this.negateNormal;
    }

    void reset() {
        this.volumeData = null;
        this.pointValid = false;
        this.normalValid = false;
        this.uvValid = false;
        this.tangentsValid = false;
        this.negateNormal = false;
    }

    public Point3d getPoint() {
        if (!this.pointValid) {
            if (this.point == null) {
                this.point = new Point3d();
            }
            this.point.scaleAdd(this.parameter, this.line.direction, this.line.origin);
            this.pointValid = true;
        }
        return this.point;
    }

    public Vector3d getNormal() {
        if (!this.normalValid) {
            if (this.normal == null) {
                this.normal = new Vector3d();
            }
            this.volume.computeNormal(this, this.normal);
            if (this.negateNormal) {
                this.normal.negate();
            }
            this.normalValid = true;
        }
        return this.normal;
    }

    public Vector2d getUV() {
        if (!this.uvValid) {
            if (this.uv == null) {
                this.uv = new Vector2d();
            }
            this.volume.computeUV(this, this.uv);
            this.uvValid = true;
        }
        return this.uv;
    }

    public Vector3d getUTangent() {
        this.validateTangents();
        return this.uTangent;
    }

    public Vector3d getVTangent() {
        this.validateTangents();
        return this.vTangent;
    }

    private void validateTangents() {
        if (!this.tangentsValid) {
            if (this.uTangent == null) {
                this.uTangent = new Vector3d();
            }
            if (this.vTangent == null) {
                this.vTangent = new Vector3d();
            }
            this.volume.computeTangents(this, this.uTangent, this.vTangent);
            this.tangentsValid = true;
        }
    }

    public Intersection deepCopy() {
        Intersection intersection = new Intersection(new IntersectionList());
        intersection.face = this.face;
        intersection.line = this.line.deepCopy();
        intersection.negateNormal = this.negateNormal;
        intersection.normal = this.getNormal();
        intersection.normalValid = this.normalValid;
        intersection.parameter = this.parameter;
        intersection.point = this.getPoint();
        intersection.pointValid = this.pointValid;
        intersection.tangentsValid = this.tangentsValid;
        intersection.tmpPoint0.set(this.tmpPoint0);
        intersection.tmpVector0.set(this.tmpVector0);
        intersection.type = this.type;
        intersection.uTangent = this.getUTangent();
        intersection.uv = this.getUV();
        intersection.uvValid = this.uvValid;
        intersection.vTangent = this.getVTangent();
        intersection.solid = this.solid;
        intersection.volume = this.volume;
        intersection.volumeData = this.volumeData;
        intersection.volumeVector.set(this.volumeVector);
        return intersection;
    }

    public String toString() {
        return "{" + this.volume + ',' + this.parameter + (this.type == -1 ? ",leaving" : (this.type == 1 ? ",entering" : ",passing")) + '}';
    }
}

