/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath.geom;

import de.grogra.vecmath.Math2;
import de.grogra.vecmath.Range;
import de.grogra.vecmath.geom.BoundingBox;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.TransformableVolume;
import de.grogra.vecmath.geom.Variables;
import java.util.LinkedList;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public abstract class ImplicitVolume
extends TransformableVolume {
    protected final ThreadLocal<Locals> locals = new ThreadLocal<Locals>(){

        @Override
        protected Locals initialValue() {
            return new Locals();
        }
    };

    protected abstract Range f(Range var1, Range var2, Range var3);

    protected abstract double f(double var1, double var3, double var5);

    private static void computeLineInterval(Line line, Range range, Range range2, Range range3, Range range4) {
        double d = line.origin.x + line.direction.x * range.a;
        double d2 = line.origin.x + line.direction.x * range.b;
        double d3 = line.origin.y + line.direction.y * range.a;
        double d4 = line.origin.y + line.direction.y * range.b;
        double d5 = line.origin.z + line.direction.z * range.a;
        double d6 = line.origin.z + line.direction.z * range.b;
        range2.set(Math.min(d, d2), Math.max(d, d2));
        range3.set(Math.min(d3, d4), Math.max(d3, d4));
        range4.set(Math.min(d5, d6), Math.max(d5, d6));
    }

    public boolean computeIntersections(Line line, int n, IntersectionList intersectionList, Intersection intersection, Intersection intersection2) {
        Object object;
        Locals locals = this.locals.get();
        Range range = locals.x;
        Range range2 = locals.y;
        Range range3 = locals.z;
        LinkedList<Range> linkedList = new LinkedList<Range>();
        linkedList.add(new Range(line.start + 1.0E-4, line.start + 1.0E8));
        while (!linkedList.isEmpty()) {
            object = (Range)linkedList.poll();
            ImplicitVolume.computeLineInterval(line, (Range)object, range, range2, range3);
            Range range4 = this.f(range, range2, range3);
            if (!(range4.a * range4.b <= 0.0)) continue;
            Point3d point3d = intersectionList.tmpPoint0;
            point3d.scaleAdd(((Range)object).a, line.direction, line.origin);
            double d = this.f(point3d.x, point3d.y, point3d.z);
            point3d.scaleAdd(((Range)object).b, line.direction, line.origin);
            double d2 = this.f(point3d.x, point3d.y, point3d.z);
            if (((Range)object).b - ((Range)object).a < 1.0E-8) {
                intersectionList.add(this, line, (((Range)object).a + ((Range)object).b) / 2.0, d < d2 ? -1 : 1);
                if (n != 1 && n != 2) continue;
                break;
            }
            double d3 = (((Range)object).a + ((Range)object).b) / 2.0;
            linkedList.addFirst(new Range(d3 + Math.ulp(d3), ((Range)object).b));
            linkedList.addFirst(new Range(((Range)object).a, d3));
        }
        object = intersectionList.tmpPoint0;
        ((Tuple3d)object).scaleAdd(line.start, line.direction, line.origin);
        return this.f(((Point3d)object).x, ((Point3d)object).y, ((Point3d)object).z) <= 0.0;
    }

    public boolean contains(Tuple3d tuple3d, boolean bl) {
        double d = tuple3d.x - this.t0;
        double d2 = tuple3d.y - this.t1;
        double d3 = tuple3d.z - this.t2;
        double d4 = this.m00 * d + this.m01 * d2 + this.m02 * d3;
        double d5 = this.m10 * d + this.m11 * d2 + this.m12 * d3;
        double d6 = this.m20 * d + this.m21 * d2 + this.m22 * d3;
        if (bl) {
            return this.f(d4, d5, d6) < 0.0;
        }
        return this.f(d4, d5, d6) <= 0.0;
    }

    public void getExtent(Tuple3d tuple3d, Tuple3d tuple3d2, Variables variables) {
        tuple3d.set(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        tuple3d2.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public boolean boxContainsBoundary(BoundingBox boundingBox, Tuple3d tuple3d, double d, Variables variables) {
        return true;
    }

    public void computeNormal(Intersection intersection, Vector3d vector3d) {
        Point3d point3d = intersection.getPoint();
        double d = point3d.x;
        double d2 = point3d.y;
        double d3 = point3d.z;
        double d4 = this.f(d + 1.0E-8, d2, d3) - this.f(d - 1.0E-8, d2, d3);
        double d5 = this.f(d, d2 + 1.0E-8, d3) - this.f(d, d2 - 1.0E-8, d3);
        double d6 = this.f(d, d2, d3 + 1.0E-8) - this.f(d, d2, d3 - 1.0E-8);
        vector3d.set(d4, d5, d6);
        vector3d.normalize();
    }

    public void computeUV(Intersection intersection, Vector2d vector2d) {
        Vector3d vector3d = intersection.tmpVector0;
        this.transformPoint(intersection.getPoint(), vector3d);
        vector3d.normalize();
        ImplicitVolume.getUV(vector3d, vector2d);
    }

    static void getUV(Tuple3d tuple3d, Vector2d vector2d) {
        double d;
        double d2;
        double d3;
        double d4 = tuple3d.z;
        double d5 = 1.0 - tuple3d.z * tuple3d.z;
        double d6 = d3 = d5 <= 0.0 ? 0.0 : Math.sqrt(d5);
        if (d3 == 0.0) {
            d2 = 1.0;
            d = 0.0;
        } else {
            d2 = tuple3d.x / d3;
            d = tuple3d.y / d3;
        }
        double d7 = Math.atan2(d, d2) * 0.15915494309189535;
        if (d7 < 0.0) {
            d7 += 1.0;
        }
        vector2d.set(d7, Math.acos(-d4) * 0.3183098861837907);
    }

    public void computeTangents(Intersection intersection, Vector3d vector3d, Vector3d vector3d2) {
        Locals locals = this.locals.get();
        Matrix3d matrix3d = locals.m;
        Vector3d vector3d3 = intersection.tmpVector0;
        this.computeNormal(intersection, vector3d3);
        Math2.getOrthogonalBasis(vector3d3, matrix3d, false);
        Matrix3d matrix3d2 = this.getObjectToWorldRotationScale();
        matrix3d.getColumn(0, vector3d);
        matrix3d2.transform(vector3d);
        matrix3d.getColumn(1, vector3d2);
        matrix3d2.transform(vector3d2);
    }

    protected static final class Locals {
        final Range tr0 = new Range();
        final Range tr1 = new Range();
        final Range tr2 = new Range();
        final Range tr3 = new Range();
        final Range tr4 = new Range();
        final Range tr5 = new Range();
        final Range tr6 = new Range();
        final Range tr7 = new Range();
        final Range r0 = new Range();
        final Range r1 = new Range();
        final Range r2 = new Range();
        final Range r3 = new Range();
        final Range r4 = new Range();
        final Range r5 = new Range();
        final Range r6 = new Range();
        final Range r7 = new Range();
        final Range x = new Range();
        final Range y = new Range();
        final Range z = new Range();
        final Matrix3d m = new Matrix3d();

        protected Locals() {
        }
    }
}

