/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath.geom;

import de.grogra.vecmath.Math2;
import de.grogra.vecmath.geom.BoundingBox;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.TransformableVolume;
import de.grogra.vecmath.geom.Variables;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class Cube
extends TransformableVolume {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int FRONT = 2;
    public static final int BACK = 3;
    public static final int BOTTOM = 4;
    public static final int TOP = 5;
    private static final Point3d MIN = new Point3d(-1.0, -1.0, -1.0);
    private static final Point3d MAX = new Point3d(1.0, 1.0, 1.0);
    private static final Point3d[] CORNERS = new Point3d[]{new Point3d(-1.0, -1.0, -1.0), new Point3d(1.0, -1.0, -1.0), new Point3d(1.0, -1.0, 1.0), new Point3d(1.0, 1.0, 1.0), new Point3d(-1.0, 1.0, 1.0), new Point3d(-1.0, 1.0, -1.0), new Point3d(-1.0, -1.0, -1.0), new Point3d(1.0, -1.0, -1.0)};
    private static final Point3d MIN_XY_MAX_Z = new Point3d(-1.0, -1.0, 1.0);
    private static final Point3d MAX_XY_MIN_Z = new Point3d(1.0, 1.0, -1.0);

    public boolean computeIntersections(Line line, int n, IntersectionList intersectionList, Intersection intersection, Intersection intersection2) {
        int n2 = intersection != null && intersection.volume == this ? intersection.face : -1;
        int n3 = intersection2 != null && intersection2.volume == this ? intersection2.face : -1;
        double d = line.origin.x;
        double d2 = line.origin.y;
        double d3 = line.origin.z;
        double d4 = line.direction.x;
        double d5 = line.direction.y;
        double d6 = line.direction.z;
        this.transformPoint(line.origin, line.origin);
        this.transformVector(line.direction, line.direction);
        boolean bl = BoundingBox.computeIntersections(this, MIN, MAX, line, n == 0, intersectionList, n2, n3);
        line.origin.set(d, d2, d3);
        line.direction.set(d4, d5, d6);
        return bl;
    }

    public boolean contains(Tuple3d tuple3d, boolean bl) {
        double d = tuple3d.x - this.t0;
        double d2 = tuple3d.y - this.t1;
        double d3 = tuple3d.z - this.t2;
        double d4 = this.m00 * d + this.m01 * d2 + this.m02 * d3;
        if (bl ? d4 <= -1.0 || d4 >= 1.0 : d4 < -1.0 || d4 > 1.0) {
            return false;
        }
        d4 = this.m10 * d + this.m11 * d2 + this.m12 * d3;
        if (bl ? d4 <= -1.0 || d4 >= 1.0 : d4 < -1.0 || d4 > 1.0) {
            return false;
        }
        d4 = this.m20 * d + this.m21 * d2 + this.m22 * d3;
        return !(bl ? d4 <= -1.0 || d4 >= 1.0 : d4 < -1.0 || d4 > 1.0);
    }

    public void getExtent(Tuple3d tuple3d, Tuple3d tuple3d2, Variables variables) {
        tuple3d.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        tuple3d2.set(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Point3d point3d = variables.tmpPoint0;
        Point3d point3d2 = variables.tmpPoint1;
        for (int i = -1; i <= 1; i += 2) {
            point3d.x = i;
            for (int j = -1; j <= 1; j += 2) {
                point3d.y = j;
                for (int k = -1; k <= 1; k += 2) {
                    point3d.z = k;
                    this.invTransformPoint(point3d, point3d2);
                    Math2.min(tuple3d, point3d2);
                    Math2.max(tuple3d2, point3d2);
                }
            }
        }
    }

    public boolean boxContainsBoundary(BoundingBox boundingBox, Tuple3d tuple3d, double d, Variables variables) {
        Point3d point3d = variables.tmpPoint0;
        Point3d point3d2 = variables.tmpPoint1;
        Point3d point3d3 = variables.tmpPoint2;
        Point3d point3d4 = variables.tmpPoint3;
        Vector3d vector3d = variables.tmpVector0;
        Vector3d vector3d2 = variables.tmpVector1;
        Vector3d vector3d3 = variables.tmpVector2;
        Matrix3d matrix3d = variables.tmpMatrix3;
        double d2 = d * this.getFrobeniusNorm() + 1.732050807568878;
        this.transformPoint(tuple3d, vector3d3);
        if (vector3d3.lengthSquared() > d2 * d2) {
            return false;
        }
        this.invTransformPoint(CORNERS[0], point3d);
        this.invTransformPoint(CORNERS[1], point3d2);
        this.invTransformPoint(MIN_XY_MAX_Z, point3d4);
        this.invTransformPoint(MAX_XY_MIN_Z, vector3d);
        for (int i = 2; i < 8; ++i) {
            this.invTransformPoint(CORNERS[i], point3d3);
            int n = (i & 1) == 0 ? boundingBox.testParallelogram(point3d, point3d2, point3d3, point3d4, matrix3d, vector3d2, vector3d3) : boundingBox.testParallelogram(point3d2, point3d, vector3d, point3d3, matrix3d, vector3d2, vector3d3);
            switch (n) {
                case -1: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            Point3d point3d5 = point3d;
            point3d = point3d2;
            point3d2 = point3d3;
            point3d3 = point3d5;
        }
        return false;
    }

    static void getNormal(int n, Vector3d vector3d) {
        switch (n) {
            case 0: {
                vector3d.set(-1.0, 0.0, 0.0);
                break;
            }
            case 1: {
                vector3d.set(1.0, 0.0, 0.0);
                break;
            }
            case 2: {
                vector3d.set(0.0, -1.0, 0.0);
                break;
            }
            case 3: {
                vector3d.set(0.0, 1.0, 0.0);
                break;
            }
            case 4: {
                vector3d.set(0.0, 0.0, -1.0);
                break;
            }
            case 5: {
                vector3d.set(0.0, 0.0, 1.0);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void computeNormal(Intersection intersection, Vector3d vector3d) {
        Cube.getNormal(intersection.face, vector3d);
        this.transformTranspose(vector3d, vector3d);
        vector3d.normalize();
    }

    static void getUV(int n, Tuple3d tuple3d, Vector2d vector2d) {
        double d;
        double d2;
        switch (n) {
            case 0: {
                d2 = 0.125 * (tuple3d.z + 1.0);
                d = 0.16666666666666666 * (tuple3d.y + 3.0);
                break;
            }
            case 1: {
                d2 = -0.125 * (tuple3d.z - 5.0);
                d = 0.16666666666666666 * (tuple3d.y + 3.0);
                break;
            }
            case 2: {
                d2 = 0.125 * (tuple3d.x + 3.0);
                d = 0.16666666666666666 * (tuple3d.z + 1.0);
                break;
            }
            case 3: {
                d2 = 0.125 * (tuple3d.x + 3.0);
                d = -0.16666666666666666 * (tuple3d.z - 5.0);
                break;
            }
            case 4: {
                d2 = -0.125 * (tuple3d.x - 7.0);
                d = 0.16666666666666666 * (tuple3d.y + 3.0);
                break;
            }
            case 5: {
                d2 = 0.125 * (tuple3d.x + 3.0);
                d = 0.16666666666666666 * (tuple3d.y + 3.0);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        vector2d.set(d2 < 0.0 ? 0.0 : (d2 > 1.0 ? 1.0 : d2), d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d));
    }

    public void computeUV(Intersection intersection, Vector2d vector2d) {
        Vector3d vector3d = intersection.tmpVector0;
        this.transformPoint(intersection.getPoint(), vector3d);
        Cube.getUV(intersection.face, vector3d, vector2d);
    }

    static void getTangents(int n, Vector3d vector3d, Vector3d vector3d2) {
        switch (n) {
            case 0: {
                vector3d.set(0.0, 0.0, 8.0);
                vector3d2.set(0.0, 6.0, 0.0);
                break;
            }
            case 1: {
                vector3d.set(0.0, 0.0, -8.0);
                vector3d2.set(0.0, 6.0, 0.0);
                break;
            }
            case 2: {
                vector3d.set(8.0, 0.0, 0.0);
                vector3d2.set(0.0, 0.0, 6.0);
                break;
            }
            case 3: {
                vector3d.set(8.0, 0.0, 0.0);
                vector3d2.set(0.0, 0.0, -6.0);
                break;
            }
            case 4: {
                vector3d.set(-8.0, 0.0, 0.0);
                vector3d2.set(0.0, 6.0, 0.0);
                break;
            }
            case 5: {
                vector3d.set(8.0, 0.0, 0.0);
                vector3d2.set(0.0, 6.0, 0.0);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void computeTangents(Intersection intersection, Vector3d vector3d, Vector3d vector3d2) {
        Cube.getTangents(intersection.face, vector3d, vector3d2);
        this.getObjectToWorldRotationScale().transform(vector3d);
        this.getObjectToWorldRotationScale().transform(vector3d2);
    }
}

