/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath;

public class Range {
    public double a;
    public double b;

    public Range() {
        this.b = 0.0;
        this.a = 0.0;
    }

    public Range(double d) {
        this.a = this.b = d;
    }

    public Range(double d, double d2) {
        this.a = d;
        this.b = d2;
    }

    public Range(Range range) {
        this.a = range.a;
        this.b = range.b;
    }

    public String toString() {
        return "[" + this.a + ", " + this.b + "]";
    }

    public void set(double d) {
        this.a = this.b = d;
    }

    public void set(double d, double d2) {
        this.a = d;
        this.b = d2;
    }

    public void set(Range range) {
        this.a = range.a;
        this.b = range.b;
    }

    public boolean contains(double d) {
        return this.a <= d && d <= this.b;
    }

    public boolean contains(Range range) {
        return this.a <= range.a && range.b <= this.b;
    }

    public static final Range add(Range range, Range range2, Range range3) {
        range.set(range2.a + range3.a, range2.b + range3.b);
        return range;
    }

    public static final Range sub(Range range, Range range2, Range range3) {
        range.set(range2.a - range3.b, range2.b - range3.a);
        return range;
    }

    public static final Range mul(Range range, Range range2, Range range3) {
        range.set(Math.min(Math.min(range2.a * range3.a, range2.a * range3.b), Math.min(range2.b * range3.a, range2.b * range3.b)), Math.max(Math.max(range2.a * range3.a, range2.a * range3.b), Math.max(range2.b * range3.a, range2.b * range3.b)));
        return range;
    }

    public static final Range div(Range range, Range range2, Range range3) {
        double d = range2.a;
        double d2 = range2.b;
        double d3 = range3.a;
        double d4 = range3.b;
        if (d3 == 0.0 && d4 == 0.0) {
            range.set(Double.NaN);
        } else if (d == 0.0 && d2 == 0.0) {
            range.set(0.0);
        } else if (d3 >= 0.0 && d4 > 0.0) {
            if (d > 0.0 && d2 > 0.0) {
                range.set(d / d4, d3 == 0.0 ? Double.POSITIVE_INFINITY : d2 / d3);
            } else if (d == 0.0 && d2 > 0.0) {
                range.set(0.0, d3 == 0.0 ? Double.POSITIVE_INFINITY : d2 / d3);
            } else if (d < 0.0 && d2 > 0.0) {
                if (d3 == 0.0) {
                    range.set(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                } else {
                    range.set(d / d3, d2 / d3);
                }
            } else if (d < 0.0 && d2 == 0.0) {
                range.set(d3 == 0.0 ? Double.NEGATIVE_INFINITY : d / d3, 0.0);
            } else if (d < 0.0 && d2 < 0.0) {
                range.set(d3 == 0.0 ? Double.NEGATIVE_INFINITY : d / d3, d2 / d4);
            }
        } else if (d3 < 0.0 && d4 > 0.0) {
            range.set(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        } else if (d3 < 0.0 && d4 <= 0.0) {
            if (d > 0.0 && d2 > 0.0) {
                range.set(d4 == 0.0 ? Double.NEGATIVE_INFINITY : d2 / d4, d / d3);
            } else if (d == 0.0 && d2 > 0.0) {
                range.set(d4 == 0.0 ? Double.NEGATIVE_INFINITY : d2 / d4, 0.0);
            } else if (d < 0.0 && d2 > 0.0) {
                if (d4 == 0.0) {
                    range.set(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                } else {
                    range.set(d2 / d4, d / d4);
                }
            } else if (d < 0.0 && d2 == 0.0) {
                range.set(0.0, d4 == 0.0 ? Double.POSITIVE_INFINITY : d / d4);
            } else if (d < 0.0 && d2 < 0.0) {
                range.set(d2 / d3, d4 == 0.0 ? Double.POSITIVE_INFINITY : d / d4);
            }
        }
        return range;
    }

    public static final Range sqr(Range range, Range range2) {
        if (range2.a >= 0.0) {
            range.set(range2.a * range2.a, range2.b * range2.b);
        } else if (range2.b < 0.0) {
            range.set(range2.b * range2.b, range2.a * range2.a);
        } else {
            range.set(0.0, Math.max(range2.a * range2.a, range2.b * range2.b));
        }
        return range;
    }

    public static final Range sqrt(Range range, Range range2) {
        range.set(Math.sqrt(range2.a), Math.sqrt(range2.b));
        return range;
    }

    public static final Range pow(Range range, Range range2, double d) {
        double d2 = Math.pow(range2.a, d);
        double d3 = Math.pow(range2.b, d);
        range.set(Math.min(d2, d3), Math.max(d2, d3));
        return range;
    }

    public static final Range abs(Range range, Range range2) {
        if (range2.b <= 0.0) {
            range.set(Math.abs(range2.b), Math.abs(range2.a));
        } else if (range2.a < 0.0) {
            range.set(0.0, Math.max(Math.abs(range2.a), range2.b));
        } else {
            range.set(range2);
        }
        return range;
    }

    public static final Range cos(Range range, Range range2) {
        double d = range2.a;
        double d2 = range2.b;
        double d3 = Math.cos(d);
        double d4 = Math.cos(d2);
        range.set(Math.min(d3, d4), Math.max(d3, d4));
        if (Math.ceil(d / 2.0 / Math.PI) < d2 / 2.0 / Math.PI) {
            range.b = 1.0;
        }
        if (Math.ceil(d / 2.0 / Math.PI - 0.5) <= d2 / 2.0 / Math.PI - 0.5) {
            range.a = -1.0;
        }
        return range;
    }

    public static final Range sin(Range range, Range range2) {
        range.a = range2.a - 1.5707963267948966;
        range.b = range2.b - 1.5707963267948966;
        return Range.cos(range, range);
    }

    public static final Range tan(Range range, Range range2) {
        double d = Math.tan(range2.a);
        double d2 = Math.tan(range2.b);
        range.set(Math.min(d, d2), Math.max(d, d2));
        if (Math.floor(range2.a / Math.PI - 0.5) <= range2.b / Math.PI - 0.5) {
            range.a = Double.NEGATIVE_INFINITY;
            range.b = Double.POSITIVE_INFINITY;
        }
        return Range.cos(range, range);
    }

    public static final Range acos(Range range, Range range2) {
        double d = Math.acos(range2.a);
        double d2 = Math.acos(range2.b);
        range.set(Math.min(d, d2), Math.max(d, d2));
        return range;
    }

    public static final Range asin(Range range, Range range2) {
        double d = Math.asin(range2.a);
        double d2 = Math.asin(range2.b);
        range.set(Math.min(d, d2), Math.max(d, d2));
        return range;
    }

    public static final Range atan(Range range, Range range2) {
        double d = Math.atan(range2.a);
        double d2 = Math.atan(range2.b);
        range.set(Math.min(d, d2), Math.max(d, d2));
        return range;
    }

    public static final Range atan2(Range range, Range range2, Range range3) {
        double d = Math.atan2(range2.a, range3.a);
        double d2 = Math.atan2(range2.a, range3.b);
        double d3 = Math.atan2(range2.b, range3.a);
        double d4 = Math.atan2(range2.b, range3.b);
        if (range3.a == 0.0 && range3.b == 0.0) {
            if (range2.b < 0.0) {
                range.set(-1.5707963267948966);
            } else if (range2.a > 0.0) {
                range.set(1.5707963267948966);
            } else {
                range.set(-1.5707963267948966, 1.5707963267948966);
            }
        } else if (range2.a == 0.0 && range2.b == 0.0) {
            if (range3.b < 0.0) {
                range.set(Math.PI);
            } else if (range3.a > 0.0) {
                range.set(0.0);
            } else {
                range.set(0.0, Math.PI);
            }
        } else if (range3.a < 0.0 && range3.b > 0.0 && range2.a < 0.0 && range2.b > 0.0) {
            range.set(-Math.PI, Math.PI);
        } else if (range3.a < 0.0 && range3.b == 0.0 && range2.a < 0.0 && range2.b > 0.0) {
            range.set(1.5707963267948966, 4.71238898038469);
        } else if (range3.a == 0.0 && range3.b > 0.0 && range2.a < 0.0 && range2.b > 0.0) {
            range.set(-1.5707963267948966, 1.5707963267948966);
        } else if (range3.a < 0.0 && range3.b > 0.0 && range2.a < 0.0 && range2.b == 0.0) {
            range.set(-Math.PI, 0.0);
        } else if (range3.a < 0.0 && range3.b > 0.0 && range2.a == 0.0 && range2.b > 0.0) {
            range.set(0.0, Math.PI);
        } else if (range3.a < 0.0 && range3.b == 0.0 && range2.a < 0.0 && range2.b == 0.0) {
            range.set(-Math.PI, -1.5707963267948966);
        } else if (range3.a == 0.0 && range3.b > 0.0 && range2.a == 0.0 && range2.b > 0.0) {
            range.set(0.0, 1.5707963267948966);
        } else if (range3.a < 0.0 && range3.b == 0.0 && range2.a == 0.0 && range2.b > 0.0) {
            range.set(1.5707963267948966, Math.PI);
        } else if (range3.a == 0.0 && range3.b > 0.0 && range2.a < 0.0 && range2.b == 0.0) {
            range.set(-1.5707963267948966, 0.0);
        } else if (range3.b < 0.0 && range2.contains(0.0)) {
            if (range2.b == 0.0) {
                range.set(-Math.PI, d2);
            } else if (range2.a == 0.0) {
                range.set(d4, Math.PI);
            } else {
                range.set(d4, d2 + Math.PI * 2);
            }
        } else {
            range.set(Math.min(Math.min(d, d2), Math.min(d3, d4)), Math.max(Math.max(d, d2), Math.max(d3, d4)));
        }
        return range;
    }
}

