/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.URLTagFragmentGenerator;
import org.jfree.io.SerialUtilities;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class ChartEntity
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -4445994133561919083L;
    private transient Shape area;
    private String toolTipText;
    private String urlText;

    public ChartEntity(Shape shape) {
        this(shape, null);
    }

    public ChartEntity(Shape shape, String string) {
        this(shape, string, null);
    }

    public ChartEntity(Shape shape, String string, String string2) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        this.area = shape;
        this.toolTipText = string;
        this.urlText = string2;
    }

    public Shape getArea() {
        return this.area;
    }

    public void setArea(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        this.area = shape;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String string) {
        this.toolTipText = string;
    }

    public String getURLText() {
        return this.urlText;
    }

    public void setURLText(String string) {
        this.urlText = string;
    }

    public String getShapeType() {
        if (this.area instanceof Rectangle2D) {
            return "rect";
        }
        return "poly";
    }

    public String getShapeCoords() {
        if (this.area instanceof Rectangle2D) {
            return this.getRectCoords((Rectangle2D)this.area);
        }
        return this.getPolyCoords(this.area);
    }

    private String getRectCoords(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException("Null 'rectangle' argument.");
        }
        int n = (int)rectangle2D.getX();
        int n2 = (int)rectangle2D.getY();
        int n3 = n + (int)rectangle2D.getWidth();
        int n4 = n2 + (int)rectangle2D.getHeight();
        if (n3 == n) {
            ++n3;
        }
        if (n4 == n2) {
            ++n4;
        }
        return n + "," + n2 + "," + n3 + "," + n4;
    }

    private String getPolyCoords(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        float[] fArray = new float[6];
        PathIterator pathIterator = shape.getPathIterator(null, 1.0);
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(fArray);
            if (bl) {
                bl = false;
                stringBuffer.append((int)fArray[0]);
                stringBuffer.append(",").append((int)fArray[1]);
            } else {
                stringBuffer.append(",");
                stringBuffer.append((int)fArray[0]);
                stringBuffer.append(",");
                stringBuffer.append((int)fArray[1]);
            }
            pathIterator.next();
        }
        return stringBuffer.toString();
    }

    public String getImageMapAreaTag(ToolTipTagFragmentGenerator toolTipTagFragmentGenerator, URLTagFragmentGenerator uRLTagFragmentGenerator) {
        boolean bl;
        boolean bl2;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl3 = this.urlText == null ? false : (bl2 = !this.urlText.equals(""));
        boolean bl4 = this.toolTipText == null ? false : (bl = !this.toolTipText.equals(""));
        if (bl2 || bl) {
            stringBuffer.append("<area shape=\"" + this.getShapeType() + "\"" + " coords=\"" + this.getShapeCoords() + "\"");
            if (bl) {
                stringBuffer.append(toolTipTagFragmentGenerator.generateToolTipFragment(this.toolTipText));
            }
            if (bl2) {
                stringBuffer.append(uRLTagFragmentGenerator.generateURLFragment(this.urlText));
            }
            if (!bl) {
                stringBuffer.append(" alt=\"\"");
            }
            stringBuffer.append("/>");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ChartEntity: ");
        stringBuffer.append("tooltip = ");
        stringBuffer.append(this.toolTipText);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ChartEntity) {
            ChartEntity chartEntity = (ChartEntity)object;
            if (!this.area.equals(chartEntity.area)) {
                return false;
            }
            if (!ObjectUtilities.equal((Object)this.toolTipText, (Object)chartEntity.toolTipText)) {
                return false;
            }
            return ObjectUtilities.equal((Object)this.urlText, (Object)chartEntity.urlText);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape((Shape)this.area, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.area = SerialUtilities.readShape((ObjectInputStream)objectInputStream);
    }
}

