/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.swing;

import de.grogra.docking.DockablePanel;
import de.grogra.icon.IconAdapter;
import de.grogra.icon.IconSource;
import de.grogra.pf.ui.UIProperty;
import de.grogra.pf.ui.swing.PanelSupport;
import de.grogra.pf.ui.swing.SwingDockable;
import de.grogra.pf.ui.swing.SwingToolkit;
import de.grogra.util.Disposable;
import de.grogra.util.Map;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.Icon;

public class PlainPanel
extends DockablePanel
implements SwingDockable {
    private PanelSupport support;
    private Disposable toDispose;

    PlainPanel(LayoutManager layoutManager, Disposable disposable) {
        super(layoutManager);
        this.toDispose = disposable;
        this.setClosable(true);
    }

    public PanelSupport getSupport() {
        return this.support;
    }

    public void initialize(PanelSupport panelSupport, Map map) {
        this.support = panelSupport;
        panelSupport.installUpdater(UIProperty.PANEL_TITLE, true, "setTitles", map);
        panelSupport.installUpdater(UIProperty.ICON, true, "setIconSource", map);
    }

    public void dispose() {
        if (this.toDispose != null) {
            this.toDispose.dispose();
            this.toDispose = null;
        }
    }

    public void setIconSource(IconSource iconSource) {
        this.setIcon((Icon)IconAdapter.create((IconSource)iconSource, (Dimension)SwingToolkit.WINDOW_ICON_SIZE));
    }

    public void dockableClosed() {
        this.support.dockableClosed();
    }

    public void setMenu(Component component) {
        if (component != null) {
            throw new UnsupportedOperationException();
        }
    }

    public Container getContentPane() {
        return this;
    }

    public void checkClose(Runnable runnable) {
        this.support.checkClose(runnable);
    }
}

