/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.swing;

import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.edit.Selectable;
import de.grogra.pf.ui.edit.Selection;
import de.grogra.pf.ui.swing.MenuModelBase;
import de.grogra.pf.ui.swing.SwingButtonSupport;
import de.grogra.pf.ui.swing.SwingToolkit;
import de.grogra.pf.ui.tree.UITree;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

class MenuModel
extends MenuModelBase {
    boolean isPopup;
    final ActionListener listener;

    MenuModel(UITree uITree, ActionListener actionListener, boolean bl) {
        super(uITree);
        this.isPopup = bl;
        this.listener = actionListener;
    }

    protected Container getContentPane(Object object) {
        return object instanceof JMenuBar ? (Container)object : (object instanceof JPopupMenu ? (JPopupMenu)object : (object instanceof JMenu ? ((JMenu)object).getPopupMenu() : null));
    }

    public boolean isLeaf(Object object) {
        return !(object instanceof JPopupMenu) && !(object instanceof JMenu) && !(object instanceof JMenuBar) || object != this.root && object instanceof JMenu && ((JMenu)object).getClientProperty("de.grogra.pf.ui.swing.WRAPPER") != null;
    }

    protected JComponent createNodeImpl(Object object, Object object2) {
        JComponent jComponent;
        int n = 0;
        if (this.isSourceRoot(object)) {
            jComponent = this.isPopup ? new JPopupMenu() : new JMenuBar();
        } else if (this.sourceTree.isLeaf(object)) {
            switch (this.sourceTree.getType(object)) {
                case 5: {
                    jComponent = new JRadioButtonMenuItem();
                    new SwingButtonSupport(this.sourceTree, object, (AbstractButton)jComponent, 5);
                    n |= 5;
                    break;
                }
                case 1: {
                    jComponent = new JPopupMenu.Separator();
                    break;
                }
                case 7: {
                    jComponent = (JComponent)Box.createHorizontalGlue();
                    break;
                }
                case 3: {
                    jComponent = new JButton();
                    new SwingButtonSupport(this.sourceTree, object, (AbstractButton)jComponent, 3);
                    n |= 4;
                    break;
                }
                case 9: {
                    Selection selection;
                    Selectable selectable = (Selectable)this.sourceTree.invoke(object, "getSelectable", null);
                    if (selectable != null && (selection = selectable.toSelection(this.sourceTree.getContext())) != null) {
                        ComponentWrapper componentWrapper = selection.createPropertyEditorMenu();
                        jComponent = (JMenu)componentWrapper.getComponent();
                        jComponent.putClientProperty("de.grogra.pf.ui.swing.WRAPPER", componentWrapper);
                        break;
                    }
                    jComponent = new JMenuItem();
                    break;
                }
                default: {
                    jComponent = new JMenuItem();
                    SwingButtonSupport swingButtonSupport = new SwingButtonSupport(this.sourceTree, object, (AbstractButton)jComponent, 2);
                    if (this.listener != null) {
                        swingButtonSupport.setActionListener(null);
                        ((AbstractButton)jComponent).addActionListener(this.listener);
                    }
                    n |= 5;
                    break;
                }
            }
        } else {
            jComponent = new JMenu();
            n |= (this.isPopup ? object2 instanceof JPopupMenu : object2 instanceof JMenuBar) ? 1 : 5;
        }
        SwingToolkit.initialize(jComponent, this.sourceTree, object, n);
        return jComponent;
    }

    public Object createNode(Object object, Object object2) {
        JComponent jComponent = this.createNodeImpl(object, object2);
        jComponent.putClientProperty("de.grogra.pf.ui.swing.SOURCE", object);
        return jComponent;
    }

    protected void treeChangedSync(Container container) {
        while (container != this.root && !(container instanceof JMenu)) {
            container = container.getParent();
        }
        this.updateIcons(container);
        super.treeChangedSync(container);
    }

    private void updateIcons(Container container) {
        Icon icon;
        Component component;
        int n;
        boolean bl = container instanceof JMenuBar;
        container = this.getContentPane(container);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (n = container.getComponentCount() - 1; n >= 0; --n) {
            component = container.getComponent(n);
            if (!(component instanceof AbstractButton)) continue;
            icon = ((AbstractButton)component).getIcon();
            if (icon == SwingToolkit.MENU_ICON_DUMMY) {
                bl4 = true;
            } else if (icon != null) {
                bl2 = true;
            } else if (!bl) {
                bl3 = true;
            }
            if (component != this.root && !(component instanceof JMenu)) continue;
            this.updateIcons((Container)component);
        }
        if (bl3 && (bl2 || bl4) || bl4 && !bl2) {
            for (n = container.getComponentCount() - 1; n >= 0; --n) {
                component = container.getComponent(n);
                if (!(component instanceof AbstractButton)) continue;
                icon = ((AbstractButton)component).getIcon();
                if (icon == SwingToolkit.MENU_ICON_DUMMY) {
                    if (bl2) continue;
                    ((AbstractButton)component).setIcon(null);
                    continue;
                }
                if (icon != null || !bl2) continue;
                ((AbstractButton)component).setIcon((Icon)SwingToolkit.MENU_ICON_DUMMY);
            }
        }
    }
}

