/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.swing;

import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.swing.MenuModel;
import de.grogra.pf.ui.swing.SwingToolkit;
import de.grogra.pf.ui.tree.UITree;
import de.grogra.util.Disposable;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.tree.TreePath;

class ComponentMenu
extends MenuModel {
    private Disposable toDispose;

    public ComponentMenu(UITree uITree, Disposable disposable) {
        super(uITree, null, false);
        this.toDispose = disposable;
    }

    protected void disposeImpl() {
        super.disposeImpl();
        if (this.toDispose != null) {
            this.toDispose.dispose();
            this.toDispose = null;
        }
    }

    protected JComponent createNodeImpl(Object object, Object object2) {
        ComponentWrapper componentWrapper;
        if (this.isSourceRoot(object)) {
            return new JMenu("ROOT");
        }
        if (this.sourceTree.isLeaf(object) && (componentWrapper = (ComponentWrapper)this.sourceTree.invoke(object, "createComponentWrapper", null)) != null) {
            AbstractButton abstractButton = (AbstractButton)componentWrapper.getComponent();
            this.setEnabled(abstractButton, this.sourceTree.isEnabled(object));
            abstractButton.putClientProperty("de.grogra.pf.ui.swing.WRAPPER", componentWrapper);
            abstractButton.setText((String)this.sourceTree.getDescription(object, "Name"));
            return abstractButton;
        }
        return super.createNodeImpl(object, object2);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        ComponentWrapper componentWrapper = (ComponentWrapper)((JComponent)treePath.getLastPathComponent()).getClientProperty("de.grogra.pf.ui.swing.WRAPPER");
        if (componentWrapper != null) {
            Object object2 = SwingToolkit.getSource(componentWrapper.getComponent());
            this.sourceTree.invoke(object2, "updateComponentWrapper", (Object)componentWrapper);
            this.setEnabled((Component)componentWrapper.getComponent(), this.sourceTree.isEnabled(object2));
        }
    }
}

