/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.awt;

import de.grogra.icon.IconAdapter;
import de.grogra.icon.IconSource;
import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.awt.AWTToolkitBase;
import de.grogra.pf.ui.awt.LabelRenderer;
import de.grogra.pf.ui.awt.MappedComponentModel;
import de.grogra.pf.ui.tree.UITree;
import de.grogra.util.Disposable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.tree.TreePath;

public class AWTTree
extends MappedComponentModel
implements LayoutManager2 {
    public static final Color color1 = new Color(0xF0F0F0);
    public static final Color color2 = new Color(0xE0E0E0);
    protected static final Icon ICON_COLLAPSED_NORMAL = new ButtonIcon(false, false);
    protected static final Icon ICON_EXPANDED_NORMAL = new ButtonIcon(true, false);
    protected static final Icon ICON_COLLAPSED_PRESSED = new ButtonIcon(false, true);
    protected static final Icon ICON_EXPANDED_PRESSED = new ButtonIcon(true, true);
    protected final Insets rootInsets = new Insets(0, 0, 0, 0);
    private static final int MINIMUM = 0;
    private static final int PREFERRED = 1;
    private static final int MAXIMUM = 2;
    private static final int LAYOUT = 3;
    private static final int COMPONENT_X = 4;
    private Disposable toDispose;
    private final LabelRenderer renderer = new LabelRenderer(this.sourceTree.getContext(), 0, false){

        private Object src(LabelRenderer.LabelData labelData) {
            return AWTTree.this.getSourceOf(((LayoutInfo)labelData.getUserData()).label.getParent());
        }

        protected String getText(LabelRenderer.LabelData labelData) {
            return (String)AWTTree.this.sourceTree.getDescription(this.src(labelData), "Name");
        }

        protected IconSource getIconSource(LabelRenderer.LabelData labelData) {
            return (IconSource)AWTTree.this.sourceTree.getDescription(this.src(labelData), "Icon");
        }

        protected void updateNodes(LabelRenderer.LabelData[] labelDataArray, boolean bl) {
            LayoutInfo layoutInfo;
            int n;
            if (bl) {
                for (n = labelDataArray.length - 1; n >= 0; --n) {
                    layoutInfo = (LayoutInfo)labelDataArray[n].getUserData();
                    layoutInfo.label.invalidate();
                }
                AWTTree.this.root.validate();
            }
            for (n = labelDataArray.length - 1; n >= 0; --n) {
                layoutInfo = (LayoutInfo)labelDataArray[n].getUserData();
                AWTTree.this.getToolkit().updateLabel(layoutInfo.label, labelDataArray[n].getText(), labelDataArray[n].getIcon());
                layoutInfo.label.repaint();
            }
        }
    };
    private LayoutInfo rootInfo = new LayoutInfo();
    private final Insets layoutInsets = new Insets(0, 0, 0, 0);
    private static final Insets nullInsets = new Insets(0, 0, 0, 0);
    private int globalComponentX = 0;

    public AWTTree(UITree uITree, Disposable disposable, Container container) {
        super(uITree);
        this.toDispose = disposable;
        this.root = container;
        container.setLayout(this);
    }

    protected void disposeImpl() {
        if (this.toDispose != null) {
            this.toDispose.dispose();
            this.toDispose = null;
        }
    }

    Object getSourceOf(Container container) {
        return container == this.root ? this.sourceRoot : ((NodeBase)container).source;
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    private LayoutInfo getLayoutInfo(Container container) {
        return container == this.root ? this.rootInfo : ((NodeBase)container).layoutInfo;
    }

    public void addLayoutComponent(Component component, Object object) {
        if (component instanceof NodeBase) {
            ((NodeBase)component).setLayout(this);
        } else {
            LayoutInfo layoutInfo = this.getLayoutInfo(component.getParent());
            if (component == layoutInfo.label) {
                int n = component.getPreferredSize().width;
                if (n > layoutInfo.maxLabelWidth) {
                    layoutInfo.maxLabelWidth = n;
                }
            } else if (component instanceof Leaf) {
                LayoutInfo layoutInfo2 = ((Leaf)component).layoutInfo;
                if (layoutInfo2.maxLabelWidth > layoutInfo.maxLabelWidth) {
                    layoutInfo.maxLabelWidth = layoutInfo2.maxLabelWidth;
                }
            }
        }
    }

    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            if (container == this.root) {
                this.layout(3);
            }
            this.applyLayout(container);
        }
    }

    private void applyLayout(Container container) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Serializable serializable;
            Component component = container.getComponent(i);
            if (component instanceof NodeBase) {
                serializable = (NodeBase)component;
                serializable.setBounds(serializable.layoutInfo);
                continue;
            }
            serializable = this.getLayoutInfo(container);
            component.setBounds(((LayoutInfo)serializable).label == component ? ((LayoutInfo)serializable).labelBounds : ((Leaf)container).compBounds);
        }
    }

    public void invalidateLayout(Container container) {
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    private Dimension layoutSize(Container container, int n) {
        if (container != this.root) {
            return container.getSize();
        }
        this.layout(n);
        return this.rootInfo.getSize();
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.layoutSize(container, 0);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.layoutSize(container, 1);
    }

    public Dimension maximumLayoutSize(Container container) {
        return this.layoutSize(container, 2);
    }

    public void paint(Graphics graphics) {
        this.paintRoot(graphics);
        this.paintChildren(this.root, 0, graphics);
    }

    private void paintChildren(Container container, int n, Graphics graphics) {
        int n2 = container.getComponentCount();
        for (int i = 0; i < n2; ++i) {
            Component component = container.getComponent(i);
            if (!(component instanceof NodeBase)) continue;
            graphics.translate(component.getX(), component.getY());
            if (component instanceof Node) {
                Node node = (Node)component;
                this.paintNode(node, n, node.expanded, node.pressed, graphics);
                if (node.expanded) {
                    this.paintChildren(node, n + 1, graphics);
                }
            } else {
                this.paintChildren((Container)component, n + 1, graphics);
            }
            graphics.translate(-component.getX(), -component.getY());
        }
    }

    protected void paintRoot(Graphics graphics) {
        graphics.setColor(color2);
        graphics.fillRect(0, 0, this.root.getWidth(), this.root.getHeight());
    }

    private static Color lighten(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        fArray[2] = (float)Math.min((double)fArray[2] + 0.1, 1.0);
        return Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
    }

    protected void paintNode(Node node, int n, boolean bl, boolean bl2, Graphics graphics) {
        Color color = node.getBackground();
        int n2 = node.getWidth();
        int n3 = node.getHeight();
        int n4 = 1;
        int n5 = n2 - 3;
        int n6 = 1;
        int n7 = n3 - 3;
        graphics.setColor(color);
        graphics.fillRect(n4, n6, n2 - 3, n3 - 3);
        Icon icon = node.getButtonIcon();
        if (icon != null) {
            icon.paintIcon(this.root, graphics, node.iconLeft, 4);
        }
        if (bl) {
            graphics.setColor(Color.darkGray);
            graphics.drawRect(n4 + 1, n6 + 1, n5 - n4, n7 - n6);
            graphics.setColor(Color.white);
            graphics.drawRect(n4, n6, n5 - n4, n7 - n6);
        }
    }

    private void layout(int n) {
        Insets insets = this.root.getInsets();
        this.layoutInsets.left = insets.left;
        this.layoutInsets.right = insets.right;
        this.layoutInsets.top = insets.top;
        this.layoutInsets.bottom = insets.bottom;
        insets = this.layoutInsets;
        insets.left += this.rootInsets.left;
        insets.right += this.rootInsets.right;
        insets.top += this.rootInsets.top;
        insets.bottom += this.rootInsets.bottom;
        this.layoutChildren(this.root, insets, 4, insets);
        this.layoutChildren(this.root, insets, n, insets);
    }

    private void layoutChildren(Container container, Insets insets, int n, Insets insets2) {
        int n2 = insets.top;
        int n3 = 0;
        LayoutInfo layoutInfo = this.getLayoutInfo(container);
        if (container instanceof Leaf) {
            Component component;
            int n4;
            Leaf leaf = (Leaf)container;
            if (layoutInfo.label != null) {
                layoutInfo.labelBounds.height = layoutInfo.label.getPreferredSize().height;
                layoutInfo.labelBounds.x = insets.left;
                layoutInfo.labelBounds.y = n2;
                layoutInfo.labelBounds.width = this.globalComponentX - this.getLabelGap() - insets2.left;
                n4 = 1;
            } else {
                layoutInfo.labelBounds.height = 0;
                n4 = 0;
            }
            Component component2 = component = container.getComponentCount() == n4 ? null : container.getComponent(n4);
            if (component != null && n != 4) {
                Dimension dimension;
                leaf.compBounds.y = n2;
                switch (n) {
                    case 0: {
                        dimension = component.getMinimumSize();
                        break;
                    }
                    case 1: {
                        dimension = component.getPreferredSize();
                        break;
                    }
                    case 2: {
                        dimension = component.getMaximumSize();
                        break;
                    }
                    default: {
                        dimension = null;
                    }
                }
                if (dimension != null) {
                    leaf.compBounds.setSize(dimension);
                    int n5 = dimension.width;
                    if (layoutInfo.label != null) {
                        n5 += this.globalComponentX - insets2.left;
                    }
                    n3 = Math.max(n3, n5);
                } else {
                    leaf.compBounds.x = layoutInfo.label != null ? this.globalComponentX - insets2.left + insets.left : insets.left;
                    dimension = component.getPreferredSize();
                    leaf.compBounds.height = dimension.height;
                    leaf.compBounds.width = Math.min(this.root.getWidth() - insets2.right - insets2.left - leaf.compBounds.x + insets.left, dimension.width + 127 & 0xFFFFFF80);
                }
                n2 += Math.max(layoutInfo.labelBounds.height, leaf.compBounds.height);
            } else {
                n2 += layoutInfo.labelBounds.height;
            }
        } else {
            Icon icon;
            int n6 = insets.left;
            int n7 = n2;
            if (container instanceof Node && (icon = ((Node)container).getButtonIcon()) != null) {
                n6 += icon.getIconWidth() + this.getIconGap();
                n7 += icon.getIconHeight() + this.getIconGap();
            }
            if (layoutInfo.label != null) {
                layoutInfo.labelBounds.x = n6;
                layoutInfo.labelBounds.y = n2;
                layoutInfo.labelBounds.setSize(layoutInfo.label.getPreferredSize());
                n7 = Math.max(n7, n2 + layoutInfo.labelBounds.height + 4);
            }
            if (container instanceof Node) {
                ((Node)container).iconLeft = insets.left;
                ((Node)container).iconBottom = n7;
                ((Node)container).iconRight = n6;
            }
            n2 = n7;
            if (!(container instanceof Node) || ((Node)container).expanded) {
                int n8 = container.getComponentCount();
                for (int i = layoutInfo.label != null ? 1 : 0; i < n8; ++i) {
                    int n9;
                    Insets insets3;
                    NodeBase nodeBase = (NodeBase)container.getComponent(i);
                    nodeBase.layoutInfo.x = insets.left;
                    nodeBase.layoutInfo.y = n2;
                    if (n == 3) {
                        nodeBase.layoutInfo.width = this.root.getWidth() - insets2.left - insets2.right;
                    }
                    if (nodeBase instanceof Node) {
                        insets3 = ((Node)nodeBase).layoutInsets;
                        insets3.left = 4;
                        insets3.right = 4;
                        insets3.top = 4;
                        insets3.bottom = 4;
                    } else {
                        insets3 = nullInsets;
                    }
                    insets2.left += insets3.left;
                    insets2.right += insets3.right;
                    insets2.top += insets3.top;
                    insets2.bottom += insets3.bottom;
                    if (n == 4 && (n9 = insets2.left + nodeBase.layoutInfo.maxLabelWidth + this.getLabelGap()) > this.globalComponentX) {
                        this.globalComponentX = n9;
                    }
                    this.layoutChildren(nodeBase, insets3, n, insets2);
                    insets2.left -= insets3.left;
                    insets2.right -= insets3.right;
                    insets2.top -= insets3.top;
                    insets2.bottom -= insets3.bottom;
                    n2 += nodeBase.layoutInfo.height;
                    n3 = Math.max(n3, nodeBase.layoutInfo.width);
                }
            }
        }
        n3 += insets.left + insets.right;
        layoutInfo.height = n2 + insets.bottom;
        if (n != 3) {
            layoutInfo.width = n3;
        }
    }

    public Object createNode(Object object, Object object2) {
        NodeBase nodeBase;
        if (this.isSourceRoot(object)) {
            this.createLabel(this.root);
            return this.root;
        }
        if (this.sourceTree.isLeaf(object)) {
            Leaf leaf = new Leaf(object);
            leaf.component = (ComponentWrapper)this.sourceTree.invoke(object, "createComponentWrapper", null);
            if (leaf.component != null) {
                this.setEnabled((Component)leaf.component.getComponent(), this.sourceTree.isEnabled(object));
                leaf.add((Component)leaf.component.getComponent(), null);
            }
            nodeBase = leaf;
        } else {
            nodeBase = new Node(object, object2 == this.root ? 0 : ((Node)object2).depth + 1);
        }
        nodeBase.setTree(this);
        return nodeBase;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        Container container = (Container)treePath.getLastPathComponent();
        LabelRenderer.LabelData labelData = this.getLayoutInfo((Container)container).renderer;
        if (labelData != null) {
            labelData.invalidate();
            labelData.revalidate();
        }
        if (container instanceof Leaf) {
            Leaf leaf = (Leaf)container;
            if (leaf.component != null) {
                this.sourceTree.invoke(leaf.source, "updateComponentWrapper", (Object)leaf.component);
                this.setEnabled((Component)leaf.component.getComponent(), this.sourceTree.isEnabled(leaf.source));
            }
        }
    }

    void createLabel(Container container) {
        LabelRenderer.LabelData labelData;
        Object object = this.getSourceOf(container);
        String string = (String)this.sourceTree.getDescription(object, "Name");
        IconSource iconSource = (IconSource)this.sourceTree.getDescription(object, "Icon");
        if (string == null && iconSource == null) {
            return;
        }
        LayoutInfo layoutInfo = this.getLayoutInfo(container);
        LabelRenderer labelRenderer = this.renderer;
        labelRenderer.getClass();
        layoutInfo.renderer = labelData = new LabelRenderer.LabelData(labelRenderer, layoutInfo);
        layoutInfo.label = this.getToolkit().createLabel(string, labelData, container instanceof Leaf ? 262144 : 65536);
        container.add(layoutInfo.label, 0);
        labelData.revalidate();
    }

    public void disposeNode(Object object) {
        if (object instanceof Leaf) {
            ((Leaf)object).component.dispose();
        }
    }

    public boolean isLeaf(Object object) {
        return object instanceof Leaf;
    }

    public boolean isImage(Object object, Object object2) {
        return this.isSourceRoot(object) ? this.root == object2 : ((NodeBase)object2).source == object;
    }

    protected Icon getButtonIcon(int n, boolean bl, boolean bl2) {
        return bl ? (bl2 ? ICON_EXPANDED_PRESSED : ICON_EXPANDED_NORMAL) : (bl2 ? ICON_COLLAPSED_PRESSED : ICON_COLLAPSED_NORMAL);
    }

    protected Icon getIcon(Object object, int n, boolean bl) {
        return IconAdapter.create((IconSource)((IconSource)this.sourceTree.getDescription(object, "Icon")), (Dimension)AWTToolkitBase.MENU_ICON_SIZE);
    }

    protected String getText(Object object, int n, boolean bl) {
        return (String)this.sourceTree.getDescription(object, "Name");
    }

    protected int getIconGap() {
        return 4;
    }

    protected int getLabelGap() {
        return 4;
    }

    protected int getPrefixComponentCount(Container container) {
        return this.getLayoutInfo((Container)container).label != null ? 1 : 0;
    }

    static final class Node
    extends NodeBase {
        boolean expanded = true;
        boolean pressed = false;
        int depth;
        Insets layoutInsets = new Insets(0, 0, 0, 0);
        int iconLeft;
        int iconRight;
        int iconBottom;
        private Object[] icons = new Object[4];
        private long releaseTime = 0L;

        Node(Object object, int n) {
            super(object);
            this.depth = n;
            this.enableEvents(48L);
            this.setExpanded(true);
        }

        public void setExpanded(boolean bl) {
            this.setBackground(bl ^ (this.depth & 1) == 1 ? color1 : color2);
            if (this.expanded != bl) {
                this.expanded = bl;
                int n = this.getComponentCount();
                for (int i = 1; i < n; ++i) {
                    this.getComponent(i).setVisible(bl);
                }
                AWTTree aWTTree = this.getTree();
                if (aWTTree != null) {
                    aWTTree.revalidate(this);
                }
            }
        }

        public void expandAndCollapseOthers() {
            Container container;
            Container container2 = this;
            AWTTree aWTTree = this.getTree();
            Container container3 = container = aWTTree != null ? aWTTree.root : null;
            Container container4;
            while ((container4 = container2.getParent()) != null) {
                int n = container4.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component component = container4.getComponent(i);
                    if (!(component instanceof Node)) continue;
                    ((Node)component).setExpanded(component == container2);
                }
                if (container4 == container) {
                    return;
                }
                container2 = container4;
            }
            return;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        private boolean isOverButton(MouseEvent mouseEvent) {
            return 0 <= mouseEvent.getX() && mouseEvent.getX() < this.iconRight && 0 <= mouseEvent.getY() && mouseEvent.getY() < this.iconBottom;
        }

        private void setPressed(boolean bl) {
            if (this.pressed != bl) {
                this.pressed = bl;
                AWTTree aWTTree = this.getTree();
                if (aWTTree != null) {
                    aWTTree.root.repaint();
                }
            }
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                case 501: {
                    if (!this.isOverButton(mouseEvent)) break;
                    this.setPressed(true);
                    break;
                }
                case 502: {
                    if (!this.pressed) break;
                    this.setPressed(false);
                    if (mouseEvent.getWhen() - this.releaseTime < 300L) {
                        this.expandAndCollapseOthers();
                    } else {
                        this.setExpanded(!this.expanded);
                    }
                    this.releaseTime = mouseEvent.getWhen();
                }
            }
        }

        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            this.setPressed(false);
        }

        Icon getButtonIcon() {
            int n = (this.expanded ? 1 : 0) | (this.pressed ? 2 : 0);
            Object object = this.icons[n];
            if (object == this) {
                return null;
            }
            if (object != null) {
                return (Icon)object;
            }
            AWTTree aWTTree = this.getTree();
            if (aWTTree == null) {
                return null;
            }
            object = aWTTree.getButtonIcon(this.depth, this.expanded, this.pressed);
            this.icons[n] = object == null ? this : object;
            return (Icon)object;
        }
    }

    static final class Leaf
    extends NodeBase {
        ComponentWrapper component;
        Rectangle compBounds = new Rectangle();

        Leaf(Object object) {
            super(object);
        }
    }

    static abstract class NodeBase
    extends Container {
        final Object source;
        final LayoutInfo layoutInfo = new LayoutInfo();

        NodeBase(Object object) {
            this.source = object;
        }

        void setTree(AWTTree aWTTree) {
            this.setLayout(aWTTree);
            aWTTree.createLabel(this);
        }

        AWTTree getTree() {
            return (AWTTree)this.getLayout();
        }
    }

    static class LayoutInfo
    extends Rectangle {
        int maxLabelWidth;
        Component label;
        LabelRenderer.LabelData renderer;
        Rectangle labelBounds = new Rectangle();

        LayoutInfo() {
        }
    }

    private static final class ButtonIcon
    implements Icon {
        private final int size;
        private final boolean pressed;
        private final boolean expanded;
        private final int[] arrowX = new int[5];
        private final int[] arrowY = new int[5];

        ButtonIcon(boolean bl, boolean bl2) {
            this.expanded = bl;
            this.pressed = bl2;
            this.size = 16;
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3;
            graphics.setColor(this.pressed ? Color.darkGray : Color.white);
            graphics.drawLine(n, n2 + this.size - 2, n, n2);
            graphics.drawLine(n + 1, n2, n + this.size - 1, n2);
            graphics.setColor(this.pressed ? Color.white : Color.darkGray);
            graphics.drawLine(n, n2 + this.size - 1, n + this.size - 1, n2 + this.size - 1);
            graphics.drawLine(n + this.size - 1, n2 + this.size - 2, n + this.size - 1, n2);
            n += this.size / 2 - 1;
            n2 += this.size / 2 - 1;
            if (this.pressed) {
                ++n;
                ++n2;
            }
            int n4 = 3;
            if (this.expanded) {
                this.arrowX[0] = n - n4;
                this.arrowY[0] = --n2 - 1;
                this.arrowX[1] = n - n4;
                this.arrowY[1] = n2;
                this.arrowX[2] = n;
                this.arrowY[2] = n2 + n4 + 1;
                this.arrowX[3] = n + n4 + 1;
                this.arrowY[3] = n2;
                this.arrowX[4] = n + n4 + 1;
                this.arrowY[4] = n2 - 1;
                n3 = 5;
            } else {
                this.arrowX[0] = n -= 2;
                this.arrowY[0] = n2 - n4 - 1;
                this.arrowX[1] = n + n4 + 2;
                this.arrowY[1] = n2;
                this.arrowX[2] = n;
                this.arrowY[2] = n2 + n4 + 1;
                n3 = 3;
            }
            graphics.setColor(component.getForeground());
            graphics.fillPolygon(this.arrowX, this.arrowY, n3);
        }
    }
}

