/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.awt;

import de.grogra.pf.ui.Synchronizer;
import de.grogra.util.Utils;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.util.WeakHashMap;

public class AWTSynchronizer
extends Synchronizer {
    public static final AWTSynchronizer QUEUE = new AWTSynchronizer(null);

    public AWTSynchronizer(Synchronizer.Callback callback) {
        super(callback);
    }

    protected boolean isDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    public void execute(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    protected void invokeAndWait(Runnable runnable) throws InvocationTargetException {
        Throwable throwable = Queue.get(Toolkit.getDefaultToolkit().getSystemEventQueue()).invokeAndWait(runnable);
        if (throwable != null) {
            throw new InvocationTargetException(throwable);
        }
    }

    public static void staticInvokeAndWait(Runnable runnable) {
        try {
            QUEUE.invokeAndWait(runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            Utils.rethrow((Throwable)invocationTargetException.getTargetException());
        }
    }

    public static void invokeInEventQueue(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            AWTSynchronizer.staticInvokeAndWait(runnable);
        }
    }

    private static final class Queue
    implements Runnable {
        private static final WeakHashMap queues = new WeakHashMap();
        private boolean running = false;
        private final Object postLock = new Object();
        private final Object doneLock = new Object();
        private Runnable nextRunnable = null;
        private Throwable exception;

        private Queue() {
        }

        static synchronized Queue get(EventQueue eventQueue) {
            Queue queue = (Queue)queues.get(eventQueue);
            if (queue == null) {
                queue = new Queue();
                queues.put(eventQueue, queue);
            }
            return queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized Throwable invokeAndWait(Runnable runnable) {
            try {
                Object object = this.doneLock;
                synchronized (object) {
                    Object object2 = this.postLock;
                    synchronized (object2) {
                        this.nextRunnable = runnable;
                        if (this.running) {
                            this.postLock.notifyAll();
                        } else {
                            EventQueue.invokeLater(this);
                        }
                    }
                    while (this.nextRunnable != null) {
                        try {
                            this.doneLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.interrupted();
                        }
                    }
                }
                object = this.exception;
                return object;
            }
            finally {
                this.exception = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.postLock;
            synchronized (object) {
                this.running = true;
                try {
                    while (this.nextRunnable != null) {
                        try {
                            this.exception = null;
                            this.nextRunnable.run();
                        }
                        catch (Throwable throwable) {
                            this.exception = throwable;
                        }
                        Object object2 = this.doneLock;
                        synchronized (object2) {
                            this.nextRunnable = null;
                            this.doneLock.notifyAll();
                        }
                        if (this.running) {
                            try {
                                this.postLock.wait(15L);
                            }
                            catch (InterruptedException interruptedException) {
                                this.running = false;
                            }
                            continue;
                        }
                        return;
                    }
                }
                finally {
                    this.running = false;
                }
            }
        }
    }
}

