/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.docking;

import de.grogra.docking.DockComponent;
import de.grogra.docking.DockContainer;
import de.grogra.docking.DockManager;
import de.grogra.docking.DockPosition;
import de.grogra.docking.DockPositionList;
import de.grogra.docking.DockableToolBar;
import de.grogra.docking.FixedSize;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JSplitPane;

public class DockSplitPane
extends JSplitPane
implements DockContainer,
FixedSize {
    private final DockManager manager;
    private int fixedSize = 0;
    private float propLocation = -1.0f;

    public DockSplitPane(DockManager dockManager, int n) {
        super(n);
        this.manager = dockManager;
        this.setContinuousLayout(false);
        this.setResizeWeight(0.5);
    }

    public int getDockComponentCount() {
        return this.leftComponent != null ? (this.rightComponent != null ? 2 : 1) : (this.rightComponent != null ? 1 : 0);
    }

    public DockComponent getDockComponent(int n) {
        return (DockComponent)((Object)(this.leftComponent != null ? (n == 0 ? this.leftComponent : this.rightComponent) : this.rightComponent));
    }

    public void findDockPositions(DockPositionList dockPositionList, Point point) {
        if (this.orientation == 1) {
            DockPosition.addDockPositions(dockPositionList, (DockComponent)((Object)this.leftComponent), 30, point, this, null);
            DockPosition.addDockPositions(dockPositionList, (DockComponent)((Object)this.rightComponent), 28, point, this, null);
        } else {
            DockPosition.addDockPositions(dockPositionList, (DockComponent)((Object)this.leftComponent), 27, point, this, null);
            DockPosition.addDockPositions(dockPositionList, (DockComponent)((Object)this.rightComponent), 19, point, this, null);
        }
    }

    public DockComponent remove(DockComponent dockComponent) {
        DockComponent dockComponent2 = (DockComponent)((Object)(dockComponent == this.leftComponent ? this.rightComponent : this.leftComponent));
        this.setLeftComponent(null);
        this.setRightComponent(null);
        DockContainer dockContainer = this.getDockParent();
        return dockContainer != null ? dockContainer.replace(this, dockComponent2) : dockComponent2;
    }

    public DockContainer getDockParent() {
        return DockManager.getDockParent(this);
    }

    public void add(int n, DockComponent dockComponent) {
        if (dockComponent instanceof DockableToolBar) {
            ((DockableToolBar)dockComponent).setOrientation(this.getOrientation() == 1 ? 1 : 0);
        }
        dockComponent = this.manager.wrap(dockComponent, true);
        if (n >= 0) {
            if ((n & 5) != 0) {
                if (this.getLeftComponent() != null) {
                    Component component = this.getLeftComponent();
                    this.setLeftComponent((Component)((Object)dockComponent));
                    this.setRightComponent(component);
                    return;
                }
            } else if ((n & 0xA) != 0 && this.getRightComponent() != null) {
                Component component = this.getRightComponent();
                this.setRightComponent((Component)((Object)dockComponent));
                this.setLeftComponent(component);
                return;
            }
        }
        this.add((Component)((Object)dockComponent), null);
    }

    public DockComponent replace(DockContainer dockContainer, DockComponent dockComponent) {
        dockComponent = this.manager.wrap(dockComponent, true);
        DockManager.replace0((Component)((Object)dockContainer), (Component)((Object)dockComponent));
        return dockComponent;
    }

    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        this.updateFixedSize();
    }

    private void updateFixedSize() {
        int n;
        int n2 = this.leftComponent instanceof FixedSize ? ((FixedSize)((Object)this.leftComponent)).getFixedSize() : 0;
        int n3 = n = this.rightComponent instanceof FixedSize ? ((FixedSize)((Object)this.rightComponent)).getFixedSize() : 0;
        if (n2 == n) {
            this.setResizeWeight(0.5);
        } else if ((n2 & 1) != 0 && this.orientation == 1 || (n2 & 2) != 0 && this.orientation == 0) {
            this.setResizeWeight(0.0);
        } else if ((n & 1) != 0 && this.orientation == 1 || (n & 2) != 0 && this.orientation == 0) {
            this.setResizeWeight(1.0);
        } else {
            this.setResizeWeight(0.5);
        }
        int n4 = n & n2;
        if (n4 != this.fixedSize) {
            this.fixedSize = n4;
            if (this.isValid()) {
                this.resetToPreferredSizes();
            }
            if (this.getParent() instanceof DockSplitPane) {
                ((DockSplitPane)this.getParent()).updateFixedSize();
            }
        }
    }

    public float getProportionalDividerLocation() {
        return (float)this.getDividerLocation() / (float)((this.getOrientation() == 0 ? this.getHeight() : this.getWidth()) - this.getDividerSize());
    }

    void setProportionalDividerLocation(float f) {
        this.propLocation = f;
        this.setDividerLocation(f);
    }

    void updateDividerLocation() {
        if (this.propLocation > 0.0f && this.getWidth() > 0 && this.getHeight() > 0) {
            this.setDividerLocation(this.propLocation);
            this.propLocation = -1.0f;
        }
    }

    public int getFixedSize() {
        return this.fixedSize;
    }

    public void toFront(DockComponent dockComponent) {
    }
}

