/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.docking;

import de.grogra.docking.DockComponent;
import de.grogra.docking.DockContainer;
import de.grogra.docking.DockManager;
import de.grogra.docking.DockPosition;
import de.grogra.docking.DockPositionList;
import de.grogra.docking.DockSplitPane;
import de.grogra.docking.DockableComponent;
import de.grogra.docking.FloatingWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Point;
import javax.swing.JPanel;

public class DockContentPane
extends JPanel
implements DockContainer,
Runnable {
    private DockManager manager;
    private FloatingWindow window;

    public DockContentPane() {
        this((FloatingWindow)null);
    }

    DockContentPane(FloatingWindow floatingWindow) {
        super(new GridLayout(1, 1));
        this.window = floatingWindow;
    }

    void setDockManager(DockManager dockManager) {
        this.manager = dockManager;
    }

    void windowChanged() {
        this.window = (FloatingWindow)this.getRootPane().getParent();
    }

    public DockManager getDockManager() {
        return this.manager;
    }

    public int getDockComponentCount() {
        return this.getComponentCount();
    }

    public DockComponent getDockComponent(int n) {
        return (DockComponent)((Object)this.getComponent(n));
    }

    public void findDockPositions(DockPositionList dockPositionList, Point point) {
        if (this.getComponentCount() > 0) {
            DockPosition.addDockPositions(dockPositionList, this.getDockComponent(0), 31, point, this, null);
        } else {
            DockPosition.addDockPositions(dockPositionList, this, 16, point, this, null);
        }
    }

    public DockComponent remove(DockComponent dockComponent) {
        this.remove(0);
        if (this.window != null) {
            this.window.dispose();
        } else {
            this.revalidate();
            this.repaint();
        }
        return this;
    }

    public void add(int n, DockComponent dockComponent) {
        if (this.getComponentCount() == 0) {
            dockComponent = this.manager.wrap(dockComponent, true);
            this.add((Component)((Object)dockComponent));
            if (dockComponent instanceof DockableComponent && this.window != null) {
                this.window.setTitle(((DockableComponent)dockComponent).getDockable().getPanelTitle());
            }
        } else {
            if (!(dockComponent instanceof DockableComponent)) {
                throw new IllegalArgumentException();
            }
            DockComponent dockComponent2 = this.getDockComponent(0);
            this.manager.addImpl(((DockableComponent)dockComponent).getDockable(), dockComponent2 instanceof DockSplitPane ? 2 : 16, dockComponent2);
        }
    }

    public DockComponent replace(DockContainer dockContainer, DockComponent dockComponent) {
        dockComponent = this.manager.wrap(dockComponent, true);
        DockManager.replace0((Component)((Object)dockContainer), (Component)((Object)dockComponent));
        return dockComponent;
    }

    public DockContainer getDockParent() {
        return DockManager.getDockParent(this);
    }

    public static DockContentPane get(Component component) {
        while (component != null) {
            if (component instanceof DockContentPane) {
                return (DockContentPane)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public void toFront(DockComponent dockComponent) {
    }

    protected void validateTree() {
        super.validateTree();
        EventQueue.invokeLater(this);
    }

    public void run() {
        DockContentPane.updateSplitPanes(this);
    }

    private static void updateSplitPanes(Container container) {
        if (container instanceof DockSplitPane) {
            ((DockSplitPane)container).updateDividerLocation();
        } else if (container instanceof DockableComponent) {
            return;
        }
        for (int i = container.getComponentCount() - 1; i >= 0; --i) {
            Component component = container.getComponent(i);
            if (!(component instanceof Container)) continue;
            DockContentPane.updateSplitPanes((Container)component);
        }
    }
}

