/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.expr.BreakTarget;
import de.grogra.xl.expr.ControlTransfer;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.vmx.AbruptCompletion;
import de.grogra.xl.vmx.VMXState;

public final class Return
extends ControlTransfer {
    private Expression expr;
    private final int iteratedType;
    private final MethodScope scope;
    private VMXState.Local result;

    public Return(MethodScope methodScope, Type type) {
        this.scope = methodScope;
        this.iteratedType = type == null ? 1 : type.getTypeId();
    }

    public final MethodScope getScope() {
        return this.scope;
    }

    protected AbruptCompletion evaluate(VMXState vMXState) {
        if (this.expr == null) {
            switch (this.iteratedType) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return vMXState.ireturn(0);
                }
                case 7: {
                    return vMXState.lreturn(0L);
                }
                case 8: {
                    return vMXState.freturn(0.0f);
                }
                case 9: {
                    return vMXState.dreturn(0.0);
                }
                case 0: {
                    return vMXState.areturn(null);
                }
                case 1: {
                    return vMXState.vreturn();
                }
            }
            throw new AssertionError();
        }
        return this.expr.evaluateRet(vMXState);
    }

    public void link(boolean bl) {
        this.expr = this.getFirstExpression();
        if (this.expr != null && this.expr.etype == 1) {
            throw new AssertionError();
        }
    }

    protected void writeLocal(BytecodeWriter bytecodeWriter, Expression expression) {
        if (this.expr != null) {
            this.result = this.getScope().getResultLocal();
            if (this.result != null) {
                bytecodeWriter.visitStore(this.result, this.expr.getType());
            }
        }
        expression.writeFinally(bytecodeWriter, -1, this);
    }

    protected void writeTransfer(BytecodeWriter bytecodeWriter, BreakTarget breakTarget) {
        if (this.expr == null) {
            bytecodeWriter.visitNull(this.iteratedType);
            bytecodeWriter.visitReturn(this.iteratedType);
        } else {
            if (this.result != null) {
                bytecodeWriter.visitLoad(this.result, this.expr.getType());
            }
            bytecodeWriter.visitReturn(this.expr.etype);
        }
    }

    protected void writeAbruptCompletion(BytecodeWriter bytecodeWriter) {
        int n;
        bytecodeWriter.visitVMX();
        if (this.expr == null) {
            n = this.iteratedType;
            bytecodeWriter.visitNull(n);
        } else {
            n = this.expr.etype;
            this.expr.write(bytecodeWriter, false);
        }
        bytecodeWriter.visitMethodInsn(VMX_TYPE, Reflection.getJVMPrefix((int)n) + "return");
    }
}

