/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.expr.Completable;
import de.grogra.xl.expr.EvalExpression;
import de.grogra.xl.vmx.VMXState;

public final class PopIntArray
extends EvalExpression
implements Completable {
    private final int length;

    public PopIntArray(int n) {
        super((Type)ClassAdapter.wrap(int[].class));
        this.length = n;
    }

    public void complete(MethodScope methodScope) {
        methodScope.createLocalForVMX();
    }

    protected Object evaluateObjectImpl(VMXState vMXState) {
        return vMXState.popIntArray(this.length).clone();
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        if (!bl) {
            bytecodeWriter.visitVMX();
            bytecodeWriter.visiticonst(this.length);
            bytecodeWriter.visitMethodInsn(VMX_TYPE, "popIntArray");
        }
    }
}

