/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.Type;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.expr.EvalExpression;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.vmx.VMXState;

public final class ExpressionList
extends EvalExpression {
    private Expression[] exprs;
    private final boolean returnFirst;

    public ExpressionList() {
        this.returnFirst = false;
    }

    public ExpressionList(Type type) {
        super(type);
        this.returnFirst = false;
    }

    public ExpressionList(Type type, boolean bl) {
        super(type);
        this.returnFirst = bl;
    }

    public boolean isRequired(int n) {
        return n == (this.returnFirst ? 0 : this.getExpressionCount() - 1);
    }

    protected boolean evaluateBooleanImpl(VMXState vMXState) {
        int n;
        int n2 = this.returnFirst ? 0 : this.exprs.length - 1;
        for (n = 0; n < n2; ++n) {
            this.exprs[n].evaluateAsVoid(vMXState);
        }
        n = this.exprs[n2].evaluateBoolean(vMXState) ? 1 : 0;
        for (int i = n2 + 1; i < this.exprs.length; ++i) {
            this.exprs[i].evaluateAsVoid(vMXState);
        }
        return n != 0;
    }

    protected byte evaluateByteImpl(VMXState vMXState) {
        int n;
        int n2 = this.returnFirst ? 0 : this.exprs.length - 1;
        for (n = 0; n < n2; ++n) {
            this.exprs[n].evaluateAsVoid(vMXState);
        }
        n = this.exprs[n2].evaluateByte(vMXState);
        for (int i = n2 + 1; i < this.exprs.length; ++i) {
            this.exprs[i].evaluateAsVoid(vMXState);
        }
        return (byte)n;
    }

    protected short evaluateShortImpl(VMXState vMXState) {
        int n;
        int n2 = this.returnFirst ? 0 : this.exprs.length - 1;
        for (n = 0; n < n2; ++n) {
            this.exprs[n].evaluateAsVoid(vMXState);
        }
        n = this.exprs[n2].evaluateShort(vMXState);
        for (int i = n2 + 1; i < this.exprs.length; ++i) {
            this.exprs[i].evaluateAsVoid(vMXState);
        }
        return (short)n;
    }

    protected char evaluateCharImpl(VMXState vMXState) {
        int n;
        int n2 = this.returnFirst ? 0 : this.exprs.length - 1;
        for (n = 0; n < n2; ++n) {
            this.exprs[n].evaluateAsVoid(vMXState);
        }
        n = this.exprs[n2].evaluateChar(vMXState);
        for (int i = n2 + 1; i < this.exprs.length; ++i) {
            this.exprs[i].evaluateAsVoid(vMXState);
        }
        return (char)n;
    }

    protected int evaluateIntImpl(VMXState vMXState) {
        int n;
        int n2 = this.returnFirst ? 0 : this.exprs.length - 1;
        for (n = 0; n < n2; ++n) {
            this.exprs[n].evaluateAsVoid(vMXState);
        }
        n = this.exprs[n2].evaluateInt(vMXState);
        for (int i = n2 + 1; i < this.exprs.length; ++i) {
            this.exprs[i].evaluateAsVoid(vMXState);
        }
        return n;
    }

    protected long evaluateLongImpl(VMXState vMXState) {
        int n = this.returnFirst ? 0 : this.exprs.length - 1;
        for (int i = 0; i < n; ++i) {
            this.exprs[i].evaluateAsVoid(vMXState);
        }
        long l = this.exprs[n].evaluateLong(vMXState);
        for (int i = n + 1; i < this.exprs.length; ++i) {
            this.exprs[i].evaluateAsVoid(vMXState);
        }
        return l;
    }

    protected float evaluateFloatImpl(VMXState vMXState) {
        int n = this.returnFirst ? 0 : this.exprs.length - 1;
        for (int i = 0; i < n; ++i) {
            this.exprs[i].evaluateAsVoid(vMXState);
        }
        float f = this.exprs[n].evaluateFloat(vMXState);
        for (int i = n + 1; i < this.exprs.length; ++i) {
            this.exprs[i].evaluateAsVoid(vMXState);
        }
        return f;
    }

    protected double evaluateDoubleImpl(VMXState vMXState) {
        int n = this.returnFirst ? 0 : this.exprs.length - 1;
        for (int i = 0; i < n; ++i) {
            this.exprs[i].evaluateAsVoid(vMXState);
        }
        double d = this.exprs[n].evaluateDouble(vMXState);
        for (int i = n + 1; i < this.exprs.length; ++i) {
            this.exprs[i].evaluateAsVoid(vMXState);
        }
        return d;
    }

    protected Object evaluateObjectImpl(VMXState vMXState) {
        int n = this.returnFirst ? 0 : this.exprs.length - 1;
        for (int i = 0; i < n; ++i) {
            this.exprs[i].evaluateAsVoid(vMXState);
        }
        Object object = this.exprs[n].evaluateObject(vMXState);
        for (int i = n + 1; i < this.exprs.length; ++i) {
            this.exprs[i].evaluateAsVoid(vMXState);
        }
        return object;
    }

    protected void evaluateVoidImpl(VMXState vMXState) {
        int n;
        int n2 = this.returnFirst ? 0 : this.exprs.length - 1;
        for (n = 0; n < n2; ++n) {
            this.exprs[n].evaluateAsVoid(vMXState);
        }
        this.exprs[n2].evaluateAsVoid(vMXState);
        for (n = n2 + 1; n < this.exprs.length; ++n) {
            this.exprs[n].evaluateAsVoid(vMXState);
        }
    }

    public void link(boolean bl) {
        this.exprs = new Expression[this.getExpressionCount()];
        for (int i = 0; i < this.exprs.length; ++i) {
            this.exprs[i] = this.getExpression(i);
        }
    }

    protected void writeOperator(BytecodeWriter bytecodeWriter) {
    }

    protected String paramString() {
        return super.paramString() + ",returnFirst=" + this.returnFirst;
    }
}

