/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.expr.ControlTransfer;
import de.grogra.xl.expr.VoidExpression;
import de.grogra.xl.vmx.AbruptCompletion;
import de.grogra.xl.vmx.VMXState;
import org.objectweb.asm.Label;

public abstract class BreakTarget
extends VoidExpression {
    private int label = -1;
    private Label bcLabel = null;

    public boolean isInitialized() {
        return this.label >= 0;
    }

    public void initialize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.label = n;
    }

    public int getLabel() {
        return this.label;
    }

    public Label getBytecodeLabel() {
        assert (this.label >= 0);
        if (this.bcLabel == null) {
            this.bcLabel = new Label();
        }
        return this.bcLabel;
    }

    protected final void evaluateVoidImpl(VMXState vMXState) {
        if (this.label >= 0) {
            try {
                this.evaluate(vMXState);
            }
            catch (AbruptCompletion.Break break_) {
                if (break_.getLabel() == this.label) {
                    break_.dispose();
                }
                throw break_;
            }
        } else {
            this.evaluate(vMXState);
        }
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        assert (bl) : this;
        this.writeOperator(bytecodeWriter);
        if (this.bcLabel != null) {
            bytecodeWriter.visitLabel(this.bcLabel);
        }
    }

    public void writeFinally(BytecodeWriter bytecodeWriter, int n, ControlTransfer controlTransfer) {
        if (n >= 0 && n == this.label) {
            controlTransfer.writeTransfer(bytecodeWriter, this);
        } else {
            super.writeFinally(bytecodeWriter, n, controlTransfer);
        }
    }

    protected abstract void evaluate(VMXState var1);

    protected String paramString() {
        return super.paramString() + ",label=" + this.label;
    }
}

