/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.Type;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.expr.Constant;
import de.grogra.xl.expr.EvalExpression;
import de.grogra.xl.vmx.VMXState;
import org.objectweb.asm.Label;

public class BooleanConst
extends EvalExpression
implements Constant {
    public boolean value;

    public BooleanConst() {
        super(Type.BOOLEAN);
    }

    public BooleanConst(boolean bl) {
        this();
        this.value = bl;
    }

    protected boolean evaluateBooleanImpl(VMXState vMXState) {
        return this.value;
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        if (!bl) {
            bytecodeWriter.visiticonst(this.value ? 1 : 0);
        }
    }

    public boolean isConditional() {
        return true;
    }

    public int writeConditional(BytecodeWriter bytecodeWriter, Label label, Label label2) {
        if (label2 != null && this.value) {
            bytecodeWriter.visitJumpInsn(167, label2);
        } else if (label != null && !this.value) {
            bytecodeWriter.visitJumpInsn(167, label);
        }
        return this.value ? 1 : -1;
    }
}

