/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler.scope;

import antlr.collections.AST;
import de.grogra.reflect.Field;
import de.grogra.reflect.Lookup;
import de.grogra.reflect.Member;
import de.grogra.reflect.Method;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.reflect.XField;
import de.grogra.xl.compiler.CClass;
import de.grogra.xl.compiler.Compiler;
import de.grogra.xl.compiler.InheritedField;
import de.grogra.xl.compiler.InheritedMethod;
import de.grogra.xl.compiler.ShiftedMethod;
import de.grogra.xl.compiler.pattern.PatternWrapper;
import de.grogra.xl.compiler.scope.ClassPath;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.compiler.scope.Members;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.compiler.scope.Scope;
import de.grogra.xl.expr.Invoke;
import de.grogra.xl.query.UserDefinedPattern;
import de.grogra.xl.util.ObjectList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeScope
extends Scope {
    final CClass type;
    public final MethodScope instanceInit;
    public final MethodScope staticInit;
    private final Compiler compiler;
    public final XField enclosingInstance;
    private long modifiersHi;
    private final HashMap astForFields = new HashMap();
    private final ObjectList methodScopes = new ObjectList();
    private final ObjectList constructorScopes = new ObjectList();
    private final ObjectList constrInvocations = new ObjectList();
    private final ObjectList<Local> enclosingLocals = new ObjectList();
    private final HashMap fieldsForLocals = new HashMap();
    private int nextId;
    private Field assertionsDisabled;
    private final AST node;

    public int nextLocalClassId() {
        return this.nextId++;
    }

    public static TypeScope get(Scope scope) {
        while (!(scope instanceof TypeScope)) {
            if (scope == null) {
                return null;
            }
            scope = scope.getEnclosingScope();
        }
        return (TypeScope)scope;
    }

    public static TypeScope getNonlocal(Scope scope) {
        TypeScope typeScope = null;
        while (scope != null) {
            if (scope instanceof TypeScope) {
                if ((((TypeScope)scope).type.getModifiers() & 0x80000) != 0) {
                    typeScope = null;
                } else if (typeScope == null) {
                    typeScope = (TypeScope)scope;
                }
            }
            scope = scope.getEnclosingScope();
        }
        return typeScope;
    }

    public TypeScope(Scope scope, CClass cClass, long l, Compiler compiler, AST aST) {
        super(scope);
        this.node = aST;
        this.compiler = compiler;
        this.modifiersHi = l;
        this.type = cClass;
        this.staticInit = this.createMethodScope(0x2000000008L);
        this.staticInit.createAndDeclareMethod("<clinit>", Type.VOID);
        TypeScope typeScope = TypeScope.get(scope);
        XField xField = this.enclosingInstance = typeScope != null && !Reflection.isStatic((Member)cClass) ? cClass.declareField("this$0", 4112, (Type)typeScope.getDeclaredType()) : null;
        if ((cClass.getModifiers() & 0x200) == 0) {
            this.instanceInit = this.createMethodScope(0x2000001012L);
            this.instanceInit.createAndDeclareMethod("this", Type.VOID);
        } else {
            this.instanceInit = null;
        }
    }

    public AST getAST() {
        return this.node;
    }

    @Override
    public Compiler getCompiler() {
        return this.compiler;
    }

    public MethodScope createMethodScope(long l) {
        MethodScope methodScope = new MethodScope(this, l);
        if (methodScope.isConstructor()) {
            this.constructorScopes.add((Object)methodScope);
        }
        TypeScope.getNonlocal((Scope)this).methodScopes.add((Object)methodScope);
        return methodScope;
    }

    public long getModifiersEx() {
        return (long)this.type.getModifiers() | this.modifiersHi & 0xFFFFFFFF00000000L;
    }

    public Field getAssertionsDisabledField() {
        if (this.assertionsDisabled == null) {
            this.assertionsDisabled = this.type.declareAuxField("$assertionsDisabled", 24, Type.BOOLEAN);
        }
        return this.assertionsDisabled;
    }

    public boolean hasAssertionsDisabledField() {
        return this.assertionsDisabled != null;
    }

    public Field getFieldForEnclosingLocal(Local local) {
        Field field = (Field)this.fieldsForLocals.get(local);
        if (field == null) {
            assert (!this.isNonlocal());
            TypeScope typeScope = TypeScope.get(this.getEnclosingScope());
            if (local.getScope().encloses(typeScope)) {
                field = typeScope.getFieldForEnclosingLocal(local);
            } else {
                field = this.getDeclaredType().declareField("val$" + local.getName(), 16, local.getType());
                this.fieldsForLocals.put(local, field);
                this.enclosingLocals.add((Object)local);
            }
        }
        return field;
    }

    public ObjectList<Local> getEnclosingLocals() {
        return this.enclosingLocals;
    }

    public ObjectList getConstructorScopes() {
        return this.constructorScopes;
    }

    public ObjectList getAllContainedMethodScopes() {
        return this.methodScopes;
    }

    public void setInstantiatorModule() {
        this.modifiersHi |= 0x8000000000L;
    }

    @Override
    public CClass getDeclaredType() {
        return this.type;
    }

    @Override
    public Member getDeclaredEntity() {
        return this.type;
    }

    @Override
    public boolean isStatic() {
        return this.enclosingInstance == null;
    }

    public boolean isNonlocal() {
        return TypeScope.getNonlocal(this) == this;
    }

    public void addIncompleteConstructorInvocation(Invoke invoke) {
        this.constrInvocations.add((Object)invoke);
    }

    public ObjectList getIncompleteConstructorInvocations() {
        return this.constrInvocations;
    }

    public void setASTOfDeclaration(Field field, AST aST) {
        this.astForFields.put(field, aST);
    }

    public AST getASTOfDeclaration(Field field) {
        return (AST)this.astForFields.get(field);
    }

    @Override
    public void findMembers(String string, int n, Members members) {
        TypeScope.findMembers((Type)this.type, null, string, n, members, this);
        super.findMembers(string, n, members);
    }

    static void addTypeOrPatterns(Type type, Members members, Scope scope, int n) {
        if (type == null) {
            return;
        }
        if (!type.getPackage().equals(members.getPackage())) {
            n |= 0x80000;
        }
        if ((n & 0x20) != 0) {
            members.add((Member)type, scope, n);
        }
        if ((n & 4) != 0) {
            TypeScope.addPattern(type, type, members, scope, n);
            for (int i = type.getDeclaredTypeCount() - 1; i >= 0; --i) {
                TypeScope.addPattern(type.getDeclaredType(i), type, members, scope, n);
            }
        }
    }

    private static void addPattern(Type type, Type type2, Members members, Scope scope, int n) {
        if (Reflection.isAbstract((Member)type) || !Reflection.isSuperclassOrSame(UserDefinedPattern.class, (Type)type)) {
            return;
        }
        try {
            type = ClassPath.get(members.getContextScope()).typeForType(type);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Method method = UserDefinedPattern.findSignatureMethod((Type)type);
        if (method == null) {
            return;
        }
        int[] nArray = new int[2];
        Type[] typeArray = UserDefinedPattern.getSignature((Method)method, (int[])nArray);
        if (typeArray == null) {
            return;
        }
        members.add(new PatternWrapper(type, type2, typeArray, nArray[0], nArray[1]), scope, n);
    }

    static void findMembers(Type type, Type type2, String string, int n, Members members, Scope scope) {
        if ((n & 0x2000) != 0) {
            n &= 0xFFFFDFFF;
            type = type.getSupertype();
        }
        if (type2 == null) {
            type2 = type;
        }
        while (type != null) {
            Object object;
            if (!type.getPackage().equals(members.getPackage())) {
                n |= 0x80000;
            }
            Lookup lookup = type.getLookup();
            if ((n & 2) != 0 && (object = lookup.getField(string)) != null) {
                if (type != type2) {
                    object = new InheritedField((Field)object, type2);
                }
                members.add((Member)object, scope, n);
            }
            if ((n & 0x18) != 0) {
                for (object = lookup.getMethods(string); object != null; object = object.next()) {
                    Method method = (Method)object.getValue();
                    if (type != type2) {
                        method = new InheritedMethod(method, type2);
                    }
                    if ((n & 0x40000) != 0) {
                        if (Reflection.isStatic((Member)method)) continue;
                        method = new ShiftedMethod(method);
                    }
                    members.add((Member)method, scope, n);
                }
                if ((n & 0x10) != 0) {
                    n &= 0xFFFFFFEF;
                }
            }
            TypeScope.addTypeOrPatterns(lookup.getType(string), members, scope, n);
            if ((n & 0x800) != 0) {
                return;
            }
            if ((n & 0x80) == 0) {
                for (int i = type.getDeclaredInterfaceCount() - 1; i >= 0; --i) {
                    TypeScope.findMembers(type.getDeclaredInterface(i), type2, string, n, members, scope);
                }
            }
            type = type.getSupertype();
        }
    }

    public String toString() {
        return "TypeScope[" + this.type + ']';
    }
}

