/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler.pattern;

import antlr.collections.AST;
import de.grogra.reflect.IntersectionType;
import de.grogra.reflect.Type;
import de.grogra.xl.compiler.pattern.Argument;
import de.grogra.xl.compiler.pattern.Component;
import de.grogra.xl.compiler.pattern.PatternBuilder;
import de.grogra.xl.compiler.pattern.PatternData;
import de.grogra.xl.compiler.pattern.SimplePatternData;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.query.NumericConversionPattern;
import de.grogra.xl.query.Pattern;
import de.grogra.xl.query.WrappedTypePattern;
import de.grogra.xl.util.ObjectList;

public final class Place
extends Component {
    final ObjectList<Mapping> mappings = new ObjectList();
    final Local label;
    final ObjectList<Local> foldings = new ObjectList();
    final ObjectList<Place> placeFoldings = new ObjectList();
    private final int placeId;
    private PatternBuilder builder;
    private boolean node = false;
    private boolean notContext = false;
    private boolean hasContext = false;
    private Type firstType;
    private Local wrapperLocal;
    private Argument nodeArg;
    private Place replacement;

    Place(Local local, PatternBuilder patternBuilder) {
        super(patternBuilder.problems);
        this.builder = patternBuilder;
        this.label = local;
        this.placeId = patternBuilder.nextPlaceId();
    }

    PatternBuilder getBuilder() {
        return this.builder;
    }

    void setParentBuilder() {
        this.builder = this.builder.enclosing;
    }

    public void setNode(boolean bl, boolean bl2, AST aST) {
        this.notContext |= bl;
        this.hasContext |= bl2;
        if (this.node) {
            return;
        }
        this.node = true;
        if (this.label != null && this.builder.getModel().needsWrapperFor(this.firstType)) {
            this.wrapperLocal = this.label.getPatternBuilder().declareWrapper(this.label, this.builder.compiler.getWrapperTypeFor(this.firstType, this.builder.getModel(), aST), aST);
        }
    }

    public Mapping map(PatternData patternData, int n, AST aST) {
        Place place = patternData.getPlaces()[n];
        if (place == null) {
            Mapping mapping = new Mapping(patternData, n);
            patternData.getPlaces()[n] = this;
            this.mappings.add((Object)mapping);
            if (this.firstType == null) {
                this.firstType = mapping.getType();
            }
            return mapping;
        }
        if (place.label == null) {
            this.receive(place, aST);
            return this.getMapping(patternData, n);
        }
        this.problems.addSemanticError(I18N.msg("compiler.duplicate-place-label", (Object)place.label.getName()), aST);
        return null;
    }

    private void receive(Place place, AST aST) {
        assert (place.label == null);
        for (int i = 0; i < place.mappings.size(); ++i) {
            Mapping mapping = (Mapping)place.mappings.get(i);
            mapping.pred.getPlaces()[mapping.index] = null;
            this.map(mapping.pred, mapping.index, null);
        }
        place.mappings.clear();
        if (place.node) {
            this.setNode(place.notContext, place.hasContext, aST);
        }
        place.replacement = this;
    }

    public Place resolve() {
        Place place = this;
        while (place.replacement != null) {
            place = place.replacement;
        }
        return place;
    }

    public void merge(Place place, AST aST) {
        if (this.label == null) {
            place.receive(this, aST);
        } else if (place.label == null) {
            this.receive(place, aST);
        } else {
            this.problems.addSemanticError(I18N, "compiler.conflicting-join-terms", aST);
        }
    }

    private Local getVariable(Type type, boolean bl) {
        if (this.label != null) {
            int n = this.label.getType().getTypeId();
            int n2 = type.getTypeId();
            if (n == 0 ? n2 == 0 && (!bl || this.builder.getModel().needsWrapperFor(type)) : n == n2 || ((1 << n | 1 << n2) & 0xFFFFFF87) == 0) {
                return this.label;
            }
        }
        return this.builder.declareAuxVariable(type);
    }

    void mapToArguments() {
        Object object;
        boolean bl;
        int n = this.mappings.size();
        if (n == 0) {
            return;
        }
        Object object2 = null;
        Argument argument = null;
        SimplePatternData simplePatternData = null;
        boolean bl2 = bl = !this.notContext && this.hasContext;
        if (bl) {
            this.builder.beginContext(null);
        }
        if (this.node) {
            for (int i = 0; i < n; ++i) {
                object = (Mapping)this.mappings.get(i);
                if (!this.builder.getModel().needsWrapperFor(((Mapping)object).getType())) continue;
                if (this.wrapperLocal == null) {
                    this.wrapperLocal = this.builder.declareAuxVariable(this.builder.compiler.getWrapperTypeFor(((Mapping)object).getType(), this.builder.getModel(), ((Mapping)object).pred.pos));
                }
                object2 = new Argument(this, this.wrapperLocal);
                argument = new Argument(this, this.getVariable(((Mapping)object).getType(), true));
                simplePatternData = new SimplePatternData(null, (Pattern)new WrappedTypePattern(this.wrapperLocal.getType(), ((Mapping)object).getType()), null, 0, 0, 0, 0, ((Mapping)object).pred.pos, -1, -1, this.builder);
                this.builder.add(simplePatternData, false);
                this.map(simplePatternData, 0, ((Mapping)object).pred.pos).initParam((Argument)object2);
                this.map(simplePatternData, 1, ((Mapping)object).pred.pos).initParam(argument);
                break;
            }
        }
        AST aST = null;
        object = null;
        Object object3 = null;
        Object object4 = null;
        Object object5 = null;
        Object object6 = null;
        Object object7 = null;
        for (int i = 0; i < n; ++i) {
            Mapping mapping = (Mapping)this.mappings.get(i);
            aST = mapping.pred.pos;
            Object object8 = null;
            int n2 = mapping.getType().getTypeId();
            switch (n2) {
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    object8 = object4;
                    break;
                }
                case 7: {
                    object8 = object5;
                    break;
                }
                case 8: {
                    object8 = object6;
                    break;
                }
                case 9: {
                    object8 = object7;
                }
            }
            if (object8 == null) {
                if (object3 != null && (1 << n2 & 0x3F8) != 0) {
                    object8 = new Argument(this, this.getVariable(mapping.getType(), object2 != null));
                    SimplePatternData simplePatternData2 = new SimplePatternData(null, (Pattern)new NumericConversionPattern(((Argument)object3).getType(), ((Argument)object8).getType()), null, -1, -1, 0, 0, aST, -1, -1, this.builder);
                    this.builder.add(simplePatternData2, false);
                    this.map(simplePatternData2, 0, aST).initParam((Argument)object3);
                    this.map(simplePatternData2, 1, aST).initParam((Argument)object8);
                } else if (object2 != null) {
                    if ((1 << n2 & 0x3F8) != 0) {
                        this.intersectType(argument, mapping.getType(), aST);
                        object3 = object8 = argument;
                    } else if (this.builder.getModel().needsWrapperFor(mapping.getType())) {
                        this.intersectType(argument, mapping.getType(), aST);
                        this.intersectType((Argument)object2, this.builder.compiler.getWrapperTypeFor(mapping.getType(), this.builder.getModel(), aST), aST);
                        object8 = argument;
                    } else {
                        this.intersectType((Argument)object2, mapping.getType(), aST);
                        object8 = object2;
                    }
                } else {
                    if (object == null) {
                        object = new Argument(this, this.getVariable(mapping.getType(), false));
                    } else {
                        this.intersectType((Argument)object, mapping.getType(), aST);
                    }
                    object8 = object;
                    if ((1 << n2 & 0x3F8) != 0) {
                        object3 = object8;
                    }
                }
                switch (mapping.getType().getTypeId()) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        object4 = object8;
                        break;
                    }
                    case 7: {
                        object5 = object8;
                        break;
                    }
                    case 8: {
                        object6 = object8;
                        break;
                    }
                    case 9: {
                        object7 = object8;
                    }
                }
            }
            mapping.initParam((Argument)object8);
            if (object2 == null || object8 == object2) continue;
            mapping.pred.addDependency(simplePatternData);
        }
        Object object9 = this.nodeArg = object2 != null ? object2 : object;
        if (this.node) {
            this.nodeArg.node = true;
            this.nodeArg.context = bl;
            this.intersectType(this.nodeArg, this.builder.getModel().getNodeType(), aST);
        }
        if (bl) {
            this.builder.endContext(null);
        }
    }

    private void intersectType(Argument argument, Type type, AST aST) {
        if (argument.getType().getTypeId() == 0) {
            this.builder.compiler.intersect((IntersectionType)argument.getType(), type, aST);
        } else {
            int n;
            int n2 = 1 << argument.getType().getTypeId();
            if (n2 != (n = 1 << type.getTypeId()) && ((n2 | n) & 0xFFFFFF87) != 0) {
                this.problems.addSemanticError(I18N.msg("compiler.incompatible-types", (Object)argument.getType().getName(), (Object)type.getName()), aST);
            }
        }
    }

    public Mapping getMapping(PatternData patternData, int n) {
        for (int i = 0; i < this.mappings.size(); ++i) {
            Mapping mapping = (Mapping)this.mappings.get(i);
            if (mapping.pred != patternData || mapping.index != n) continue;
            return mapping;
        }
        return null;
    }

    void getArguments(ObjectList objectList) {
        for (int i = 0; i < this.mappings.size(); ++i) {
            objectList.addIfNotContained((Object)((Mapping)this.mappings.get(i)).arg);
        }
    }

    Argument getArgument(int n) {
        for (int i = 0; i < this.mappings.size(); ++i) {
            Argument argument = ((Mapping)this.mappings.get(i)).arg;
            if (argument.getType().getTypeId() != n) continue;
            return argument;
        }
        return null;
    }

    public Argument getNodeArgument() {
        return this.nodeArg;
    }

    public String toString() {
        return "Place " + this.placeId;
    }

    public static final class Mapping {
        public final PatternData pred;
        public final int index;
        private Argument arg;

        Mapping(PatternData patternData, int n) {
            this.pred = patternData;
            this.index = n;
        }

        Place getPlace() {
            return this.pred.getPlaces()[this.index];
        }

        void initParam(Argument argument) {
            assert (this.arg == null);
            argument.getClass();
            this.arg = argument;
        }

        public Type getType() {
            return this.pred.getPattern().getParameterType(this.index);
        }

        public Argument getArgument() {
            return this.arg;
        }
    }
}

