/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler.pattern;

import de.grogra.reflect.Annotation;
import de.grogra.reflect.Member;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Signature;
import de.grogra.reflect.Type;
import de.grogra.xl.query.BytecodeSerialization;
import de.grogra.xl.query.Graph;
import de.grogra.xl.query.Pattern;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.XBitSet;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public final class PatternWrapper
extends Pattern
implements Member,
Signature {
    private final int inParameter;
    private final int outParameter;
    private final Type predType;
    private final Type nameType;
    private final String descr;
    private transient Pattern predicate;

    public PatternWrapper(Type type, Type type2, Type[] typeArray, int n, int n2) {
        super(typeArray, typeArray.length);
        this.inParameter = n;
        this.outParameter = n2;
        this.predType = type;
        this.nameType = type2;
        this.descr = 'p' + type.getBinaryName() + ';';
    }

    public void write(BytecodeSerialization bytecodeSerialization) throws IOException {
        bytecodeSerialization.beginMethod(Reflection.getDeclaredMethod((Type)this.predType, (String)"m<init>;()V"));
        bytecodeSerialization.endMethod();
    }

    private synchronized Pattern getPattern() {
        if (this.predicate == null) {
            try {
                this.predicate = (Pattern)this.predType.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                throw new AssertionError((Object)instantiationException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AssertionError((Object)invocationTargetException.getCause());
            }
        }
        return this.predicate;
    }

    public Type getPatternType() {
        return this.predType;
    }

    public boolean isFirstInOut() {
        return this.inParameter == 0 && this.outParameter == 0;
    }

    public int getInParameter() {
        return this.inParameter;
    }

    public int getOutParameter() {
        return this.outParameter;
    }

    public Pattern.Matcher createMatcher(Graph graph, XBitSet xBitSet, IntList intList) {
        return this.getPattern().createMatcher(graph, xBitSet, intList);
    }

    public int getParameterKind(int n) {
        return this.getPattern().getParameterKind(n);
    }

    public boolean isDeleting() {
        return this.getPattern().isDeleting();
    }

    public int getModifiers() {
        return this.predType.getModifiers();
    }

    public Type getDeclaringType() {
        return this.nameType.getDeclaringType();
    }

    public String getName() {
        return this.nameType.getName();
    }

    public String getSimpleName() {
        return this.nameType.getSimpleName();
    }

    public String getDescriptor() {
        return this.descr;
    }

    public int getDeclaredAnnotationCount() {
        return this.predType.getDeclaredAnnotationCount();
    }

    public Annotation getDeclaredAnnotation(int n) {
        return this.predType.getDeclaredAnnotation(n);
    }
}

