/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler;

import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Field;
import de.grogra.reflect.IntersectionType;
import de.grogra.reflect.Member;
import de.grogra.reflect.Method;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.reflect.XField;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.CClass;
import de.grogra.xl.compiler.XMethod;
import de.grogra.xl.query.BytecodeSerialization;
import de.grogra.xl.query.Utils;
import de.grogra.xl.util.ObjectList;
import de.grogra.xl.vmx.Routine;
import de.grogra.xl.vmx.SerializationWithRoutine;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

final class Serialization
implements SerializationWithRoutine {
    private static final Method READ_OBJECT = Reflection.getDeclaredMethod((Type)ClassAdapter.wrap(ObjectInputStream.class), (String)"readObject");
    private static final Type UTILS = ClassAdapter.wrap(Utils.class);
    private static final Type ISECT_TYPE = ClassAdapter.wrap(IntersectionType.class);
    private final BytecodeWriter out;
    private final XField serialized;
    private final ObjectList stack = new ObjectList();
    private final int streamIndex;
    private final ObjectOutputStream objectOut;
    private final ByteArrayOutputStream objectOutBytes;
    private boolean array = false;
    private Type componentType = null;
    private int index = 0;
    private Method method = null;

    Serialization(CClass cClass, BytecodeWriter bytecodeWriter, int n, int n2) throws IOException {
        this.out = bytecodeWriter;
        this.serialized = cClass.declareAuxField("serialized", 4120, Type.STRING);
        this.objectOutBytes = new ByteArrayOutputStream();
        this.objectOut = new ObjectOutputStream(this.objectOutBytes);
        bytecodeWriter.visitFieldInsn(178, (Field)this.serialized, null);
        bytecodeWriter.visitVarInsn(25, n);
        bytecodeWriter.visitMethodInsn(Reflection.getDeclaredMethod((Type)UTILS, (String)"getObjectInput"));
        this.streamIndex = n2;
        bytecodeWriter.visitVarInsn(58, this.streamIndex);
    }

    private void push() {
        this.stack.push((Object)(this.array ? this : null)).push((Object)this.componentType).push((Object)this.index).push((Object)this.method);
    }

    private void pop() {
        this.method = (Method)this.stack.pop();
        this.index = (Integer)this.stack.pop();
        this.componentType = (Type)this.stack.pop();
        this.array = this.stack.pop() != null;
    }

    public void visitBoolean(boolean bl) {
        this.out.visiticonst(bl ? 1 : 0);
    }

    public void visitByte(byte by) {
        this.out.visiticonst(by);
    }

    public void visitShort(short s) {
        this.out.visiticonst(s);
    }

    public void visitChar(char c) {
        this.out.visiticonst(c);
    }

    public void visitInt(int n) {
        this.out.visiticonst(n);
    }

    public void visitLong(long l) {
        this.out.visitlconst(l);
    }

    public void visitFloat(float f) {
        this.out.visitfconst(f);
    }

    public void visitDouble(double d) {
        this.out.visitdconst(d);
    }

    public void visitObject(Object object) throws IOException {
        if (object == null || object instanceof String) {
            this.out.visitaconst(object);
        } else if (object instanceof BytecodeSerialization.Serializable) {
            ((BytecodeSerialization.Serializable)object).write((BytecodeSerialization)this);
        } else {
            this.objectOut.writeObject(object);
            this.out.visitVarInsn(25, this.streamIndex);
            this.out.visitMethodInsn(READ_OBJECT);
        }
    }

    public void visitClass(Type type) {
        this.out.visitaconst(type);
    }

    public void visitType(Type type) {
        if (type instanceof IntersectionType) {
            type = ((IntersectionType)type).simplify();
        }
        if (type instanceof IntersectionType) {
            IntersectionType intersectionType = (IntersectionType)type;
            this.out.visitTypeInsn(187, ISECT_TYPE);
            this.out.visitInsn(89);
            this.visitType(type.getSupertype());
            this.out.visitMethodInsn(ISECT_TYPE, "<init>", "(Lde/grogra/reflect/Type;)V");
            for (int i = 0; i < intersectionType.getDeclaredInterfaceCount(); ++i) {
                this.out.visitInsn(89);
                this.visitType(intersectionType.getDeclaredInterface(i));
                this.out.visitMethodInsn(ISECT_TYPE, "addInterface");
            }
        } else if (Reflection.isPrimitiveOrVoid((Type)type)) {
            this.out.visitFieldInsn(178, Type.class, type.getBinaryName().toUpperCase(), Type.TYPE.getDescriptor());
        } else {
            this.out.visitInsn(3);
            this.out.visitNewArray(type);
            this.out.visitMethodInsn(UTILS, "toClassAdapter");
        }
    }

    public void beginArray(int n, Type type) {
        this.push();
        this.array = true;
        this.index = 0;
        this.componentType = type;
        this.out.visiticonst(n);
        this.out.visitNewArray(type);
    }

    public void beginArrayComponent(int n) {
        this.out.visitInsn(89);
        this.out.visiticonst(n);
    }

    public void endArrayComponent() {
        this.out.visitAStore(this.componentType.getTypeId());
    }

    public void endArray() {
        this.pop();
    }

    public void beginMethod(Method method) {
        this.push();
        this.array = false;
        this.method = method;
        if (method.getSimpleName().equals("<init>")) {
            this.out.visitTypeInsn(187, method.getDeclaringType());
            this.out.visitInsn(89);
        }
    }

    public void endMethod() throws IOException {
        this.out.visitMethodInsn(this.method);
        this.pop();
    }

    public void visitField(Field field) {
        this.out.visitFieldInsn(Reflection.isStatic((Member)field) ? 178 : 180, field, null);
    }

    public void visitRoutine(Routine routine) {
        this.visitField(((XMethod)routine).getRoutineField());
    }

    public void flush() throws IOException {
        this.objectOut.flush();
        this.objectOut.close();
        this.serialized.setConstant((Object)Utils.toString((byte[])this.objectOutBytes.toByteArray()));
    }
}

