/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.greenlab.conf;

import de.grogra.pf.io.FileSource;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.ui.Context;
import de.grogra.vfs.MemoryFileSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GreenLabPropertyFileReader {
    private HashMap<String, String> backup = null;
    private HashMap<String, String> properties = null;
    private File inFile = null;
    private Context ctx = null;
    private static GreenLabPropertyFileReader greenLabPropertyFileReader;

    public static synchronized GreenLabPropertyFileReader get() {
        if (greenLabPropertyFileReader == null) {
            greenLabPropertyFileReader = new GreenLabPropertyFileReader();
        }
        return greenLabPropertyFileReader;
    }

    public void reset() {
        if (this.backup != null) {
            this.properties.clear();
            this.properties = (HashMap)this.backup.clone();
        }
    }

    public void setFile(Context context) {
        this.init();
        this.ctx = context;
        this.inFile = null;
        this.load();
    }

    public void setFile(String string) {
        this.init();
        this.inFile = new File(string);
        this.ctx = null;
        this.load();
    }

    public void setFile(FileSource fileSource) {
        this.init();
        this.inFile = fileSource.getInputFile();
        this.ctx = null;
        this.load();
    }

    private void init() {
        this.properties = new HashMap();
    }

    private boolean load(InputStream inputStream) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                String string3;
                String[] stringArray;
                if (string.matches("^\\s*-?\\d.*$")) {
                    stringArray = string.split("[^ \ta-zA-Z0-9_()\\-]\\.");
                    string3 = stringArray[0].replaceAll("^\\s+", "").replaceAll("\\s*$", "").replaceAll("\\s+", " ");
                    if (string2 == null) continue;
                    String string4 = this.properties.get(string2);
                    string4 = string4 == null ? string3 : string4 + " " + string3;
                    this.properties.put(string2, string4);
                    continue;
                }
                if (!string.matches("^\\s*[a-zA-Z(].*$")) continue;
                stringArray = string.split("[^ \ta-zA-Z0-9_()\\.\\-]");
                string3 = stringArray[0].replaceAll("^\\s+", "").replaceAll("\\s*$", "").replaceAll("\\s+", " ");
                int n = string3.indexOf(" ");
                if (n > 0) {
                    string2 = string3.substring(0, n);
                    String string5 = string3.substring(n + 1);
                    if (this.properties.containsKey(string2)) {
                        if (this.properties.containsKey(string2 + "__1")) {
                            int n2 = 0;
                            for (int i = 2; i <= 6; ++i) {
                                if (this.properties.containsKey(string2 + "__" + i)) continue;
                                n2 = i;
                                break;
                            }
                            if (n2 == 0) continue;
                            this.properties.put(string2 + "__" + n2, string5);
                            string2 = string2 + "__" + n2;
                            continue;
                        }
                        this.properties.put(string2 + "__1", this.properties.get(string2));
                        this.properties.put(string2, "");
                        this.properties.put(string2 + "__2", string5);
                        string2 = string2 + "__2";
                        continue;
                    }
                    this.properties.put(string2, string5);
                    continue;
                }
                string2 = string3;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Error during reading a property file: " + iOException);
            return false;
        }
        if (this.backup == null) {
            this.backup = (HashMap)this.properties.clone();
        }
        return true;
    }

    private boolean load() {
        if (this.inFile == null) {
            Registry registry = this.ctx.getWorkbench().getRegistry();
            MemoryFileSystem memoryFileSystem = (MemoryFileSystem)registry.getFileSystem();
            InputStream inputStream = memoryFileSystem.getInputStream(memoryFileSystem.getFile("maize.sci"));
            return this.load(inputStream);
        }
        try {
            return this.load(new FileInputStream(this.inFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return false;
        }
    }

    public String getProperty(String string, int n, int n2) {
        if (n2 > 7 - n || n2 < 1 || n < 1 || n > 6) {
            return null;
        }
        return this.getProperty(string, n * (15 - n) / 2 - 7 + n2);
    }

    public String getProperty(String string, int n) {
        String[] stringArray = this.properties.get(string).split("\\s+");
        if (n <= stringArray.length && n >= 1) {
            return stringArray[n - 1];
        }
        return null;
    }

    public String getProperty(String string) {
        return this.properties.get(string);
    }

    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public boolean setProperty(String string, String string2, int n, int n2) {
        if (n2 > 7 - n || n2 < 1 || n < 1 || n > 6) {
            return false;
        }
        return this.setProperty(string, string2, n * (15 - n) / 2 - 7 + n2);
    }

    public boolean setProperty(String string, String string2, int n) {
        string2 = string2.replaceAll(",", ".");
        if (string.equals("") || string2.equals("")) {
            return false;
        }
        if (n == 0) {
            this.properties.put(string, string2);
            return true;
        }
        if (n > 0) {
            String string3 = this.properties.get(string);
            String[] stringArray = string3.split("\\s+");
            if (n > stringArray.length) {
                return false;
            }
            stringArray[n - 1] = string2;
            String string4 = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string4 = string4 + " " + stringArray[i];
            }
            this.properties.put(string, string4);
            return true;
        }
        return false;
    }

    public boolean setProperty(String string, String string2) {
        string2 = string2.replaceAll(",", ".");
        if (this.properties.containsKey(string) && this.properties.get(string).split("\\s+").length == string2.split("\\s+").length) {
            return this.setProperty(string, string2, 0);
        }
        if (!this.properties.containsKey(string)) {
            return this.setProperty(string, string2, 0);
        }
        System.err.println(this.properties.get(string) + "\t" + string + "\t" + string2);
        return false;
    }

    private String printList(String string) {
        String[] stringArray = string.split("\\s+");
        String string2 = "{";
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2 + stringArray[i];
            if (i == stringArray.length - 1) continue;
            string2 = string2 + ", ";
        }
        string2 = string2 + "}";
        return string2;
    }

    private String printBool(String string) {
        return string.equals("1") ? "true" : "false";
    }

    private String printBoolList(String string) {
        String[] stringArray = string.split("\\s+");
        String string2 = "{";
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2 + (stringArray[i].equals("1") ? "true" : "false");
            if (i == stringArray.length - 1) continue;
            string2 = string2 + ", ";
        }
        string2 = string2 + "}";
        return string2;
    }

    private String printAges(String string) {
        String[] stringArray = string.split("\\s+");
        String string2 = "{";
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            string2 = string2 + "{";
            for (int j = 0; j < 6; ++j) {
                if (j < i) {
                    string2 = string2 + "0";
                } else {
                    string2 = string2 + stringArray[n];
                    ++n;
                }
                if (j == 5) continue;
                string2 = string2 + ", ";
            }
            string2 = i == 5 ? string2 + "}" : string2 + "}, ";
        }
        string2 = string2 + "}";
        return string2;
    }

    private String printSp(String string, int n, int n2) {
        String[] stringArray = string.split("\\s+");
        String string2 = "{";
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            string2 = string2 + "{";
            for (int j = 0; j < n2; ++j) {
                string2 = string2 + stringArray[n3];
                ++n3;
                if (j == n2 - 1) continue;
                string2 = string2 + ", ";
            }
            string2 = i == n - 1 ? string2 + "}" : string2 + "}, ";
        }
        string2 = string2 + "}";
        return string2;
    }

    private String printPhyAge(int n) {
        String string = "{";
        String[] stringArray = new String[]{this.printList(this.getProperty("Time_Function(Tu_O(1))__" + n)), this.printList(this.getProperty("Time_appearance(2)__" + n)), this.printList(this.getProperty("Time_disappearance(3)__" + n)), this.printList(this.getProperty("Time_busy(4)__" + n)), this.printList(this.getProperty("Time_idle(5)__" + n))};
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i];
            if (i == stringArray.length - 1) continue;
            string = string + ", ";
        }
        string = string + "}";
        return string;
    }

    private String printTimeFunc(int n) {
        String string = "{";
        String[] stringArray = new String[]{this.printList(this.getProperty("Blade__" + n)), this.printList(this.getProperty("Petiole__" + n)), this.printList(this.getProperty("Internode__" + n)), this.printList(this.getProperty("Femalefruit__" + n)), this.printList(this.getProperty("Malefruit__" + n)), this.printList(this.getProperty("Root__" + n))};
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i];
            if (i == stringArray.length - 1) continue;
            string = string + ", ";
        }
        string = string + "}";
        return string;
    }

    private String printSink() {
        String string = "{";
        String[] stringArray = new String[]{this.printList(this.getProperty("Sink_Blade(S_B)")), this.printList(this.getProperty("Sink_Petiole(S_P)")), this.printList(this.getProperty("Sink_Internode(S_I)")), this.printList(this.getProperty("Sink_Female(S_Ff)")), this.printList(this.getProperty("Sink_Male(S_Fm)")), this.printList(this.getProperty("Sink_Layer(S_L)")), this.printList(this.getProperty("Sink_Root(S_R)"))};
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i];
            if (i == stringArray.length - 1) continue;
            string = string + ", ";
        }
        string = string + "}";
        return string;
    }

    private String printSci(String string) {
        String[] stringArray = string.split(" ");
        String string2 = "";
        if (stringArray.length == 21) {
            int n = 0;
            for (int i = 0; i < 6; ++i) {
                int n2;
                if (i != 0) {
                    for (n2 = 0; n2 < i + 8; ++n2) {
                        string2 = string2 + "  ";
                    }
                }
                for (n2 = 0; n2 < 6 - i; ++n2) {
                    string2 = string2 + stringArray[n] + " ";
                    ++n;
                }
                string2 = string2 + "\n";
            }
        } else {
            string2 = string;
        }
        return string2;
    }

    private String printSci(String string, int n) {
        String[] stringArray = string.split(" ");
        String string2 = "\n";
        int n2 = 0;
        for (int i = 0; i < stringArray.length / n; ++i) {
            for (int j = 0; j < n; ++j) {
                string2 = string2 + stringArray[n2] + " ";
                ++n2;
            }
            string2 = string2 + "\n";
        }
        return string2;
    }

    public String getSci() {
        String string = "";
        string = string + " \n";
        string = string + "Chr_Age(N) " + this.printSci(this.getProperty("Chr_Age(N)")) + "\n";
        string = string + "Phy_Age(Maxp) " + this.printSci(this.getProperty("Phy_Age(Maxp)")) + "\n";
        string = string + "Sample_Size(Tr) " + this.printSci(this.getProperty("Sample_Size(Tr)")) + "\n";
        string = string + " \n";
        string = string + "Axillary_Num(Nu_A) " + this.printSci(this.getProperty("Axillary_Num(Nu_A)")) + "\n";
        string = string + "Leaf_Num(Nu_B) " + this.printSci(this.getProperty("Leaf_Num(Nu_B)")) + "\n";
        string = string + "Female_Num(Nu_Ff) " + this.printSci(this.getProperty("Female_Num(Nu_Ff)")) + "\n";
        string = string + "Male_Num(Nu_Fm) " + this.printSci(this.getProperty("Male_Num(Nu_Fm)")) + "\n";
        string = string + "Micro_Num(Nu_I) " + this.printSci(this.getProperty("Micro_Num(Nu_I)")) + "\n";
        string = string + " \n";
        string = string + "Flag_Nu_Ma_version " + this.printSci(this.getProperty("Flag_Nu_Ma_version")) + "\n";
        string = string + "Macro_Num(Nu_Ma) " + this.printSci(this.getProperty("Macro_Num(Nu_Ma)")) + "\n";
        string = string + " \n";
        string = string + "Struc_Jump(st_j) " + this.printSci(this.getProperty("Struc_Jump(st_j)")) + "\n";
        string = string + "Reiter_Order(b_o) " + this.printSci(this.getProperty("Reiter_Order(b_o)")) + "\n";
        string = string + "Bran_Control(br_a) " + this.printSci(this.getProperty("Bran_Control(br_a)")) + "\n";
        string = string + "Reiter_Control(re_a) " + this.printSci(this.getProperty("Reiter_Control(re_a)")) + "\n";
        string = string + "Rest_Func(rs_A) " + this.printSci(this.getProperty("Rest_Func(rs_A)")) + "\n";
        string = string + "Rest_Func(rs_B) " + this.printSci(this.getProperty("Rest_Func(rs_B)")) + "\n";
        string = string + "rythm_Ratio(rt_a) " + this.printSci(this.getProperty("rythm_Ratio(rt_a)")) + "\n";
        string = string + " \n";
        string = string + "branching_proba(a) " + this.printSci(this.getProperty("branching_proba(a)")) + "\n";
        string = string + "Growth_macro(b) " + this.printSci(this.getProperty("Growth_macro(b)")) + "\n";
        string = string + "Growth_micro(bu) " + this.printSci(this.getProperty("Growth_micro(bu)")) + "\n";
        string = string + "Survive(c) " + this.printSci(this.getProperty("Survive(c)")) + "\n";
        string = string + " \n";
        string = string + "%***********************Hydro*********************\n";
        string = string + "%OrganType(id)--------Blade-Petiel-Internode-FemaleFlower-MaleFlower-Ring-Root\n";
        string = string + "%phy_age=1\n";
        string = string + "Time_Function(Tu_O(1)) " + this.printSci(this.getProperty("Time_Function(Tu_O(1))__1")) + "\n";
        string = string + "Time_appearance(2) " + this.printSci(this.getProperty("Time_appearance(2)__1")) + "\n";
        string = string + "Time_disappearance(3) " + this.printSci(this.getProperty("Time_disappearance(3)__1")) + "\n";
        string = string + "Time_busy(4) " + this.printSci(this.getProperty("Time_busy(4)__1")) + "\n";
        string = string + "Time_idle(5) " + this.printSci(this.getProperty("Time_idle(5)__1")) + "\n";
        string = string + "%phy_age=2\n";
        string = string + "Time_Function(Tu_O(1)) " + this.printSci(this.getProperty("Time_Function(Tu_O(1))__2")) + "\n";
        string = string + "Time_appearance(2) " + this.printSci(this.getProperty("Time_appearance(2)__2")) + "\n";
        string = string + "Time_disappearance(3) " + this.printSci(this.getProperty("Time_disappearance(3)__2")) + "\n";
        string = string + "Time_busy(4) " + this.printSci(this.getProperty("Time_busy(4)__2")) + "\n";
        string = string + "Time_idle(5) " + this.printSci(this.getProperty("Time_idle(5)__2")) + "\n";
        string = string + "%phy_age=3\n";
        string = string + "Time_Function(Tu_O(1)) " + this.printSci(this.getProperty("Time_Function(Tu_O(1))__3")) + "\n";
        string = string + "Time_appearance(2) " + this.printSci(this.getProperty("Time_appearance(2)__3")) + "\n";
        string = string + "Time_disappearance(3) " + this.printSci(this.getProperty("Time_disappearance(3)__3")) + "\n";
        string = string + "Time_busy(4) " + this.printSci(this.getProperty("Time_busy(4)__3")) + "\n";
        string = string + "Time_idle(5) " + this.printSci(this.getProperty("Time_idle(5)__3")) + "\n";
        string = string + "%phy_age=4\n";
        string = string + "Time_Function(Tu_O(1)) " + this.printSci(this.getProperty("Time_Function(Tu_O(1))__4")) + "\n";
        string = string + "Time_appearance(2) " + this.printSci(this.getProperty("Time_appearance(2)__4")) + "\n";
        string = string + "Time_disappearance(3) " + this.printSci(this.getProperty("Time_disappearance(3)__4")) + "\n";
        string = string + "Time_busy(4) " + this.printSci(this.getProperty("Time_busy(4)__4")) + "\n";
        string = string + "Time_idle(5) " + this.printSci(this.getProperty("Time_idle(5)__4")) + "\n";
        string = string + "%phy_age=5\n";
        string = string + "Time_Function(Tu_O(1)) " + this.printSci(this.getProperty("Time_Function(Tu_O(1))__5")) + "\n";
        string = string + "Time_appearance(2) " + this.printSci(this.getProperty("Time_appearance(2)__5")) + "\n";
        string = string + "Time_disappearance(3) " + this.printSci(this.getProperty("Time_disappearance(3)__5")) + "\n";
        string = string + "Time_busy(4) " + this.printSci(this.getProperty("Time_busy(4)__5")) + "\n";
        string = string + "Time_idle(5) " + this.printSci(this.getProperty("Time_idle(5)__5")) + "\n";
        string = string + "%phy_age=6\n";
        string = string + "Time_Function(Tu_O(1)) " + this.printSci(this.getProperty("Time_Function(Tu_O(1))__6")) + "\n";
        string = string + "Time_appearance(2) " + this.printSci(this.getProperty("Time_appearance(2)__6")) + "\n";
        string = string + "Time_disappearance(3) " + this.printSci(this.getProperty("Time_disappearance(3)__6")) + "\n";
        string = string + "Time_busy(4) " + this.printSci(this.getProperty("Time_busy(4)__6")) + "\n";
        string = string + "Time_idle(5) " + this.printSci(this.getProperty("Time_idle(5)__6")) + "\n";
        string = string + " \n";
        string = string + "Time_Expansion(t_exp) " + this.printSci(this.getProperty("Time_Expansion(t_exp)")) + "\n";
        string = string + " \n";
        string = string + "//*****************function_time_variable*****************\n";
        string = string + "//******************rank*min*rank*max*********************\n";
        string = string + "Flag_Time_function_version " + this.printSci(this.getProperty("Flag_Time_function_version")) + "\n";
        string = string + "Time_function(T_f(1))\n";
        string = string + "Blade " + this.printSci(this.getProperty("Blade__1")) + "\n";
        string = string + "Petiole " + this.printSci(this.getProperty("Petiole__1")) + "\n";
        string = string + "Internode " + this.printSci(this.getProperty("Internode__1")) + "\n";
        string = string + "Femalefruit " + this.printSci(this.getProperty("Femalefruit__1")) + "\n";
        string = string + "Malefruit " + this.printSci(this.getProperty("Malefruit__1")) + "\n";
        string = string + "Root " + this.printSci(this.getProperty("Root__1")) + "\n";
        string = string + "Time_function(T_f(2))\n";
        string = string + "Blade " + this.printSci(this.getProperty("Blade__2")) + "\n";
        string = string + "Petiole " + this.printSci(this.getProperty("Petiole__2")) + "\n";
        string = string + "Internode " + this.printSci(this.getProperty("Internode__2")) + "\n";
        string = string + "Femalefruit " + this.printSci(this.getProperty("Femalefruit__2")) + "\n";
        string = string + "Malefruit " + this.printSci(this.getProperty("Malefruit__2")) + "\n";
        string = string + "Root " + this.printSci(this.getProperty("Root__2")) + "\n";
        string = string + "Time_function(T_f(3))\n";
        string = string + "Blade " + this.printSci(this.getProperty("Blade__3")) + "\n";
        string = string + "Petiole " + this.printSci(this.getProperty("Petiole__3")) + "\n";
        string = string + "Internode " + this.printSci(this.getProperty("Internode__3")) + "\n";
        string = string + "Femalefruit " + this.printSci(this.getProperty("Femalefruit__3")) + "\n";
        string = string + "Malefruit " + this.printSci(this.getProperty("Malefruit__3")) + "\n";
        string = string + "Root " + this.printSci(this.getProperty("Root__3")) + "\n";
        string = string + "Time_function(T_f(4))\n";
        string = string + "Blade " + this.printSci(this.getProperty("Blade__4")) + "\n";
        string = string + "Petiole " + this.printSci(this.getProperty("Petiole__4")) + "\n";
        string = string + "Internode " + this.printSci(this.getProperty("Internode__4")) + "\n";
        string = string + "Femalefruit " + this.printSci(this.getProperty("Femalefruit__4")) + "\n";
        string = string + "Malefruit " + this.printSci(this.getProperty("Malefruit__4")) + "\n";
        string = string + "Root " + this.printSci(this.getProperty("Root__4")) + "\n";
        string = string + "Time_function(T_f(5))\n";
        string = string + "Blade " + this.printSci(this.getProperty("Blade__5")) + "\n";
        string = string + "Petiole " + this.printSci(this.getProperty("Petiole__5")) + "\n";
        string = string + "Internode " + this.printSci(this.getProperty("Internode__5")) + "\n";
        string = string + "Femalefruit " + this.printSci(this.getProperty("Femalefruit__5")) + "\n";
        string = string + "Malefruit " + this.printSci(this.getProperty("Malefruit__5")) + "\n";
        string = string + "Root " + this.printSci(this.getProperty("Root__5")) + "\n";
        string = string + " \n";
        string = string + "//*********************expansion_time_variable************************\n";
        string = string + "//******************rank*min*rank*max*********************\n";
        string = string + "Flag_Time_expansion_version " + this.printSci(this.getProperty("Flag_Time_expansion_version")) + "\n";
        string = string + "Time_expansion(T_exp)\n";
        string = string + "Blade " + this.printSci(this.getProperty("Blade__6")) + "\n";
        string = string + "Petiole " + this.printSci(this.getProperty("Petiole__6")) + "\n";
        string = string + "Internode " + this.printSci(this.getProperty("Internode__6")) + "\n";
        string = string + "Femalefruit " + this.printSci(this.getProperty("Femalefruit__6")) + "\n";
        string = string + "Malefruit " + this.printSci(this.getProperty("Malefruit__6")) + "\n";
        string = string + "Root " + this.printSci(this.getProperty("Root__6")) + "\n";
        string = string + " \n";
        string = string + "%OrganType(id)--------Blade-Petiel-Internode-FemaleFlower-MaleFlower-Ring-Root\n";
        string = string + "Para_a(Bt_a) " + this.printSci(this.getProperty("Para_a(Bt_a)")) + "\n";
        string = string + "Para_b(Bt_b) " + this.printSci(this.getProperty("Para_b(Bt_b)")) + "\n";
        string = string + " \n";
        string = string + "Portion_Remobilization(P_Remob) " + this.printSci(this.getProperty("Portion_Remobilization(P_Remob)")) + "\n";
        string = string + "Speed_Remobilization(V_Remob) " + this.printSci(this.getProperty("Speed_Remobilization(V_Remob)")) + "\n";
        string = string + " \n";
        string = string + "Sink_Blade(S_B) " + this.printSci(this.getProperty("Sink_Blade(S_B)")) + "\n";
        string = string + "Sink_Petiole(S_P) " + this.printSci(this.getProperty("Sink_Petiole(S_P)")) + "\n";
        string = string + "Sink_Internode(S_I) " + this.printSci(this.getProperty("Sink_Internode(S_I)")) + "\n";
        string = string + "Sink_Female(S_Ff) " + this.printSci(this.getProperty("Sink_Female(S_Ff)")) + "\n";
        string = string + "Sink_Male(S_Fm) " + this.printSci(this.getProperty("Sink_Male(S_Fm)")) + "\n";
        string = string + "Sink_Layer(S_L) " + this.printSci(this.getProperty("Sink_Layer(S_L)")) + "\n";
        string = string + "Sink_Root(S_R) " + this.printSci(this.getProperty("Sink_Root(S_R)")) + "\n";
        string = string + " \n";
        string = string + "Allom_Internode(a_bI) " + this.printSci(this.getProperty("Allom_Internode(a_bI)")) + "\n";
        string = string + "(a_aI) " + this.printSci(this.getProperty("(a_aI)")) + "\n";
        string = string + "Allom_Petiole(a_bP) " + this.printSci(this.getProperty("Allom_Petiole(a_bP)")) + "\n";
        string = string + "(a_aP) " + this.printSci(this.getProperty("(a_aP)")) + "\n";
        string = string + "Allom_Blade(a_bB) " + this.printSci(this.getProperty("Allom_Blade(a_bB)")) + "\n";
        string = string + "(a_aB) " + this.printSci(this.getProperty("(a_aB)")) + "\n";
        string = string + "Allom_Thick(Th_B) " + this.printSci(this.getProperty("Allom_Thick(Th_B)")) + "\n";
        string = string + "Female_Density(Den_Ff) " + this.printSci(this.getProperty("Female_Density(Den_Ff)")) + "\n";
        string = string + "Male_Density(Den_Fm) " + this.printSci(this.getProperty("Male_Density(Den_Fm)")) + "\n";
        string = string + "Internode_Dens(Den_I) " + this.printSci(this.getProperty("Internode_Dens(Den_I)")) + "\n";
        string = string + " \n";
        string = string + "Number_Primordia(N_PM) " + this.printSci(this.getProperty("Number_Primordia(N_PM)")) + "\n";
        string = string + "Sink_Primordia(S_PM) " + this.printSci(this.getProperty("Sink_Primordia(S_PM)")) + "\n";
        string = string + " \n";
        string = string + "%Top_Down_Delay_Parameter:ND(p)=Np(p)+Cp(p)*(Nu_Ma(1)-Pos),gl_demand\n";
        string = string + "Delay_Branch(Cp_B) " + this.printSci(this.getProperty("Delay_Branch(Cp_B)")) + "\n";
        string = string + " \n";
        string = string + "Flag_field " + this.printSci(this.getProperty("Flag_field")) + "\n";
        string = string + "Resist_Blade(r_B) " + this.printSci(this.getProperty("Resist_Blade(r_B)")) + "\n";
        string = string + "Resist_Petiole(r_P) " + this.printSci(this.getProperty("Resist_Petiole(r_P)")) + "\n";
        string = string + "Resist_Root(r_R) " + this.printSci(this.getProperty("Resist_Root(r_R)")) + "\n";
        string = string + "Projected_area(Sp) " + this.printSci(this.getProperty("Projected_area(Sp)")) + "\n";
        string = string + "Beer_law(rp) " + this.printSci(this.getProperty("Beer_law(rp)")) + "\n";
        string = string + "Beer_law(kp) " + this.printSci(this.getProperty("Beer_law(kp)")) + "\n";
        string = string + " \n";
        string = string + "Seed_Biomass(Q0) " + this.printSci(this.getProperty("Seed_Biomass(Q0)")) + "\n";
        string = string + "Flow_Biomass(dQ0) " + this.printSci(this.getProperty("Flow_Biomass(dQ0)")) + "\n";
        string = string + " \n";
        string = string + "Flag_TotalLayerDemand_Mode " + this.printSci(this.getProperty("Flag_TotalLayerDemand_Mode")) + "\n";
        string = string + "Global_Sink_Layer(Slay) " + this.printSci(this.getProperty("Global_Sink_Layer(Slay)")) + "\n";
        string = string + "Global_Sink_Coefficient(Slope) " + this.printSci(this.getProperty("Global_Sink_Coefficient(Slope)")) + "\n";
        string = string + "Layer_repartition_Coefficient(Lamda) " + this.printSci(this.getProperty("Layer_repartition_Coefficient(Lamda)")) + "\n";
        string = string + " \n";
        string = string + "Expansion_Mode " + this.printSci(this.getProperty("Expansion_Mode")) + "\n";
        string = string + "Root_Demand_Mode " + this.printSci(this.getProperty("Root_Demand_Mode")) + "\n";
        string = string + " \n";
        string = string + "ShortInter_Number(N_SI) " + this.printSci(this.getProperty("ShortInter_Number(N_SI)")) + "\n";
        string = string + "ShortInter_RelaSink(kp_SI) " + this.printSci(this.getProperty("ShortInter_RelaSink(kp_SI)")) + "\n";
        string = string + " \n";
        string = string + "%***********************Geometry*********************\n";
        string = string + "Leaf_shape(smb_L) " + this.printSci(this.getProperty("Leaf_shape(smb_L)")) + "\n";
        string = string + "Female_shape(smb_Ff) " + this.printSci(this.getProperty("Female_shape(smb_Ff)")) + "\n";
        string = string + "Male_shape(smb_Fm) " + this.printSci(this.getProperty("Male_shape(smb_Fm)")) + "\n";
        string = string + " \n";
        string = string + "Leaf_color(Color_B) " + this.printSci(this.getProperty("Leaf_color(Color_B)"), 3) + "\n";
        string = string + "Internode_color(Color_I) " + this.printSci(this.getProperty("Internode_color(Color_I)"), 3) + "\n";
        string = string + "Female_color(Color_Ff) " + this.printSci(this.getProperty("Female_color(Color_Ff)"), 3) + "\n";
        string = string + "Male_color(Color_Fm) " + this.printSci(this.getProperty("Male_color(Color_Fm)"), 3) + "\n";
        string = string + " \n";
        string = string + "Phy_Color(Color_P) " + this.printSci(this.getProperty("Phy_Color(Color_P)"), 3) + "\n";
        string = string + " \n";
        string = string + "Angle_Male(Ang_Fm) " + this.printSci(this.getProperty("Angle_Male(Ang_Fm)")) + "\n";
        string = string + "Angle_Female(Ang_Ff) " + this.printSci(this.getProperty("Angle_Female(Ang_Ff)")) + "\n";
        string = string + "Angle_Blade(Ang_B) " + this.printSci(this.getProperty("Angle_Blade(Ang_B)")) + "\n";
        string = string + "Angle_Axillary(Ang_A) " + this.printSci(this.getProperty("Angle_Axillary(Ang_A)")) + "\n";
        string = string + "Angle_Phyllotaxy(Ang_Ph) " + this.printSci(this.getProperty("Angle_Phyllotaxy(Ang_Ph)")) + "\n";
        string = string + " \n";
        string = string + "Young_Modulus(Ey) " + this.printSci(this.getProperty("Young_Modulus(Ey)")) + "\n";
        string = string + "Force_point(fp) " + this.printSci(this.getProperty("Force_point(fp)")) + "\n";
        string = string + "Terminal_Angle(Eng_Ang) " + this.printSci(this.getProperty("Terminal_Angle(Eng_Ang)")) + "\n";
        string = string + "Righting_point(Eng_N) " + this.printSci(this.getProperty("Righting_point(Eng_N)")) + "\n";
        string = string + "InitialMin_angle(InitMin) " + this.printSci(this.getProperty("InitialMin_angle(InitMin)")) + "\n";
        string = string + "InitialMax_angle(InitMax) " + this.printSci(this.getProperty("InitialMax_angle(InitMax)")) + "\n";
        string = string + "InitialNum_angle(InitNum) " + this.printSci(this.getProperty("InitialNum_angle(InitNum)")) + "\n";
        string = string + "Flag_Bending_by_node " + this.printSci(this.getProperty("Flag_Bending_by_node")) + "\n";
        string = string + " \n";
        string = string + "Max_Angle(wb) " + this.printSci(this.getProperty("Max_Angle(wb)")) + "\n";
        string = string + "Openning_cycle(wbn) " + this.printSci(this.getProperty("Openning_cycle(wbn)")) + "\n";
        string = string + " \n";
        string = string + "Organ(Flag_organ_bending) " + this.printSci(this.getProperty("Organ(Flag_organ_bending)")) + "\n";
        string = string + "Bending_branch(Theta_B) " + this.printSci(this.getProperty("Bending_branch(Theta_B)")) + "\n";
        string = string + "Bending_leaf(Theta_L) " + this.printSci(this.getProperty("Bending_leaf(Theta_L)")) + "\n";
        string = string + "Bending_fruit(Theta_F) " + this.printSci(this.getProperty("Bending_fruit(Theta_F)")) + "\n";
        string = string + " \n";
        string = string + "Flag_plagiotropic " + this.printSci(this.getProperty("Flag_plagiotropic")) + "\n";
        string = string + "Leaf_direction(Flag) " + this.printSci(this.getProperty("Leaf_direction(Flag)")) + "\n";
        string = string + " \n";
        string = string + "Pruning(Flag_pruning) " + this.printSci(this.getProperty("Pruning(Flag_pruning)")) + "\n";
        string = string + "Delay(Pruning_delay) " + this.printSci(this.getProperty("Delay(Pruning_delay)")) + "\n";
        string = string + "Leaf_display(Flag_leaf) " + this.printSci(this.getProperty("Leaf_display(Flag_leaf)")) + "\n";
        string = string + "Fruit_display(Flag_fruit) " + this.printSci(this.getProperty("Fruit_display(Flag_fruit)")) + "\n";
        string = string + " \n";
        string = string + "Internode_Volume(VI) " + this.printSci(this.getProperty("Internode_Volume(VI)")) + "\n";
        string = string + "Blade_Volume(VB) " + this.printSci(this.getProperty("Blade_Volume(VB)")) + "\n";
        string = string + "Fruit_Volume(VF) " + this.printSci(this.getProperty("Fruit_Volume(VF)")) + "\n";
        string = string + "Internode_C(CI) " + this.printSci(this.getProperty("Internode_C(CI)")) + "\n";
        string = string + "Blade_C(CB) " + this.printSci(this.getProperty("Blade_C(CB)")) + "\n";
        string = string + "Fruit_C(CF) " + this.printSci(this.getProperty("Fruit_C(CF)")) + "\n";
        string = string + " \n";
        string = string + "%***********************Environment*********************\n";
        string = string + "%soil_water_budget\n";
        string = string + "Flag_climate " + this.printSci(this.getProperty("Flag_climate")) + "\n";
        string = string + "SoilWaterEffect(K1) " + this.printSci(this.getProperty("SoilWaterEffect(K1)")) + "\n";
        string = string + "SoilWaterEffect(K2) " + this.printSci(this.getProperty("SoilWaterEffect(K2)")) + "\n";
        string = string + "Soil_budget_para(C1) " + this.printSci(this.getProperty("Soil_budget_para(C1)")) + "\n";
        string = string + "Soil_budget_para(C2) " + this.printSci(this.getProperty("Soil_budget_para(C2)")) + "\n";
        string = string + "InitialSoilWater(QSW0) " + this.printSci(this.getProperty("InitialSoilWater(QSW0)")) + "\n";
        string = string + "MaxPlantSoilWater(QSWMAX) " + this.printSci(this.getProperty("MaxPlantSoilWater(QSWMAX)")) + "\n";
        string = string + "MinPlantSoilWater(QSWMIN) " + this.printSci(this.getProperty("MinPlantSoilWater(QSWMIN)")) + "\n";
        string = string + "MaxEnvFSoilWater(QSW_MAX) " + this.printSci(this.getProperty("MaxEnvFSoilWater(QSW_MAX)")) + "\n";
        string = string + "MinEnvFSoilWater(QSW_MIN) " + this.printSci(this.getProperty("MinEnvFSoilWater(QSW_MIN)")) + "\n";
        string = string + " \n";
        string = string + "%temperature_effect\n";
        string = string + "Flag_temperature " + this.printSci(this.getProperty("Flag_temperature")) + "\n";
        string = string + "SumTEffect(Flag_sumt) " + this.printSci(this.getProperty("SumTEffect(Flag_sumt)")) + "\n";
        string = string + "Temperature(E_ALPHA) " + this.printSci(this.getProperty("Temperature(E_ALPHA)")) + "\n";
        string = string + "Temperature(E_BETA) " + this.printSci(this.getProperty("Temperature(E_BETA)")) + "\n";
        string = string + "SumTEffect(KSUMT) " + this.printSci(this.getProperty("SumTEffect(KSUMT)")) + "\n";
        string = string + "SumTEffect(THETA_BASE) " + this.printSci(this.getProperty("SumTEffect(THETA_BASE)")) + "\n";
        string = string + "MaxPlantTemp(THETAMAX) " + this.printSci(this.getProperty("MaxPlantTemp(THETAMAX)")) + "\n";
        string = string + "MinPlantTemp(THETAMIN) " + this.printSci(this.getProperty("MinPlantTemp(THETAMIN)")) + "\n";
        string = string + "MaxEnvFTemp(THETA_MAX) " + this.printSci(this.getProperty("MaxEnvFTemp(THETA_MAX)")) + "\n";
        string = string + "MinEnvFTemp(THETA_MIN) " + this.printSci(this.getProperty("MinEnvFTemp(THETA_MIN)")) + "\n";
        string = string + " \n";
        string = string + "%light_effect\n";
        string = string + "Flag_light " + this.printSci(this.getProperty("Flag_light")) + "\n";
        string = string + "Light(E_A) " + this.printSci(this.getProperty("Light(E_A)")) + "\n";
        string = string + "Light(E_B) " + this.printSci(this.getProperty("Light(E_B)")) + "\n";
        string = string + "MaxEnvFLight(LIGHTMAX) " + this.printSci(this.getProperty("MaxEnvFLight(LIGHTMAX)")) + "\n";
        string = string + "MinEnvFLight(LIGHTMIN) " + this.printSci(this.getProperty("MinEnvFLight(LIGHTMIN)")) + "\n";
        string = string + "MaxEnvFLight(LIGHT_MAX) " + this.printSci(this.getProperty("MaxEnvFLight(LIGHT_MAX)")) + "\n";
        string = string + "MinEnvFLight(LIGHT_MIN) " + this.printSci(this.getProperty("MinEnvFLight(LIGHT_MIN)")) + "\n";
        string = string + "PotentialCondition(E0) " + this.printSci(this.getProperty("PotentialCondition(E0)")) + "\n";
        string = string + " \n";
        string = string + "%***********************OutputOption*********************\n";
        string = string + "Flag_topo_disp " + this.printSci(this.getProperty("Flag_topo_disp")) + "\n";
        string = string + "Flag_topo_disp_total " + this.printSci(this.getProperty("Flag_topo_disp_total")) + "\n";
        string = string + "Flag_topo_disp_living " + this.printSci(this.getProperty("Flag_topo_disp_living")) + "\n";
        string = string + "Flag_topo_disp_living_aboveGU " + this.printSci(this.getProperty("Flag_topo_disp_living_aboveGU")) + "\n";
        string = string + "Flag_hydro " + this.printSci(this.getProperty("Flag_hydro")) + "\n";
        string = string + "Flag_demand_biomass_layer " + this.printSci(this.getProperty("Flag_demand_biomass_layer")) + "\n";
        string = string + "Flag_demand_biomass_plant " + this.printSci(this.getProperty("Flag_demand_biomass_plant")) + "\n";
        string = string + "Flag_biomass_repartition " + this.printSci(this.getProperty("Flag_biomass_repartition")) + "\n";
        string = string + "Flag_biomass_fig " + this.printSci(this.getProperty("Flag_biomass_fig")) + "\n";
        string = string + "Flag_biomassdemand_fig " + this.printSci(this.getProperty("Flag_biomassdemand_fig")) + "\n";
        string = string + "Flag_biomass_fig_accumulated " + this.printSci(this.getProperty("Flag_biomass_fig_accumulated")) + "\n";
        string = string + "Flag_disp_LAI " + this.printSci(this.getProperty("Flag_disp_LAI")) + "\n";
        string = string + "Flag_organ_biomass_fig_phy " + this.printSci(this.getProperty("Flag_organ_biomass_fig_phy")) + "\n";
        string = string + "Flag_organ_size_fig_phy " + this.printSci(this.getProperty("Flag_organ_size_fig_phy")) + "\n";
        string = string + "Flag_geometry " + this.printSci(this.getProperty("Flag_geometry")) + "\n";
        string = string + "Flag_geo_full " + this.printSci(this.getProperty("Flag_geo_full")) + "\n";
        string = string + "Flag_geo_3D " + this.printSci(this.getProperty("Flag_geo_3D")) + "\n";
        string = string + "Flag_geo_leaf " + this.printSci(this.getProperty("Flag_geo_leaf")) + "\n";
        string = string + "Flag_geo_fruit " + this.printSci(this.getProperty("Flag_geo_fruit")) + "\n";
        string = string + "Flag_geo_skeleton " + this.printSci(this.getProperty("Flag_geo_skeleton")) + "\n";
        string = string + "Flag_geo_lig " + this.printSci(this.getProperty("Flag_geo_lig")) + "\n";
        string = string + "Flag_windows " + this.printSci(this.getProperty("Flag_windows")) + "\n";
        string = string + " \n";
        return string;
    }

    public String getRgg() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String string = "/**\n";
        string = string + "* XL-Reimplementation of the GreenLab Model\n";
        string = string + "* This parameter file is based on the one from the GreenScilabV1.0Demo software\n";
        string = string + "* \n";
        string = string + "* NOTE: DO NOT EDIT THIS FILE -\n";
        string = string + "* IT WILL BE REPLACED AUTOMATICALLY WHEN YOU PUSH THE APPLY BUTTON!\n";
        string = string + "*\n";
        string = string + "* @date <" + simpleDateFormat.format(date) + ">\n";
        string = string + "* @author Groimp Generator\n";
        string = string + "* @version \n";
        string = string + "*/\n";
        string = string + "///////////////////////////// GreenScilab parameters ///////////////////////////\n";
        string = string + "\n";
        string = string + "// Chr_Age(N)\n";
        string = string + "public static final int  N = " + this.getProperty("Chr_Age(N)") + ";\n";
        string = string + "// Phy_Age(Maxp)\n";
        string = string + "public static final int  MAXP = " + this.getProperty("Phy_Age(Maxp)") + ";\n";
        string = string + "// Sample_Size(Tr)\n";
        string = string + "public static final int[]  TR = " + this.printList(this.getProperty("Sample_Size(Tr)")) + ";\n";
        string = string + "\n";
        string = string + "// TOPOLOGY\n";
        string = string + "\n";
        string = string + "// number of organs (microstate)\n";
        string = string + "// Axillary_Num(Nu_A)\n";
        string = string + "public static final int[][]  NU_A = " + this.printAges(this.getProperty("Axillary_Num(Nu_A)")) + ";\n";
        string = string + "// Leaf_Num(Nu_B)\n";
        string = string + "public static final int[][]  NU_B = " + this.printAges(this.getProperty("Leaf_Num(Nu_B)")) + ";\n";
        string = string + "// Female_Num(Nu_Ff)\n";
        string = string + "public static final int[][]  NU_FF = " + this.printAges(this.getProperty("Female_Num(Nu_Ff)")) + ";\n";
        string = string + "// Male_Num(Nu_Fm)\n";
        string = string + "public static final int[][]  NU_FM = " + this.printAges(this.getProperty("Male_Num(Nu_Fm)")) + ";\n";
        string = string + "// Micro_Num(Nu_I)\n";
        string = string + "public static final int[][]  NU_I = " + this.printAges(this.getProperty("Micro_Num(Nu_I)")) + ";\n";
        string = string + "\n";
        string = string + "// macrostate\n";
        string = string + "// Flag_Nu_Ma_version\n";
        string = string + "public static final int  FLAG_NU_MA = " + this.getProperty("Flag_Nu_Ma_version") + ";\n";
        string = string + "// Macro_Num(Nu_Ma)\n";
        string = string + "public static final int[]  NU_MA = " + this.printList(this.getProperty("Macro_Num(Nu_Ma)")) + ";\n";
        string = string + "\n";
        string = string + "// jump in PA for ending structures\n";
        string = string + "// Struc_Jump(st_j)\n";
        string = string + "public static final int[]  ST_J = " + this.printList(this.getProperty("Struc_Jump(st_j)")) + ";\n";
        string = string + "\n";
        string = string + "// reiteration control\n";
        string = string + "// Reiter_Order(b_o)\n";
        string = string + "public static final int[]  B_O = " + this.printList(this.getProperty("Reiter_Order(b_o)")) + ";\n";
        string = string + "// Bran_Control(br_a)\n";
        string = string + "public static final boolean[]  BR_A = " + this.printBoolList(this.getProperty("Bran_Control(br_a)")) + ";\n";
        string = string + "// Reiter_Control(re_a)\n";
        string = string + "public static final boolean[]  RE_A = " + this.printBoolList(this.getProperty("Reiter_Control(re_a)")) + ";\n";
        string = string + "// rest before functioning\n";
        string = string + "// Rest_Func(rs_A)\n";
        string = string + "public static final int[]  RS_A = " + this.printList(this.getProperty("Rest_Func(rs_A)")) + ";\n";
        string = string + "// Rest_Func(rs_B)\n";
        string = string + "public static final int[]  RS_B = " + this.printList(this.getProperty("Rest_Func(rs_B)")) + ";\n";
        string = string + "// rythm_Ratio(rt_a)\n";
        string = string + "public static final double[]  RT_A = " + this.printList(this.getProperty("rythm_Ratio(rt_a)")) + ";\n";
        string = string + "\n";
        string = string + "// stochastic control\n";
        string = string + "// branching_proba(a)\n";
        string = string + "public static final double[]  A = " + this.printList(this.getProperty("branching_proba(a)")) + ";\n";
        string = string + "// Growth_macro(b)\n";
        string = string + "public static final double[]  B = " + this.printList(this.getProperty("Growth_macro(b)")) + ";\n";
        string = string + "// Growth_micro(bu)\n";
        string = string + "public static final double[]  BU = " + this.printList(this.getProperty("Growth_micro(bu)")) + ";\n";
        string = string + "// Survive(c)\n";
        string = string + "public static final double[]  C = " + this.printList(this.getProperty("Survive(c)")) + ";\n";
        string = string + "\n";
        string = string + "// GROWTH\n";
        string = string + "\n";
        string = string + "// functioning duration, appearance, disappearance, busy, idle time, dependent on PA, constant\n";
        string = string + "// %phy_age=1\n";
        string = string + "public static final int[][]  TU_O_PA1 = " + this.printPhyAge(1) + ";\n";
        string = string + "// %phy_age=2\n";
        string = string + "public static final int[][]  TU_O_PA2 = " + this.printPhyAge(2) + ";\n";
        string = string + "// %phy_age=3\n";
        string = string + "public static final int[][]  TU_O_PA3 = " + this.printPhyAge(3) + ";\n";
        string = string + "// %phy_age=4\n";
        string = string + "public static final int[][]  TU_O_PA4 = " + this.printPhyAge(4) + ";\n";
        string = string + "// %phy_age=5\n";
        string = string + "public static final int[][]  TU_O_PA5 = " + this.printPhyAge(5) + ";\n";
        string = string + "// %phy_age=6\n";
        string = string + "public static final int[][]  TU_O_PA6 = " + this.printPhyAge(6) + ";\n";
        string = string + "\n";
        string = string + "// expansion duration, independent of PA, constant\n";
        string = string + "// Time_Expansion(t_exp)\n";
        string = string + "public static final int[]  T_EXP_CONST = " + this.printList(this.getProperty("Time_Expansion(t_exp)")) + ";\n";
        string = string + "\n";
        string = string + "// Flag_Time_function_version, 0 - constant, 1 - variable, 2 - from file\n";
        string = string + "public static final int  FLAG_TIME_FUNCTION = " + this.getProperty("Flag_Time_function_version") + ";\n";
        string = string + "\n";
        string = string + "// functioning duration, dependent on PA, variable\n";
        string = string + "// Time_function(T_f(1))\n";
        string = string + "public static final int[][]  T_FUNC_VAR_PA1 = " + this.printTimeFunc(1) + ";\n";
        string = string + "// Time_function(T_f(2))\n";
        string = string + "public static final int[][]  T_FUNC_VAR_PA2 = " + this.printTimeFunc(2) + ";\n";
        string = string + "// Time_function(T_f(3))\n";
        string = string + "public static final int[][]  T_FUNC_VAR_PA3 = " + this.printTimeFunc(3) + ";\n";
        string = string + "// Time_function(T_f(4))\n";
        string = string + "public static final int[][]  T_FUNC_VAR_PA4 = " + this.printTimeFunc(4) + ";\n";
        string = string + "// Time_function(T_f(5))\n";
        string = string + "public static final int[][]  T_FUNC_VAR_PA5 = " + this.printTimeFunc(5) + ";\n";
        string = string + "\n";
        string = string + "// Flag_Time_expansion_version, 0 - constant, 1 - variable, 2 - from file\n";
        string = string + "public static final int  FLAG_TIME_EXPANSION = " + this.getProperty("Flag_Time_expansion_version") + ";\n";
        string = string + "// expansion duration, independent of PA, variable\n";
        string = string + "// Time_expansion(T_exp)\n";
        string = string + "public static final int[][]  T_EXP_VAR = " + this.printTimeFunc(6) + ";\n";
        string = string + "\n";
        string = string + "// expansion law\n";
        string = string + "// Para_a(Bt_a)\n";
        string = string + "public static final double[]  BT_N = " + this.printList(this.getProperty("Para_a(Bt_a)")) + ";\n";
        string = string + "// Para_b(Bt_b)\n";
        string = string + "public static final double[]  BT_P = " + this.printList(this.getProperty("Para_b(Bt_b)")) + ";\n";
        string = string + "\n";
        string = string + "// remobilization\n";
        string = string + "// Portion_Remobilization(P_Remob)\n";
        string = string + "public static final double[]  P_REMOB = " + this.printList(this.getProperty("Portion_Remobilization(P_Remob)")) + ";\n";
        string = string + "// Speed_Remobilization(V_Remob)\n";
        string = string + "public static final double[]  V_REMOB = " + this.printList(this.getProperty("Speed_Remobilization(V_Remob)")) + ";\n";
        string = string + "\n";
        string = string + "// sink of organs\n";
        string = string + "// Sink_Blade(S_B)\n";
        string = string + "// Sink_Petiole(S_P)\n";
        string = string + "// Sink_Internode(S_I)\n";
        string = string + "// Sink_Female(S_Ff)\n";
        string = string + "// Sink_Male(S_Fm)\n";
        string = string + "// Sink_Layer(S_L)\n";
        string = string + "// Sink_Root(S_R)\n";
        string = string + "public static final double[][]  S_O = " + this.printSink() + ";\n";
        string = string + "\n";
        string = string + "// allometry\n";
        string = string + "// Allom_Internode(a_bI)\n";
        string = string + "public static final double[]  A_BI = " + this.printList(this.getProperty("Allom_Internode(a_bI)")) + ";\n";
        string = string + "// (a_aI)\n";
        string = string + "public static final double[]  A_AI = " + this.printList(this.getProperty("(a_aI)")) + ";\n";
        string = string + "// Allom_Petiole(a_bP)\n";
        string = string + "public static final double[]  A_BP = " + this.printList(this.getProperty("Allom_Petiole(a_bP)")) + ";\n";
        string = string + "// (a_aP)\n";
        string = string + "public static final double[]  A_AP = " + this.printList(this.getProperty("(a_aP)")) + ";\n";
        string = string + "// Allom_Blade(a_bB)\n";
        string = string + "public static final double[]  A_BB = " + this.printList(this.getProperty("Allom_Blade(a_bB)")) + ";\n";
        string = string + "// (a_aB)\n";
        string = string + "public static final double[]  A_AB = " + this.printList(this.getProperty("(a_aB)")) + ";\n";
        string = string + "// Allom_Thick(Th_B)\n";
        string = string + "public static final double[]  TH_B = " + this.printList(this.getProperty("Allom_Thick(Th_B)")) + ";\n";
        string = string + "// Female_Density(Den_Ff)\n";
        string = string + "public static final double[]  DEN_FF = " + this.printList(this.getProperty("Female_Density(Den_Ff)")) + ";\n";
        string = string + "// Male_Density(Den_Fm)\n";
        string = string + "public static final double[]  DEN_FM = " + this.printList(this.getProperty("Male_Density(Den_Fm)")) + ";\n";
        string = string + "// Internode_Dens(Den_I)\n";
        string = string + "public static final double[]  DEN_I = " + this.printList(this.getProperty("Internode_Dens(Den_I)")) + ";\n";
        string = string + "\n";
        string = string + "// Number_Primordia(N_PM) \n";
        string = string + "public static final double[]  N_PM = " + this.printList(this.getProperty("Number_Primordia(N_PM)")) + ";\n";
        string = string + "// Sink_Primordia(S_PM)\n";
        string = string + "public static final double[]  S_PM = " + this.printList(this.getProperty("Sink_Primordia(S_PM)")) + ";\n";
        string = string + "\n";
        string = string + "// Delay_Branch(Cp_B)\n";
        string = string + "public static final int[]  CP_B = " + this.printList(this.getProperty("Delay_Branch(Cp_B)")) + ";\n";
        string = string + "\n";
        string = string + "// Flag_field\n";
        string = string + "public static final int  FLAG_FIELD = " + this.getProperty("Flag_field") + ";\n";
        string = string + "// Resist_Blade(r_B)\n";
        string = string + "public static final double  R_B = " + this.getProperty("Resist_Blade(r_B)") + ";\n";
        string = string + "// Resist_Petiole(r_P)\n";
        string = string + "public static final double  R_P = " + this.getProperty("Resist_Petiole(r_P)") + ";\n";
        string = string + "// Resist_Root(r_R)\n";
        string = string + "public static final double  R_R = " + this.getProperty("Resist_Root(r_R)") + ";\n";
        string = string + "// Projected_area(Sp)\n";
        string = string + "public static final double  SP = " + this.getProperty("Projected_area(Sp)") + ";\n";
        string = string + "// Beer_law(rp)\n";
        string = string + "public static final double  RP = " + this.getProperty("Beer_law(rp)") + ";\n";
        string = string + "// Beer_law(kp)\n";
        string = string + "public static final double  KP = " + this.getProperty("Beer_law(kp)") + ";\n";
        string = string + "\n";
        string = string + "// Seed_Biomass(Q0)\n";
        string = string + "public static final double  Q0 = " + this.getProperty("Seed_Biomass(Q0)") + ";\n";
        string = string + "// Flow_Biomass(dQ0)\n";
        string = string + "public static final double  DQ0 = " + this.getProperty("Flow_Biomass(dQ0)") + ";\n";
        string = string + "\n";
        string = string + "// Flag_TotalLayerDemand_Mode\n";
        string = string + "public static final int  FLAG_TOTAL_LAYER_DEMAND = " + this.getProperty("Flag_TotalLayerDemand_Mode") + ";\n";
        string = string + "// Global_Sink_Layer(Slay)\n";
        string = string + "public static final double  SLAY = " + this.getProperty("Global_Sink_Layer(Slay)") + ";\n";
        string = string + "// Global_Sink_Coefficient(Slope)\n";
        string = string + "public static final double  SLOPE = " + this.getProperty("Global_Sink_Coefficient(Slope)") + ";\n";
        string = string + "// Layer_repartition_Coefficient(Lamda)\n";
        string = string + "public static final double  COFF_L = " + this.getProperty("Layer_repartition_Coefficient(Lamda)") + ";\n";
        string = string + "\n";
        string = string + "// Expansion_Mode\n";
        string = string + "public static final int  EXPANSION_MODE = " + this.getProperty("Expansion_Mode") + ";\n";
        string = string + "// Root_Demand_Mode\n";
        string = string + "public static final int  ROOT_DEMAND_MODE = " + this.getProperty("Root_Demand_Mode") + ";\n";
        string = string + "\n";
        string = string + "// ShortInter_Number(N_SI)\n";
        string = string + "public static final int  N_SI = " + this.getProperty("ShortInter_Number(N_SI)") + ";\n";
        string = string + "// ShortInter_RelaSink(kp_SI)\n";
        string = string + "public static final double  KP_SI = " + this.getProperty("ShortInter_RelaSink(kp_SI)") + ";\n";
        string = string + "\n";
        string = string + "// GEOMETRY\n";
        string = string + "\n";
        string = string + "// shape\n";
        string = string + "// Leaf_shape(smb_L)\n";
        string = string + "public static final Reference LEAF_OBJECT = reference(\"" + this.getProperty("Leaf_shape(smb_L)") + "\");\n";
        string = string + "// Female_shape(smb_Ff)\n";
        string = string + "public static final Reference FEMALE_FRUIT_OBJECT = reference(\"" + this.getProperty("Female_shape(smb_Ff)") + "\");\n";
        string = string + "// Male_shape(smb_Fm)\n";
        string = string + "public static final Reference MALE_FRUIT_OBJECT = reference(\"" + this.getProperty("Male_shape(smb_Fm)") + "\");\n";
        string = string + "\n";
        string = string + "// colour\n";
        string = string + "// Leaf_color(Color_B)\n";
        string = string + "public static final double[][]  COLOR_B = " + this.printSp(this.getProperty("Leaf_color(Color_B)"), 2, 3) + ";\n";
        string = string + "// Internode_color(Color_I)\n";
        string = string + "public static final double[][]  COLOR_I = " + this.printSp(this.getProperty("Internode_color(Color_I)"), 2, 3) + ";\n";
        string = string + "// Female_color(Color_Ff)\n";
        string = string + "public static final double[][]  COLOR_FF = " + this.printSp(this.getProperty("Female_color(Color_Ff)"), 2, 3) + ";\n";
        string = string + "// Male_color(Color_Fm)\n";
        string = string + "public static final double[][]  COLOR_FM = " + this.printSp(this.getProperty("Male_color(Color_Fm)"), 2, 3) + ";\n";
        string = string + "// Phy_Color(Color_P)\n";
        string = string + "public static final double[][]  COLOR_P = " + this.printSp(this.getProperty("Phy_Color(Color_P)"), 6, 3) + ";\n";
        string = string + "\n";
        string = string + "// textures\n";
        string = string + "// Leaf_texture_{alive, dead}\n";
        string = string + "public static final String Leaf_texture_alive = \"" + this.getProperty("Leaf_texture_alive") + "\";\n";
        string = string + "public static final String Leaf_texture_dead = \"" + this.getProperty("Leaf_texture_dead") + "\";\n";
        string = string + "// Internode_texture_{alive, dead}\n";
        string = string + "public static final String Internode_texture_alive = \"" + this.getProperty("Internode_texture_alive") + "\";\n";
        string = string + "public static final String Internode_texture_dead = \"" + this.getProperty("Internode_texture_dead") + "\";\n";
        string = string + "// Female_texture_{alive, dead}\n";
        string = string + "public static final String Female_texture_alive = \"" + this.getProperty("Female_texture_alive") + "\";\n";
        string = string + "public static final String Female_texture_dead = \"" + this.getProperty("Female_texture_dead") + "\";\n";
        string = string + "// Male_texture_{alive, dead}\n";
        string = string + "public static final String Male_texture_alive = \"" + this.getProperty("Male_texture_alive") + "\";\n";
        string = string + "public static final String Male_texture_dead = \"" + this.getProperty("Male_texture_dead") + "\";\n";
        string = string + "\n";
        string = string + "// angles\n";
        string = string + "// Angle_Male(Ang_Fm)\n";
        string = string + "public static final double[][]  ANG_FM = " + this.printAges(this.getProperty("Angle_Male(Ang_Fm)")) + ";\n";
        string = string + "// Angle_Female(Ang_Ff)\n";
        string = string + "public static final double[][]  ANG_FF = " + this.printAges(this.getProperty("Angle_Female(Ang_Ff)")) + ";\n";
        string = string + "// Angle_Blade(Ang_B)\n";
        string = string + "public static final double[][]  ANG_B = " + this.printAges(this.getProperty("Angle_Blade(Ang_B)")) + ";\n";
        string = string + "// Angle_Axillary(Ang_A)\n";
        string = string + "public static final double[][]  ANG_A = " + this.printAges(this.getProperty("Angle_Axillary(Ang_A)")) + ";\n";
        string = string + "// Angle_Phyllotaxy(Ang_Ph)\n";
        string = string + "public static final double[]  ANG_PH = " + this.printList(this.getProperty("Angle_Phyllotaxy(Ang_Ph)")) + ";\n";
        string = string + "\n";
        string = string + "// branch bending\n";
        string = string + "// Young_Modulus(Ey)\n";
        string = string + "public static final double[]  EY = " + this.printList(this.getProperty("Young_Modulus(Ey)")) + ";\n";
        string = string + "// Force_point(fp)\n";
        string = string + "public static final double[]  FP = " + this.printList(this.getProperty("Force_point(fp)")) + ";\n";
        string = string + "// Terminal_Angle(Eng_Ang)\n";
        string = string + "public static final double[]  ENG_ANG = " + this.printList(this.getProperty("Terminal_Angle(Eng_Ang)")) + ";\n";
        string = string + "// Righting_point(Eng_N)\n";
        string = string + "public static final int[]  ENG_N = " + this.printList(this.getProperty("Righting_point(Eng_N)")) + ";\n";
        string = string + "// InitialMin_angle(InitMin)\n";
        string = string + "public static final double[]  INITMIN = " + this.printList(this.getProperty("InitialMin_angle(InitMin)")) + ";\n";
        string = string + "// InitialMax_angle(InitMax)\n";
        string = string + "public static final double[]  INITMAX = " + this.printList(this.getProperty("InitialMax_angle(InitMax)")) + ";\n";
        string = string + "// InitialNum_angle(InitNum)\n";
        string = string + "public static final int[]  INITNUM = " + this.printList(this.getProperty("InitialNum_angle(InitNum)")) + ";\n";
        string = string + "//Flag_Bending_by_node\n";
        string = string + "public static final boolean[]  FLAG_BENDING_BY_NODE = " + this.printBoolList(this.getProperty("Flag_Bending_by_node")) + ";\n";
        string = string + "\n";
        string = string + "// Max_Angle(wb)\n";
        string = string + "public static final double[]  WB = " + this.printList(this.getProperty("Max_Angle(wb)")) + ";\n";
        string = string + "// Openning_cycle(wbn)\n";
        string = string + "public static final int[]  WBN = " + this.printList(this.getProperty("Openning_cycle(wbn)")) + ";\n";
        string = string + "\n";
        string = string + "// Organ(Flag_organ_bending)\n";
        string = string + "public static final boolean[]  FLAG_ORGAN_BENDING = " + this.printBoolList(this.getProperty("Organ(Flag_organ_bending)")) + ";\n";
        string = string + "// Bending_branch(Theta_B)\n";
        string = string + "public static final double[]  THETA_B = " + this.printList(this.getProperty("Bending_branch(Theta_B)")) + ";\n";
        string = string + "// Bending_leaf(Theta_L)\n";
        string = string + "public static final double[]  THETA_L = " + this.printList(this.getProperty("Bending_leaf(Theta_L)")) + ";\n";
        string = string + "// Bending_fruit(Theta_F)\n";
        string = string + "public static final double[]  THETA_F = " + this.printList(this.getProperty("Bending_fruit(Theta_F)")) + ";\n";
        string = string + "\n";
        string = string + "// Flag_plagiotropic\n";
        string = string + "public static final boolean[]  FLAG_PLAGIOTROPIC = " + this.printBoolList(this.getProperty("Flag_plagiotropic")) + ";\n";
        string = string + "// Leaf_direction(Flag)\n";
        string = string + "public static final boolean[]  FLAG_LEAF_DIRECTION = " + this.printBoolList(this.getProperty("Leaf_direction(Flag)")) + ";\n";
        string = string + "\n";
        string = string + "// Pruning(Flag_pruning)\n";
        string = string + "public static final boolean[]  FLAG_PRUNING = " + this.printBoolList(this.getProperty("Pruning(Flag_pruning)")) + ";\n";
        string = string + "// Delay(Pruning_delay)\n";
        string = string + "public static final int[]  PRUNING_DELAY = " + this.printList(this.getProperty("Delay(Pruning_delay)")) + ";\n";
        string = string + "// Leaf_display(Flag_leaf)\n";
        string = string + "public static final boolean[]  FLAG_LEAF = " + this.printBoolList(this.getProperty("Leaf_display(Flag_leaf)")) + ";\n";
        string = string + "// Fruit_display(Flag_fruit)\n";
        string = string + "public static final boolean[]  FLAG_FRUIT = " + this.printBoolList(this.getProperty("Fruit_display(Flag_fruit)")) + ";\n";
        string = string + "\n";
        string = string + "// Internode_Volume(VI)\n";
        string = string + "public static final double[]  VI = " + this.printList(this.getProperty("Internode_Volume(VI)")) + ";\n";
        string = string + "// Blade_Volume(VB)\n";
        string = string + "public static final double[]  VB = " + this.printList(this.getProperty("Blade_Volume(VB)")) + ";\n";
        string = string + "// Fruit_Volume(VF)\n";
        string = string + "public static final double[]  VF = " + this.printList(this.getProperty("Fruit_Volume(VF)")) + ";\n";
        string = string + "// Internode_C(CI)\n";
        string = string + "public static final double[]  CI = " + this.printList(this.getProperty("Internode_C(CI)")) + ";\n";
        string = string + "// Blade_C(CB)\n";
        string = string + "public static final double[]  CB = " + this.printList(this.getProperty("Blade_C(CB)")) + ";\n";
        string = string + "// Fruit_C(CF)\n";
        string = string + "public static final double[]  CF = " + this.printList(this.getProperty("Fruit_C(CF)")) + ";\n";
        string = string + "\n";
        string = string + "// ENVIRONMENT\n";
        string = string + "\n";
        string = string + "// soil water\n";
        string = string + "// Flag_climate\n";
        string = string + "public static final boolean  FLAG_CLIMATE = " + this.printBool(this.getProperty("Flag_climate")) + ";\n";
        string = string + "// SoilWaterEffect(K1)\n";
        string = string + "public static final double  E_K1 = " + this.getProperty("SoilWaterEffect(K1)") + ";\n";
        string = string + "// SoilWaterEffect(K2)\n";
        string = string + "public static final double  E_K2 = " + this.getProperty("SoilWaterEffect(K2)") + ";\n";
        string = string + "// Soil_budget_para(C1)\n";
        string = string + "public static final double  C1 = " + this.getProperty("Soil_budget_para(C1)") + ";\n";
        string = string + "// Soil_budget_para(C2)\n";
        string = string + "public static final double  C2 = " + this.getProperty("Soil_budget_para(C2)") + ";\n";
        string = string + "// InitialSoilWater(QSW0)\n";
        string = string + "public static final double  QSW0 = " + this.getProperty("InitialSoilWater(QSW0)") + ";\n";
        string = string + "// MaxPlantSoilWater(QSWMAX)\n";
        string = string + "public static final double  QSWMAX = " + this.getProperty("MaxPlantSoilWater(QSWMAX)") + ";\n";
        string = string + "// MinPlantSoilWater(QSWMIN)\n";
        string = string + "public static final double  QSWMIN = " + this.getProperty("MinPlantSoilWater(QSWMIN)") + ";\n";
        string = string + "// MaxEnvFSoilWater(QSW_MAX)\n";
        string = string + "public static final double  QSW_MAX = " + this.getProperty("MaxEnvFSoilWater(QSW_MAX)") + ";\n";
        string = string + "// MinEnvFSoilWater(QSW_MIN)\n";
        string = string + "public static final double  QSW_MIN = " + this.getProperty("MinEnvFSoilWater(QSW_MIN)") + ";\n";
        string = string + "\n";
        string = string + "// temperature\n";
        string = string + "// Flag_temperature\n";
        string = string + "public static final boolean  FLAG_TEMPERATURE = " + this.printBool(this.getProperty("Flag_temperature")) + ";\n";
        string = string + "// SumTEffect(Flag_sumt)\n";
        string = string + "public static final boolean  FLAG_SUMT = " + this.printBool(this.getProperty("SumTEffect(Flag_sumt)")) + ";\n";
        string = string + "// Temperature(E_ALPHA)\n";
        string = string + "public static final double  E_ALPHA = " + this.getProperty("Temperature(E_ALPHA)") + ";\n";
        string = string + "// Temperature(E_BETA)\n";
        string = string + "public static final double  E_BETA = " + this.getProperty("Temperature(E_BETA)") + ";\n";
        string = string + "// SumTEffect(KSUMT)\n";
        string = string + "public static final double  KSUMT = " + this.getProperty("SumTEffect(KSUMT)") + ";\n";
        string = string + "// SumTEffect(THETA_BASE)\n";
        string = string + "public static final double  THETA_BASE = " + this.getProperty("SumTEffect(THETA_BASE)") + ";\n";
        string = string + "// MaxPlantTemp(THETAMAX)\n";
        string = string + "public static final double  THETAMAX = " + this.getProperty("MaxPlantTemp(THETAMAX)") + ";\n";
        string = string + "// MinPlantTemp(THETAMIN)\n";
        string = string + "public static final double  THETAMIN = " + this.getProperty("MinPlantTemp(THETAMIN)") + ";\n";
        string = string + "// MaxEnvFTemp(THETA_MAX)\n";
        string = string + "public static final double  THETA_MAX = " + this.getProperty("MaxEnvFTemp(THETA_MAX)") + ";\n";
        string = string + "// MinEnvFTemp(THETA_MIN)\n";
        string = string + "public static final double  THETA_MIN = " + this.getProperty("MinEnvFTemp(THETA_MIN)") + ";\n";
        string = string + "\n";
        string = string + "// light\n";
        string = string + "// Flag_light\n";
        string = string + "public static final boolean  FLAG_LIGHT = " + this.printBool(this.getProperty("Flag_light")) + ";\n";
        string = string + "// Light(E_A)\n";
        string = string + "public static final double  E_A = " + this.getProperty("Light(E_A)") + ";\n";
        string = string + "// Light(E_B)\n";
        string = string + "public static final double  E_B = " + this.getProperty("Light(E_B)") + ";\n";
        string = string + "// MaxEnvFLight(LIGHTMAX)\n";
        string = string + "public static final double  LIGHTMAX = " + this.getProperty("MaxEnvFLight(LIGHTMAX)") + ";\n";
        string = string + "// MinEnvFLight(LIGHTMIN)\n";
        string = string + "public static final double  LIGHTMIN = " + this.getProperty("MinEnvFLight(LIGHTMIN)") + ";\n";
        string = string + "// MaxEnvFLight(LIGHT_MAX)\n";
        string = string + "public static final double  LIGHT_MAX = " + this.getProperty("MaxEnvFLight(LIGHT_MAX)") + ";\n";
        string = string + "// MinEnvFLight(LIGHT_MIN)\n";
        string = string + "public static final double  LIGHT_MIN = " + this.getProperty("MinEnvFLight(LIGHT_MIN)") + ";\n";
        string = string + "// PotentialCondition(E0)\n";
        string = string + "public static final double  E0 = " + this.getProperty("PotentialCondition(E0)") + ";\n";
        string = string + "\n";
        string = string + "// OUTPUT OPTIONS\n";
        string = string + "\n";
        string = string + "// data\n";
        string = string + "// Flag_topo_disp\n";
        string = string + "public static final boolean[]  FLAG_TOPO_DISP = " + this.printBoolList(this.getProperty("Flag_topo_disp")) + ";\n";
        string = string + "// Flag_topo_disp_total\n";
        string = string + "public static final boolean  FLAG_TOPO_DISP_S = " + this.printBool(this.getProperty("Flag_topo_disp_total")) + ";\n";
        string = string + "// Flag_topo_disp_living\n";
        string = string + "public static final boolean[]  FLAG_TOPO_DISP_L = " + this.printBoolList(this.getProperty("Flag_topo_disp_living")) + ";\n";
        string = string + "// Flag_topo_disp_living_aboveGU\n";
        string = string + "public static final boolean[]  FLAG_TOPO_DISP_A = " + this.printBoolList(this.getProperty("Flag_topo_disp_living_aboveGU")) + ";\n";
        string = string + "// Flag_hydro\n";
        string = string + "public static final boolean  FLAG_HYDRO = " + this.printBool(this.getProperty("Flag_hydro")) + ";\n";
        string = string + "// Flag_demand_biomass_layer\n";
        string = string + "public static final boolean  FLAG_LAYER_DISP = " + this.printBool(this.getProperty("Flag_demand_biomass_layer")) + ";\n";
        string = string + "// Flag_demand_biomass_plant\n";
        string = string + "public static final boolean  FLAG_DEMAND_BIOMASS = " + this.printBool(this.getProperty("Flag_demand_biomass_plant")) + ";\n";
        string = string + "// Flag_biomass_repartition\n";
        string = string + "public static final boolean[]  FLAG_BIOMASS_NUM = " + this.printBoolList(this.getProperty("Flag_biomass_repartition")) + ";\n";
        string = string + "\n";
        string = string + "// charts\n";
        string = string + "// Flag_biomass_fig\n";
        string = string + "public static final boolean  FLAG_BIOMASS_FIG = " + this.printBool(this.getProperty("Flag_biomass_fig")) + ";\n";
        string = string + "// Flag_biomassdemand_fig\n";
        string = string + "public static final boolean  FLAG_BIOPROD_FIG = " + this.printBool(this.getProperty("Flag_biomassdemand_fig")) + ";\n";
        string = string + "// Flag_biomass_fig_accumulated\n";
        string = string + "public static final boolean  FLAG_BIOMASS_FIG_A = " + this.printBool(this.getProperty("Flag_biomass_fig_accumulated")) + ";\n";
        string = string + "// Flag_disp_LAI\n";
        string = string + "public static final boolean  FLAG_DISP_LAI = " + this.printBool(this.getProperty("Flag_disp_LAI")) + ";\n";
        string = string + "// Flag_organ_biomass_fig_phy\n";
        string = string + "public static final boolean[]  FLAG_BIOMASS_FIG_PHY = " + this.printBoolList(this.getProperty("Flag_organ_biomass_fig_phy")) + ";\n";
        string = string + "// Flag_organ_size_fig_phy\n";
        string = string + "public static final boolean[]  FLAG_SIZE_FIG_PHY = " + this.printBoolList(this.getProperty("Flag_organ_size_fig_phy")) + ";\n";
        string = string + "\n";
        string = string + "// 3D\n";
        string = string + "// Flag_geometry\n";
        string = string + "public static final boolean  FLAG_GEOMETRY = " + this.printBool(this.getProperty("Flag_geometry")) + ";\n";
        string = string + "// Flag_geo_full\n";
        string = string + "public static final boolean  FLAG_GEO_FULL = " + this.printBool(this.getProperty("Flag_geo_full")) + ";\n";
        string = string + "// Flag_geo_3D\n";
        string = string + "public static final boolean  FLAG_GEO_3D = " + this.printBool(this.getProperty("Flag_geo_3D")) + ";\n";
        string = string + "// Flag_geo_leaf\n";
        string = string + "public static final boolean  FLAG_GEO_LEAF = " + this.printBool(this.getProperty("Flag_geo_leaf")) + ";\n";
        string = string + "// Flag_geo_fruit\n";
        string = string + "public static final boolean  FLAG_GEO_FRUIT = " + this.printBool(this.getProperty("Flag_geo_fruit")) + ";\n";
        string = string + "// Flag_geo_skeleton\n";
        string = string + "public static final boolean[]  FLAG_GEO_SKELETON = " + this.printBoolList(this.getProperty("Flag_geo_skeleton")) + ";\n";
        string = string + "// Flag_geo_lig\n";
        string = string + "public static final boolean  FLAG_GEO_LIG = " + this.printBool(this.getProperty("Flag_geo_lig")) + ";\n";
        string = string + "// Flag_window\n";
        string = string + "public static final boolean  FLAG_WINDOWS = " + this.printBool(this.getProperty("Flag_windows")) + ";\n";
        return string;
    }

    private String preSolveRgg(String string) {
        String string2 = "";
        String[] stringArray = string.split("\\s+");
        if (stringArray.length == 36) {
            for (int i = 0; i < 6; ++i) {
                for (int j = i; j < 6; ++j) {
                    string2 = string2 + stringArray[i * 6 + j] + " ";
                }
            }
        } else {
            string2 = string;
        }
        return string2.replaceAll("\\s+$", "").replaceAll("^\\s+", "");
    }

    private String preSolveRgg(String string, int n, int n2) {
        String string2 = "";
        String[] stringArray = string.split("\\s+");
        for (int i = n * n2; i < (n + 1) * n2; ++i) {
            string2 = string2 + stringArray[i] + " ";
        }
        return string2.replaceAll("\\s+$", "").replaceAll("^\\s+", "");
    }

    public void reloadRgg(HashMap<?, ?> hashMap) {
        int n;
        this.setProperty("Phy_Age(Maxp)", this.preSolveRgg(hashMap.get("MAXP").toString()));
        this.setProperty("Sample_Size(Tr)", this.preSolveRgg(hashMap.get("TR").toString()));
        this.setProperty("Axillary_Num(Nu_A)", this.preSolveRgg(hashMap.get("NU_A").toString()));
        this.setProperty("Leaf_Num(Nu_B)", this.preSolveRgg(hashMap.get("NU_B").toString()));
        this.setProperty("Female_Num(Nu_Ff)", this.preSolveRgg(hashMap.get("NU_FF").toString()));
        this.setProperty("Male_Num(Nu_Fm)", this.preSolveRgg(hashMap.get("NU_FM").toString()));
        this.setProperty("Micro_Num(Nu_I)", this.preSolveRgg(hashMap.get("NU_I").toString()));
        this.setProperty("Flag_Nu_Ma_version", this.preSolveRgg(hashMap.get("FLAG_NU_MA").toString()));
        this.setProperty("Macro_Num(Nu_Ma)", this.preSolveRgg(hashMap.get("NU_MA").toString()));
        this.setProperty("Struc_Jump(st_j)", this.preSolveRgg(hashMap.get("ST_J").toString()));
        this.setProperty("Reiter_Order(b_o)", this.preSolveRgg(hashMap.get("B_O").toString()));
        this.setProperty("Bran_Control(br_a)", this.preSolveRgg(hashMap.get("BR_A").toString()));
        this.setProperty("Reiter_Control(re_a)", this.preSolveRgg(hashMap.get("RE_A").toString()));
        this.setProperty("Rest_Func(rs_A)", this.preSolveRgg(hashMap.get("RS_A").toString()));
        this.setProperty("Rest_Func(rs_B)", this.preSolveRgg(hashMap.get("RS_B").toString()));
        this.setProperty("rythm_Ratio(rt_a)", this.preSolveRgg(hashMap.get("RT_A").toString()));
        this.setProperty("branching_proba(a)", this.preSolveRgg(hashMap.get("A").toString()));
        this.setProperty("Growth_macro(b)", this.preSolveRgg(hashMap.get("B").toString()));
        this.setProperty("Growth_micro(bu)", this.preSolveRgg(hashMap.get("BU").toString()));
        this.setProperty("Survive(c)", this.preSolveRgg(hashMap.get("C").toString()));
        this.setProperty("Time_Expansion(t_exp)", this.preSolveRgg(hashMap.get("T_EXP_CONST").toString()));
        this.setProperty("Flag_Time_function_version", this.preSolveRgg(hashMap.get("FLAG_TIME_FUNCTION").toString()));
        this.setProperty("Flag_Time_expansion_version", this.preSolveRgg(hashMap.get("FLAG_TIME_EXPANSION").toString()));
        this.setProperty("Para_b(Bt_b)", this.preSolveRgg(hashMap.get("BT_P").toString()));
        this.setProperty("Portion_Remobilization(P_Remob)", this.preSolveRgg(hashMap.get("P_REMOB").toString()));
        this.setProperty("Speed_Remobilization(V_Remob)", this.preSolveRgg(hashMap.get("V_REMOB").toString()));
        this.setProperty("Allom_Internode(a_bI)", this.preSolveRgg(hashMap.get("A_BI").toString()));
        this.setProperty("(a_aI)", this.preSolveRgg(hashMap.get("A_AI").toString()));
        this.setProperty("Allom_Petiole(a_bP)", this.preSolveRgg(hashMap.get("A_BP").toString()));
        this.setProperty("(a_aP)", this.preSolveRgg(hashMap.get("A_AP").toString()));
        this.setProperty("Allom_Blade(a_bB)", this.preSolveRgg(hashMap.get("A_BB").toString()));
        this.setProperty("(a_aB)", this.preSolveRgg(hashMap.get("A_AB").toString()));
        this.setProperty("Allom_Thick(Th_B)", this.preSolveRgg(hashMap.get("TH_B").toString()));
        this.setProperty("Female_Density(Den_Ff)", this.preSolveRgg(hashMap.get("DEN_FF").toString()));
        this.setProperty("Male_Density(Den_Fm)", this.preSolveRgg(hashMap.get("DEN_FM").toString()));
        this.setProperty("Internode_Dens(Den_I)", this.preSolveRgg(hashMap.get("DEN_I").toString()));
        this.setProperty("Number_Primordia(N_PM)", this.preSolveRgg(hashMap.get("N_PM").toString()));
        this.setProperty("Sink_Primordia(S_PM)", this.preSolveRgg(hashMap.get("S_PM").toString()));
        this.setProperty("Delay_Branch(Cp_B)", this.preSolveRgg(hashMap.get("CP_B").toString()));
        this.setProperty("Flag_field", this.preSolveRgg(hashMap.get("FLAG_FIELD").toString()));
        this.setProperty("Resist_Blade(r_B)", this.preSolveRgg(hashMap.get("R_B").toString()));
        this.setProperty("Resist_Petiole(r_P)", this.preSolveRgg(hashMap.get("R_P").toString()));
        this.setProperty("Resist_Root(r_R)", this.preSolveRgg(hashMap.get("R_R").toString()));
        this.setProperty("Projected_area(Sp)", this.preSolveRgg(hashMap.get("SP").toString()));
        this.setProperty("Beer_law(rp)", this.preSolveRgg(hashMap.get("RP").toString()));
        this.setProperty("Beer_law(kp)", this.preSolveRgg(hashMap.get("KP").toString()));
        this.setProperty("Seed_Biomass(Q0)", this.preSolveRgg(hashMap.get("Q0").toString()));
        this.setProperty("Flow_Biomass(dQ0)", this.preSolveRgg(hashMap.get("DQ0").toString()));
        this.setProperty("Flag_TotalLayerDemand_Mode", this.preSolveRgg(hashMap.get("FLAG_TOTAL_LAYER_DEMAND").toString()));
        this.setProperty("Global_Sink_Layer(Slay)", this.preSolveRgg(hashMap.get("SLAY").toString()));
        this.setProperty("Global_Sink_Coefficient(Slope)", this.preSolveRgg(hashMap.get("SLOPE").toString()));
        this.setProperty("Layer_repartition_Coefficient(Lamda)", this.preSolveRgg(hashMap.get("COFF_L").toString()));
        this.setProperty("Expansion_Mode", this.preSolveRgg(hashMap.get("EXPANSION_MODE").toString()));
        this.setProperty("Root_Demand_Mode", this.preSolveRgg(hashMap.get("ROOT_DEMAND_MODE").toString()));
        this.setProperty("ShortInter_Number(N_SI)", this.preSolveRgg(hashMap.get("N_SI").toString()));
        this.setProperty("ShortInter_RelaSink(kp_SI)", this.preSolveRgg(hashMap.get("KP_SI").toString()));
        this.setProperty("Leaf_shape(smb_L)", this.preSolveRgg(hashMap.get("LEAF_OBJECT").toString()));
        this.setProperty("Female_shape(smb_Ff)", this.preSolveRgg(hashMap.get("FEMALE_FRUIT_OBJECT").toString()));
        this.setProperty("Male_shape(smb_Fm)", this.preSolveRgg(hashMap.get("MALE_FRUIT_OBJECT").toString()));
        this.setProperty("Leaf_color(Color_B)", this.preSolveRgg(hashMap.get("COLOR_B").toString()));
        this.setProperty("Internode_color(Color_I)", this.preSolveRgg(hashMap.get("COLOR_I").toString()));
        this.setProperty("Female_color(Color_Ff)", this.preSolveRgg(hashMap.get("COLOR_FF").toString()));
        this.setProperty("Male_color(Color_Fm)", this.preSolveRgg(hashMap.get("COLOR_FM").toString()));
        this.setProperty("Phy_Color(Color_P)", this.preSolveRgg(hashMap.get("COLOR_P").toString()));
        this.setProperty("Leaf_texture_alive", this.preSolveRgg(hashMap.get("Leaf_texture_alive").toString()));
        this.setProperty("Internode_texture_alive", this.preSolveRgg(hashMap.get("Internode_texture_alive").toString()));
        this.setProperty("Female_texture_alive", this.preSolveRgg(hashMap.get("Female_texture_alive").toString()));
        this.setProperty("Male_texture_alive", this.preSolveRgg(hashMap.get("Male_texture_alive").toString()));
        this.setProperty("Leaf_texture_dead", this.preSolveRgg(hashMap.get("Leaf_texture_dead").toString()));
        this.setProperty("Internode_texture_dead", this.preSolveRgg(hashMap.get("Internode_texture_dead").toString()));
        this.setProperty("Female_texture_dead", this.preSolveRgg(hashMap.get("Female_texture_dead").toString()));
        this.setProperty("Male_texture_dead", this.preSolveRgg(hashMap.get("Male_texture_dead").toString()));
        this.setProperty("Angle_Male(Ang_Fm)", this.preSolveRgg(hashMap.get("ANG_FM").toString()));
        this.setProperty("Angle_Female(Ang_Ff)", this.preSolveRgg(hashMap.get("ANG_FF").toString()));
        this.setProperty("Angle_Blade(Ang_B)", this.preSolveRgg(hashMap.get("ANG_B").toString()));
        this.setProperty("Angle_Axillary(Ang_A)", this.preSolveRgg(hashMap.get("ANG_A").toString()));
        this.setProperty("Angle_Phyllotaxy(Ang_Ph)", this.preSolveRgg(hashMap.get("ANG_PH").toString()));
        this.setProperty("Young_Modulus(Ey)", this.preSolveRgg(hashMap.get("EY").toString()));
        this.setProperty("Force_point(fp)", this.preSolveRgg(hashMap.get("FP").toString()));
        this.setProperty("Terminal_Angle(Eng_Ang)", this.preSolveRgg(hashMap.get("ENG_ANG").toString()));
        this.setProperty("Righting_point(Eng_N)", this.preSolveRgg(hashMap.get("ENG_N").toString()));
        this.setProperty("InitialMin_angle(InitMin)", this.preSolveRgg(hashMap.get("INITMIN").toString()));
        this.setProperty("InitialMax_angle(InitMax)", this.preSolveRgg(hashMap.get("INITMAX").toString()));
        this.setProperty("InitialNum_angle(InitNum)", this.preSolveRgg(hashMap.get("INITNUM").toString()));
        this.setProperty("Flag_Bending_by_node", this.preSolveRgg(hashMap.get("FLAG_BENDING_BY_NODE").toString()));
        this.setProperty("Max_Angle(wb)", this.preSolveRgg(hashMap.get("WB").toString()));
        this.setProperty("Openning_cycle(wbn)", this.preSolveRgg(hashMap.get("WBN").toString()));
        this.setProperty("Organ(Flag_organ_bending)", this.preSolveRgg(hashMap.get("FLAG_ORGAN_BENDING").toString()));
        this.setProperty("Bending_branch(Theta_B)", this.preSolveRgg(hashMap.get("THETA_B").toString()));
        this.setProperty("Bending_leaf(Theta_L)", this.preSolveRgg(hashMap.get("THETA_L").toString()));
        this.setProperty("Bending_fruit(Theta_F)", this.preSolveRgg(hashMap.get("THETA_F").toString()));
        this.setProperty("Flag_plagiotropic", this.preSolveRgg(hashMap.get("FLAG_PLAGIOTROPIC").toString()));
        this.setProperty("Leaf_direction(Flag)", this.preSolveRgg(hashMap.get("FLAG_LEAF_DIRECTION").toString()));
        this.setProperty("Pruning(Flag_pruning)", this.preSolveRgg(hashMap.get("FLAG_PRUNING").toString()));
        this.setProperty("Delay(Pruning_delay)", this.preSolveRgg(hashMap.get("PRUNING_DELAY").toString()));
        this.setProperty("Leaf_display(Flag_leaf)", this.preSolveRgg(hashMap.get("FLAG_LEAF").toString()));
        this.setProperty("Fruit_display(Flag_fruit)", this.preSolveRgg(hashMap.get("FLAG_FRUIT").toString()));
        this.setProperty("Internode_Volume(VI)", this.preSolveRgg(hashMap.get("VI").toString()));
        this.setProperty("Blade_Volume(VB)", this.preSolveRgg(hashMap.get("VB").toString()));
        this.setProperty("Fruit_Volume(VF)", this.preSolveRgg(hashMap.get("VF").toString()));
        this.setProperty("Internode_C(CI)", this.preSolveRgg(hashMap.get("CI").toString()));
        this.setProperty("Blade_C(CB)", this.preSolveRgg(hashMap.get("CB").toString()));
        this.setProperty("Fruit_C(CF)", this.preSolveRgg(hashMap.get("CF").toString()));
        this.setProperty("Flag_climate", this.preSolveRgg(hashMap.get("FLAG_CLIMATE").toString()));
        this.setProperty("SoilWaterEffect(K1)", this.preSolveRgg(hashMap.get("E_K1").toString()));
        this.setProperty("SoilWaterEffect(K2)", this.preSolveRgg(hashMap.get("E_K2").toString()));
        this.setProperty("Soil_budget_para(C1)", this.preSolveRgg(hashMap.get("C1").toString()));
        this.setProperty("Soil_budget_para(C2)", this.preSolveRgg(hashMap.get("C2").toString()));
        this.setProperty("InitialSoilWater(QSW0)", this.preSolveRgg(hashMap.get("QSW0").toString()));
        this.setProperty("MaxPlantSoilWater(QSWMAX)", this.preSolveRgg(hashMap.get("QSWMAX").toString()));
        this.setProperty("MinPlantSoilWater(QSWMIN)", this.preSolveRgg(hashMap.get("QSWMIN").toString()));
        this.setProperty("MaxEnvFSoilWater(QSW_MAX)", this.preSolveRgg(hashMap.get("QSW_MAX").toString()));
        this.setProperty("MinEnvFSoilWater(QSW_MIN)", this.preSolveRgg(hashMap.get("QSW_MIN").toString()));
        this.setProperty("Flag_temperature", this.preSolveRgg(hashMap.get("FLAG_TEMPERATURE").toString()));
        this.setProperty("SumTEffect(Flag_sumt)", this.preSolveRgg(hashMap.get("FLAG_SUMT").toString()));
        this.setProperty("Temperature(E_ALPHA)", this.preSolveRgg(hashMap.get("E_ALPHA").toString()));
        this.setProperty("Temperature(E_BETA)", this.preSolveRgg(hashMap.get("E_BETA").toString()));
        this.setProperty("SumTEffect(KSUMT)", this.preSolveRgg(hashMap.get("KSUMT").toString()));
        this.setProperty("SumTEffect(THETA_BASE)", this.preSolveRgg(hashMap.get("THETA_BASE").toString()));
        this.setProperty("MaxPlantTemp(THETAMAX)", this.preSolveRgg(hashMap.get("THETAMAX").toString()));
        this.setProperty("MinPlantTemp(THETAMIN)", this.preSolveRgg(hashMap.get("THETAMIN").toString()));
        this.setProperty("MaxEnvFTemp(THETA_MAX)", this.preSolveRgg(hashMap.get("THETA_MAX").toString()));
        this.setProperty("MinEnvFTemp(THETA_MIN)", this.preSolveRgg(hashMap.get("THETA_MIN").toString()));
        this.setProperty("Flag_light", this.preSolveRgg(hashMap.get("FLAG_LIGHT").toString()));
        this.setProperty("Light(E_A)", this.preSolveRgg(hashMap.get("E_A").toString()));
        this.setProperty("Light(E_B)", this.preSolveRgg(hashMap.get("E_B").toString()));
        this.setProperty("MaxEnvFLight(LIGHTMAX)", this.preSolveRgg(hashMap.get("LIGHTMAX").toString()));
        this.setProperty("MinEnvFLight(LIGHTMIN)", this.preSolveRgg(hashMap.get("LIGHTMIN").toString()));
        this.setProperty("MaxEnvFLight(LIGHT_MAX)", this.preSolveRgg(hashMap.get("LIGHT_MAX").toString()));
        this.setProperty("MinEnvFLight(LIGHT_MIN)", this.preSolveRgg(hashMap.get("LIGHT_MIN").toString()));
        this.setProperty("PotentialCondition(E0)", this.preSolveRgg(hashMap.get("E0").toString()));
        this.setProperty("Flag_topo_disp", this.preSolveRgg(hashMap.get("FLAG_TOPO_DISP").toString()));
        this.setProperty("Flag_topo_disp_total", this.preSolveRgg(hashMap.get("FLAG_TOPO_DISP_S").toString()));
        this.setProperty("Flag_topo_disp_living", this.preSolveRgg(hashMap.get("FLAG_TOPO_DISP_L").toString()));
        this.setProperty("Flag_topo_disp_living_aboveGU", this.preSolveRgg(hashMap.get("FLAG_TOPO_DISP_A").toString()));
        this.setProperty("Flag_hydro", this.preSolveRgg(hashMap.get("FLAG_HYDRO").toString()));
        this.setProperty("Flag_demand_biomass_layer", this.preSolveRgg(hashMap.get("FLAG_LAYER_DISP").toString()));
        this.setProperty("Flag_demand_biomass_plant", this.preSolveRgg(hashMap.get("FLAG_DEMAND_BIOMASS").toString()));
        this.setProperty("Flag_biomass_repartition", this.preSolveRgg(hashMap.get("FLAG_BIOMASS_NUM").toString()));
        this.setProperty("Flag_biomass_fig", this.preSolveRgg(hashMap.get("FLAG_BIOMASS_FIG").toString()));
        this.setProperty("Flag_biomassdemand_fig", this.preSolveRgg(hashMap.get("FLAG_BIOPROD_FIG").toString()));
        this.setProperty("Flag_biomass_fig_accumulated", this.preSolveRgg(hashMap.get("FLAG_BIOMASS_FIG_A").toString()));
        this.setProperty("Flag_disp_LAI", this.preSolveRgg(hashMap.get("FLAG_DISP_LAI").toString()));
        this.setProperty("Flag_organ_biomass_fig_phy", this.preSolveRgg(hashMap.get("FLAG_BIOMASS_FIG_PHY").toString()));
        this.setProperty("Flag_organ_size_fig_phy", this.preSolveRgg(hashMap.get("FLAG_SIZE_FIG_PHY").toString()));
        this.setProperty("Flag_geometry", this.preSolveRgg(hashMap.get("FLAG_GEOMETRY").toString()));
        this.setProperty("Flag_geo_full", this.preSolveRgg(hashMap.get("FLAG_GEO_FULL").toString()));
        this.setProperty("Flag_geo_3D", this.preSolveRgg(hashMap.get("FLAG_GEO_3D").toString()));
        this.setProperty("Flag_geo_leaf", this.preSolveRgg(hashMap.get("FLAG_GEO_LEAF").toString()));
        this.setProperty("Flag_geo_fruit", this.preSolveRgg(hashMap.get("FLAG_GEO_FRUIT").toString()));
        this.setProperty("Flag_geo_skeleton", this.preSolveRgg(hashMap.get("FLAG_GEO_SKELETON").toString()));
        this.setProperty("Flag_geo_lig", this.preSolveRgg(hashMap.get("FLAG_GEO_LIG").toString()));
        this.setProperty("Flag_windows", this.preSolveRgg(hashMap.get("FLAG_WINDOWS").toString()));
        this.setProperty("Para_a(Bt_a)", this.preSolveRgg(hashMap.get("BT_N").toString()));
        this.setProperty("Chr_Age(N)", this.preSolveRgg(hashMap.get("N").toString()));
        for (n = 1; n <= 6; ++n) {
            this.setProperty("Time_Function(Tu_O(1))__" + n, this.preSolveRgg(hashMap.get("TU_O_PA" + n).toString(), 0, 8));
            this.setProperty("Time_appearance(2)__" + n, this.preSolveRgg(hashMap.get("TU_O_PA" + n).toString(), 1, 8));
            this.setProperty("Time_disappearance(3)__" + n, this.preSolveRgg(hashMap.get("TU_O_PA" + n).toString(), 2, 8));
            this.setProperty("Time_busy(4)__" + n, this.preSolveRgg(hashMap.get("TU_O_PA" + n).toString(), 3, 8));
            this.setProperty("Time_idle(5)__" + n, this.preSolveRgg(hashMap.get("TU_O_PA" + n).toString(), 4, 8));
        }
        for (n = 1; n < 6; ++n) {
            this.setProperty("Blade__" + n, this.preSolveRgg(hashMap.get("T_FUNC_VAR_PA" + n).toString(), 0, 4));
            this.setProperty("Petiole__" + n, this.preSolveRgg(hashMap.get("T_FUNC_VAR_PA" + n).toString(), 1, 4));
            this.setProperty("Internode__" + n, this.preSolveRgg(hashMap.get("T_FUNC_VAR_PA" + n).toString(), 2, 4));
            this.setProperty("Femalefruit__" + n, this.preSolveRgg(hashMap.get("T_FUNC_VAR_PA" + n).toString(), 3, 4));
            this.setProperty("Malefruit__" + n, this.preSolveRgg(hashMap.get("T_FUNC_VAR_PA" + n).toString(), 4, 4));
            this.setProperty("Root__" + n, this.preSolveRgg(hashMap.get("T_FUNC_VAR_PA" + n).toString(), 5, 4));
        }
        n = 6;
        this.setProperty("Blade__" + n, this.preSolveRgg(hashMap.get("T_EXP_VAR").toString(), 0, 4));
        this.setProperty("Petiole__" + n, this.preSolveRgg(hashMap.get("T_EXP_VAR").toString(), 1, 4));
        this.setProperty("Internode__" + n, this.preSolveRgg(hashMap.get("T_EXP_VAR").toString(), 2, 4));
        this.setProperty("Femalefruit__" + n, this.preSolveRgg(hashMap.get("T_EXP_VAR").toString(), 3, 4));
        this.setProperty("Malefruit__" + n, this.preSolveRgg(hashMap.get("T_EXP_VAR").toString(), 4, 4));
        this.setProperty("Root__" + n, this.preSolveRgg(hashMap.get("T_EXP_VAR").toString(), 5, 4));
        this.setProperty("Sink_Blade(S_B)", this.preSolveRgg(hashMap.get("S_O").toString(), 0, 6));
        this.setProperty("Sink_Petiole(S_P)", this.preSolveRgg(hashMap.get("S_O").toString(), 1, 6));
        this.setProperty("Sink_Internode(S_I)", this.preSolveRgg(hashMap.get("S_O").toString(), 2, 6));
        this.setProperty("Sink_Female(S_Ff)", this.preSolveRgg(hashMap.get("S_O").toString(), 3, 6));
        this.setProperty("Sink_Male(S_Fm)", this.preSolveRgg(hashMap.get("S_O").toString(), 4, 6));
        this.setProperty("Sink_Layer(S_L)", this.preSolveRgg(hashMap.get("S_O").toString(), 5, 6));
        this.setProperty("Sink_Root(S_R)", this.preSolveRgg(hashMap.get("S_O").toString(), 6, 6));
        this.backup = (HashMap)this.properties.clone();
    }
}

