/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.tracing.modular;

import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray2.Scene;
import de.grogra.ray2.tracing.modular.CombinedPathValues;
import de.grogra.vecmath.geom.Line;
import java.util.ArrayList;

public class MemoryHelper {
    ArrayList<Environment> freeEnvList;
    ArrayList<Environment> usedEnvList;
    ArrayList<Environment> markedEnvs2Remove;
    ArrayList<Line> freeLineList;
    ArrayList<Line> usedLineList;
    ArrayList<Line> markedLines2Remove;
    ArrayList<Spectrum> freeSpecList;
    ArrayList<Spectrum> usedSpecList;
    ArrayList<Spectrum> markedSpecs2Remove;
    int funcCallEnv;
    int funcCallLine;
    int funcCallSpec;

    public MemoryHelper(int n, Scene scene) {
        this.freeEnvList = new ArrayList(n);
        this.usedEnvList = new ArrayList(0);
        this.markedEnvs2Remove = new ArrayList(n);
        this.freeLineList = new ArrayList(n);
        this.usedLineList = new ArrayList(0);
        this.markedLines2Remove = new ArrayList(n);
        this.freeSpecList = new ArrayList(n);
        this.usedSpecList = new ArrayList(0);
        this.markedSpecs2Remove = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.freeEnvList.add(new Environment(scene.getBoundingBox(), scene.createSpectrum(), 1));
        }
    }

    public Environment getFreeEnvironment() {
        ++this.funcCallEnv;
        Environment environment = this.freeEnvList.remove(0);
        this.usedEnvList.add(environment);
        return environment;
    }

    public Line getFreeLine() {
        ++this.funcCallLine;
        Line line = this.freeLineList.remove(0);
        this.usedLineList.add(line);
        return line;
    }

    public Spectrum getFreeSpectrum() {
        ++this.funcCallSpec;
        Spectrum spectrum = this.freeSpecList.remove(0);
        this.usedSpecList.add(spectrum);
        return spectrum;
    }

    public void freeUnusedPathElements(CombinedPathValues combinedPathValues, CombinedPathValues combinedPathValues2) {
        for (Environment object : this.usedEnvList) {
            if (combinedPathValues.envList.contains(object) || combinedPathValues2.envList.contains(object)) continue;
            this.markedEnvs2Remove.add(object);
        }
        for (Environment environment : this.markedEnvs2Remove) {
            this.usedEnvList.remove(environment);
            this.freeEnvList.add(environment);
        }
        this.usedEnvList.trimToSize();
        this.freeEnvList.trimToSize();
        this.markedEnvs2Remove.clear();
        for (Line line : this.usedLineList) {
            if (combinedPathValues.rayListBE.contains(line) || combinedPathValues.rayListEB.contains(line) || combinedPathValues2.rayListBE.contains(line) || combinedPathValues2.rayListEB.contains(line)) continue;
            this.markedLines2Remove.add(line);
        }
        for (Line line : this.markedLines2Remove) {
            this.usedLineList.remove(line);
            this.freeLineList.add(line);
        }
        this.usedLineList.trimToSize();
        this.freeLineList.trimToSize();
        this.markedLines2Remove.clear();
        for (Spectrum spectrum : this.usedSpecList) {
            if (combinedPathValues.weightListBE.contains(spectrum) || combinedPathValues.weightListEB.contains(spectrum) || combinedPathValues2.weightListBE.contains(spectrum) || combinedPathValues2.weightListEB.contains(spectrum)) continue;
            this.markedSpecs2Remove.add(spectrum);
        }
        for (Spectrum spectrum : this.markedSpecs2Remove) {
            this.usedSpecList.remove(spectrum);
            this.freeSpecList.add(spectrum);
        }
        this.usedSpecList.trimToSize();
        this.freeSpecList.trimToSize();
        this.markedSpecs2Remove.clear();
    }
}

