/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.tracing.modular;

import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Scattering;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3d;
import de.grogra.ray.util.RayList;
import de.grogra.ray2.Scene;
import de.grogra.ray2.tracing.PixelwiseRenderer;
import de.grogra.ray2.tracing.modular.CombinedPathValues;
import de.grogra.ray2.tracing.modular.PathValues;
import de.grogra.vecmath.geom.Line;
import java.util.ArrayList;
import java.util.Random;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class ComplementTracer {
    static final double EPSILON = 1.0E-4;
    private boolean hasCombEdgeFailure = false;
    static final int BEGIN2END = 1;
    static final int END2BEGIN = 2;
    static int DIRECTION;
    RayList rays = new RayList();
    Scene scene;
    Random random;
    PathValues startPathValues;
    PathValues complementPathValues;
    CombinedPathValues resultPath;
    int startIndex;
    int complIndex;
    public ArrayList<Line> resultRayList;
    public ArrayList<Spectrum> resultWeightList;
    public ArrayList<Float> resultGeometryFactors;
    Vector3f tempVector1 = new Vector3f();
    Vector3f tempVector2 = new Vector3f();
    Vector3f tempVector3 = new Vector3f();
    Vector3f lastDirection = new Vector3f();
    int counter;
    int step;

    public ComplementTracer(Scene scene, Random random) {
        this.scene = scene;
        this.random = random;
    }

    public void complement2Paths(PathValues pathValues, int n, PathValues pathValues2, int n2, boolean bl, CombinedPathValues combinedPathValues) {
        int n3;
        this.resultPath = combinedPathValues;
        combinedPathValues.merge2Paths(pathValues, n, pathValues2, n2);
        combinedPathValues.pathResultList = pathValues2.pathResultList;
        combinedPathValues.lightID = pathValues.creatorID;
        combinedPathValues.sensorID = pathValues2.creatorID;
        combinedPathValues.specReflectionList[n] = pathValues.specReflectionList[n];
        combinedPathValues.specReflectionList[n + 1] = pathValues2.specReflectionList[n2];
        combinedPathValues.specRefractionList[n] = pathValues.specRefractionList[n];
        combinedPathValues.specRefractionList[n + 1] = pathValues2.specRefractionList[n2];
        if (PixelwiseRenderer.DEBUG_SUBPIXEL) {
            System.err.println("ComplementTracer: compl2Paths:  Before s=" + n + " t=" + n2);
            for (n3 = 0; n3 < n; ++n3) {
                System.err.println(" rLBE= " + ((Line)combinedPathValues.rayListBE.get((int)n3)).directionDensity);
            }
            for (n3 = 0; n3 < n; ++n3) {
                System.err.println(" geomFacBE= " + combinedPathValues.geometryFactorsBE.get(n3));
            }
            for (n3 = 0; n3 < n + n2 + 1; ++n3) {
                System.err.println(" rLEB= " + combinedPathValues.rayListEB.get((int)n3).directionDensity);
            }
            for (n3 = 0; n3 < n + n2 + 1; ++n3) {
                System.err.println(" geomFacEB= " + combinedPathValues.geometryFactorsEB.get(n3));
            }
        }
        this.traceComplement(pathValues, n, pathValues2, n2, bl, 1);
        if (combinedPathValues.isValid()) {
            this.traceComplement(pathValues2, n2, pathValues, n, !bl, 2);
        }
        if (PixelwiseRenderer.DEBUG_SUBPIXEL) {
            System.err.println("ComplementTracer: compl2Paths:  After  s=" + n + " t=" + n2);
            for (n3 = 0; n3 < n + n2; ++n3) {
                System.err.println(" rLBE= " + ((Line)combinedPathValues.rayListBE.get((int)n3)).directionDensity);
            }
            for (n3 = 0; n3 < n + n2; ++n3) {
                System.err.println(" geomFacBE= " + combinedPathValues.geometryFactorsBE.get(n3));
            }
            for (n3 = 0; n3 < n + n2; ++n3) {
                System.err.println(" rLEB= " + combinedPathValues.rayListEB.get((int)n3).directionDensity);
            }
            for (n3 = 0; n3 < n + n2; ++n3) {
                System.err.println(" geomFacEB= " + combinedPathValues.geometryFactorsEB.get(n3));
            }
        }
    }

    public void traceComplement(PathValues pathValues, int n, PathValues pathValues2, int n2, boolean bl, int n3) {
        this.startPathValues = pathValues;
        this.complementPathValues = pathValues2;
        DIRECTION = n3;
        this.hasCombEdgeFailure = false;
        this.startIndex = n;
        this.complIndex = n2;
        if (DIRECTION == 1) {
            this.resultRayList = this.resultPath.rayListBE;
            this.resultWeightList = this.resultPath.weightListBE;
            this.resultGeometryFactors = this.resultPath.geometryFactorsBE;
            this.step = 1;
            this.counter = n - 1;
        } else {
            this.resultRayList = this.resultPath.rayListEB;
            this.resultWeightList = this.resultPath.weightListEB;
            this.resultGeometryFactors = this.resultPath.geometryFactorsEB;
            this.step = -1;
            this.counter = n2 + 1;
        }
        Spectrum spectrum = this.scene.createSpectrum();
        Scattering scattering = this.startPathValues.shaderList.get(n);
        Environment environment = this.startPathValues.envList.get(n);
        Spectrum3d spectrum3d = n != 0 ? this.startPathValues.weightListBE.get(n - 1) : this.startPathValues.initialSpectrum;
        Environment environment2 = this.complementPathValues.envList.get(n2);
        this.tempVector1.sub((Tuple3f)environment2.point, (Tuple3f)environment.point);
        this.tempVector1.normalize();
        if (n != 0) {
            this.tempVector2.set((Tuple3d)pathValues.rayListBE.get((int)(n - 1)).direction);
        } else {
            this.tempVector2.set(0.0f, 0.0f, 0.0f);
        }
        this.tempVector2.negate();
        float f = 1.0f;
        if (scattering != null) {
            try {
                f = scattering.computeBSDF(environment, this.tempVector2, spectrum3d, this.tempVector1, bl, spectrum);
                if (this.startPathValues.isSpecular(n)) {
                    spectrum.scale(1.0E-10f);
                }
                if (f < 1.0E-6f) {
                    this.hasCombEdgeFailure = true;
                    this.resultPath.setValidFlag(false);
                    return;
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                spectrum.set(spectrum3d);
            }
        } else {
            spectrum.set(spectrum3d);
        }
        Line line = new Line();
        line.origin.set((Tuple3f)environment.point);
        line.direction.set((Tuple3f)this.tempVector1);
        line.directionDensity = f;
        float f2 = this.calculateGeometryfactor(environment2, n2, environment, 0, this.tempVector1);
        this.counter += this.step;
        this.save2ResultPath(this.counter, line, spectrum, f2);
        Vector3f vector3f = new Vector3f();
        vector3f.set((Tuple3f)this.tempVector1);
        vector3f.negate();
        if (n2 > 0) {
            this.traceRecursively(n2 - 1, vector3f, spectrum, bl);
        }
    }

    private void traceRecursively(int n, Vector3f vector3f, Spectrum spectrum, boolean bl) {
        Spectrum spectrum2 = this.scene.createSpectrum();
        Scattering scattering = this.complementPathValues.shaderList.get(n + 1);
        Environment environment = this.complementPathValues.envList.get(n + 1);
        this.tempVector1.set((Tuple3d)this.complementPathValues.rayListBE.get((int)n).direction);
        this.tempVector1.negate();
        this.tempVector1.normalize();
        this.tempVector2.set((Tuple3f)vector3f);
        float f = 1.0f;
        this.rays.clear();
        this.rays.setSize(1);
        if (scattering != null) {
            try {
                f = scattering.computeBSDF(environment, this.tempVector2, spectrum, this.tempVector1, bl, spectrum2);
                if (this.complementPathValues.isSpecular(n + 1)) {
                    spectrum2.scale(1.0E-10f);
                }
                if (f < 1.0E-6f) {
                    if (n + 1 == this.complIndex) {
                        this.resultPath.setValidFlag(false);
                    }
                    if (PixelwiseRenderer.DEBUG_SUBPIXEL) {
                        System.err.println("ComplementTracer:traceRecursively: Another edge behind Combining produced NULL-BSDF ?????????????????????????????????????????????????????????????");
                        System.err.println("  ComplTracer:traceRecursively:  DirectionDensity == ZERO  at " + n + " predeccor-Weight=  " + spectrum + "    And combining Edge has Failure=" + this.hasCombEdgeFailure);
                        System.err.println("  ComplPath: " + this.complementPathValues);
                        System.err.println("  complementing: Vec1=" + this.tempVector1 + " <---- Env.point=" + environment.point + " ----> Vec2=" + this.tempVector2);
                        System.err.println("  Combination-Indices: start-I=" + this.startIndex + " compl-I=" + this.complIndex);
                    }
                    this.resultPath.setValidFlag(false);
                    return;
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                spectrum2.set(spectrum);
            }
        } else {
            spectrum2.set(spectrum);
        }
        Line line = new Line();
        line.origin.set((Tuple3f)environment.point);
        line.direction.set((Tuple3f)this.tempVector1);
        line.directionDensity = f;
        float f2 = this.getGeometryFactor(n, this.complementPathValues);
        this.counter += this.step;
        this.save2ResultPath(this.counter, line, spectrum2, f2);
        Vector3f vector3f2 = new Vector3f();
        vector3f2.set((Tuple3f)this.tempVector1);
        vector3f2.negate();
        if (n > 0) {
            this.traceRecursively(n - 1, vector3f2, spectrum2, bl);
        }
    }

    float getGeometryFactor(int n, PathValues pathValues) {
        Environment environment = pathValues.envList.get(n);
        Environment environment2 = pathValues.envList.get(n + 1);
        this.tempVector3.sub((Tuple3f)environment.point, (Tuple3f)environment2.point);
        this.tempVector3.normalize();
        return this.calculateGeometryfactor(environment, n, environment2, n + 1, this.tempVector3);
    }

    public float calculateGeometryfactor(Environment environment, int n, Environment environment2, int n2, Vector3f vector3f) {
        Vector3f vector3f2 = new Vector3f(vector3f);
        vector3f2.normalize();
        if (environment.normal.length() != 0.0f) {
            environment.normal.normalize();
        }
        if (environment2.normal.length() != 0.0f) {
            environment2.normal.normalize();
        }
        float f = environment2.normal.length() != 0.0f ? environment2.normal.dot(vector3f2) : 1.0f;
        vector3f2.negate();
        float f2 = environment.normal.length() != 0.0f ? vector3f2.dot(environment.normal) : 1.0f;
        float f3 = Math.max(1.0f, environment.point.distanceSquared(environment2.point));
        float f4 = Math.abs(f2 * f) / f3;
        if (PixelwiseRenderer.DEBUG_SUBPIXEL) {
            System.err.println("ComplemtTracer:calculGeoFac: cosOut=" + f + " cosIn=" + f2 + " dist=" + f3 + " --> geomFac=" + f4);
        }
        return f4;
    }

    boolean isSpecularlyReflected(int n, Environment environment) {
        boolean bl = false;
        if (--n != 0) {
            Environment environment2 = this.complementPathValues.envList.get(n);
            this.tempVector1.sub((Tuple3f)environment.point, (Tuple3f)environment2.point);
            this.tempVector1.normalize();
            this.tempVector2.set((Tuple3d)this.complementPathValues.rayListBE.get((int)(n - 1)).direction);
            this.tempVector2.negate();
            bl = (double)Math.abs(environment2.normal.dot(this.tempVector1) - environment2.normal.dot(this.tempVector2)) <= 1.0E-4;
        }
        return bl;
    }

    void save2ResultPath(int n, Line line, Spectrum spectrum, float f) {
        if (this.resultRayList.size() > n) {
            this.resultRayList.set(n, line);
        } else {
            this.resultRayList.add(n, line);
        }
        if (this.resultWeightList.size() > n) {
            this.resultWeightList.set(n, spectrum);
        } else {
            this.resultWeightList.add(n, spectrum);
        }
        if (this.resultGeometryFactors.size() > n) {
            this.resultGeometryFactors.set(n, new Float(f));
        } else {
            this.resultGeometryFactors.add(n, new Float(f));
        }
    }
}

