/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.tracing;

import de.grogra.ray.physics.Spectrum;
import de.grogra.ray2.ProgressMonitor;
import de.grogra.ray2.Scene;
import de.grogra.ray2.tracing.RadiationModel;
import de.grogra.ray2.tracing.RadiationModelTask;
import de.grogra.xl.util.ObjectList;

public class ParallelRadiationModel
extends RadiationModel {
    private final Scene scene;
    private final int threadCount;

    public ParallelRadiationModel(Scene scene, int[] nArray, int n) {
        super(scene.createSpectrum(), (ObjectList<Spectrum>)new ObjectList(), (ObjectList<Spectrum>)new ObjectList(), nArray);
        this.scene = scene;
        if (n <= 0) {
            n = Runtime.getRuntime().availableProcessors();
        }
        this.threadCount = n;
    }

    public void compute(long l, long l2, ProgressMonitor progressMonitor, int n, double d) {
        RadiationModelTask radiationModelTask = new RadiationModelTask();
        l = (l + 1000L - 1L) / 1000L;
        radiationModelTask.compute(this.scene, l, l2, progressMonitor, n, d, (ObjectList<Spectrum>)this.radiantPowerSum, (ObjectList<Spectrum>)this.sensedIrradianceSum, this.idToGroup, this.threadCount);
    }
}

