/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.tracing;

import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Sensor;
import de.grogra.ray2.Options;
import de.grogra.ray2.ProgressMonitor;
import de.grogra.ray2.Resources;
import de.grogra.ray2.Scene;
import de.grogra.ray2.antialiasing.Antialiasing;
import de.grogra.ray2.antialiasing.MetropolisAntiAliasing;
import de.grogra.ray2.tracing.PixelwiseRenderer;
import de.grogra.task.PartialTask;
import de.grogra.task.Solver;
import de.grogra.task.SolverInOwnThread;
import de.grogra.xl.util.IntList;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.vecmath.Color4f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import net.goui.util.MTRandom;

public class MetropolisRenderer
extends PixelwiseRenderer {
    public static final String INITIAL_COUNT = "MetropolisPathTracer/initialCount";
    public static final String SEED_COUNT = "MetropolisPathTracer/seedCount";
    public static final String MUTATION_PP_COUNT = "MetropolisPathTracer/mutationPPCount";
    public static final int FIRST_STAGE = 0;
    public static final int SECOND_STAGE = 1;
    protected int[] pixelChangeArray;
    public static int initialCount = 20000;
    public static int seedPathCount = 100;
    public static int mutationPPCount = 1;
    public int mutatedPixPerProc;
    public int solverCount;
    public int notMutatedPixelsLeft;
    public static boolean twoStage_Ref;
    public static boolean directLightning_Ref;
    public static boolean expectedValues_Ref;
    public static boolean importanceSampling_Ref;
    public static int actRenderingStage;
    protected BufferedImage firstStageImage;
    protected int[] firstStageRgbaPixels;
    protected float[][] firstStageHdrPixels;
    protected Color4f firstStageBrightestValue;
    protected Color4f firstStageDarkestValue;
    protected Color4f firstStageAverageValue;
    protected static float testimageCorrectionFactor;
    public static int testimageMutperPix;
    protected MTRandom rnd;
    int nextImageUpdateI;
    long nextImageUpdateTime;
    int maxY = 0;
    float maxYFloat = 0.0f;

    public synchronized void stop() {
        super.stop();
        ((MetropolisAntiAliasing)this.antialiasing).stopProcessor();
    }

    public void initialize(Options options, ProgressMonitor progressMonitor) {
        super.initialize(options, progressMonitor);
        initialCount = this.getNumericOption(INITIAL_COUNT, 100000).intValue();
        assert (initialCount >= 1);
        System.err.println(" MetroRenderer: initialize: initialCount=" + initialCount);
        seedPathCount = this.getNumericOption(SEED_COUNT, 10000).intValue();
        assert (seedPathCount >= 1);
        System.err.println(" MetroRenderer: initialize: seedPathCount=" + seedPathCount);
        mutationPPCount = this.getNumericOption(MUTATION_PP_COUNT, 10000).intValue();
        assert (mutationPPCount >= 1);
        twoStage_Ref = false;
        directLightning_Ref = false;
        expectedValues_Ref = true;
        importanceSampling_Ref = false;
        System.err.println(" MetroRenderer: initialize: mutationPPCount=" + mutationPPCount);
        this.antialiasing = new MetropolisAntiAliasing();
        this.rnd = new MTRandom(this.getSeed());
        changedPixels = 0;
    }

    public void render(Scene scene, Sensor sensor, Matrix4d matrix4d, int n, int n2, ImageObserver imageObserver) {
        int n3;
        changedPixels = 0;
        this.pixelChangeArray = new int[n * n2];
        int n4 = n3 = this.threadCount >= 2 ? this.threadCount : 1;
        if (twoStage_Ref) {
            actRenderingStage = 0;
            if (this.hdr) {
                this.firstStageHdrPixels = new float[4][n * n2];
                DataBufferFloat dataBufferFloat = new DataBufferFloat(this.firstStageHdrPixels, this.firstStageHdrPixels[0].length);
                BandedSampleModel bandedSampleModel = new BandedSampleModel(dataBufferFloat.getDataType(), n, n2, 4);
                WritableRaster writableRaster = Raster.createWritableRaster(bandedSampleModel, dataBufferFloat, null);
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, true, false, 3, dataBufferFloat.getDataType());
                this.firstStageImage = new BufferedImage(componentColorModel, writableRaster, false, null);
            } else {
                this.firstStageImage = new BufferedImage(n, n2, 2);
                this.firstStageRgbaPixels = ((DataBufferInt)this.firstStageImage.getRaster().getDataBuffer()).getData();
            }
            mutationPPCount = testimageMutperPix;
            this.notMutatedPixelsLeft = mutationPPCount * n * n2;
            this.mutatedPixPerProc = Math.round((float)this.notMutatedPixelsLeft / (float)n3) + 1;
            System.err.println(" MetroRend: renderer: ************************************* First Stage!*********************");
            super.render(scene, sensor, matrix4d, n, n2, imageObserver);
            this.prefilterTestImage3();
            mutationPPCount = this.getNumericOption(MUTATION_PP_COUNT, 10000).intValue();
            assert (mutationPPCount >= 1);
            this.pixelChangeArray = new int[n * n2];
            changedPixels = 0;
            System.err.println(" MetroRend: renderer: ************************************ Second Stage!*********************");
        }
        actRenderingStage = 1;
        this.notMutatedPixelsLeft = mutationPPCount * n * n2;
        this.mutatedPixPerProc = Math.round((float)this.notMutatedPixelsLeft / (float)n3) + 1;
        super.render(scene, sensor, matrix4d, n, n2, imageObserver);
    }

    public Solver createLocalSolver(final boolean bl) {
        final Antialiasing antialiasing = this.antialiasing.dup(this.originalScene.dup());
        ++this.solverCount;
        return new SolverInOwnThread(){
            private final MetropolisResult result = new MetropolisResult();

            protected void solveImpl(PartialTask partialTask) {
                MetropolisRenderer.this.renderMLT(antialiasing, ((MLTTask)partialTask).mutatedPixPerProc, MetropolisRenderer.this.solverCount, this.result);
            }

            protected Thread createThread() {
                if (bl) {
                    return null;
                }
                Thread thread = new Thread((Runnable)this, this.toString());
                thread.setPriority(1);
                return thread;
            }
        };
    }

    protected PartialTask nextPartialTask(int n) {
        MLTTask mLTTask = new MLTTask();
        if (this.notMutatedPixelsLeft > this.mutatedPixPerProc) {
            this.notMutatedPixelsLeft -= this.mutatedPixPerProc;
            mLTTask.mutatedPixPerProc = this.mutatedPixPerProc;
            return mLTTask;
        }
        if (this.notMutatedPixelsLeft > 0) {
            mLTTask.mutatedPixPerProc = this.notMutatedPixelsLeft;
            this.notMutatedPixelsLeft = 0;
            return mLTTask;
        }
        return null;
    }

    protected void dispose(PartialTask partialTask) {
    }

    public synchronized void increaseNotMutatedPixels(int n) {
        this.notMutatedPixelsLeft += n;
    }

    protected synchronized boolean done() {
        System.err.println("  MetroRender: done()    ret=" + (changedPixels >= this.width * this.height * mutationPPCount));
        System.err.println("  MetroRender: done()    changed= " + changedPixels + "  target= " + this.width * this.height * mutationPPCount);
        return changedPixels >= this.width * this.height * mutationPPCount - 10;
    }

    protected void renderMLT(Antialiasing antialiasing, int n, int n2, PixelwiseRenderer.Result result) {
        System.err.println(" MetroRenderer: renderMLT:  \n \n  SolverNo:" + n2 + "\n  mutatedPixPerProc:" + n + "\n  imWidth= " + this.width + "  imHeight= " + this.height + "\n" + "\n  mutationPerPix= " + mutationPPCount + "  threads= " + this.threadCount + "  InitialPaths= " + seedPathCount);
        ((MetropolisAntiAliasing)antialiasing).resetAll();
        ((MetropolisAntiAliasing)antialiasing).signAntialiser2Processor();
        double d = 2.0 / (double)this.width;
        double d2 = 2.0 / (double)this.height;
        Color4f color4f = new Color4f();
        result.lines.setSize(0);
        result.data.setSize(0);
        MTRandom mTRandom = new MTRandom();
        int n3 = 0;
        int n4 = 0;
        for (int i = n; n3 < i; i -= n3) {
            int n5 = Math.round((float)i / (float)seedPathCount) + 1;
            ((MetropolisAntiAliasing)antialiasing).initializeProccessorLoop(this.getBrightness(), this.width, this.height, n5, (MetropolisResult)result, n2);
            mTRandom.setSeed(this.seed + 25214903917L * (long)(seedPathCount + n4));
            System.err.println(" MetroRend: renderMLT: Before loop " + ++n4 + "  target Mutation Count= " + i);
            for (int j = 0; j < seedPathCount; ++j) {
                ((MetropolisAntiAliasing)antialiasing).pathChanged();
                float f = (float)mTRandom.nextInt(this.height) + 0.5f;
                float f2 = (float)mTRandom.nextInt(this.width) + 0.5f;
                if (this.isStopped()) {
                    return;
                }
                DEBUG_SUBPIXEL = DEBUG_PIXEL = (int)f2 == DEBUG_X && (int)f == DEBUG_Y;
                DEBUG_SUBPIXEL = (int)f == Math.round((float)this.height * DEBUG_LINE);
                ((MetropolisAntiAliasing)antialiasing).setPixelXY(f2, f);
                antialiasing.getColorOfRectangle((double)f2 * d - 1.0, (0.5 * (double)this.height - (double)(f + 1.0f)) * d, d, d, color4f, mTRandom);
                n3 += ((MetropolisAntiAliasing)antialiasing).getProcessorMutatedPixels();
            }
            System.err.println(" MetroRend: renderMLT: After loop " + n4 + "  target Mutation Count= " + i + " reached mutation count=" + n3);
            n3 = 0;
        }
    }

    public synchronized void merge(PixelwiseRenderer.Result result) {
        float[] fArray = result.data.elements;
        float f = this.maxValue;
        for (int i = 0; i <= ((MetropolisResult)result).lastIndex; ++i) {
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            int n = result.lines.elements[i];
            int n2 = ((MetropolisResult)result).cols.elements[i];
            int n3 = i * 4;
            int n4 = n2 + n * this.width;
            if (this.autoAdjust) {
                float f7 = fArray[n3 + 3];
                if (f7 * fArray[n3] > f) {
                    f = f7 * fArray[n3];
                }
                if (f7 * fArray[n3 + 1] > f) {
                    f = f7 * fArray[n3 + 1];
                }
                if (f7 * fArray[n3 + 2] > f) {
                    f = f7 * fArray[n3 + 2];
                }
            }
            int n5 = this.pixelChangeArray[n4];
            if (this.hdr) {
                f6 = this.brightness / Math.max(this.hdrPixels[3][n4], 0.001f);
                float[] fArray2 = this.hdrPixels[0];
                int n6 = n4;
                fArray2[n6] = fArray2[n6] * (1.0f / f6);
                float[] fArray3 = this.hdrPixels[1];
                int n7 = n4;
                fArray3[n7] = fArray3[n7] * (1.0f / f6);
                float[] fArray4 = this.hdrPixels[2];
                int n8 = n4;
                fArray4[n8] = fArray4[n8] * (1.0f / f6);
                this.hdrPixels[3][n4] = (this.hdrPixels[3][n4] * (float)n5 + fArray[n3 + 3]) / (float)(n5 + 1);
                f5 = this.brightness / Math.max(this.hdrPixels[3][n4], 0.001f);
                float[] fArray5 = this.hdrPixels[0];
                int n9 = n4;
                fArray5[n9] = fArray5[n9] + fArray[n3];
                float[] fArray6 = this.hdrPixels[1];
                int n10 = n4;
                fArray6[n10] = fArray6[n10] + fArray[n3 + 1];
                float[] fArray7 = this.hdrPixels[2];
                int n11 = n4;
                fArray7[n11] = fArray7[n11] + fArray[n3 + 2];
                float[] fArray8 = this.hdrPixels[0];
                int n12 = n4;
                fArray8[n12] = fArray8[n12] * f5;
                float[] fArray9 = this.hdrPixels[1];
                int n13 = n4;
                fArray9[n13] = fArray9[n13] * f5;
                float[] fArray10 = this.hdrPixels[2];
                int n14 = n4;
                fArray10[n14] = fArray10[n14] * f5;
                if (this.luminance(this.hdrPixels[0][n4], this.hdrPixels[1][n4], this.hdrPixels[2][n4]) > this.luminance(this.maxColor.x, this.maxColor.y, this.maxColor.z)) {
                    this.maxColor.x = this.hdrPixels[0][n4];
                    this.maxColor.y = this.hdrPixels[1][n4];
                    this.maxColor.z = this.hdrPixels[2][n4];
                    this.maxColor.w = this.hdrPixels[3][n4];
                }
                if (this.luminance(this.hdrPixels[0][n4], this.hdrPixels[1][n4], this.hdrPixels[2][n4]) < this.luminance(this.minColor.x, this.minColor.y, this.minColor.z)) {
                    this.minColor.x = this.hdrPixels[0][n4];
                    this.minColor.y = this.hdrPixels[1][n4];
                    this.minColor.z = this.hdrPixels[2][n4];
                    this.minColor.w = this.hdrPixels[3][n4];
                }
            } else {
                float[] fArray11 = MetropolisRenderer.toRGBA(this.rgbaPixels[n4]);
                f5 = fArray[n3] + fArray11[0];
                f4 = fArray[n3 + 1] + fArray11[1];
                f3 = fArray[n3 + 2] + fArray11[2];
                f2 = (fArray[n3 + 3] + fArray11[3] * (float)n5) / (float)(n5 + 1);
                this.rgbaPixels[n4] = MetropolisRenderer.toIntColor(f5, f4, f3, f2);
            }
            if (twoStage_Ref && actRenderingStage == 0) {
                if (this.hdr) {
                    f6 = this.brightness / Math.max(this.firstStageHdrPixels[3][n4], 0.001f);
                    float[] fArray12 = this.firstStageHdrPixels[0];
                    int n15 = n4;
                    fArray12[n15] = fArray12[n15] * (1.0f / f6);
                    float[] fArray13 = this.firstStageHdrPixels[1];
                    int n16 = n4;
                    fArray13[n16] = fArray13[n16] * (1.0f / f6);
                    float[] fArray14 = this.firstStageHdrPixels[2];
                    int n17 = n4;
                    fArray14[n17] = fArray14[n17] * (1.0f / f6);
                    this.firstStageHdrPixels[3][n4] = (this.firstStageHdrPixels[3][n4] * (float)n5 + fArray[n3 + 3]) / (float)(n5 + 1);
                    f5 = this.brightness / Math.max(this.hdrPixels[3][n4], 0.001f);
                    float[] fArray15 = this.firstStageHdrPixels[0];
                    int n18 = n4;
                    fArray15[n18] = fArray15[n18] + fArray[n3];
                    float[] fArray16 = this.firstStageHdrPixels[1];
                    int n19 = n4;
                    fArray16[n19] = fArray16[n19] + fArray[n3 + 1];
                    float[] fArray17 = this.firstStageHdrPixels[2];
                    int n20 = n4;
                    fArray17[n20] = fArray17[n20] + fArray[n3 + 2];
                    float[] fArray18 = this.firstStageHdrPixels[0];
                    int n21 = n4;
                    fArray18[n21] = fArray18[n21] * f5;
                    float[] fArray19 = this.firstStageHdrPixels[1];
                    int n22 = n4;
                    fArray19[n22] = fArray19[n22] * f5;
                    float[] fArray20 = this.firstStageHdrPixels[2];
                    int n23 = n4;
                    fArray20[n23] = fArray20[n23] * f5;
                } else {
                    float[] fArray21 = MetropolisRenderer.toRGBA(this.firstStageRgbaPixels[n4]);
                    f5 = fArray[n3] + fArray21[0];
                    f4 = fArray[n3 + 1] + fArray21[1];
                    f3 = fArray[n3 + 2] + fArray21[2];
                    f2 = (fArray[n3 + 3] + fArray21[3] * (float)n5) / (float)(n5 + 1);
                    this.firstStageRgbaPixels[n4] = MetropolisRenderer.toIntColor(f5, f4, f3, f2);
                }
            }
            int n24 = n4;
            this.pixelChangeArray[n24] = this.pixelChangeArray[n24] + 1;
            ++changedPixels;
        }
        this.maxValue = f;
        this.observer.imageUpdate(this.image, 8, 0, 0, this.width, this.height);
        if (this.monitor != null) {
            float f8 = (float)changedPixels / (float)(this.width * this.height) / (float)mutationPPCount;
            this.monitor.setProgress(Resources.msg("renderer.rendering", new Float(f8)), f8);
        }
    }

    public float[] getPixelsForLine2Vertex(Environment environment, Point3d point3d) {
        float[] fArray = new float[]{-1.0f, -1.0f};
        double d = 2.0 / (double)this.width;
        double d2 = 2.0 / (double)this.height;
        float[] fArray2 = this.getCamera().getUVForVertex(environment, point3d);
        if (fArray2[0] == -10.0f || fArray2[1] == -10.0f) {
            return fArray;
        }
        fArray[0] = Math.min((float)((double)(fArray2[0] + 1.0f) / d), (float)(this.width - 1));
        fArray[1] = (float)((double)(-fArray2[1]) / d + 0.5 * (double)this.height - 1.0);
        if (fArray[0] < 0.0f || fArray[0] >= (float)this.width) {
            return new float[]{-1.0f, -1.0f};
        }
        if (fArray[1] < 0.0f || fArray[1] >= (float)this.height) {
            return new float[]{-1.0f, -1.0f};
        }
        this.maxY = (int)Math.max(fArray[1], (float)this.maxY);
        this.maxYFloat = Math.min(fArray2[1], this.maxYFloat);
        return fArray;
    }

    public float getFirstStageImageValue(int n, int n2) {
        int n3 = n + n2 * this.width;
        float f = 0.0f;
        if (this.hdr) {
            double d = this.firstStageHdrPixels[0][n3];
            double d2 = this.firstStageHdrPixels[1][n3];
            double d3 = this.firstStageHdrPixels[2][n3];
            f = this.luminance(d, d2, d3);
        } else {
            float[] fArray = MetropolisRenderer.toRGBA(this.firstStageRgbaPixels[n3]);
            double d = fArray[0];
            double d4 = fArray[1];
            double d5 = fArray[2];
            f = this.luminance(d, d4, d5);
        }
        return f;
    }

    private void prefilterTestImage1() {
        float f;
        int n;
        int n2;
        this.firstStageBrightestValue = new Color4f();
        this.firstStageAverageValue = new Color4f();
        int n3 = 0;
        for (n2 = 0; n2 < this.width; ++n2) {
            for (n = 0; n < this.height; ++n) {
                f = this.getFirstStageImageValue(n2, n);
                float f2 = this.luminance(this.firstStageBrightestValue.x, this.firstStageBrightestValue.y, this.firstStageBrightestValue.z);
                int n4 = n2 + n * this.width;
                if (f > f2) {
                    this.setExtremumValue(this.firstStageBrightestValue, n4);
                }
                if (!(f > 0.0f)) continue;
                this.add2ExtremumValue(this.firstStageAverageValue, n4);
                ++n3;
            }
        }
        this.firstStageAverageValue.scale(1.0f / (float)n3);
        for (n2 = 0; n2 < this.width; ++n2) {
            for (n = 0; n < this.height; ++n) {
                int n5;
                f = this.getFirstStageImageValue(n2, n);
                int n6 = n2 + n * this.width;
                if (f != 0.0f) continue;
                float f3 = this.firstStageAverageValue.x;
                float f4 = this.firstStageAverageValue.y;
                float f5 = this.firstStageAverageValue.z;
                float f6 = this.firstStageAverageValue.w;
                if (this.hdr) {
                    this.firstStageHdrPixels[0][n6] = f3;
                    this.firstStageHdrPixels[1][n6] = f4;
                    this.firstStageHdrPixels[2][n6] = f5;
                    this.firstStageHdrPixels[3][n6] = f6;
                    continue;
                }
                this.firstStageRgbaPixels[n6] = n5 = MetropolisRenderer.toIntColor(f3, f4, f5, f6);
            }
        }
    }

    private void prefilterTestImage3() {
        int n;
        float f;
        float f2;
        int n2;
        int n3;
        this.firstStageBrightestValue = new Color4f();
        this.firstStageAverageValue = new Color4f();
        int n4 = 0;
        for (n3 = 0; n3 < this.width; ++n3) {
            for (n2 = 0; n2 < this.height; ++n2) {
                f2 = this.getFirstStageImageValue(n3, n2);
                f = this.luminance(this.firstStageBrightestValue.x, this.firstStageBrightestValue.y, this.firstStageBrightestValue.z);
                n = n3 + n2 * this.width;
                if (f2 > f) {
                    this.setExtremumValue(this.firstStageBrightestValue, n);
                }
                if (!(f2 > 0.0f)) continue;
                this.add2ExtremumValue(this.firstStageAverageValue, n);
                ++n4;
            }
        }
        if (testimageCorrectionFactor <= 1.0f) {
            this.firstStageDarkestValue = new Color4f(this.firstStageBrightestValue);
            for (n3 = 0; n3 < this.width; ++n3) {
                for (n2 = 0; n2 < this.height; ++n2) {
                    f2 = this.getFirstStageImageValue(n3, n2);
                    f = this.luminance(this.firstStageDarkestValue.x, this.firstStageDarkestValue.y, this.firstStageDarkestValue.z);
                    if (!(f2 > 0.0f) || !(f2 < f)) continue;
                    n = n3 + n2 * this.width;
                    this.setExtremumValue(this.firstStageDarkestValue, n);
                }
            }
            for (n3 = 0; n3 < this.width; ++n3) {
                for (n2 = 0; n2 < this.height; ++n2) {
                    int n5;
                    f2 = this.getFirstStageImageValue(n3, n2);
                    int n6 = n3 + n2 * this.width;
                    if (f2 != 0.0f) continue;
                    float f3 = this.firstStageDarkestValue.x;
                    float f4 = this.firstStageDarkestValue.y;
                    float f5 = this.firstStageDarkestValue.z;
                    float f6 = this.firstStageDarkestValue.w;
                    if (this.hdr) {
                        this.firstStageHdrPixels[0][n6] = f3;
                        this.firstStageHdrPixels[1][n6] = f4;
                        this.firstStageHdrPixels[2][n6] = f5;
                        this.firstStageHdrPixels[3][n6] = f6;
                        continue;
                    }
                    this.firstStageRgbaPixels[n6] = n5 = MetropolisRenderer.toIntColor(f3, f4, f5, f6);
                }
            }
        } else {
            this.firstStageAverageValue.scale(1.0f / (float)n4);
            float f7 = 1.0f + 1.0f / testimageCorrectionFactor;
            for (n2 = 0; n2 < this.width; ++n2) {
                for (int i = 0; i < this.height; ++i) {
                    int n7;
                    f = this.getFirstStageImageValue(n2, i);
                    float f8 = this.luminance(this.firstStageAverageValue.x, this.firstStageAverageValue.y, this.firstStageAverageValue.z);
                    int n8 = n2 + i * this.width;
                    if (f >= f8 * f7) {
                        float f9 = f8 / f * f7;
                        if (this.hdr) {
                            float[] fArray = this.firstStageHdrPixels[0];
                            int n9 = n8;
                            fArray[n9] = fArray[n9] * f9;
                            float[] fArray2 = this.firstStageHdrPixels[1];
                            int n10 = n8;
                            fArray2[n10] = fArray2[n10] * f9;
                            float[] fArray3 = this.firstStageHdrPixels[2];
                            int n11 = n8;
                            fArray3[n11] = fArray3[n11] * f9;
                            float[] fArray4 = this.firstStageHdrPixels[3];
                            int n12 = n8;
                            fArray4[n12] = fArray4[n12] * f9;
                        } else {
                            int n13;
                            float[] fArray = MetropolisRenderer.toRGBA(this.firstStageRgbaPixels[n8]);
                            fArray[0] = fArray[0] * f9;
                            fArray[1] = fArray[1] * f9;
                            fArray[2] = fArray[2] * f9;
                            fArray[3] = fArray[3] * f9;
                            this.firstStageRgbaPixels[n8] = n13 = MetropolisRenderer.toIntColor(fArray[0], fArray[1], fArray[2], fArray[3]);
                        }
                    }
                    if (this.hdr) {
                        this.firstStageHdrPixels[0][n8] = this.firstStageAverageValue.x - (this.firstStageAverageValue.x - this.firstStageHdrPixels[0][n8]) / testimageCorrectionFactor;
                        this.firstStageHdrPixels[1][n8] = this.firstStageAverageValue.y - (this.firstStageAverageValue.y - this.firstStageHdrPixels[1][n8]) / testimageCorrectionFactor;
                        this.firstStageHdrPixels[2][n8] = this.firstStageAverageValue.z - (this.firstStageAverageValue.z - this.firstStageHdrPixels[2][n8]) / testimageCorrectionFactor;
                        this.firstStageHdrPixels[3][n8] = this.firstStageAverageValue.w - (this.firstStageAverageValue.w - this.firstStageHdrPixels[3][n8]) / testimageCorrectionFactor;
                        continue;
                    }
                    float[] fArray = MetropolisRenderer.toRGBA(this.firstStageRgbaPixels[n8]);
                    fArray[0] = this.firstStageAverageValue.x - (this.firstStageAverageValue.x - fArray[0]) / testimageCorrectionFactor;
                    fArray[1] = this.firstStageAverageValue.y - (this.firstStageAverageValue.y - fArray[1]) / testimageCorrectionFactor;
                    fArray[2] = this.firstStageAverageValue.z - (this.firstStageAverageValue.z - fArray[2]) / testimageCorrectionFactor;
                    fArray[3] = this.firstStageAverageValue.w - (this.firstStageAverageValue.w - fArray[3]) / testimageCorrectionFactor;
                    this.firstStageRgbaPixels[n8] = n7 = MetropolisRenderer.toIntColor(fArray[0], fArray[1], fArray[2], fArray[3]);
                }
            }
        }
    }

    private void prefilterTestImage2() {
        int n;
        float f;
        float f2;
        int n2;
        int n3;
        this.firstStageBrightestValue = new Color4f();
        for (n3 = 0; n3 < this.width; ++n3) {
            for (n2 = 0; n2 < this.height; ++n2) {
                f2 = this.getFirstStageImageValue(n3, n2);
                f = this.luminance(this.firstStageBrightestValue.x, this.firstStageBrightestValue.y, this.firstStageBrightestValue.z);
                n = n3 + n2 * this.width;
                if (!(f2 > f)) continue;
                this.setExtremumValue(this.firstStageBrightestValue, n);
            }
        }
        this.firstStageDarkestValue = new Color4f(this.firstStageBrightestValue);
        for (n3 = 0; n3 < this.width; ++n3) {
            for (n2 = 0; n2 < this.height; ++n2) {
                f2 = this.getFirstStageImageValue(n3, n2);
                f = this.luminance(this.firstStageDarkestValue.x, this.firstStageDarkestValue.y, this.firstStageDarkestValue.z);
                if (!(f2 > 0.0f) || !(f2 < f)) continue;
                n = n3 + n2 * this.width;
                this.setExtremumValue(this.firstStageDarkestValue, n);
            }
        }
        for (n3 = 0; n3 < this.width; ++n3) {
            for (n2 = 0; n2 < this.height; ++n2) {
                int n4;
                f2 = this.getFirstStageImageValue(n3, n2);
                int n5 = n3 + n2 * this.width;
                if (f2 != 0.0f) continue;
                float f3 = this.firstStageDarkestValue.x;
                float f4 = this.firstStageDarkestValue.y;
                float f5 = this.firstStageDarkestValue.z;
                float f6 = this.firstStageDarkestValue.w;
                if (this.hdr) {
                    this.firstStageHdrPixels[0][n5] = f3;
                    this.firstStageHdrPixels[1][n5] = f4;
                    this.firstStageHdrPixels[2][n5] = f5;
                    this.firstStageHdrPixels[3][n5] = f6;
                    continue;
                }
                this.firstStageRgbaPixels[n5] = n4 = MetropolisRenderer.toIntColor(f3, f4, f5, f6);
            }
        }
    }

    private void setExtremumValue(Color4f color4f, int n) {
        if (this.hdr) {
            color4f.x = this.firstStageHdrPixels[0][n];
            color4f.y = this.firstStageHdrPixels[1][n];
            color4f.z = this.firstStageHdrPixels[2][n];
            color4f.w = this.firstStageHdrPixels[3][n];
        } else {
            float[] fArray = MetropolisRenderer.toRGBA(this.firstStageRgbaPixels[n]);
            color4f.x = fArray[0];
            color4f.y = fArray[1];
            color4f.z = fArray[2];
            color4f.w = fArray[3];
        }
    }

    private void add2ExtremumValue(Color4f color4f, int n) {
        if (this.hdr) {
            color4f.x += this.firstStageHdrPixels[0][n];
            color4f.y += this.firstStageHdrPixels[1][n];
            color4f.z += this.firstStageHdrPixels[2][n];
            color4f.w += this.firstStageHdrPixels[3][n];
        } else {
            float[] fArray = MetropolisRenderer.toRGBA(this.firstStageRgbaPixels[n]);
            color4f.x += fArray[0];
            color4f.y += fArray[1];
            color4f.z += fArray[2];
            color4f.w += fArray[3];
        }
    }

    static {
        testimageMutperPix = 1;
    }

    public static class MLTTask
    implements PartialTask {
        public int mutatedPixPerProc;
    }

    public static class MetropolisResult
    extends PixelwiseRenderer.Result {
        public IntList cols = new IntList(500);
        public int lastIndex = 0;
    }
}

