/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.tracing;

import de.grogra.ray.physics.Collector;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Light;
import de.grogra.ray.physics.Scattering;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import de.grogra.ray2.ProgressMonitor;
import de.grogra.ray2.Scene;
import de.grogra.ray2.tracing.RadiationModel;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.xl.util.ObjectList;
import java.util.Random;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.goui.util.MTRandom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LightModelProcessor
extends RadiationModel
implements Cloneable {
    private Scene scene;
    private RayList rays;
    private Environment env;
    private Vector3f out;
    private Line line;
    private ObjectList<Spectrum> radiantPower;
    private ObjectList<Spectrum> sensedIrradiance;
    private Spectrum tmpSpectrum0;
    private Spectrum tmpSpectrum1;
    private Spectrum tmpSpectrum2;
    private Spectrum tmpSpectrum3;
    private IntersectionList ilist;
    private double minPower;
    private int depth;

    public LightModelProcessor(Scene scene, int[] nArray) {
        this(scene, (ObjectList<Spectrum>)new ObjectList(), (ObjectList<Spectrum>)new ObjectList(), nArray);
    }

    public LightModelProcessor(Scene scene, ObjectList<Spectrum> objectList, ObjectList<Spectrum> objectList2, int[] nArray) {
        super(scene.createSpectrum(), objectList, objectList2, nArray);
        this.scene = scene;
        this.initLocals();
    }

    protected void initLocals() {
        this.rays = new RayList(this.black);
        this.tmpSpectrum0 = this.black.newInstance();
        this.tmpSpectrum1 = this.black.newInstance();
        this.tmpSpectrum2 = this.black.newInstance();
        this.tmpSpectrum3 = this.black.newInstance();
        this.out = new Vector3f();
        this.line = new Line();
        this.env = new Environment(this.scene.getBoundingBox(), this.black, 2);
        this.radiantPower = new ObjectList();
        this.sensedIrradiance = new ObjectList();
        this.ilist = new IntersectionList();
    }

    public LightModelProcessor dup(Scene scene) {
        try {
            LightModelProcessor lightModelProcessor = (LightModelProcessor)super.clone();
            lightModelProcessor.scene = scene;
            lightModelProcessor.initLocals();
            return lightModelProcessor;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    @Override
    public void compute(long l, long l2, ProgressMonitor progressMonitor, int n, double d) {
        Light[] lightArray = this.scene.getLights();
        int n2 = lightArray.length;
        if (n2 == 0) {
            return;
        }
        this.depth = n;
        Environment environment = new Environment(this.scene.getBoundingBox(), this.black, 2);
        double[] dArray = new double[n2];
        double d2 = 0.0;
        for (int i = 0; i < n2; ++i) {
            dArray[i] = lightArray[i].getTotalPower(environment);
            d2 += dArray[i];
        }
        if (!(d2 > 0.0)) {
            return;
        }
        l = (l + 1000L - 1L) / 1000L;
        long[] lArray = new long[n2];
        long l3 = 0L;
        for (int i = 0; i < n2; ++i) {
            lArray[i] = (long)((double)l * dArray[i] / d2);
            l3 += lArray[i];
        }
        MTRandom mTRandom = new MTRandom(l2);
        while (l > l3) {
            int n3 = mTRandom.nextInt(n2);
            if (!(dArray[n3] > 0.0)) continue;
            int n4 = n3;
            lArray[n4] = lArray[n4] + 1L;
            ++l3;
        }
        double[] dArray2 = new double[n2];
        long[] lArray2 = new long[n2];
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = 1.0 / (double)lArray[i];
            lArray2[i] = (l2 * (long)n2 + (long)i) * l;
        }
        this.computeImpl(lArray, lArray2, dArray2, mTRandom, progressMonitor, n, d);
    }

    void computeImpl(long[] lArray, long[] lArray2, double[] dArray, Random random, ProgressMonitor progressMonitor, int n, double d) {
        this.minPower = d;
        this.depth = n;
        Light[] lightArray = this.scene.getLights();
        int n2 = lightArray.length;
        RayList rayList = new RayList(this.black);
        rayList.setSize(1000);
        RayList rayList2 = new RayList(this.black);
        rayList2.setSize(1);
        Environment environment = new Environment(this.scene.getBoundingBox(), this.black, 2);
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            l += lArray[i];
        }
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        for (int i = 0; i < n2; ++i) {
            long l4 = lArray[i];
            for (long j = 0L; j < l4; ++j) {
                ++l3;
                random.setSeed(lArray2[i] + j);
                environment.localToGlobal.set(this.scene.getLightTransformation(i));
                environment.globalToLocal.set(this.scene.getInverseLightTransformation(i));
                Light light = lightArray[i];
                light.generateRandomOrigins(environment, rayList, random);
                for (int k = 0; k < 1000; ++k) {
                    rayList2.rays[0].origin.set((Tuple3f)rayList.rays[k].origin);
                    light.generateRandomRays(environment, null, rayList.rays[k].spectrum, rayList2, true, random);
                    this.ilist.clear();
                    this.traceRay(n, rayList2.rays[0], null, random, dArray[i]);
                }
                if (progressMonitor == null) continue;
                long l5 = System.currentTimeMillis();
                if (l3 < l && l5 - l2 <= 500L) continue;
                progressMonitor.setProgress("Ray " + l3 * 1000L + " of " + l * 1000L, (float)l3 / (float)l);
                l2 = l5;
            }
            if (lArray[i] <= 0L) continue;
            LightModelProcessor.addAndClear(dArray[i] * 0.001, this.radiantPower, (ObjectList<Spectrum>)this.radiantPowerSum);
            LightModelProcessor.addAndClear(dArray[i] * 0.001, this.sensedIrradiance, (ObjectList<Spectrum>)this.sensedIrradianceSum);
        }
    }

    void traceRay(int n, Ray ray, Intersection intersection, Random random, double d) {
        this.line.origin.set((Tuple3f)ray.getOrigin());
        this.line.direction.set((Tuple3f)ray.getDirection());
        this.line.start = 1.0E-5;
        this.line.end = Double.POSITIVE_INFINITY;
        Spectrum spectrum = this.tmpSpectrum0;
        spectrum.set(ray.spectrum);
        this.tmpSpectrum3.set(ray.spectrum);
        this.tmpSpectrum3.clampMinZero();
        int n2 = this.ilist.size;
        this.scene.computeIntersections(this.line, 1, this.ilist, intersection, null);
        if (this.ilist.size > n2) {
            Intersection intersection2 = this.ilist.elements[n2];
            if (intersection2.parameter < Double.POSITIVE_INFINITY) {
                Object object;
                Scattering scattering;
                int n3 = this.idToGroup[intersection2.volume.getId()];
                this.out.set((Tuple3d)this.line.direction);
                this.out.negate();
                int n4 = this.scene.getSensor(intersection2.volume);
                if (n4 >= 0) {
                    scattering = this.scene.getSensors()[n4];
                    this.rays.setSize(1);
                    this.env.set(intersection2, scattering.getFlags(), this.scene);
                    scattering.computeExitance(this.env, this.tmpSpectrum1);
                    scattering.computeBSDF(this.env, null, this.tmpSpectrum1, this.out, true, this.tmpSpectrum2);
                    this.tmpSpectrum2.mul(spectrum);
                    object = (Spectrum)this.sensedIrradiance.get(n3);
                    if (object == null) {
                        object = this.tmpSpectrum2.clone();
                        this.sensedIrradiance.set(n3, object);
                    } else {
                        object.add(this.tmpSpectrum2);
                    }
                    if (object instanceof Collector) {
                        ((Collector)object).setAsCollector();
                        ((Collector)object).addToStatistic((Tuple3d)this.line.direction, this.tmpSpectrum2, d, this.depth == n);
                    }
                }
                if ((scattering = this.scene.getShader(intersection2.volume)) == null) {
                    this.rays.setSize(1);
                    object = this.rays.rays[0];
                    ((Ray)object).direction.set((Tuple3d)this.line.direction);
                    ((Ray)object).spectrum.set(spectrum);
                } else {
                    this.env.set(intersection2, scattering.getFlags(), this.scene);
                    this.rays.setSize(1);
                    scattering.generateRandomRays(this.env, this.out, spectrum, this.rays, true, random);
                }
                object = this.rays.lastRay();
                ((Ray)object).origin.set((Tuple3d)intersection2.getPoint());
                spectrum.sub(((Ray)object).spectrum);
                spectrum.clampMinZero();
                Spectrum spectrum2 = (Spectrum)this.radiantPower.get(n3);
                if (spectrum2 == null) {
                    spectrum2 = spectrum.clone();
                    this.radiantPower.set(n3, (Object)spectrum2);
                } else {
                    spectrum2.add(spectrum);
                }
                if (spectrum2 instanceof Collector) {
                    ((Collector)spectrum2).setAsCollector();
                    ((Collector)spectrum2).addToStatistic((Tuple3d)this.line.direction, this.tmpSpectrum3, d, this.depth == n);
                }
                if (n > 0 && ((Ray)object).spectrum.integrate() > this.minPower) {
                    this.traceRay(n - 1, (Ray)object, intersection2, random, d);
                }
            }
            this.ilist.setSize(n2);
        }
    }
}

