/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.radiosity;

import de.grogra.ray2.radiosity.FormFactor;
import de.grogra.ray2.radiosity.HemiCube;
import de.grogra.ray2.radiosity.SubPatch;
import de.grogra.ray2.radiosity.Vector3d;
import de.grogra.ray2.radiosity.ZPixel;
import java.util.Map;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZBuffer {
    private ZPixel[][] viewPlane = null;
    private int planePixWide;
    private int planePixHigh;
    private float planeStartX;
    private float planeEndX;
    private float planeStartY;
    private float planeEndY;

    public ZBuffer(boolean bl) {
        int n = HemiCube.getPixelsWide();
        float f = HemiCube.getWorldWide();
        float f2 = f / 2.0f;
        if (bl) {
            this.planePixWide = n;
            this.planePixHigh = n;
            this.planeStartX = -f2;
            this.planeEndX = f2;
            this.planeStartY = -f2;
            this.planeEndY = f2;
        } else {
            this.planePixWide = n;
            this.planePixHigh = n >> 1;
            this.planeStartX = -f2;
            this.planeEndX = f2;
            this.planeStartY = 0.0f;
            this.planeEndY = f2;
        }
        this.viewPlane = new ZPixel[this.planePixWide][this.planePixHigh];
        for (int i = 0; i < this.planePixWide; ++i) {
            for (int j = 0; j < this.planePixHigh; ++j) {
                this.viewPlane[i][j] = new ZPixel();
            }
        }
    }

    public void insert(SubPatch subPatch, SubPatch subPatch2) {
        boolean bl;
        Vector3d vector3d;
        Vector3d[] vector3dArray = new Vector3d[]{(Vector3d)((Object)subPatch.getVertices()[0].clone()), (Vector3d)((Object)subPatch.getVertices()[1].clone()), (Vector3d)((Object)subPatch.getVertices()[2].clone())};
        boolean bl2 = false;
        Vector3d vector3d2 = subPatch.getNormal();
        if (vector3d2.dot(vector3d = new Vector3d(0.0, 0.0, 1.0)) > 0.0) {
            bl2 = true;
        }
        if (!(bl = this.calcProjectedCoords(vector3dArray))) {
            int[] nArray = new int[this.planePixHigh];
            int[] nArray2 = new int[this.planePixHigh];
            double[] dArray = new double[this.planePixHigh];
            double[] dArray2 = new double[this.planePixHigh];
            for (int i = 0; i < this.planePixHigh; ++i) {
                nArray[i] = -this.planePixWide;
                nArray2[i] = this.planePixWide;
                dArray[i] = 1.0;
                dArray2[i] = 1.0;
            }
            this.computeRowValues(vector3dArray, nArray2, nArray, dArray2, dArray);
            this.clipValues(nArray2, nArray, dArray2, dArray);
            this.fillZBuffer(subPatch2, bl2, nArray2, nArray, dArray2, dArray);
        }
    }

    private boolean calcProjectedCoords(Vector3d[] vector3dArray) {
        float f = this.planeEndY;
        double d = 0.001 * (double)f;
        boolean bl = false;
        for (int i = 0; i < 3; ++i) {
            double d2;
            if (vector3dArray[i].z < d) {
                int n = 1;
                double d3 = -1.0;
                int n2 = 0;
                for (n = 1; n < 3; ++n) {
                    d2 = vector3dArray[(i + n) % 3].z;
                    if (!(d2 > d3)) continue;
                    d3 = d2;
                    n2 = n;
                }
                n = n2;
                if (d3 < d) {
                    bl = true;
                }
                if (!bl) {
                    Point3d point3d = new Point3d();
                    point3d.sub((Tuple3d)vector3dArray[(i + n) % 3], (Tuple3d)vector3dArray[i]);
                    double d4 = 1.0 / point3d.z;
                    double d5 = point3d.x * d4;
                    double d6 = point3d.y * d4;
                    double d7 = d - vector3dArray[i].z;
                    vector3dArray[i].set(d7 * d5 + vector3dArray[i].x, d7 * d6 + vector3dArray[i].y, d);
                }
            }
            double d8 = 1.0 / vector3dArray[i].z;
            double d9 = vector3dArray[i].x * (double)f * d8;
            d2 = vector3dArray[i].y * (double)f * d8;
            double d10 = -d8;
            vector3dArray[i].set(d9, d2, d10);
        }
        return bl;
    }

    private void computeRowValues(Vector3d[] vector3dArray, int[] nArray, int[] nArray2, double[] dArray, double[] dArray2) {
        float f = (float)this.planePixWide / (this.planeEndX - this.planeStartX);
        int n = (int)(f * this.planeStartX);
        int n2 = n + this.planePixWide - 1;
        int n3 = (int)(f * this.planeStartY);
        int n4 = n3 + this.planePixHigh - 1;
        int n5 = 0 - n3;
        for (int i = 0; i < 3; ++i) {
            int n6 = (int)(vector3dArray[i].x * (double)f);
            int n7 = (int)(vector3dArray[i].y * (double)f);
            int n8 = (int)(vector3dArray[(i + 1) % 3].x * (double)f);
            int n9 = (int)(vector3dArray[(i + 1) % 3].y * (double)f);
            double d = vector3dArray[i].z;
            double d2 = vector3dArray[(i + 1) % 3].z;
            if (n7 > n9) {
                int n10 = n7;
                n7 = n9;
                n9 = n10;
                n10 = n6;
                n6 = n8;
                n8 = n10;
                double d3 = d;
                d = d2;
                d2 = d3;
            }
            if (n9 <= n3 || n7 >= n4) continue;
            double d4 = n8 - n6;
            double d5 = n9 - n7;
            double d6 = d2 - d;
            double d7 = 1.0 / d5;
            double d8 = d4 * d7;
            double d9 = d6 * d7;
            int n11 = n7;
            int n12 = n9;
            if (n7 < n3) {
                n11 = n3;
            }
            if (n9 > n2) {
                n12 = n4;
            }
            int n13 = n11;
            double d10 = d8 * (double)(n11 - n7) + (double)n6;
            double d11 = d9 * (double)(n11 - n7) + d;
            while (n13 <= n12) {
                int n14 = n13 + n5;
                if ((double)nArray2[n14] < d10) {
                    nArray2[n14] = (int)d10;
                    dArray2[n14] = d11;
                }
                if ((double)nArray[n14] > d10) {
                    nArray[n14] = (int)d10;
                    dArray[n14] = d11;
                }
                ++n13;
                d11 += d9;
                d10 += d8;
            }
        }
    }

    private void clipValues(int[] nArray, int[] nArray2, double[] dArray, double[] dArray2) {
        float f = (float)this.planePixWide / (this.planeEndX - this.planeStartX);
        int n = (int)(f * this.planeStartX);
        int n2 = n + this.planePixWide - 1;
        for (int i = 0; i < this.planePixHigh; ++i) {
            float f2;
            double d = dArray[i];
            double d2 = dArray2[i];
            double d3 = d2 - d;
            int n3 = nArray2[i] - nArray[i];
            double d4 = d3 / (double)n3;
            if (nArray2[i] > n2) {
                f2 = nArray2[i] - n2;
                dArray2[i] = dArray2[i] - (double)f2 * d4;
                nArray2[i] = n2;
            }
            if (nArray[i] >= n) continue;
            f2 = nArray[i] - n;
            dArray[i] = dArray[i] - (double)f2 * d4;
            nArray[i] = n;
        }
    }

    private void fillZBuffer(SubPatch subPatch, boolean bl, int[] nArray, int[] nArray2, double[] dArray, double[] dArray2) {
        float f = (float)this.planePixWide / (this.planeEndX - this.planeStartX);
        int n = (int)(f * this.planeStartX);
        int n2 = n + this.planePixWide - 1;
        int n3 = 0 - n;
        for (int i = 0; i < this.planePixHigh; ++i) {
            if (nArray2[i] < n || nArray[i] > n2) continue;
            double d = dArray[i];
            double d2 = dArray2[i] - d;
            int n4 = nArray2[i] - nArray[i];
            double d3 = d2 / (double)n4;
            int n5 = nArray[i] + n3;
            int n6 = nArray2[i] + n3;
            double d4 = d;
            for (int j = n5; j <= n6; ++j) {
                this.viewPlane[j][i].add(subPatch, d4, bl);
                d4 += d3;
            }
        }
    }

    public ZPixel getZPixel(int n, int n2) {
        return this.viewPlane[n][n2];
    }

    public void fillFormFactors(Map<SubPatch, FormFactor> map, int n) {
        for (int i = 0; i < this.viewPlane.length; ++i) {
            for (int j = 0; j < this.viewPlane[0].length; ++j) {
                SubPatch subPatch = this.viewPlane[i][j].getPatch();
                if (subPatch == null || this.viewPlane[i][j].isBack()) continue;
                if (map.get(subPatch) == null) {
                    map.put(subPatch, new FormFactor(HemiCube.getFormFactor(0, i, j)));
                    continue;
                }
                map.get(subPatch).add(HemiCube.getFormFactor(0, i, j));
            }
        }
    }
}

