/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.radiosity;

import de.grogra.ray2.radiosity.FormFactor;
import de.grogra.ray2.radiosity.PatchGroup;
import de.grogra.ray2.radiosity.SubPatch;
import de.grogra.ray2.tracing.PixelwiseRenderer;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadiosityAlgorithm {
    private float iterTreshold = 0.0f;
    private PixelwiseRenderer renderer;
    private int steps = 0;

    public RadiosityAlgorithm(PixelwiseRenderer pixelwiseRenderer) {
        this.renderer = pixelwiseRenderer;
    }

    public void calculateScene(Vector<PatchGroup> vector, float f, int n, int n2) {
        boolean bl = true;
        Vector<PatchGroup> vector2 = new Vector<PatchGroup>(vector);
        while (bl && !this.isStopped() && this.steps < n) {
            this.renderer.setMessage("Calculating Radiosity. Iteration = " + (this.steps + 1), -1.0f);
            this.projectAllPatches(vector2, n2);
            this.computeAllPatchColors(vector2);
            if (this.steps + 1 < n) {
                this.computeChangedPatches(vector, vector2, f);
                if (vector2.isEmpty()) {
                    bl = false;
                }
            }
            ++this.steps;
        }
    }

    private void computeChangedPatches(Vector<PatchGroup> vector, Vector<PatchGroup> vector2, float f) {
        LinkedList<SubPatch> linkedList = new LinkedList<SubPatch>();
        vector2.clear();
        for (int i = 0; i < vector.size(); ++i) {
            PatchGroup patchGroup = vector.get(i);
            if (!patchGroup.subdivide(vector, linkedList, vector2, f)) continue;
            --i;
        }
        for (PatchGroup patchGroup : vector) {
            if (!patchGroup.ffMapContains(linkedList)) continue;
            patchGroup.clearRadiosity();
            vector2.add(patchGroup);
        }
    }

    private void projectAllPatches(Vector<PatchGroup> vector, int n) {
        Thread[] threadArray = new Thread[n];
        for (int i = 0; i < n; ++i) {
            threadArray[i] = new Thread(new ProjectThread(vector, i, n));
            threadArray[i].start();
        }
        for (Thread thread : threadArray) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    private void computeAllPatchColors(Vector<PatchGroup> vector) {
        for (int i = 0; i < 3; ++i) {
            float f = this.iterTreshold + 1.0f;
            while (f > this.iterTreshold) {
                f = 0.0f;
                f = this.computeRadiosity(vector, f, i);
            }
        }
    }

    private float computeRadiosity(Vector<PatchGroup> vector, float f, int n) {
        int n2 = vector.size();
        for (int i = 0; i < n2 && !this.isStopped(); ++i) {
            PatchGroup patchGroup = vector.get(i);
            float f2 = this.getComponent((Tuple3f)patchGroup.getReflectance(), n);
            for (int j = 0; j < 4; ++j) {
                float f3;
                SubPatch subPatch2;
                Map<SubPatch, FormFactor> map = patchGroup.getFormFactors(j);
                float f4 = 0.0f;
                for (SubPatch subPatch2 : map.keySet()) {
                    Color3f color3f = subPatch2.getRadiosity();
                    f3 = this.getComponent((Tuple3f)color3f, n);
                    f4 += map.get(subPatch2).getValue() * f3;
                }
                Color3f color3f = patchGroup.getRadiosity(j);
                subPatch2 = patchGroup.getEmittance(j);
                float f5 = this.getComponent((Tuple3f)color3f, n);
                this.setComponent((Tuple3f)color3f, n, this.getComponent((Tuple3f)subPatch2, n) + f2 * f4);
                f3 = this.getComponent((Tuple3f)color3f, n) - f5;
                if (f3 > f) {
                    f = f3;
                    continue;
                }
                if (!(-f3 > f)) continue;
                f = -f3;
            }
        }
        return f;
    }

    public float getComponent(Tuple3f tuple3f, int n) {
        float f = 0.0f;
        switch (n) {
            case 0: {
                f = tuple3f.x;
                break;
            }
            case 1: {
                f = tuple3f.y;
                break;
            }
            case 2: {
                f = tuple3f.z;
                break;
            }
            default: {
                System.err.println("ERROR in Tuple3f no Component " + n + " found");
            }
        }
        return f;
    }

    public void setComponent(Tuple3f tuple3f, int n, float f) {
        switch (n) {
            case 0: {
                tuple3f.x = f;
                break;
            }
            case 1: {
                tuple3f.y = f;
                break;
            }
            case 2: {
                tuple3f.z = f;
                break;
            }
            default: {
                System.err.println("ERROR in Tuple3f cannot set Component " + n);
            }
        }
    }

    public int getSteps() {
        return this.steps;
    }

    private boolean isStopped() {
        return this.renderer.isStopped();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProjectThread
    implements Runnable {
        private Vector<PatchGroup> groups;
        private int start;
        private int step;

        public ProjectThread(Vector<PatchGroup> vector, int n, int n2) {
            this.groups = vector;
            this.start = n;
            this.step = n2;
        }

        @Override
        public void run() {
            for (int i = this.start; i < this.groups.size() && !RadiosityAlgorithm.this.isStopped(); i += this.step) {
                this.groups.get(i).project(this.groups);
            }
        }
    }
}

