/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.util;

import de.grogra.ray.RTObject;
import de.grogra.ray.shader.RTMedium;
import java.util.ArrayList;
import java.util.Vector;
import javax.vecmath.Point3d;

public class RayContext {
    public final Point3d lastIntersectionPoint = new Point3d();
    public RTObject excludeObject = null;
    private final ArrayList m_enteringStack = new ArrayList(2);
    private final Vector m_materialStack = new Vector();

    public void initializeContext() {
        this.lastIntersectionPoint.set(0.0, 0.0, 0.0);
        this.excludeObject = null;
        this.m_materialStack.clear();
    }

    public void pushMaterial(RTObject rTObject) {
        this.m_materialStack.add(rTObject);
    }

    public void popMaterial() {
        if (this.m_materialStack.size() == 0) {
            return;
        }
        this.m_materialStack.remove(this.m_materialStack.size() - 1);
    }

    public boolean isLastMaterial(RTObject rTObject) {
        if (this.m_materialStack.size() == 0) {
            return false;
        }
        return this.m_materialStack.elementAt(this.m_materialStack.size() - 1) == rTObject;
    }

    public int deleteMaterial(RTObject rTObject) {
        for (int i = this.m_materialStack.size() - 1; i >= 0; --i) {
            if (this.m_materialStack.elementAt(i) != rTObject) continue;
            this.m_materialStack.remove(i);
            return i;
        }
        return -1;
    }

    public void insertMaterial(RTObject rTObject, int n) {
        this.m_materialStack.add(n, rTObject);
    }

    public void printMaterials() {
        System.out.println("  materials stack (" + this.m_materialStack.size() + ")");
        for (int i = 0; i < this.m_materialStack.size(); ++i) {
            System.out.println("    material:" + this.m_materialStack.get(i));
        }
    }

    public void enteringObject(RTObject rTObject, RTMedium rTMedium) {
        EnteringStackItem enteringStackItem = new EnteringStackItem(rTObject, rTMedium);
        this.m_enteringStack.add(enteringStackItem);
    }

    public void exitingObject(RTObject rTObject) {
        if (this.m_enteringStack.size() == 0) {
            return;
        }
        if (this.m_enteringStack.size() == 1) {
            this.m_enteringStack.clear();
            return;
        }
        int n = -1;
        for (int i = 0; i < this.m_enteringStack.size(); ++i) {
            if (((EnteringStackItem)this.m_enteringStack.get((int)i)).object != rTObject) continue;
            n = i;
            break;
        }
        if (n > -1) {
            this.m_enteringStack.remove(n);
        }
    }

    public float getEnteringIORRation() {
        if (this.m_enteringStack.size() == 0) {
            System.err.println("ERROR in RayContent");
            return 1.0f;
        }
        if (this.m_enteringStack.size() == 1) {
            return 1.0f / ((EnteringStackItem)this.m_enteringStack.get((int)0)).ior;
        }
        return ((EnteringStackItem)this.m_enteringStack.get((int)(this.m_enteringStack.size() - 2))).ior / ((EnteringStackItem)this.m_enteringStack.get((int)(this.m_enteringStack.size() - 1))).ior;
    }

    public float getExitingIORRation() {
        if (this.m_materialStack.size() == 0) {
            System.err.println("ERROR in RayContent");
            return 1.0f;
        }
        if (this.m_materialStack.size() == 1) {
            if (((RTObject)this.m_materialStack.get(0)).getMedium() == null) {
                return 1.0f;
            }
            return ((RTObject)this.m_materialStack.get(0)).getMedium().getIndexOfRefraction();
        }
        return ((RTObject)this.m_materialStack.get(this.m_materialStack.size() - 1)).getMedium().getIndexOfRefraction() / ((RTObject)this.m_materialStack.get(this.m_materialStack.size() - 2)).getMedium().getIndexOfRefraction();
    }

    public float getCurrentIOR() {
        if (this.m_materialStack.size() == 0) {
            return 1.0f;
        }
        if (((RTObject)this.m_materialStack.get(this.m_materialStack.size() - 1)).getMedium() == null) {
            return 1.0f;
        }
        return ((RTObject)this.m_materialStack.get(this.m_materialStack.size() - 1)).getMedium().getIndexOfRefraction();
    }

    private class EnteringStackItem {
        public RTObject object;
        public float ior = 1.0f;

        public EnteringStackItem(RTObject rTObject, RTMedium rTMedium) {
            this.object = rTObject;
            this.ior = rTMedium.getIndexOfRefraction();
        }
    }
}

