/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.util;

import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3f;
import de.grogra.vecmath.geom.Line;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class Ray {
    public final Point3f origin = new Point3f();
    public final Vector3f direction = new Vector3f();
    public final Spectrum3f color;
    public final Spectrum spectrum;
    public float m_importance = 1.0f;
    public float directionDensity = 1.0f;
    public float originDensity = 1.0f;
    public boolean reflected = true;
    public boolean ambient = false;
    public boolean valid = true;

    public Ray(Spectrum spectrum) {
        this.spectrum = spectrum.newInstance();
        this.color = this.spectrum instanceof Spectrum3f ? (Spectrum3f)this.spectrum : null;
    }

    public Ray() {
        this(new Spectrum3f());
    }

    public Ray(Ray ray) {
        this();
        this.origin.set((Tuple3f)ray.origin);
        this.direction.set((Tuple3f)ray.direction);
        this.color.set((Tuple3f)ray.color);
        this.m_importance = ray.m_importance;
        this.directionDensity = ray.directionDensity;
        this.originDensity = ray.originDensity;
        this.ambient = ray.ambient;
    }

    public Ray(Point3f point3f, Vector3f vector3f, float f) {
        this();
        this.origin.set((Tuple3f)point3f);
        this.direction.set((Tuple3f)vector3f);
        this.m_importance = f;
    }

    public Ray(Point3d point3d, Vector3d vector3d, float f) {
        this();
        this.origin.set((Tuple3d)point3d);
        this.direction.set((Tuple3d)vector3d);
        this.m_importance = f;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Ray)) {
            return false;
        }
        Ray ray = (Ray)object;
        return this.getOrigin().x == ray.getOrigin().x && this.getOrigin().y == ray.getOrigin().y && this.getOrigin().z == ray.getOrigin().z && this.getDirection().x == ray.getDirection().x && this.getDirection().y == ray.getDirection().y && this.getDirection().z == ray.getDirection().z && this.getImportance() == ray.getImportance();
    }

    public int hashCode() {
        return this.getOrigin().hashCode() + this.getDirection().hashCode() + (int)this.getImportance() * 10000;
    }

    public Point3f getOrigin() {
        return this.origin;
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public Color3f getColor() {
        return this.color;
    }

    public float getImportance() {
        return this.m_importance;
    }

    public void setImportance(float f) {
        this.m_importance = f;
    }

    public void setRay(Ray ray) {
        this.getOrigin().set((Tuple3f)ray.getOrigin());
        this.getDirection().set((Tuple3f)ray.getDirection());
        this.getColor().set((Tuple3f)ray.getColor());
        this.setImportance(ray.getImportance());
        this.directionDensity = ray.directionDensity;
        this.originDensity = ray.originDensity;
        this.ambient = ray.ambient;
    }

    public void transform(Matrix4f matrix4f, Ray ray) {
        ray.getOrigin().set((Tuple3f)this.getOrigin());
        ray.getDirection().set((Tuple3f)this.getDirection());
        matrix4f.transform(ray.getOrigin());
        matrix4f.transform(ray.getDirection());
    }

    public void transform(Matrix4d matrix4d, Ray ray) {
        ray.getOrigin().set((Tuple3f)this.getOrigin());
        ray.getDirection().set((Tuple3f)this.getDirection());
        matrix4d.transform(ray.getOrigin());
        matrix4d.transform(ray.getDirection());
    }

    public String toString() {
        return "Ray[origin=" + this.origin + ", direction=" + this.direction + ", spectrum=" + this.spectrum + "]";
    }

    public Line convert2Line() {
        Line line = new Line();
        line.setLineAttributes(0.0, Double.POSITIVE_INFINITY);
        line.direction.set((Tuple3f)this.direction);
        line.origin.set((Tuple3f)this.origin);
        line.directionDensity = this.directionDensity;
        line.originDensity = this.originDensity;
        this.spectrum.get((Tuple3f)line.spectrum);
        line.reflected = this.reflected;
        line.valid = this.valid;
        return line;
    }
}

